/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.GDBJtagCommandFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.debug.mi.core.AbstractGDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetNewConsole;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBJtagDebugger
extends AbstractGDBCDIDebugger {
    public ICDISession createSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        return super.createSession(launch, executable, monitor);
    }

    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        return super.createDebuggerSession(launch, exe, monitor);
    }

    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        String miVersion = MIPlugin.getMIVersion((ILaunchConfiguration)config);
        return new GDBJtagCommandFactory(miVersion);
    }

    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        String symbolsFileName;
        boolean doLoadSymbols;
        String imageFileName;
        IGDBJtagDevice gdbJtagDevice;
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 120, "Error getting debug target", null));
            return;
        }
        MISession miSession = ((Target)targets[0]).getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        try {
            MIGDBSetNewConsole newConsole = factory.createMIGDBSetNewConsole();
            miSession.postCommand((Command)newConsole);
            MIInfo info = newConsole.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString((String)"src.common.No_answer"));
            }
        }
        catch (MIException mIException) {}
        try {
            gdbJtagDevice = this.getGDBJtagDevice(config);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        ArrayList commands = new ArrayList();
        boolean useRemote = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        if (useRemote) {
            monitor.beginTask("Connecting to remote", 1);
            String ipAddress = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            int portNumber = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 10000);
            gdbJtagDevice.doRemote(ipAddress, portNumber, commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        monitor.beginTask("Executing init commands", 1);
        if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", true)) {
            commands = new ArrayList();
            gdbJtagDevice.doReset(commands);
            int defaultDelay = gdbJtagDevice.getDefaultDelay();
            gdbJtagDevice.doDelay(config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", defaultDelay), commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        if (config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", true)) {
            commands = new ArrayList();
            gdbJtagDevice.doHalt(commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbjtag.core.initCommands", miSession);
        boolean doLoad = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", false);
        if (doLoad && (imageFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "")).length() > 0) {
            monitor.beginTask("Loading image", 1);
            imageFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName).replace("\\", "\\\\");
            String imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
            commands = new ArrayList();
            gdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        if ((doLoadSymbols = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", false)) && (symbolsFileName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "")).length() > 0) {
            symbolsFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName).replace("\\", "\\\\");
            String symbolsOffset = "0x" + config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
            commands = new ArrayList();
            gdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
    }

    public void doRunSession(ILaunch launch, ICDISession session, IProgressMonitor monitor) throws CoreException {
        boolean setResume;
        IGDBJtagDevice gdbJtagDevice;
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return;
        }
        MISession miSession = ((Target)targets[0]).getMISession();
        try {
            gdbJtagDevice = this.getGDBJtagDevice(config);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        ArrayList commands = new ArrayList();
        boolean setPc = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        if (setPc) {
            String pcRegister = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
            gdbJtagDevice.doSetPC(pcRegister, commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        monitor.beginTask("Executing run commands", 1);
        boolean setStopAt = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false);
        if (setStopAt) {
            String stopAt = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "");
            commands = new ArrayList();
            gdbJtagDevice.doStopAt(stopAt, commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        if (setResume = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false)) {
            commands = new ArrayList();
            gdbJtagDevice.doContinue(commands);
            this.executeGDBScript(this.getGDBScript(commands), miSession);
        }
        this.executeGDBScript(config, "org.eclipse.cdt.debug.gdbjtag.core.runCommands", miSession);
    }

    private void executeGDBScript(String script, MISession miSession) throws CoreException {
        if (script == null) {
            return;
        }
        script = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(script);
        String[] commands = script.split("\\r?\\n");
        int j = 0;
        while (j < commands.length) {
            try {
                CLICommand cli = new CLICommand(commands[j]);
                miSession.postCommand((Command)cli, Integer.MAX_VALUE);
                MIInfo info = cli.getMIInfo();
                if (info == null) {
                    throw new MIException("Timeout");
                }
            }
            catch (MIException e) {
                MultiStatus status = new MultiStatus("org.eclipse.cdt.debug.gdbjtag.core", 150, "Failed command", (Throwable)e);
                status.add((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", 150, e == null ? "" : e.getLocalizedMessage(), (Throwable)e));
                CDebugCorePlugin.log((IStatus)status);
            }
            ++j;
        }
    }

    private void executeGDBScript(ILaunchConfiguration configuration, String attribute, MISession miSession) throws CoreException {
        this.executeGDBScript(configuration.getAttribute(attribute, ""), miSession);
    }

    private IGDBJtagDevice getGDBJtagDevice(ILaunchConfiguration config) throws CoreException, NullPointerException {
        IGDBJtagDevice gdbJtagDevice = null;
        String jtagDeviceName = config.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "");
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int i = 0;
        while (i < availableDevices.length) {
            if (jtagDeviceName.equals(availableDevices[i].getDeviceName())) {
                gdbJtagDevice = availableDevices[i].getDevice();
                break;
            }
            ++i;
        }
        return gdbJtagDevice;
    }

    private String getGDBScript(Collection commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }
}

