/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core.jtagdevice;

import java.util.ArrayList;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class GDBJtagDeviceContributionFactory {
    private static final String EXTENSION_POINT_NAME = "JTagDevice";
    private static final String MAIN_ELEMENT = "device";
    private static GDBJtagDeviceContributionFactory instance;
    protected ArrayList contributions = new ArrayList();

    private GDBJtagDeviceContributionFactory() {
        this.loadSubtypeContributions();
    }

    public GDBJtagDeviceContribution[] getGDBJtagDeviceContribution() {
        return this.contributions.toArray(new GDBJtagDeviceContribution[this.contributions.size()]);
    }

    private void loadSubtypeContributions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(Activator.getUniqueIdentifier(), EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configurationElement = elements[i];
            if (configurationElement.getName().equals(MAIN_ELEMENT)) {
                String id = GDBJtagDeviceContributionFactory.getRequired(configurationElement, "id");
                String name = GDBJtagDeviceContributionFactory.getRequired(configurationElement, "name");
                String className = GDBJtagDeviceContributionFactory.getRequired(configurationElement, "class");
                GDBJtagDeviceContribution adapter = new GDBJtagDeviceContribution();
                adapter.setDeviceId(id);
                adapter.setDeviceName(name);
                adapter.setDeviceClassName(className);
                this.addContribution(adapter);
            }
            ++i;
        }
    }

    public void addContribution(GDBJtagDeviceContribution contribution) {
        this.contributions.add(contribution);
    }

    public static GDBJtagDeviceContributionFactory getInstance() {
        if (instance == null) {
            instance = new GDBJtagDeviceContributionFactory();
        }
        return instance;
    }

    private static String getRequired(IConfigurationElement configurationElement, String name) {
        String elementValue = configurationElement.getAttribute(name);
        if (elementValue == null) {
            Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 120, "Extension " + configurationElement.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: " + name, null));
        }
        return elementValue;
    }
}

