/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser;

import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.CLanguageKeywords;
import org.eclipse.cdt.core.dom.lrparser.CPreprocessorAdapter;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ASTPrinter;
import org.eclipse.cdt.core.parser.util.DebugUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.core.runtime.CoreException;

public abstract class BaseExtensibleLanguage
extends AbstractLanguage
implements ILanguage,
ICLanguageKeywords {
    private static final boolean DEBUG_PRINT_GCC_AST = false;
    private static final boolean DEBUG_PRINT_AST = false;
    private ICLanguageKeywords keywords = null;

    protected abstract IParser getParser();

    protected abstract IDOMTokenMap getTokenMap();

    protected abstract IASTTranslationUnit createASTTranslationUnit(IIndex var1, IScanner var2);

    protected abstract ParserLanguage getParserLanguage();

    protected abstract IScannerExtensionConfiguration getScannerExtensionConfiguration();

    private void getCLanguageKeywords() {
        ParserLanguage lang = this.getParserLanguage();
        IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
        this.keywords = new CLanguageKeywords(lang, config);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPDOMLinkageFactory.class) {
            return new PDOMCLinkageFactory();
        }
        return super.getAdapter(adapter);
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, int options, IParserLogService log) throws CoreException {
        ScannerExtensionConfiguration config = new ScannerExtensionConfiguration();
        ParserLanguage pl = this.getParserLanguage();
        CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, (IScannerExtensionConfiguration)config, fileCreator);
        preprocessor.setScanComments((options & 2) != 0);
        preprocessor.setComputeImageLocations((options & 4) == 0);
        IParser parser = this.getParser();
        IASTTranslationUnit tu = this.createASTTranslationUnit(index, (IScanner)preprocessor);
        CPreprocessorAdapter.runCPreprocessor((IScanner)preprocessor, parser, this.getTokenMap(), tu);
        parser.parse(tu);
        tu.setIsHeaderUnit((options & 8) == 0);
        return tu;
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, fileCreator, index, 0, log);
    }

    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IScannerExtensionConfiguration config = this.getScannerExtensionConfiguration();
        ParserLanguage pl = this.getParserLanguage();
        CPreprocessor preprocessor = new CPreprocessor(reader, scanInfo, pl, log, config, fileCreator);
        preprocessor.setContentAssistMode(offset);
        IParser parser = this.getParser();
        IASTTranslationUnit tu = this.createASTTranslationUnit(index, (IScanner)preprocessor);
        CPreprocessorAdapter.runCPreprocessor((IScanner)preprocessor, parser, this.getTokenMap(), tu);
        IASTCompletionNode completionNode = parser.parse(tu);
        return completionNode;
    }

    private static void printCompletionNode(IASTCompletionNode cn) {
        if (cn == null) {
            System.out.println("Completion node is null");
            return;
        }
        ASTPrinter.print((IASTNode)cn.getTranslationUnit());
        IASTName[] iASTNameArray = cn.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            ASTNode context = (ASTNode)name.getCompletionContext();
            System.out.printf("Name: %s, Context: %s, At: %d", name, DebugUtil.safeClassName((Object)context), context == null ? null : Integer.valueOf(context.getOffset()));
            if (name.getTranslationUnit() == null) {
                System.out.print(", not hooked up");
            }
            System.out.println();
            ++n2;
        }
        System.out.println();
    }

    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        return GCCLanguage.getDefault().getSelectedNames(ast, start, length);
    }

    public String[] getBuiltinTypes() {
        if (this.keywords == null) {
            this.getCLanguageKeywords();
        }
        return this.keywords.getBuiltinTypes();
    }

    public String[] getKeywords() {
        if (this.keywords == null) {
            this.getCLanguageKeywords();
        }
        return this.keywords.getKeywords();
    }

    public String[] getPreprocessorKeywords() {
        if (this.keywords == null) {
            this.getCLanguageKeywords();
        }
        return this.keywords.getPreprocessorKeywords();
    }
}

