/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CMainTab
extends CLaunchConfigurationTab {
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Label fProgLabel;
    protected Text fProgText;
    protected Button fSearchButton;
    private final boolean fWantsTerminalOption;
    protected Button fTerminalButton;
    private final boolean dontCheckProgram;
    protected static final String EMPTY_STRING = "";
    private String filterPlatform = "";
    public static final int WANTS_TERMINAL = 1;
    public static final int DONT_CHECK_PROGRAM = 2;

    public CMainTab() {
        this(0);
    }

    public CMainTab(boolean terminalOption) {
        this(terminalOption ? 1 : 0);
    }

    public CMainTab(int flags) {
        this.fWantsTerminalOption = (flags & 1) != 0;
        this.dontCheckProgram = (flags & 2) != 0;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_main_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        if (this.wantsTerminalOption()) {
            this.createTerminalOption(comp, 1);
        }
        LaunchUIPlugin.setDialogShell(parent.getShell());
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LaunchMessages.getString("CMainTab.&ProjectColon"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LaunchMessages.getString("Launch.common.Browse_1"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleProjectButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createExeFileGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(mainComp, 0);
        this.fProgLabel.setText(LaunchMessages.getString("CMainTab.C/C++_Application"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fProgLabel.setLayoutData((Object)gd);
        this.fProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fProgText.setLayoutData((Object)gd);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(mainComp, LaunchMessages.getString("CMainTab.Search..."), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleSearchButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button fBrowseForBinaryButton = this.createPushButton(mainComp, LaunchMessages.getString("Launch.common.Browse_2"), null);
        fBrowseForBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleBinaryBrowseButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected boolean wantsTerminalOption() {
        return this.fWantsTerminalOption;
    }

    protected void createTerminalOption(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.fTerminalButton = this.createCheckButton(mainComp, LaunchMessages.getString("CMainTab.UseTerminal"));
        this.fTerminalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTerminalButton.setEnabled(PTY.isSupported());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.filterPlatform = this.getPlatform(config);
        this.updateProjectFromConfig(config);
        this.updateProgramFromConfig(config);
        this.updateTerminalFromConfig(config);
    }

    protected void updateTerminalFromConfig(ILaunchConfiguration config) {
        if (this.fTerminalButton != null) {
            boolean useTerminal = true;
            try {
                useTerminal = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            }
            catch (CoreException e) {
                LaunchUIPlugin.log(e);
            }
            this.fTerminalButton.setSelection(useTerminal);
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        String programName = EMPTY_STRING;
        try {
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log(ce);
        }
        this.fProgText.setText(programName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = this.getCProject();
        if (cProject != null) {
            config.setMappedResources(new IResource[]{cProject.getProject()});
            try {
                ICProjectDescription projDes;
                if (config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", EMPTY_STRING).length() == 0 && (projDes = CCorePlugin.getDefault().getProjectDescription(cProject.getProject())) != null) {
                    String buildConfigID = projDes.getActiveConfiguration().getId();
                    config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
        if (this.fTerminalButton != null) {
            config.setAttribute("org.eclipse.cdt.launch.use_terminal", this.fTerminalButton.getSelection());
        }
    }

    protected void handleSearchButtonSelected() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString("CMainTab.Project_required"), (String)LaunchMessages.getString("CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IBinary belement;
                if (!(element instanceof ICElement)) {
                    return super.getImage(element);
                }
                ICElement celement = (ICElement)element;
                if (celement.getElementType() == 14 && (belement = (IBinary)celement).isExecutable()) {
                    return DebugUITools.getImage((String)"IMG_ACT_RUN");
                }
                return super.getImage(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])this.getBinaryFiles(this.getCProject()));
        dialog.setMessage(LaunchMessages.getString("CMainTab.Choose_program_to_run"));
        dialog.setTitle(LaunchMessages.getString("CMainTab.Program_Selection"));
        dialog.setUpperListLabel(LaunchMessages.getString("Launch.common.BinariesColon"));
        dialog.setLowerListLabel(LaunchMessages.getString("Launch.common.QualifierColon"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            IBinary binary = (IBinary)dialog.getFirstResult();
            this.fProgText.setText(binary.getResource().getProjectRelativePath().toString());
        }
    }

    protected void handleBinaryBrowseButtonSelected() {
        ICProject cproject = this.getCProject();
        if (cproject == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString("CMainTab.Project_required"), (String)LaunchMessages.getString("CMainTab.Enter_project_before_browsing_for_program"));
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.fProgText.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.fProgText.setText(text);
        }
    }

    protected IBinary[] getBinaryFiles(final ICProject cproject) {
        if (cproject == null || !cproject.exists()) {
            return null;
        }
        Display display = this.getShell() == null ? LaunchUIPlugin.getShell().getDisplay() : this.getShell().getDisplay();
        final Object[] ret = new Object[1];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = cproject.getBinaryContainer().getBinaries();
                }
                catch (CModelException e) {
                    LaunchUIPlugin.errorDialog("Launch UI internal error", e);
                }
            }
        });
        return (IBinary[])ret[0];
    }

    protected void handleProjectButtonSelected() {
        ICProject project = this.chooseCProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected ICProject chooseCProject() {
        try {
            Object[] projects = this.getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(LaunchMessages.getString("CMainTab.Project_Selection"));
            dialog.setMessage(LaunchMessages.getString("CMainTab.Choose_project_to_constrain_search_for_program"));
            dialog.setElements(projects);
            ICProject cProject = this.getCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            LaunchUIPlugin.errorDialog("Launch UI internal error", e);
        }
        return null;
    }

    protected ICProject[] getCProjects() throws CModelException {
        ICProject[] cproject = CoreModel.getDefault().getCModel().getCProjects();
        ArrayList<ICProject> list = new ArrayList<ICProject>(cproject.length);
        int i = 0;
        while (i < cproject.length) {
            ICDescriptor cdesciptor = null;
            try {
                cdesciptor = CCorePlugin.getDefault().getCProjectDescription((IProject)cproject[i].getResource(), false);
                if (cdesciptor != null) {
                    String projectPlatform = cdesciptor.getPlatform();
                    if (this.filterPlatform.equals("*") || projectPlatform.equals("*") || this.filterPlatform.equalsIgnoreCase(projectPlatform)) {
                        list.add(cproject[i]);
                    }
                } else {
                    list.add(cproject[i]);
                }
            }
            catch (CoreException coreException) {
                list.add(cproject[i]);
            }
            ++i;
        }
        return list.toArray(new ICProject[list.size()]);
    }

    protected ICProject getCProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(projectName);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.dontCheckProgram) {
            return true;
        }
        String name = this.fProjText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LaunchMessages.getString("CMainTab.Project_not_specified"));
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LaunchMessages.getString("Launch.common.Project_does_not_exist"));
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.isOpen()) {
            this.setErrorMessage(LaunchMessages.getString("CMainTab.Project_must_be_opened"));
            return false;
        }
        name = this.fProgText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LaunchMessages.getString("CMainTab.Program_not_specified"));
            return false;
        }
        if (name.equals(".") || name.equals("..")) {
            this.setErrorMessage(LaunchMessages.getString("CMainTab.Program_does_not_exist"));
            return false;
        }
        Path exePath = new Path(name);
        if (!exePath.isAbsolute()) {
            if (!project.getFile(name).exists()) {
                this.setErrorMessage(LaunchMessages.getString("CMainTab.Program_does_not_exist"));
                return false;
            }
            exePath = project.getFile(name).getLocation();
        } else if (!exePath.toFile().exists()) {
            this.setErrorMessage(LaunchMessages.getString("CMainTab.Program_does_not_exist"));
            return false;
        }
        try {
            if (!this.isBinary(project, (IPath)exePath)) {
                this.setErrorMessage(LaunchMessages.getString("CMainTab.Program_is_not_a_recongnized_executable"));
                return false;
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
            this.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    protected boolean isBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
            return exe != null;
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)config, this.getPlatform((ILaunchConfiguration)config));
        if (cElement != null) {
            this.initializeCProject(cElement, config);
            this.initializeProgramName(cElement, config);
        }
        if (this.wantsTerminalOption()) {
            config.setAttribute("org.eclipse.cdt.launch.use_terminal", true);
        }
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            name = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigName = projDes.getActiveConfiguration().getName();
                name = LaunchMessages.getFormattedString("CMainTab.Configuration_name", new String[]{name, buildConfigName});
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
            renamed = true;
        }
        IBinary binary = null;
        if (cElement instanceof ICProject) {
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null && bins.length == 1) {
                binary = bins[0];
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (binary != null) {
            String path = binary.getResource().getProjectRelativePath().toOSString();
            config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", path);
            if (!renamed) {
                String name2 = binary.getElementName();
                int index = name2.lastIndexOf(46);
                if (index > 0) {
                    name2 = name2.substring(0, index);
                }
                name2 = this.getLaunchConfigurationDialog().generateName(name2);
                config.rename(name2);
                renamed = true;
            }
        }
        if (!renamed) {
            name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    public String getName() {
        return LaunchMessages.getString("CMainTab.Main");
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_MAIN_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

