/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.KVStringPair;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SCDOptionsEnum;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GCCPerFileBOPConsoleParserUtility
extends AbstractGCCBOPConsoleParserUtility {
    private Map directoryCommandListMap;
    private List compiledFileList;
    private List commandsList2;
    private int workingDirsN = 0;
    private int commandsN = 0;
    private int filesN = 0;
    private String fDefaultMacroDefinitionValue = "1";

    public GCCPerFileBOPConsoleParserUtility(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        super(project, workingDirectory, markerGenerator);
    }

    void addGenericCommandForFile(String longFileName, String genericCommand) {
        if (this.compiledFileList.contains(longFileName)) {
            return;
        }
        this.compiledFileList.add(longFileName);
        String workingDir = this.getWorkingDirectory().toString();
        ArrayList directoryCommandList = (ArrayList)this.directoryCommandListMap.get(workingDir);
        if (directoryCommandList == null) {
            directoryCommandList = new ArrayList();
            this.directoryCommandListMap.put(workingDir, directoryCommandList);
            ++this.workingDirsN;
        }
        Object var5_5 = null;
        for (Map map : directoryCommandList) {
            List fileList = (List)map.get(genericCommand);
            if (fileList == null) continue;
            if (!fileList.contains(longFileName)) {
                fileList.add(longFileName);
                ++this.filesN;
            }
            return;
        }
        HashMap hashMap = new HashMap(1);
        directoryCommandList.add(hashMap);
        ++this.commandsN;
        ArrayList<String> fileList = new ArrayList<String>();
        hashMap.put(genericCommand, fileList);
        fileList.add(longFileName);
        ++this.filesN;
    }

    void generateReport() {
        TraceUtil.metricsTrace("Stats for directory ", "Generic command: '", "' applicable for:", this.directoryCommandListMap);
        TraceUtil.summaryTrace("Discovery summary", this.workingDirsN, this.commandsN, this.filesN);
    }

    void addGenericCommandForFile2(String longFileName, String genericLine) {
        if (this.compiledFileList.contains(longFileName)) {
            return;
        }
        this.compiledFileList.add(longFileName);
        String[] tokens = genericLine.split("\\s+");
        CCommandDSC command = this.getNewCCommandDSC(tokens, 0, false);
        int index = this.commandsList2.indexOf(command);
        if (index == -1) {
            this.commandsList2.add(command);
            ++this.commandsN;
        } else {
            command = (CCommandDSC)this.commandsList2.get(index);
        }
    }

    public CCommandDSC getNewCCommandDSC(String[] tokens, int idxOfCompilerCommand, boolean cppFileType) {
        ArrayList<KVStringPair> dirafter = new ArrayList<KVStringPair>();
        ArrayList<String> includes = new ArrayList<String>();
        CCommandDSC command = new CCommandDSC(cppFileType, this.getProject());
        command.addSCOption(new KVStringPair(SCDOptionsEnum.COMMAND.toString(), tokens[idxOfCompilerCommand]));
        int i = idxOfCompilerCommand + 1;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.startsWith("-m") || token.equals("-ansi") || token.equals("-posix") || token.equals("-pthread") || token.startsWith("-O") || token.equals("-fno-inline") || token.startsWith("-finline") || token.equals("-fno-exceptions") || token.equals("-fexceptions") || token.equals("-fshort-wchar") || token.equals("-fshort-double") || token.equals("-fno-signed-char") || token.equals("-fsigned-char") || token.startsWith("-fabi-version=")) {
                command.addSCOption(new KVStringPair(SCDOptionsEnum.COMMAND.toString(), token));
            } else {
                int j = 1;
                while (j <= 14) {
                    SCDOptionsEnum optionKind = SCDOptionsEnum.getSCDOptionsEnum(j);
                    if (token.startsWith(optionKind.toString())) {
                        KVStringPair pair;
                        String option2 = token.substring(optionKind.toString().length()).trim();
                        if (option2.length() <= 0) {
                            if (optionKind.equals(SCDOptionsEnum.IDASH)) {
                                for (String option2 : includes) {
                                    KVStringPair pair2 = new KVStringPair(SCDOptionsEnum.IQUOTE.toString(), option2);
                                    command.addSCOption(pair2);
                                }
                                includes = new ArrayList();
                            } else {
                                if (i + 1 >= tokens.length || tokens[i + 1].startsWith("-")) break;
                                option2 = tokens[++i];
                            }
                        }
                        if (option2.length() > 0 && (optionKind.equals(SCDOptionsEnum.INCLUDE) || optionKind.equals(SCDOptionsEnum.INCLUDE_FILE) || optionKind.equals(SCDOptionsEnum.IMACROS_FILE) || optionKind.equals(SCDOptionsEnum.IDIRAFTER) || optionKind.equals(SCDOptionsEnum.ISYSTEM) || optionKind.equals(SCDOptionsEnum.IQUOTE))) {
                            option2 = this.getAbsolutePath(option2).toString();
                        }
                        if (optionKind.equals(SCDOptionsEnum.IDIRAFTER)) {
                            pair = new KVStringPair(SCDOptionsEnum.INCLUDE.toString(), option2);
                            dirafter.add(pair);
                            break;
                        }
                        if (optionKind.equals(SCDOptionsEnum.INCLUDE)) {
                            includes.add(option2);
                            break;
                        }
                        if (optionKind.equals(SCDOptionsEnum.DEFINE) && option2.indexOf(61) == -1) {
                            option2 = String.valueOf(option2) + '=' + this.fDefaultMacroDefinitionValue;
                        }
                        pair = new KVStringPair(optionKind.toString(), option2);
                        command.addSCOption(pair);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (String option : includes) {
            KVStringPair pair = new KVStringPair(SCDOptionsEnum.INCLUDE.toString(), option);
            command.addSCOption(pair);
        }
        Iterator iter = dirafter.iterator();
        while (iter.hasNext()) {
            command.addSCOption((KVStringPair)iter.next());
        }
        return command;
    }

    public void setDefaultMacroDefinitionValue(String val) {
        if (val != null) {
            this.fDefaultMacroDefinitionValue = val;
        }
    }

    public IPath getAbsolutePath(String filePath) {
        Path pFilePath;
        if (filePath.startsWith("/")) {
            return GCCPerFileBOPConsoleParserUtility.convertCygpath((IPath)new Path(filePath));
        }
        if (filePath.startsWith("\\") || !filePath.startsWith(".") && filePath.length() > 2 && filePath.charAt(1) == ':' && (filePath.charAt(2) == '\\' || filePath.charAt(2) == '/')) {
            pFilePath = new Path(filePath);
        } else {
            IPath cwd = this.getWorkingDirectory();
            if (!cwd.isAbsolute()) {
                cwd = this.getBaseDirectory().append(cwd);
            }
            pFilePath = cwd.append(filePath);
        }
        return pFilePath;
    }

    public List getCCommandDSCList() {
        return new ArrayList(this.commandsList2);
    }
}

