/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerFileSICollector
implements IScannerInfoCollector3,
IScannerInfoCollectorCleaner {
    private static final int INCLUDE_PATH = 1;
    private static final int QUOTE_INCLUDE_PATH = 2;
    private static final int INCLUDE_FILE = 3;
    private static final int MACROS_FILE = 4;
    public static final String COLLECTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".PerFileSICollector";
    private static final String CC_ELEM = "compilerCommand";
    private static final String ID_ATTR = "id";
    private static final String FILE_TYPE_ATTR = "fileType";
    private static final String APPLIES_TO_ATTR = "appliesToFiles";
    private static final String FILE_ELEM = "file";
    private static final String PATH_ATTR = "path";
    IProject project;
    InfoContext context;
    private ScannerInfoData sid = new ScannerInfoData();
    private ProjectScannerInfo psi = null;
    private Map siChangedForFileMap = new HashMap();
    private List siChangedForCommandIdList = new ArrayList();
    private SortedSet freeCommandIdPool = new TreeSet();
    private int commandIdCounter = 0;

    public void setProject(IProject project) {
        this.setInfoContext(new InfoContext(project));
    }

    public void setInfoContext(InfoContext context) {
        this.project = context.getProject();
        this.context = context;
        try {
            DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, context, this.sid);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    public synchronized void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else {
            if (resource instanceof Integer) {
                this.addScannerInfo((Integer)resource, scannerInfo);
                return;
            }
            if (!(resource instanceof IFile)) {
                errorMessage = "resource is not an IFile";
            } else if (((IFile)resource).getProject() == null) {
                errorMessage = "project is null";
            } else if (!((IFile)resource).getProject().equals((Object)this.project)) {
                errorMessage = "wrong project";
            }
        }
        if (errorMessage != null) {
            TraceUtil.outputError("PerFileSICollector.contributeToScannerConfig : ", errorMessage);
            return;
        }
        IFile file = (IFile)resource;
        for (ScannerInfoTypes type : scannerInfo.keySet()) {
            if (type.equals(ScannerInfoTypes.COMPILER_COMMAND)) {
                List commands = (List)scannerInfo.get(type);
                Iterator j = commands.iterator();
                while (j.hasNext()) {
                    this.addCompilerCommand(file, (CCommandDSC)j.next());
                }
                continue;
            }
            this.addScannerInfo(type, (List)scannerInfo.get(type));
        }
    }

    private void addScannerInfo(Integer commandId, Map scannerInfo) {
        CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(commandId);
        if (cmd != null) {
            List siItem = (List)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
            cmd.setSymbols(siItem);
            siItem = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
            siItem = CygpathTranslator.translateIncludePaths(this.project, siItem);
            siItem = CCommandDSC.makeRelative(this.project, siItem);
            cmd.setIncludes(siItem);
            siItem = (List)scannerInfo.get(ScannerInfoTypes.QUOTE_INCLUDE_PATHS);
            siItem = CygpathTranslator.translateIncludePaths(this.project, siItem);
            siItem = CCommandDSC.makeRelative(this.project, siItem);
            cmd.setQuoteIncludes(siItem);
            cmd.setDiscovered(true);
        }
    }

    void addCompilerCommand(IFile file, CCommandDSC cmd) {
        ArrayList existingCommands = new ArrayList(this.sid.commandIdCommandMap.values());
        int index = existingCommands.indexOf(cmd);
        if (index != -1) {
            cmd = (CCommandDSC)existingCommands.get(index);
        } else {
            int commandId = -1;
            if (!this.freeCommandIdPool.isEmpty()) {
                Integer freeCommandId = (Integer)this.freeCommandIdPool.first();
                this.freeCommandIdPool.remove(freeCommandId);
                commandId = freeCommandId;
            } else {
                commandId = ++this.commandIdCounter;
            }
            cmd.setCommandId(commandId);
            this.sid.commandIdCommandMap.put(cmd.getCommandIdAsInteger(), cmd);
        }
        this.generateFileDelta(file, cmd);
    }

    private void generateFileDelta(IFile file, CCommandDSC cmd) {
        Integer commandId = cmd.getCommandIdAsInteger();
        Integer oldCommandId = (Integer)this.sid.fileToCommandIdMap.get(file);
        if (oldCommandId != null && oldCommandId.equals(commandId)) {
            this.siChangedForFileMap.remove(file);
        } else {
            this.siChangedForFileMap.put(file, commandId);
        }
    }

    void applyFileDeltas() {
        for (IFile file : this.siChangedForFileMap.keySet()) {
            Integer commandId = (Integer)this.siChangedForFileMap.get(file);
            if (commandId == null) continue;
            HashSet<IFile> fileSet = (HashSet<IFile>)this.sid.commandIdToFilesMap.get(commandId);
            if (fileSet == null) {
                fileSet = new HashSet<IFile>();
                this.sid.commandIdToFilesMap.put(commandId, fileSet);
                CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(commandId);
                if (cmd != null) {
                    cmd.resolveOptions(this.project);
                }
            }
            if (!fileSet.add(file)) continue;
            boolean change = true;
            Integer oldCommandId = (Integer)this.sid.fileToCommandIdMap.get(file);
            if (oldCommandId != null) {
                if (oldCommandId.equals(commandId)) {
                    change = false;
                } else {
                    Set oldFileSet = (Set)this.sid.commandIdToFilesMap.get(oldCommandId);
                    if (oldFileSet != null) {
                        oldFileSet.remove(file);
                    }
                }
            }
            if (!change) continue;
            this.sid.fileToCommandIdMap.put(file, commandId);
        }
        this.generateProjectScannerInfo();
    }

    private void generateProjectScannerInfo() {
        this.psi = new ProjectScannerInfo();
        this.psi.includePaths = this.getAllIncludePaths(1);
        this.psi.quoteIncludePaths = this.getAllIncludePaths(2);
        this.psi.includeFiles = this.getAllIncludePaths(3);
        this.psi.macrosFiles = this.getAllIncludePaths(4);
        this.psi.definedSymbols = this.getAllSymbols();
    }

    private void removeUnusedCommands() {
        for (Map.Entry entry : this.sid.commandIdToFilesMap.entrySet()) {
            Integer cmdId = (Integer)entry.getKey();
            Set fileSet = (Set)entry.getValue();
            if (!fileSet.isEmpty()) continue;
            this.freeCommandIdPool.add(cmdId);
        }
        for (Integer cmdId : this.freeCommandIdPool) {
            this.sid.commandIdCommandMap.remove(cmdId);
            this.sid.commandIdToFilesMap.remove(cmdId);
        }
        while (!this.freeCommandIdPool.isEmpty()) {
            Integer last = (Integer)this.freeCommandIdPool.last();
            if (last != this.commandIdCounter) break;
            this.freeCommandIdPool.remove(last);
            --this.commandIdCounter;
        }
    }

    private void addScannerInfo(ScannerInfoTypes type, List delta) {
    }

    public void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeMessages.getString("ScannerInfoCollector.Processing"), 100);
        monitor.subTask(MakeMessages.getString("ScannerInfoCollector.Processing"));
        if (this.scannerInfoChanged()) {
            this.applyFileDeltas();
            this.removeUnusedCommands();
            monitor.worked(50);
            monitor.subTask(String.valueOf(MakeMessages.getString("ScannerInfoCollector.Updating")) + this.project.getName());
            try {
                IDiscoveredPathManager.IDiscoveredPathInfo pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context);
                if (!(pathInfo instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo)) {
                    pathInfo = this.createPathInfoObject();
                }
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), new ArrayList<IResource>(this.siChangedForFileMap.keySet()));
                monitor.worked(50);
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }
        this.siChangedForFileMap.clear();
        this.siChangedForCommandIdList.clear();
        monitor.done();
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        return new PerFileDiscoveredPathInfo();
    }

    private boolean scannerInfoChanged() {
        return !this.siChangedForFileMap.isEmpty();
    }

    public List getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        ArrayList<Object> rv;
        block12: {
            block13: {
                block11: {
                    rv = new ArrayList<Object>();
                    String errorMessage = null;
                    if (resource == null) {
                        errorMessage = "resource is null";
                    } else if (!(resource instanceof IResource)) {
                        errorMessage = "resource is not an IResource";
                    } else if (((IResource)resource).getProject() == null) {
                        errorMessage = "project is null";
                    } else if (((IResource)resource).getProject() != this.project) {
                        errorMessage = "wrong project";
                    }
                    if (errorMessage == null) break block11;
                    TraceUtil.outputError("PerProjectSICollector.getCollectedScannerInfo : ", errorMessage);
                    break block12;
                }
                if (!this.project.equals((Object)((IResource)resource).getProject())) break block12;
                if (!type.equals(ScannerInfoTypes.COMPILER_COMMAND)) break block13;
                for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
                    Set fileSet = (Set)this.sid.commandIdToFilesMap.get(cmdId);
                    if (fileSet == null || fileSet.isEmpty()) continue;
                    rv.add(this.sid.commandIdCommandMap.get(cmdId));
                }
                break block12;
            }
            if (!type.equals(ScannerInfoTypes.UNDISCOVERED_COMPILER_COMMAND) || !this.scannerInfoChanged()) break block12;
            if (this.siChangedForCommandIdList.isEmpty()) {
                for (IFile file : this.siChangedForFileMap.keySet()) {
                    Integer cmdId = (Integer)this.siChangedForFileMap.get(file);
                    if (cmdId == null || this.siChangedForCommandIdList.contains(cmdId)) continue;
                    this.siChangedForCommandIdList.add(cmdId);
                }
            }
            Collections.sort(this.siChangedForCommandIdList);
            for (Integer cmdId : this.siChangedForCommandIdList) {
                CCommandDSC command = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
                rv.add(command);
            }
        }
        return rv;
    }

    public void deleteAllPaths(IResource resource) {
    }

    public void deleteAllSymbols(IResource resource) {
    }

    public void deletePath(IResource resource, String path) {
    }

    public void deleteSymbol(IResource resource, String symbol) {
    }

    public void deleteAll(IResource resource) {
        if (resource.equals((Object)this.project)) {
            this.siChangedForFileMap.clear();
            Set changedFiles = this.sid.fileToCommandIdMap.keySet();
            for (IFile file : changedFiles) {
                this.siChangedForFileMap.put(file, null);
            }
            this.sid = new ScannerInfoData();
            this.psi = null;
            this.commandIdCounter = 0;
            this.freeCommandIdPool.clear();
        }
    }

    private Map calculatePathInfoMap() {
        PathInfo fpi;
        HashMap<Object, PathInfo> map = new HashMap<Object, PathInfo>(this.sid.fileToCommandIdMap.size() + 1);
        for (Map.Entry entry : this.sid.fileToCommandIdMap.entrySet()) {
            CCommandDSC cmd;
            IFile file = (IFile)entry.getKey();
            if (file == null || (cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(entry.getValue())) == null) continue;
            fpi = this.createFilePathInfo(cmd);
            map.put(file, fpi);
        }
        if (this.project != null) {
            if (this.psi == null) {
                this.generateProjectScannerInfo();
            }
            fpi = new PathInfo(this.psi.includePaths, this.psi.quoteIncludePaths, this.psi.definedSymbols, this.psi.includeFiles, this.psi.macrosFiles);
            map.put(this.project, fpi);
        }
        return map;
    }

    private PathInfo createFilePathInfo(CCommandDSC cmd) {
        IPath[] includes = this.stringListToPathArray(cmd.getIncludes());
        IPath[] quotedIncludes = this.stringListToPathArray(cmd.getQuoteIncludes());
        IPath[] incFiles = this.stringListToPathArray(cmd.getIncludeFile());
        IPath[] macroFiles = this.stringListToPathArray(cmd.getImacrosFile());
        List symbols = cmd.getSymbols();
        HashMap<String, String> definedSymbols = new HashMap<String, String>(symbols.size());
        for (String symbol : symbols) {
            String key = ScannerConfigUtil.getSymbolKey(symbol);
            String value = ScannerConfigUtil.getSymbolValue(symbol);
            definedSymbols.put(key, value);
        }
        return new PathInfo(includes, quotedIncludes, definedSymbols, incFiles, macroFiles);
    }

    private CCommandDSC getCommand(IPath path) {
        try {
            IFile file = this.project.getWorkspace().getRoot().getFile(path);
            return this.getCommand(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CCommandDSC getCommand(IFile file) {
        Integer cmdId;
        CCommandDSC cmd = null;
        if (file != null && (cmdId = (Integer)this.sid.fileToCommandIdMap.get(file)) != null) {
            cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
        }
        return cmd;
    }

    private IPath[] getAllIncludePaths(int type) {
        ArrayList<String> allIncludes = new ArrayList<String>();
        for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
            CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
            if (!cmd.isDiscovered()) continue;
            List discovered = null;
            switch (type) {
                case 1: {
                    discovered = cmd.getIncludes();
                    break;
                }
                case 2: {
                    discovered = cmd.getQuoteIncludes();
                    break;
                }
                case 3: {
                    discovered = cmd.getIncludeFile();
                    break;
                }
                case 4: {
                    discovered = cmd.getImacrosFile();
                }
            }
            for (String include : discovered) {
                if (allIncludes.contains(include)) continue;
                allIncludes.add(include);
            }
        }
        return this.stringListToPathArray(allIncludes);
    }

    private IPath[] stringListToPathArray(List discovered) {
        ArrayList<Path> allIncludes = new ArrayList<Path>(discovered.size());
        for (String include : discovered) {
            if (allIncludes.contains(include)) continue;
            allIncludes.add(new Path(include));
        }
        return allIncludes.toArray(new IPath[allIncludes.size()]);
    }

    private Map getAllSymbols() {
        HashMap<String, String> symbols = new HashMap<String, String>();
        for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
            CCommandDSC cmd = (CCommandDSC)this.sid.commandIdCommandMap.get(cmdId);
            if (!cmd.isDiscovered()) continue;
            List discovered = cmd.getSymbols();
            for (String symbol : discovered) {
                String key = ScannerConfigUtil.getSymbolKey(symbol);
                String value = ScannerConfigUtil.getSymbolValue(symbol);
                symbols.put(key, value);
            }
        }
        return symbols;
    }

    public class PerFileDiscoveredPathInfo
    implements IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 {
        public IProject getProject() {
            return PerFileSICollector.this.project;
        }

        public IPath[] getIncludePaths() {
            IPath[] includepaths = PerFileSICollector.this.getAllIncludePaths(1);
            IPath[] quotepaths = PerFileSICollector.this.getAllIncludePaths(2);
            if (quotepaths == null || quotepaths.length == 0) {
                return includepaths;
            }
            if (includepaths == null || includepaths.length == 0) {
                return quotepaths;
            }
            ArrayList result = new ArrayList(includepaths.length + quotepaths.length);
            result.addAll(Arrays.asList(includepaths));
            result.addAll(Arrays.asList(quotepaths));
            return result.toArray(new IPath[result.size()]);
        }

        public Map getSymbols() {
            return PerFileSICollector.this.getAllSymbols();
        }

        public IPath[] getIncludePaths(IPath path) {
            CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
            if (cmd != null && cmd.isDiscovered()) {
                return PerFileSICollector.this.stringListToPathArray(cmd.getIncludes());
            }
            if (PerFileSICollector.this.psi == null) {
                PerFileSICollector.this.generateProjectScannerInfo();
            }
            return ((PerFileSICollector)PerFileSICollector.this).psi.includePaths;
        }

        public IPath[] getQuoteIncludePaths(IPath path) {
            CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
            if (cmd != null && cmd.isDiscovered()) {
                return PerFileSICollector.this.stringListToPathArray(cmd.getQuoteIncludes());
            }
            if (PerFileSICollector.this.psi == null) {
                PerFileSICollector.this.generateProjectScannerInfo();
            }
            return ((PerFileSICollector)PerFileSICollector.this).psi.quoteIncludePaths;
        }

        public Map getSymbols(IPath path) {
            CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
            if (cmd != null && cmd.isDiscovered()) {
                List symbols = cmd.getSymbols();
                HashMap<String, String> definedSymbols = new HashMap<String, String>(symbols.size());
                for (String symbol : symbols) {
                    String key = ScannerConfigUtil.getSymbolKey(symbol);
                    String value = ScannerConfigUtil.getSymbolValue(symbol);
                    definedSymbols.put(key, value);
                }
                return definedSymbols;
            }
            if (PerFileSICollector.this.psi == null) {
                PerFileSICollector.this.generateProjectScannerInfo();
            }
            return ((PerFileSICollector)PerFileSICollector.this).psi.definedSymbols;
        }

        public IPath[] getIncludeFiles(IPath path) {
            CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
            if (cmd != null) {
                return PerFileSICollector.this.stringListToPathArray(cmd.getIncludeFile());
            }
            if (PerFileSICollector.this.psi == null) {
                PerFileSICollector.this.generateProjectScannerInfo();
            }
            return ((PerFileSICollector)PerFileSICollector.this).psi.includeFiles;
        }

        public IPath[] getMacroFiles(IPath path) {
            CCommandDSC cmd = PerFileSICollector.this.getCommand(path);
            if (cmd != null) {
                return PerFileSICollector.this.stringListToPathArray(cmd.getImacrosFile());
            }
            if (PerFileSICollector.this.psi == null) {
                PerFileSICollector.this.generateProjectScannerInfo();
            }
            return ((PerFileSICollector)PerFileSICollector.this).psi.macrosFiles;
        }

        public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
            return PerFileSICollector.this.sid;
        }

        public boolean isEmpty(IPath path) {
            boolean rc = true;
            IResource resource = PerFileSICollector.this.project.getWorkspace().getRoot().findMember(path);
            if (resource != null) {
                if (resource instanceof IFile) {
                    rc = PerFileSICollector.this.getCommand((IFile)resource) == null;
                } else if (resource instanceof IProject) {
                    rc = PerFileSICollector.this.psi == null || PerFileSICollector.this.psi.isEmpty();
                }
            }
            return rc;
        }

        public Map getPathInfoMap() {
            return PerFileSICollector.this.calculatePathInfoMap();
        }
    }

    private static class ProjectScannerInfo {
        IPath[] includePaths;
        IPath[] quoteIncludePaths;
        IPath[] includeFiles;
        IPath[] macrosFiles;
        Map definedSymbols;

        private ProjectScannerInfo() {
        }

        public boolean isEmpty() {
            return this.includePaths.length == 0 && this.quoteIncludePaths.length == 0 && this.includeFiles.length == 0 && this.macrosFiles.length == 0 && this.definedSymbols.size() == 0;
        }
    }

    public class ScannerInfoData
    implements IDiscoveredPathManager.IDiscoveredScannerInfoSerializable {
        private Map commandIdToFilesMap;
        private Map fileToCommandIdMap;
        private Map commandIdCommandMap = new LinkedHashMap();

        public ScannerInfoData() {
            this.fileToCommandIdMap = new HashMap();
            this.commandIdToFilesMap = new HashMap();
        }

        public void serialize(Element collectorElem) {
            Document doc = collectorElem.getOwnerDocument();
            ArrayList commandIds = new ArrayList(this.commandIdCommandMap.keySet());
            Collections.sort(commandIds);
            for (Integer commandId : commandIds) {
                CCommandDSC command = (CCommandDSC)this.commandIdCommandMap.get(commandId);
                Element cmdElem = doc.createElement(PerFileSICollector.CC_ELEM);
                collectorElem.appendChild(cmdElem);
                cmdElem.setAttribute(PerFileSICollector.ID_ATTR, commandId.toString());
                cmdElem.setAttribute(PerFileSICollector.FILE_TYPE_ATTR, command.appliesToCPPFileType() ? "c++" : "c");
                command.serialize(cmdElem);
                Element filesElem = doc.createElement(PerFileSICollector.APPLIES_TO_ATTR);
                cmdElem.appendChild(filesElem);
                Set files = (Set)this.commandIdToFilesMap.get(commandId);
                if (files == null) continue;
                Iterator j = files.iterator();
                while (j.hasNext()) {
                    Element fileElem = doc.createElement(PerFileSICollector.FILE_ELEM);
                    IFile file = (IFile)j.next();
                    IPath path = file.getProjectRelativePath();
                    fileElem.setAttribute(PerFileSICollector.PATH_ATTR, path.toString());
                    filesElem.appendChild(fileElem);
                }
            }
        }

        public void deserialize(Element collectorElem) {
            Node child = collectorElem.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals(PerFileSICollector.CC_ELEM)) {
                    Element cmdElem = (Element)child;
                    boolean cppFileType = cmdElem.getAttribute(PerFileSICollector.FILE_TYPE_ATTR).equals("c++");
                    CCommandDSC command = new CCommandDSC(cppFileType, PerFileSICollector.this.project);
                    command.setCommandId(Integer.parseInt(cmdElem.getAttribute(PerFileSICollector.ID_ATTR)));
                    command.deserialize(cmdElem);
                    NodeList appliesList = cmdElem.getElementsByTagName(PerFileSICollector.APPLIES_TO_ATTR);
                    if (appliesList.getLength() > 0) {
                        Element appliesElem = (Element)appliesList.item(0);
                        NodeList fileList = appliesElem.getElementsByTagName(PerFileSICollector.FILE_ELEM);
                        int i = 0;
                        while (i < fileList.getLength()) {
                            Element fileElem = (Element)fileList.item(i);
                            String fileName = fileElem.getAttribute(PerFileSICollector.PATH_ATTR);
                            IFile file = PerFileSICollector.this.project.getFile(fileName);
                            PerFileSICollector.this.addCompilerCommand(file, command);
                            ++i;
                        }
                        PerFileSICollector.this.applyFileDeltas();
                    }
                }
                child = child.getNextSibling();
            }
        }

        public String getCollectorId() {
            return COLLECTOR_ID;
        }
    }
}

