/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigInfoFactory2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ScannerConfigProfileManager {
    public static final String SI_PROFILE_SIMPLE_ID = "ScannerConfigurationDiscoveryProfile";
    public static final String PER_PROJECT_PROFILE_ID;
    public static final String DEFAULT_SI_PROFILE_ID;
    public static final String NULL_PROFILE_ID = "";
    private Map projectToProfileInstanceMap = new HashMap();
    private List profileIds;
    private List contextAwareProfileIds;
    private static ScannerConfigProfileManager instance;

    static {
        DEFAULT_SI_PROFILE_ID = PER_PROJECT_PROFILE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCStandardMakePerProjectProfile";
        instance = null;
    }

    private ScannerConfigProfileManager() {
    }

    public static ScannerConfigProfileManager getInstance() {
        if (instance == null) {
            instance = new ScannerConfigProfileManager();
        }
        return instance;
    }

    private String getProfileId(IProject project, InfoContext context) {
        String profileId;
        try {
            IScannerConfigBuilderInfo2Set container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set(project);
            IScannerConfigBuilderInfo2 buildInfo = container.getInfo(context);
            if (buildInfo == null) {
                buildInfo = container.getInfo(new InfoContext(project));
            }
            profileId = buildInfo.getSelectedProfileId();
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
            profileId = DEFAULT_SI_PROFILE_ID;
        }
        return profileId;
    }

    public void addProfile(IProject project, ScannerConfigProfile profile) {
        this.addProfile(project, new InfoContext(project), profile);
    }

    public void addProfile(IProject project, InfoContext context, ScannerConfigProfile profile) {
        this.getProfileMap(project, true).put(context, profile);
    }

    private Map getProfileMap(IProject project, boolean create) {
        HashMap map = (HashMap)this.projectToProfileInstanceMap.get(project);
        if (map == null && create) {
            map = new HashMap();
            this.projectToProfileInstanceMap.put(project, map);
        }
        return map;
    }

    public void handleProjectRemoved(IProject project) {
        this.projectToProfileInstanceMap.remove(project);
    }

    public SCProfileInstance getSCProfileInstance(IProject project, String profileId) {
        return this.getSCProfileInstance(project, new InfoContext(project), profileId);
    }

    public SCProfileInstance getSCProfileInstance(IProject project, InfoContext context, String profileId) {
        Map map;
        SCProfileInstance profileInstance;
        if (profileId == NULL_PROFILE_ID) {
            profileId = this.getProfileId(project, context);
        }
        if ((profileInstance = (SCProfileInstance)(map = this.getProfileMap(project, true)).get(context)) == null || !profileInstance.getProfile().getId().equals(profileId)) {
            profileInstance = new SCProfileInstance(project, context, this.getSCProfileConfiguration(profileId));
            map.put(context, profileInstance);
        }
        return profileInstance;
    }

    public SCProfileInstance getSCProfileInstance(String profileId) {
        SCProfileInstance profileInstance = null;
        if (profileId != NULL_PROFILE_ID) {
            profileInstance = new SCProfileInstance(null, this.getSCProfileConfiguration(profileId));
        }
        return profileInstance;
    }

    public ScannerConfigProfile getSCProfileConfiguration(String profileId) {
        profileId = profileId == NULL_PROFILE_ID ? ScannerConfigProfileManager.getDefaultSIProfileId() : profileId;
        return new ScannerConfigProfile(profileId);
    }

    public List getProfileIds() {
        if (this.profileIds == null) {
            this.profileIds = new ArrayList();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", SI_PROFILE_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String rProfileId = extensions[i].getUniqueIdentifier();
                    this.profileIds.add(rProfileId);
                    ++i;
                }
            }
        }
        return this.profileIds;
    }

    public List getProfileIds(InfoContext context) {
        if (context.isDefaultContext() || context.getProject() == null) {
            return this.getProfileIds();
        }
        if (this.contextAwareProfileIds == null) {
            this.contextAwareProfileIds = new ArrayList();
            List all = this.getProfileIds();
            int i = 0;
            while (i < all.size()) {
                String id = (String)all.get(i);
                ScannerConfigProfile profile = this.getSCProfileConfiguration(id);
                if (profile.supportsContext()) {
                    this.contextAwareProfileIds.add(id);
                }
                ++i;
            }
        }
        return this.contextAwareProfileIds;
    }

    public static String getDefaultSIProfileId() {
        return DEFAULT_SI_PROFILE_ID;
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project, String profileId) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, profileId);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, NULL_PROFILE_ID);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(IProject project) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(project, NULL_PROFILE_ID);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(IProject project, String profileId) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(project, profileId);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(Preferences prefs, boolean useDefaults) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(prefs, NULL_PROFILE_ID, useDefaults);
    }

    public static IScannerConfigBuilderInfo2Set createScannerConfigBuildInfo2Set(Preferences prefs, String profileId, boolean useDefaults) throws CoreException {
        return ScannerConfigInfoFactory2.createInfoSet(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, String profileId, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, NULL_PROFILE_ID, useDefaults);
    }
}

