/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.upc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.lrparser.c99.C99Language;
import org.eclipse.cdt.core.parser.util.CharArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UPCKeyword {
    MYTHREAD(19),
    THREADS(20),
    UPC_MAX_BLOCKSIZE(21),
    relaxed(46),
    shared(47),
    strict(48),
    upc_barrier(38),
    upc_localsizeof(22),
    upc_blocksizeof(23),
    upc_elemsizeof(24),
    upc_notify(39),
    upc_fence(40),
    upc_wait(41),
    upc_forall(42);

    private final int tokenKind;
    private static List<String> names;
    private static final CharArrayMap<Integer> tokenMap;

    static {
        names = new ArrayList<String>();
        tokenMap = new CharArrayMap();
        UPCKeyword[] uPCKeywordArray = UPCKeyword.values();
        int n = uPCKeywordArray.length;
        int n2 = 0;
        while (n2 < n) {
            UPCKeyword keyword = uPCKeywordArray[n2];
            String name = keyword.name();
            names.add(name);
            tokenMap.put(name.toCharArray(), (Object)keyword.tokenKind);
            ++n2;
        }
    }

    private UPCKeyword(int tokenKind) {
        this.tokenKind = tokenKind;
    }

    public int getTokenKind() {
        return this.tokenKind;
    }

    public static String[] getUPCOnlyKeywords() {
        return names.toArray(new String[names.size()]);
    }

    public static String[] getAllKeywords() {
        ArrayList<String> allKeywords = new ArrayList<String>(names);
        allKeywords.addAll((Collection<String>)Arrays.asList(C99Language.getDefault().getKeywords()));
        return allKeywords.toArray(new String[allKeywords.size()]);
    }

    public static Integer getTokenKind(char[] image) {
        return (Integer)tokenMap.get(image);
    }
}

