/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesChangeEvent;
import org.eclipse.cdt.debug.core.executables.IExecutableImporter;
import org.eclipse.cdt.debug.core.executables.IExecutableProvider;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.core.executables.StandardExecutableImporter;
import org.eclipse.cdt.debug.core.executables.StandardExecutableProvider;
import org.eclipse.cdt.debug.core.executables.StandardSourceFileRemapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class ExecutablesManager
extends PlatformObject {
    private ArrayList<Executable> executables = new ArrayList();
    private List<IExecutablesChangeListener> changeListeners = Collections.synchronizedList(new ArrayList());
    private List<ISourceFileRemapping> sourceFileRemappings = Collections.synchronizedList(new ArrayList());
    private List<IExecutableProvider> executableProviders = Collections.synchronizedList(new ArrayList());
    private List<IExecutableImporter> executableImporters = Collections.synchronizedList(new ArrayList());
    private boolean refreshNeeded = true;
    private boolean tempDisableRefresh = false;
    private Job refreshJob = new Job("Get Executables"){

        public IStatus run(IProgressMonitor monitor) {
            ExecutablesManager.this.refreshExecutables(monitor);
            return Status.OK_STATUS;
        }
    };
    private static ExecutablesManager executablesManager = null;

    public static ExecutablesManager getExecutablesManager() {
        if (executablesManager == null) {
            executablesManager = new ExecutablesManager();
        }
        return executablesManager;
    }

    public ExecutablesManager() {
        this.addSourceFileRemapping(new StandardSourceFileRemapping());
        this.addExecutableImporter(new StandardExecutableImporter());
        this.addExecutablesProvider(new StandardExecutableProvider());
    }

    public void addExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void addSourceFileRemapping(ISourceFileRemapping remapping) {
        this.sourceFileRemappings.add(remapping);
    }

    public void removeSourceFileRemapping(ISourceFileRemapping remapping) {
        this.sourceFileRemappings.remove(remapping);
    }

    public void addExecutableImporter(IExecutableImporter importer) {
        this.executableImporters.add(importer);
    }

    public void removeExecutableImporter(IExecutableImporter importer) {
        this.executableImporters.remove(importer);
    }

    public void addExecutablesProvider(IExecutableProvider provider) {
        this.executableProviders.add(provider);
    }

    public void removeExecutablesProvider(IExecutableProvider provider) {
        this.executableProviders.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus refreshExecutables(IProgressMonitor monitor) {
        if (this.tempDisableRefresh) {
            return Status.OK_STATUS;
        }
        ArrayList<Executable> arrayList = this.executables;
        synchronized (arrayList) {
            ArrayList<Executable> oldList = new ArrayList<Executable>(this.executables);
            this.executables.clear();
            List<Object> list = this.executableProviders;
            synchronized (list) {
                monitor.beginTask("Refresh Executables", this.executableProviders.size());
                for (IExecutableProvider provider : this.executableProviders) {
                    this.executables.addAll(provider.getExecutables((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                }
                monitor.done();
            }
            this.refreshNeeded = false;
            list = this.changeListeners;
            synchronized (list) {
                for (IExecutablesChangeListener listener : this.changeListeners) {
                    listener.executablesChanged(new ExecutablesChangeEvent(oldList, this.executables){});
                }
            }
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public Executable[] getExecutables() {
        if (this.refreshNeeded) {
            try {
                this.refreshJob.schedule();
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.executables.toArray(new Executable[this.executables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remapSourceFile(String filePath) {
        List<ISourceFileRemapping> list = this.sourceFileRemappings;
        synchronized (list) {
            for (ISourceFileRemapping remapping : this.sourceFileRemappings) {
                String remappedPath = remapping.remapSourceFile(filePath);
                if (remappedPath.equals(filePath)) continue;
                return remappedPath;
            }
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importExecutables(String[] fileNames, IProgressMonitor monitor) {
        try {
            List<IExecutableImporter> list = this.executableImporters;
            synchronized (list) {
                this.tempDisableRefresh = true;
                monitor.beginTask("Import Executables", this.executableImporters.size());
                for (IExecutableImporter importer : this.executableImporters) {
                    importer.importExecutables(fileNames, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (monitor.isCanceled()) break;
                }
            }
        }
        finally {
            this.tempDisableRefresh = false;
        }
        this.refreshExecutables(monitor);
        monitor.done();
    }

    public ISourceFileRemapping[] getSourceFileRemappings() {
        return this.sourceFileRemappings.toArray(new ISourceFileRemapping[this.sourceFileRemappings.size()]);
    }

    public IExecutableProvider[] getExecutableProviders() {
        return this.executableProviders.toArray(new IExecutableProvider[this.executableProviders.size()]);
    }

    public IExecutableImporter[] getExecutableImporters() {
        return this.executableImporters.toArray(new IExecutableImporter[this.executableImporters.size()]);
    }

    public void scheduleRefresh(IExecutableProvider provider, long delay) {
        this.refreshNeeded = true;
        this.refreshJob.schedule(delay);
    }

    public boolean refreshNeeded() {
        return this.refreshNeeded;
    }

    public boolean executableExists(IPath exePath) {
        for (Executable executable : this.executables) {
            if (!executable.getPath().equals((Object)exePath)) continue;
            return true;
        }
        return false;
    }
}

