/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.callhierarchy.CHContentProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.cdt.internal.ui.callhierarchy.CalledByResult;
import org.eclipse.cdt.internal.ui.callhierarchy.CallsToResult;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CHQueries {
    private static final CHNode[] EMPTY_NODES = new CHNode[0];

    private CHQueries() {
    }

    public static CHNode[] findCalledBy(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        CalledByResult result = new CalledByResult();
        ICElement callee = node.getRepresentedDeclaration();
        if (!(callee instanceof ISourceReference)) {
            return EMPTY_NODES;
        }
        ICProject project = callee.getCProject();
        IIndexBinding calleeBinding = IndexUI.elementToBinding(index, callee);
        if (calleeBinding != null) {
            IBinding[] overriddenBindings;
            CHQueries.findCalledBy(index, (IBinding)calleeBinding, true, project, result);
            IBinding[] iBindingArray = overriddenBindings = CHQueries.getOverriddenBindings(index, calleeBinding);
            int n = overriddenBindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding overriddenBinding = iBindingArray[n2];
                CHQueries.findCalledBy(index, overriddenBinding, false, project, result);
                ++n2;
            }
        }
        return cp.createNodes(node, result);
    }

    private static IBinding[] getOverriddenBindings(IIndex index, IIndexBinding binding) {
        if (binding instanceof ICPPMethod && !(binding instanceof ICPPConstructor)) {
            try {
                ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
                ICPPMethod m = (ICPPMethod)binding;
                char[] mname = m.getNameCharArray();
                ICPPClassType mcl = m.getClassOwner();
                if (mcl != null) {
                    ICPPMethod[] allMethods;
                    IFunctionType mft = m.getType();
                    boolean isVirtual = m.isVirtual();
                    ICPPMethod[] iCPPMethodArray = allMethods = mcl.getMethods();
                    int n = allMethods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPMethod method = iCPPMethodArray[n2];
                        if (CharArrayUtils.equals((char[])mname, (char[])method.getNameCharArray()) && !mcl.isSameType((IType)method.getClassOwner()) && mft.isSameType((IType)method.getType())) {
                            isVirtual = isVirtual || method.isVirtual();
                            result.add(method);
                        }
                        ++n2;
                    }
                    if (isVirtual) {
                        return result.toArray(new IBinding[result.size()]);
                    }
                }
            }
            catch (DOMException dOMException) {}
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    private static IBinding[] getOverridingBindings(IIndex index, IBinding binding) throws CoreException {
        if (binding instanceof ICPPMethod && !(binding instanceof ICPPConstructor)) {
            try {
                ICPPMethod m = (ICPPMethod)binding;
                if (CHQueries.isVirtual(m)) {
                    ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
                    char[] mname = m.getNameCharArray();
                    ICPPClassType mcl = m.getClassOwner();
                    if (mcl != null) {
                        ICPPClassType[] subclasses;
                        IFunctionType mft = m.getType();
                        ICPPClassType[] iCPPClassTypeArray = subclasses = CHQueries.getSubClasses(index, mcl);
                        int n = subclasses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICPPMethod[] methods;
                            ICPPClassType subClass = iCPPClassTypeArray[n2];
                            ICPPMethod[] iCPPMethodArray = methods = subClass.getDeclaredMethods();
                            int n3 = methods.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICPPMethod method = iCPPMethodArray[n4];
                                if (CharArrayUtils.equals((char[])mname, (char[])method.getNameCharArray()) && mft.isSameType((IType)method.getType())) {
                                    result.add(method);
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                        return result.toArray(new IBinding[result.size()]);
                    }
                }
            }
            catch (DOMException dOMException) {}
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    private static ICPPClassType[] getSubClasses(IIndex index, ICPPClassType mcl) throws CoreException {
        LinkedList<ICPPBinding> result = new LinkedList<ICPPBinding>();
        HashSet<String> handled = new HashSet<String>();
        CHQueries.getSubClasses(index, (ICPPBinding)mcl, result, handled);
        result.remove(0);
        return result.toArray(new ICPPClassType[result.size()]);
    }

    private static void getSubClasses(IIndex index, ICPPBinding classOrTypedef, List<ICPPBinding> result, HashSet<String> handled) throws CoreException {
        IIndexName[] names;
        try {
            String key = CPPVisitor.renderQualifiedName((String[])classOrTypedef.getQualifiedName());
            if (!handled.add(key)) {
                return;
            }
        }
        catch (DOMException dOMException) {
            return;
        }
        if (classOrTypedef instanceof ICPPClassType) {
            result.add(classOrTypedef);
        }
        IIndexName[] iIndexNameArray = names = index.findNames((IBinding)classOrTypedef, 6);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexBinding subClass;
            IIndexName subClassDef;
            IIndexName indexName = iIndexNameArray[n2];
            if (indexName.isBaseSpecifier() && (subClassDef = indexName.getEnclosingDefinition()) != null && (subClass = index.findBinding((IName)subClassDef)) instanceof ICPPBinding) {
                CHQueries.getSubClasses(index, (ICPPBinding)subClass, result, handled);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isVirtual(ICPPMethod m) {
        try {
            ICPPMethod[] allMethods;
            if (m.isVirtual()) {
                return true;
            }
            char[] mname = m.getNameCharArray();
            ICPPClassType mcl = m.getClassOwner();
            if (mcl == null) return false;
            IFunctionType mft = m.getType();
            ICPPMethod[] iCPPMethodArray = allMethods = mcl.getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICPPMethod method = iCPPMethodArray[n2];
                if (CharArrayUtils.equals((char[])mname, (char[])method.getNameCharArray()) && mft.isSameType((IType)method.getType()) && method.isVirtual()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    private static void findCalledBy(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, CalledByResult result) throws CoreException {
        IIndexName[] names;
        IIndexName[] iIndexNameArray = names = index.findNames(callee, 12);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementHandle elem;
            IIndexName caller;
            IIndexName rname = iIndexNameArray[n2];
            if ((includeOrdinaryCalls || rname.couldBePolymorphicMethodCall()) && (caller = rname.getEnclosingDefinition()) != null && (elem = IndexUI.getCElementForName(project, index, caller)) != null) {
                result.add((ICElement)elem, rname);
            }
            ++n2;
        }
    }

    public static CHNode[] findCalls(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        ICElement caller = node.getRepresentedDeclaration();
        CallsToResult result = new CallsToResult();
        IIndexName callerName = IndexUI.elementToName(index, caller);
        if (callerName != null) {
            IIndexName[] refs;
            IIndexName[] iIndexNameArray = refs = callerName.getEnclosedNames();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                IIndexBinding binding = index.findBinding((IName)name);
                if (CallHierarchyUI.isRelevantForCallHierarchy((IBinding)binding)) {
                    ICElementHandle[] defs;
                    IBinding[] virtualOverriders = CHQueries.getOverridingBindings(index, (IBinding)binding);
                    if (virtualOverriders.length == 0) {
                        defs = IndexUI.findRepresentative(index, (IBinding)binding);
                    } else {
                        ArrayList list = new ArrayList();
                        list.addAll(Arrays.asList(IndexUI.findRepresentative(index, (IBinding)binding)));
                        IBinding[] iBindingArray = virtualOverriders;
                        int n3 = virtualOverriders.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBinding overrider = iBindingArray[n4];
                            list.addAll(Arrays.asList(IndexUI.findRepresentative(index, overrider)));
                            ++n4;
                        }
                        defs = list.toArray(new ICElement[list.size()]);
                    }
                    if (defs != null && defs.length > 0) {
                        result.add((ICElement[])defs, name);
                    }
                }
                ++n2;
            }
        }
        return cp.createNodes(node, result);
    }
}

