/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPathProjectsEntryPage
extends CPathBasePage {
    private CheckedListDialogField<CPElement> fProjectsList;
    ICProject fCurrCProject;
    private ListDialogField<CPElement> fCPathList;

    public CPathProjectsEntryPage(ListDialogField<CPElement> cPathList) {
        super(CPathEntryMessages.getString("ProjectsEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectsEntryPage.description"));
        ProjectsListListener listener = new ProjectsListListener();
        String[] buttonLabels = new String[]{CPathEntryMessages.getString("ProjectsEntryPage.projects.checkall.button"), CPathEntryMessages.getString("ProjectsEntryWorkbookPage.projects.uncheckall.button")};
        this.fProjectsList = new CheckedListDialogField(null, buttonLabels, (IBaseLabelProvider)new CPElementLabelProvider());
        this.fProjectsList.setDialogFieldListener(listener);
        this.fProjectsList.setLabelText(CPathEntryMessages.getString("ProjectsEntryPage.projects.label"));
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.fProjectsList.setViewerComparator((ViewerComparator)new CPElementSorter());
        this.fCPathList = cPathList;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void performDefaults() {
    }

    @Override
    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_projects");
    }

    public void init(ICProject cproject) {
        this.updateProjectsList(cproject);
    }

    void updateProjectsList(ICProject currCProject) {
        ICModel cmodel = currCProject.getCModel();
        ArrayList<CPElement> projects = new ArrayList<CPElement>();
        ArrayList<CPElement> checkedProjects = new ArrayList<CPElement>();
        try {
            ICProject[] cprojects = cmodel.getCProjects();
            ArrayList<Object> existingProjects = new ArrayList<Object>(cprojects.length);
            existingProjects.add(currCProject.getProject());
            List<CPElement> cpelements = this.fCPathList.getElements();
            int i = cpelements.size() - 1;
            while (i >= 0) {
                CPElement cpelem = cpelements.get(i);
                if (this.isEntryKind(cpelem.getEntryKind())) {
                    existingProjects.add(cpelem.getResource());
                    projects.add(cpelem);
                    checkedProjects.add(cpelem);
                }
                --i;
            }
            ICProject[] iCProjectArray = cprojects;
            int n = cprojects.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject cproject = iCProjectArray[n2];
                IProject proj = cproject.getProject();
                if (!existingProjects.contains(proj)) {
                    projects.add(new CPElement(this.fCurrCProject, 4, proj.getFullPath(), (IResource)proj));
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
        this.fProjectsList.setElements(projects);
        this.fProjectsList.setCheckedElements(checkedProjects);
        this.fCurrCProject = currCProject;
    }

    void updateCPathList() {
        List<CPElement> projelements = this.fProjectsList.getCheckedElements();
        boolean remove = false;
        List<CPElement> pelements = this.fCPathList.getElements();
        int i = pelements.size() - 1;
        while (i >= 0) {
            CPElement pe = pelements.get(i);
            if (this.isEntryKind(pe.getEntryKind()) && !projelements.remove(pe)) {
                pelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            pelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fCPathList.setElements(pelements);
        }
    }

    public List<CPElement> getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 4;
    }

    private class ProjectsListListener
    implements IDialogFieldListener {
        private ProjectsListListener() {
        }

        public void dialogFieldChanged(DialogField field) {
            if (CPathProjectsEntryPage.this.fCurrCProject != null) {
                CPathProjectsEntryPage.this.updateCPathList();
            }
        }
    }
}

