/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ASTProvider {
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");
    public static int PARSE_MODE_FULL = 0;
    public static int PARSE_MODE_FAST = 2;
    private ASTCache fCache = new ASTCache();
    private ActivationListener fActivationListener;
    private IWorkbenchPart fActiveEditor;
    private long fTimeStamp;

    public static ASTProvider getASTProvider() {
        return CUIPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        if (PlatformUI.isWorkbenchRunning()) {
            this.fActivationListener = new ActivationListener();
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            int length = windows.length;
            while (i < length) {
                windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeEditorChanged(IWorkbenchPart editor) {
        ICElement cElement = null;
        if (editor instanceof CEditor) {
            cElement = ((CEditor)editor).getInputCElement();
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            this.fActiveEditor = editor;
            this.fTimeStamp = -1L;
            this.fCache.setActiveElement((ITranslationUnit)cElement);
        }
    }

    public boolean isActive(ITranslationUnit tu) {
        return this.fCache.isActiveElement(tu);
    }

    void aboutToBeReconciled(ICElement cElement) {
        if (cElement == null) {
            return;
        }
        Assert.isTrue((boolean)(cElement instanceof ITranslationUnit));
        this.fCache.aboutToBeReconciled((ITranslationUnit)cElement);
        this.updateModificationStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateModificationStamp() {
        long timeStamp = -1L;
        ITextEditor textEditor = null;
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            if (this.fActiveEditor instanceof ITextEditor) {
                textEditor = (ITextEditor)this.fActiveEditor;
                timeStamp = this.fTimeStamp;
            }
        }
        if (textEditor != null) {
            IDocumentExtension4 docExt;
            long newTimeStamp;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
            if (document instanceof IDocumentExtension4 && (newTimeStamp = (docExt = (IDocumentExtension4)document).getModificationStamp()) != timeStamp) {
                ASTProvider aSTProvider2 = this;
                synchronized (aSTProvider2) {
                    block10: {
                        if (this.fActiveEditor != textEditor || this.fTimeStamp != timeStamp) break block10;
                        this.fTimeStamp = newTimeStamp;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
        this.fCache.setActiveElement(null);
    }

    void reconciled(IASTTranslationUnit ast, ICElement cElement, IProgressMonitor progressMonitor) {
        if (cElement == null) {
            return;
        }
        Assert.isTrue((boolean)(cElement instanceof ITranslationUnit));
        this.fCache.reconciled(ast, (ITranslationUnit)cElement);
    }

    public IStatus runOnAST(ICElement cElement, WAIT_FLAG waitFlag, IProgressMonitor monitor, ASTCache.ASTRunnable astRunnable) {
        Assert.isTrue((boolean)(cElement instanceof ITranslationUnit));
        boolean isActive = this.isActive((ITranslationUnit)cElement);
        if (waitFlag == WAIT_ACTIVE_ONLY && !isActive) {
            return Status.CANCEL_STATUS;
        }
        if (isActive && this.updateModificationStamp()) {
            this.fCache.disposeAST();
        }
        return this.fCache.runOnAST((ITranslationUnit)cElement, waitFlag != WAIT_NO, monitor, astRunnable);
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isCEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isCEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isCEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isCEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isCEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isCEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                ASTProvider.this.activeEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isCEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.cdt.ui.editor.CEditor".equals(id) || ref.getPart(false) instanceof CEditor;
        }
    }

    public static final class WAIT_FLAG {
        String fName;

        private WAIT_FLAG(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

