/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.cdt.internal.ui.util.Messages;

public class OccurrencesFinder
implements IOccurrencesFinder {
    public static final String ID = "OccurrencesFinder";
    private IASTTranslationUnit fRoot;
    private IASTName fSelectedNode;
    private IBinding fTarget;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult;
    private String fDescription;

    public String initialize(IASTTranslationUnit root, IASTNode node) {
        if (!(node instanceof IASTName)) {
            return CSearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (IASTName)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return CSearchMessages.OccurrencesFinder_no_binding;
        }
        this.fDescription = Messages.format(CSearchMessages.OccurrencesFinder_occurrence_description, this.fTarget.getName());
        return null;
    }

    private void performSearch() {
        if (this.fResult == null) {
            IASTName candidate;
            this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
            IASTName[] names = this.fRoot.getDeclarationsInAST(this.fTarget);
            int i = 0;
            while (i < names.length) {
                candidate = names[i];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addUsage(candidate, candidate.resolveBinding());
                }
                ++i;
            }
            names = this.fRoot.getReferences(this.fTarget);
            i = 0;
            while (i < names.length) {
                candidate = names[i];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addUsage(candidate, candidate.resolveBinding());
                }
                ++i;
            }
        }
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public IASTTranslationUnit getASTRoot() {
        return this.fRoot;
    }

    public String getJobLabel() {
        return CSearchMessages.OccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return new String(this.fSelectedNode.toCharArray());
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return CSearchMessages.OccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return CSearchMessages.OccurrencesFinder_label_singular;
    }

    private boolean addUsage(IASTName node, IBinding binding) {
        if (binding != null) {
            IASTImageLocation fileLocation;
            int flag = 0;
            String description = this.fDescription;
            if (node instanceof ICPPASTTemplateId) {
                node = ((ICPPASTTemplateId)node).getTemplateName();
            }
            if ((fileLocation = node.getImageLocation()) == null || !this.fRoot.getFilePath().equals(fileLocation.getFileName())) {
                fileLocation = node.getFileLocation();
            }
            if (fileLocation != null) {
                int offset = fileLocation.getNodeOffset();
                int length = fileLocation.getNodeLength();
                if (offset >= 0 && length > 0) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, length, flag, description));
                }
            }
            return true;
        }
        return false;
    }

    public int getSearchKind() {
        return 5;
    }

    public String getID() {
        return ID;
    }
}

