/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import com.ibm.icu.text.BreakIterator;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.cdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckIterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class SpellCheckIterator
implements ISpellCheckIterator {
    protected final String fContent;
    protected String fLastToken = null;
    protected int fNext = 1;
    protected final int fOffset;
    private int fPredecessor;
    protected int fPrevious = 0;
    private final LinkedList<Integer> fSentenceBreaks = new LinkedList();
    private boolean fStartsSentence = false;
    protected int fSuccessor;
    private final BreakIterator fWordIterator;
    private boolean fIsIgnoringSingleLetters;

    public SpellCheckIterator(IDocument document, IRegion region, Locale locale) {
        this(document, region, locale, BreakIterator.getWordInstance((Locale)locale));
    }

    public SpellCheckIterator(IDocument document, IRegion region, Locale locale, BreakIterator breakIterator) {
        String content;
        this.fOffset = region.getOffset();
        this.fWordIterator = breakIterator;
        try {
            content = document.get(region.getOffset(), region.getLength());
        }
        catch (Exception exception) {
            content = "";
        }
        this.fContent = content;
        this.fWordIterator.setText(content);
        this.fPredecessor = this.fWordIterator.first();
        this.fSuccessor = this.fWordIterator.next();
        BreakIterator iterator = BreakIterator.getSentenceInstance((Locale)locale);
        iterator.setText(content);
        int offset = iterator.current();
        while (offset != -1) {
            this.fSentenceBreaks.add(new Integer(offset));
            offset = iterator.next();
        }
    }

    public void setIgnoreSingleLetters(boolean state) {
        this.fIsIgnoringSingleLetters = state;
    }

    public final int getBegin() {
        return this.fPrevious + this.fOffset;
    }

    public final int getEnd() {
        return this.fNext + this.fOffset - 1;
    }

    public final boolean hasNext() {
        return this.fSuccessor != -1;
    }

    protected final boolean isAlphaNumeric(int begin, int end) {
        char character = '\u0000';
        boolean letter = false;
        int index = begin;
        while (index < end) {
            character = this.fContent.charAt(index);
            if (Character.isLetter(character)) {
                letter = true;
            }
            if (!Character.isLetterOrDigit(character)) {
                return false;
            }
            ++index;
        }
        return letter;
    }

    protected final boolean isToken(String[] tags) {
        return this.isToken(this.fLastToken, tags);
    }

    protected final boolean isToken(String token, String[] tags) {
        if (token != null) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (token.equals(tag)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected final boolean isSingleLetter(int begin) {
        if (!Character.isLetter(this.fContent.charAt(begin))) {
            return false;
        }
        if (begin > 0 && !Character.isWhitespace(this.fContent.charAt(begin - 1))) {
            return false;
        }
        return begin >= this.fContent.length() - 1 || Character.isWhitespace(this.fContent.charAt(begin + 1));
    }

    protected final boolean isUrlToken(int begin) {
        String[] stringArray = DefaultSpellChecker.URL_PREFIXES;
        int n = DefaultSpellChecker.URL_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (this.fContent.startsWith(element, begin)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final boolean isWhitespace(int begin, int end) {
        int index = begin;
        while (index < end) {
            if (!Character.isWhitespace(this.fContent.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public String next() {
        String token = this.nextToken();
        while (token == null && this.fSuccessor != -1) {
            token = this.nextToken();
        }
        this.fLastToken = token;
        return token;
    }

    protected final void nextBreak() {
        this.fNext = this.fSuccessor;
        this.fPredecessor = this.fSuccessor;
        this.fSuccessor = this.fWordIterator.next();
    }

    protected final int nextSentence() {
        return this.fSentenceBreaks.getFirst();
    }

    protected String nextToken() {
        String token = null;
        this.fPrevious = this.fPredecessor;
        this.fStartsSentence = false;
        this.nextBreak();
        boolean update = false;
        if (this.fNext - this.fPrevious > 0 && !this.isWhitespace(this.fPrevious, this.fNext) && this.isAlphaNumeric(this.fPrevious, this.fNext)) {
            if (this.isUrlToken(this.fPrevious)) {
                this.skipTokens(this.fPrevious, ' ');
            } else if (this.fNext - this.fPrevious > 1 || this.isSingleLetter(this.fPrevious) && !this.fIsIgnoringSingleLetters) {
                token = this.fContent.substring(this.fPrevious, this.fNext);
            }
            update = true;
        }
        if (update && this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
            while (this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
                this.fSentenceBreaks.removeFirst();
            }
            this.fStartsSentence = this.fLastToken == null || token != null;
        }
        return token;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected final void skipTokens(int begin, char stop) {
        int end = begin;
        while (end < this.fContent.length() && this.fContent.charAt(end) != stop) {
            ++end;
        }
        if (end < this.fContent.length()) {
            this.fPredecessor = this.fNext = end;
            this.fSuccessor = this.fWordIterator.following(this.fNext);
        } else {
            this.fSuccessor = -1;
        }
    }

    public final boolean startsSentence() {
        return this.fStartsSentence;
    }
}

