/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.IParserActionTokenProvider;
import org.eclipse.cdt.core.dom.lrparser.action.ASTCompletionNode;
import org.eclipse.cdt.core.dom.lrparser.action.IASTNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildASTParserAction {
    protected static final Object PLACE_HOLDER = Boolean.TRUE;
    protected static final boolean TRACE_ACTIONS = false;
    protected static final boolean TRACE_AST_STACK = false;
    protected final ScopedStack<Object> astStack = new ScopedStack();
    protected final IParserActionTokenProvider parser;
    protected ASTCompletionNode completionNode;
    protected final IASTTranslationUnit tu;
    private final IASTNodeFactory nodeFactory;
    protected static final ASTVisitor EMPTY_VISITOR = new ASTVisitor(){
        {
            this.shouldVisitStatements = true;
        }
    };

    protected abstract boolean isCompletionToken(IToken var1);

    protected abstract boolean isIdentifierToken(IToken var1);

    protected abstract IParser getExpressionParser();

    protected abstract IParser getNoCastExpressionParser();

    protected abstract IParser getSizeofExpressionParser();

    public BuildASTParserAction(IASTNodeFactory nodeFactory, IParserActionTokenProvider parser, IASTTranslationUnit tu) {
        if (nodeFactory == null) {
            throw new NullPointerException("nodeFactory is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is null");
        }
        if (tu == null) {
            throw new NullPointerException("tu is null");
        }
        this.nodeFactory = nodeFactory;
        this.parser = parser;
        this.tu = tu;
    }

    protected void addNameToCompletionNode(IASTName name, String prefix) {
        if (this.completionNode == null) {
            prefix = prefix == null || prefix.length() == 0 ? null : prefix;
            this.completionNode = this.nodeFactory.newCompletionNode(prefix, this.tu);
        }
        this.completionNode.addName(name);
    }

    protected void addNameToCompletionNode(IASTCompletionNode node) {
        if (node == null) {
            return;
        }
        IASTName[] iASTNameArray = node.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            this.addNameToCompletionNode(name, node.getPrefix());
            ++n2;
        }
    }

    public IASTCompletionNode getASTCompletionNode() {
        return this.completionNode;
    }

    public IASTNode getSecondaryParseResult() {
        return (IASTNode)this.astStack.pop();
    }

    protected static int offset(IToken token) {
        return token.getStartOffset();
    }

    protected static int offset(IASTNode node) {
        return ((ASTNode)node).getOffset();
    }

    protected static int length(IToken token) {
        return BuildASTParserAction.endOffset(token) - BuildASTParserAction.offset(token);
    }

    protected static int length(IASTNode node) {
        return ((ASTNode)node).getLength();
    }

    protected static int endOffset(IASTNode node) {
        return BuildASTParserAction.offset(node) + BuildASTParserAction.length(node);
    }

    protected static int endOffset(IToken token) {
        return token.getEndOffset();
    }

    protected void setOffsetAndLength(IASTNode node) {
        int ruleOffset = this.parser.getLeftIToken().getStartOffset();
        int ruleLength = this.parser.getRightIToken().getEndOffset() - ruleOffset;
        ((ASTNode)node).setOffsetAndLength(ruleOffset, ruleLength < 0 ? 0 : ruleLength);
    }

    protected static void setOffsetAndLength(IASTNode node, IToken token) {
        ((ASTNode)node).setOffsetAndLength(BuildASTParserAction.offset(token), BuildASTParserAction.length(token));
    }

    protected static void setOffsetAndLength(IASTNode node, int offset, int length) {
        ((ASTNode)node).setOffsetAndLength(offset, length);
    }

    protected IASTName createName(IToken token) {
        IASTName name = this.nodeFactory.newName(token.toString().toCharArray());
        BuildASTParserAction.setOffsetAndLength((IASTNode)name, token);
        if (this.isCompletionToken(token)) {
            this.addNameToCompletionNode(name, token.toString());
        }
        return name;
    }

    protected IASTNode runSecondaryParser(IParser secondaryParser) {
        return this.runSecondaryParser(secondaryParser, this.parser.getRuleTokens());
    }

    protected IASTNode runSecondaryParser(IParser secondaryParser, List<IToken> tokens) {
        int[] savedKinds = new int[tokens.size()];
        int i = 0;
        for (IToken token : tokens) {
            savedKinds[i++] = token.getKind();
        }
        secondaryParser.setTokens(tokens);
        IASTCompletionNode compNode = secondaryParser.parse(this.tu);
        this.addNameToCompletionNode(compNode);
        IASTNode result = secondaryParser.getSecondaryParseResult();
        i = 0;
        for (IToken token : tokens) {
            token.setKind(savedKinds[i++]);
        }
        return result;
    }

    public static boolean matchTokens(List<IToken> source, ITokenMap tokenMap, Integer ... pattern) {
        if (source.size() != pattern.length) {
            return false;
        }
        int i = 0;
        int n = pattern.length;
        while (i < n) {
            if (tokenMap.mapKind(source.get(i).getKind()) != pattern[i].intValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<IToken> tokenOffsetSubList(List<IToken> tokens, int startOffset, int endOffset) {
        int first = 0;
        int last = 0;
        int i = 0;
        for (IToken t : tokens) {
            if (BuildASTParserAction.offset(t) == startOffset) {
                first = i;
            }
            if (BuildASTParserAction.endOffset(t) == endOffset) {
                last = i;
                break;
            }
            ++i;
        }
        return tokens.subList(first, last + 1);
    }

    public void openASTScope() {
        this.astStack.openScope();
    }

    public void consumeEmpty() {
        this.astStack.push(null);
    }

    public void consumePlaceHolder() {
        this.astStack.push(PLACE_HOLDER);
    }

    public void consumeDeclSpecToken() {
        this.astStack.push(this.parser.getRightIToken());
    }

    public void consumeToken() {
        this.astStack.push(this.parser.getRightIToken());
    }

    public void consumeTranslationUnit() {
        for (Object o : this.astStack.topScope()) {
            this.tu.addDeclaration((IASTDeclaration)o);
        }
        IASTDeclaration[] declarations = this.tu.getDeclarations();
        if (declarations.length != 0) {
            IASTDeclaration d = declarations[declarations.length - 1];
            BuildASTParserAction.setOffsetAndLength((IASTNode)this.tu, 0, BuildASTParserAction.offset((IASTNode)d) + BuildASTParserAction.length((IASTNode)d));
        }
        this.resolveAmbiguityNodes();
    }

    private void resolveAmbiguityNodes() {
        this.tu.accept(EMPTY_VISITOR);
        if (this.tu instanceof ASTTranslationUnit) {
            ((ASTTranslationUnit)this.tu).cleanupAfterAmbiguityResolution();
        }
    }

    public void consumeIdentifierName() {
        this.astStack.push(this.createName(this.parser.getRightIToken()));
    }

    public void consumeStatementDeclarationWithDisambiguation() {
        IASTDeclarationStatement result;
        IASTDeclaration decl = (IASTDeclaration)this.astStack.pop();
        IASTDeclarationStatement declarationStatement = this.nodeFactory.newDeclarationStatement(decl);
        this.setOffsetAndLength((IASTNode)declarationStatement);
        IASTExpressionStatement expressionStatement = null;
        if (decl instanceof IASTSimpleDeclaration) {
            List<IToken> expressionTokens = this.parser.getRuleTokens();
            expressionTokens = expressionTokens.subList(0, expressionTokens.size() - 1);
            IParser expressionParser = this.getExpressionParser();
            IASTExpression expr = (IASTExpression)this.runSecondaryParser(expressionParser, expressionTokens);
            if (expr != null && !(expr instanceof IASTProblemExpression)) {
                expressionStatement = this.nodeFactory.newExpressionStatement(expr);
                this.setOffsetAndLength((IASTNode)expressionStatement);
            }
        }
        List<IToken> tokens = this.parser.getRuleTokens();
        if (expressionStatement == null) {
            result = declarationStatement;
        } else if (tokens.size() == 2 && (this.isCompletionToken(tokens.get(0)) || this.isIdentifierToken(tokens.get(0)))) {
            result = expressionStatement;
        } else if (BuildASTParserAction.isImplicitInt(decl)) {
            result = expressionStatement;
        } else {
            result = this.nodeFactory.newAmbiguousStatement(new IASTStatement[]{declarationStatement, expressionStatement});
            this.setOffsetAndLength((IASTNode)result);
        }
        this.astStack.push(result);
    }

    public void consumeStatementDeclaration() {
        IASTDeclaration decl = (IASTDeclaration)this.astStack.pop();
        IASTDeclarationStatement declarationStatement = this.nodeFactory.newDeclarationStatement(decl);
        this.setOffsetAndLength((IASTNode)declarationStatement);
        this.astStack.push(declarationStatement);
    }

    protected static boolean isImplicitInt(IASTDeclaration declaration) {
        IASTDeclSpecifier declSpec;
        return declaration instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)declSpec).getType() == 0;
    }

    public void consumeExpressionLiteral(int kind) {
        IToken token = this.parser.getRightIToken();
        String rep = token.toString();
        IASTLiteralExpression expr = this.nodeFactory.newLiteralExpression(kind, rep);
        BuildASTParserAction.setOffsetAndLength((IASTNode)expr, token);
        this.astStack.push(expr);
    }

    public void consumeExpressionBracketed() {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(11, operand);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionID() {
        IASTName name = this.createName(this.parser.getLeftIToken());
        IASTIdExpression expr = this.nodeFactory.newIdExpression(name);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionName() {
        IASTName name = (IASTName)this.astStack.pop();
        IASTIdExpression expr = this.nodeFactory.newIdExpression(name);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionList() {
        List<Object> expressions = this.astStack.closeScope();
        if (expressions.size() == 1) {
            this.astStack.push(expressions.get(0));
        } else {
            IASTExpressionList exprList = this.nodeFactory.newExpressionList();
            for (Object o : expressions) {
                exprList.addExpression((IASTExpression)o);
            }
            this.astStack.push(exprList);
        }
    }

    public void consumeExpressionArraySubscript() {
        IASTExpression subscript = (IASTExpression)this.astStack.pop();
        IASTExpression arrayExpr = (IASTExpression)this.astStack.pop();
        IASTArraySubscriptExpression expr = this.nodeFactory.newArraySubscriptExpression(arrayExpr, subscript);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionFunctionCall() {
        IASTExpression argList = (IASTExpression)this.astStack.pop();
        IASTExpression idExpr = (IASTExpression)this.astStack.pop();
        IASTFunctionCallExpression expr = this.nodeFactory.newFunctionCallExpression(idExpr, argList);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionCast(int operator) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTCastExpression expr = this.nodeFactory.newCastExpression(operator, typeId, operand);
        this.setOffsetAndLength((IASTNode)expr);
        IASTNode alternateExpr = null;
        if (operator == 0) {
            IParser secondaryParser = this.getNoCastExpressionParser();
            alternateExpr = this.runSecondaryParser(secondaryParser);
        }
        if (alternateExpr == null || alternateExpr instanceof IASTProblemExpression) {
            this.astStack.push(expr);
        } else {
            IASTAmbiguousExpression ambiguityNode = this.nodeFactory.newAmbiguousExpression(new IASTExpression[]{expr, (IASTExpression)alternateExpr});
            this.setOffsetAndLength((IASTNode)ambiguityNode);
            this.astStack.push(ambiguityNode);
        }
    }

    public void consumeExpressionUnaryOperator(int operator) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(operator, operand);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionTypeId(int operator) {
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTTypeIdExpression expr = this.nodeFactory.newTypeIdExpression(operator, typeId);
        this.setOffsetAndLength((IASTNode)expr);
        IParser secondaryParser = this.getSizeofExpressionParser();
        IASTNode alternateExpr = this.runSecondaryParser(secondaryParser);
        if (alternateExpr == null || alternateExpr instanceof IASTProblemExpression) {
            this.astStack.push(expr);
        } else {
            IASTAmbiguousExpression ambiguityNode = this.nodeFactory.newAmbiguousExpression(new IASTExpression[]{expr, (IASTExpression)alternateExpr});
            this.setOffsetAndLength((IASTNode)ambiguityNode);
            this.astStack.push(ambiguityNode);
        }
    }

    public void consumeExpressionBinaryOperator(int op) {
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTBinaryExpression binExpr = this.nodeFactory.newBinaryExpression(op, expr1, expr2);
        this.setOffsetAndLength((IASTNode)binExpr);
        this.astStack.push(binExpr);
    }

    public void consumeExpressionConditional() {
        IASTExpression expr3 = (IASTExpression)this.astStack.pop();
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTConditionalExpression condExpr = this.nodeFactory.newConditionalExpession(expr1, expr2, expr3);
        this.setOffsetAndLength((IASTNode)condExpr);
        this.astStack.push(condExpr);
    }

    public void consumeStatementLabeled() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTName label = this.createName(this.parser.getLeftIToken());
        IASTLabelStatement stat = this.nodeFactory.newLabelStatement(label, body);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementCase() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTCaseStatement caseStatement = this.nodeFactory.newCaseStatement(expr);
        this.setOffsetAndLength((IASTNode)caseStatement);
        this.astStack.push(caseStatement);
    }

    public void consumeStatementDefault() {
        IASTDefaultStatement stat = this.nodeFactory.newDefaultStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementNull() {
        IASTNullStatement stat = this.nodeFactory.newNullStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementExpression() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement(expr);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementCompoundStatement(boolean hasStatementsInBody) {
        IASTCompoundStatement block = this.nodeFactory.newCompoundStatement();
        if (hasStatementsInBody) {
            for (Object o : this.astStack.closeScope()) {
                block.addStatement((IASTStatement)o);
            }
        }
        this.setOffsetAndLength((IASTNode)block);
        this.astStack.push(block);
    }

    public void consumeStatementDoLoop() {
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTDoStatement stat = this.nodeFactory.newDoStatement(body, condition);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementGoto() {
        IASTName name = this.createName(this.parser.getRuleTokens().get(1));
        IASTGotoStatement gotoStat = this.nodeFactory.newGotoStatement(name);
        this.setOffsetAndLength((IASTNode)gotoStat);
        this.astStack.push(gotoStat);
    }

    public void consumeStatementContinue() {
        IASTContinueStatement stat = this.nodeFactory.newContinueStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementBreak() {
        IASTBreakStatement stat = this.nodeFactory.newBreakStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementReturn(boolean hasExpr) {
        IASTExpression expr = hasExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTReturnStatement returnStat = this.nodeFactory.newReturnStatement(expr);
        this.setOffsetAndLength((IASTNode)returnStat);
        this.astStack.push(returnStat);
    }

    public void consumeTypeId(boolean hasDeclarator) {
        IASTDeclarator declarator;
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.pop();
        } else {
            declarator = this.nodeFactory.newDeclarator(this.nodeFactory.newName());
            BuildASTParserAction.setOffsetAndLength((IASTNode)declarator, this.parser.getRightIToken().getEndOffset(), 0);
        }
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        IASTTypeId typeId = this.nodeFactory.newTypeId(declSpecifier, declarator);
        this.setOffsetAndLength((IASTNode)typeId);
        this.astStack.push(typeId);
    }

    public void consumeDeclaratorWithPointer(boolean hasDeclarator) {
        IASTDeclarator decl = hasDeclarator ? (IASTDeclarator)this.astStack.pop() : this.nodeFactory.newDeclarator(this.nodeFactory.newName());
        for (Object pointer : this.astStack.closeScope()) {
            decl.addPointerOperator((IASTPointerOperator)pointer);
        }
        this.setOffsetAndLength((IASTNode)decl);
        this.astStack.push(decl);
    }

    public void consumeDeclaratorWithInitializer(boolean hasDeclarator) {
        IASTDeclarator declarator;
        IASTInitializer initializer = (IASTInitializer)this.astStack.pop();
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.peek();
        } else {
            IASTName emptyName = this.nodeFactory.newName();
            declarator = this.nodeFactory.newDeclarator(emptyName);
            this.setOffsetAndLength((IASTNode)emptyName);
            this.astStack.push(declarator);
        }
        declarator.setInitializer(initializer);
        this.setOffsetAndLength((IASTNode)declarator);
    }

    public void consumeParameterDeclaration() {
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.pop();
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        IASTParameterDeclaration declaration = this.nodeFactory.newParameterDeclaration(declSpec, declarator);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeParameterDeclarationWithoutDeclarator() {
        int endOffset = this.parser.getRightIToken().getEndOffset();
        IASTName name = this.nodeFactory.newName();
        BuildASTParserAction.setOffsetAndLength((IASTNode)name, endOffset, 0);
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        BuildASTParserAction.setOffsetAndLength((IASTNode)declarator, endOffset, 0);
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        IASTParameterDeclaration declaration = this.nodeFactory.newParameterDeclaration(declSpec, declarator);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeDirectDeclaratorBracketed() {
        IASTDeclarator nested = (IASTDeclarator)this.astStack.pop();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(this.nodeFactory.newName());
        declarator.setNestedDeclarator(nested);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDirectDeclaratorIdentifier() {
        IASTName name = (IASTName)this.astStack.pop();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDirectDeclaratorArrayModifier(boolean hasAssignmentExpr) {
        IASTExpression expr = hasAssignmentExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTArrayModifier arrayModifier = this.nodeFactory.newArrayModifier(expr);
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    protected void addArrayModifier(IASTArrayModifier arrayModifier) {
        IASTDeclarator node = (IASTDeclarator)this.astStack.pop();
        if (node.getNestedDeclarator() != null) {
            IASTArrayDeclarator declarator = this.nodeFactory.newArrayDeclarator(this.nodeFactory.newName());
            IASTDeclarator nested = node;
            declarator.setNestedDeclarator(nested);
            int offset = BuildASTParserAction.offset((IASTNode)nested);
            int length = BuildASTParserAction.endOffset((IASTNode)arrayModifier) - offset;
            BuildASTParserAction.setOffsetAndLength((IASTNode)declarator, offset, length);
            declarator.addArrayModifier(arrayModifier);
            this.astStack.push(declarator);
        } else if (node instanceof IASTArrayDeclarator) {
            IASTArrayDeclarator decl = (IASTArrayDeclarator)node;
            ((ASTNode)decl).setLength(BuildASTParserAction.endOffset((IASTNode)arrayModifier) - BuildASTParserAction.offset((IASTNode)decl));
            decl.addArrayModifier(arrayModifier);
            this.astStack.push(decl);
        } else {
            IASTName name = node.getName();
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator(name);
            int offset = BuildASTParserAction.offset((IASTNode)name);
            int length = BuildASTParserAction.endOffset((IASTNode)arrayModifier) - offset;
            BuildASTParserAction.setOffsetAndLength((IASTNode)decl, offset, length);
            decl.addArrayModifier(arrayModifier);
            this.astStack.push(decl);
        }
    }

    protected void addFunctionModifier(IASTFunctionDeclarator declarator, int endOffset) {
        IASTDeclarator decl = (IASTDeclarator)this.astStack.pop();
        if (decl.getNestedDeclarator() != null) {
            decl = decl.getNestedDeclarator();
            declarator.setNestedDeclarator(decl);
            declarator.setName(this.nodeFactory.newName());
            int offset = BuildASTParserAction.offset((IASTNode)decl);
            BuildASTParserAction.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        } else {
            IASTName name = decl.getName();
            if (name == null) {
                name = this.nodeFactory.newName();
            }
            declarator.setName(name);
            IASTPointerOperator[] pointers = decl.getPointerOperators();
            int i = 0;
            while (i < pointers.length) {
                declarator.addPointerOperator(pointers[i]);
                ++i;
            }
            int offset = BuildASTParserAction.offset((IASTNode)name);
            BuildASTParserAction.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        }
    }

    public void consumeDirectDeclaratorArrayDeclarator(boolean hasDeclarator) {
        IASTArrayModifier arrayModifier = (IASTArrayModifier)this.astStack.pop();
        if (hasDeclarator) {
            this.addArrayModifier(arrayModifier);
        } else {
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator(this.nodeFactory.newName());
            decl.addArrayModifier(arrayModifier);
            this.setOffsetAndLength((IASTNode)decl);
            this.astStack.push(decl);
        }
    }

    public void consumeTypeSpecifierEnumeration(boolean hasIdent) {
        IASTName name = hasIdent ? this.createName(this.parser.getRuleTokens().get(1)) : this.nodeFactory.newName();
        IASTEnumerationSpecifier enumSpec = this.nodeFactory.newEnumerationSpecifier(name);
        for (Object o : this.astStack.closeScope()) {
            enumSpec.addEnumerator((IASTEnumerationSpecifier.IASTEnumerator)o);
        }
        this.setOffsetAndLength((IASTNode)enumSpec);
        this.astStack.push(enumSpec);
    }

    public void consumeEnumerator(boolean hasInitializer) {
        IASTName name = this.createName(this.parser.getLeftIToken());
        IASTExpression value = null;
        if (hasInitializer) {
            value = (IASTExpression)this.astStack.pop();
        }
        IASTEnumerationSpecifier.IASTEnumerator enumerator = this.nodeFactory.newEnumerator(name, value);
        this.setOffsetAndLength((IASTNode)enumerator);
        this.astStack.push(enumerator);
    }

    public void consumeInitializer() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTInitializerExpression initializer = this.nodeFactory.newInitializerExpression(expr);
        this.setOffsetAndLength((IASTNode)initializer);
        this.astStack.push(initializer);
    }

    public void consumeInitializerList() {
        IASTInitializerList list = this.nodeFactory.newInitializerList();
        for (Object o : this.astStack.closeScope()) {
            list.addInitializer((IASTInitializer)o);
        }
        this.setOffsetAndLength((IASTNode)list);
        this.astStack.push(list);
    }

    public void consumeBitField(boolean hasDeclarator) {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTName name = hasDeclarator ? ((IASTDeclarator)this.astStack.pop()).getName() : this.nodeFactory.newName();
        IASTFieldDeclarator fieldDecl = this.nodeFactory.newFieldDeclarator(name, expr);
        this.setOffsetAndLength((IASTNode)fieldDecl);
        this.astStack.push(fieldDecl);
    }

    public void consumeStatementProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemStatement());
    }

    public void consumeExpressionProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemExpression());
    }

    public void consumeDeclarationProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemDeclaration());
    }

    private void consumeProblem(IASTProblemHolder problemHolder) {
        IASTProblem problem = this.nodeFactory.newProblem(0x4000001, new char[0], true);
        problemHolder.setProblem(problem);
        this.setOffsetAndLength((IASTNode)problem);
        this.setOffsetAndLength((IASTNode)((ASTNode)problemHolder));
        this.astStack.push(problemHolder);
    }
}

