/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.projectmodel.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ProjectModelTests
extends TestCase
implements IElementChangedListener {
    private CModelEventChecker fEventChecker;

    public void elementChanged(ElementChangedEvent event) {
        if (this.fEventChecker != null) {
            this.fEventChecker.checkEvent(event);
        }
    }

    public static Test suite() {
        return new TestSuite(ProjectModelTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fEventChecker = null;
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fEventChecker = null;
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    private void modify(ICFileDescription fiDes) {
        ICLanguageSetting ls = fiDes.getLanguageSetting();
        this.modify(ls);
    }

    private void modify(ICFolderDescription foDes) {
        ICLanguageSetting ls = foDes.getLanguageSettingForFile("a.c");
        this.modify(ls);
    }

    private void modify(ICLanguageSetting ls) {
        List list = ls.getSettingEntriesList(1);
        list.add(new CIncludePathEntry("_modify_", 0));
        ls.setSettingEntries(1, list);
    }

    private void modify(IFileInfo fiInfo) {
        CLanguageData lData = fiInfo.getCLanguageDatas()[0];
        this.modify(lData);
    }

    private void modify(CLanguageData lData) {
        ICLanguageSettingEntry[] entries = lData.getEntries(1);
        ICLanguageSettingEntry[] updatedEntries = new ICLanguageSettingEntry[entries.length + 1];
        System.arraycopy(entries, 0, updatedEntries, 0, entries.length);
        updatedEntries[entries.length] = new CIncludePathEntry("_modify_", 0);
        lData.setEntries(1, updatedEntries);
    }

    public void testDescription() throws Exception {
        Object[] entries;
        ICLanguageSetting setting;
        IProject project = ProjectModelTests.createProject("test1");
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"detDescription1 returned not null!", (Object)des);
        des = coreModel.createProjectDescription(project, true);
        ProjectModelTests.assertNotNull((String)"createDescription returned null!", (Object)des);
        ProjectModelTests.assertNull((String)"detDescription2 returned not null!", (Object)coreModel.getProjectDescription(project));
        ProjectModelTests.assertFalse((String)"new des should be not valid", (boolean)des.isValid());
        ProjectModelTests.assertEquals((int)0, (int)des.getConfigurations().length);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.gnu30.exe");
        ProjectModelTests.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            String id = ManagedBuildManager.calculateChildId((String)cfgs[i].getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)cfgs[i], id, false, true, false);
            CConfigurationData data = config.getConfigurationData();
            ProjectModelTests.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            ++i;
        }
        coreModel.setProjectDescription(project, des);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject("test1");
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = ProjectModelTests.createProject("test1");
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        ICConfigurationDescription[] cfgDess = des.getConfigurations();
        ProjectModelTests.assertEquals((int)2, (int)cfgDess.length);
        ICConfigurationDescription cfgDes = cfgDess[0];
        ICResourceDescription[] rcDess = cfgDes.getResourceDescriptions();
        ProjectModelTests.assertEquals((int)1, (int)rcDess.length);
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)rcDess[0]);
        ProjectModelTests.assertFalse((boolean)cfgDes.isModified());
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals(null, (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), true));
        ICFileDescription fd_abc = cfgDes.createFileDescription((IPath)new Path("a/b/c.c"), rcDess[0]);
        ProjectModelTests.assertTrue((boolean)cfgDes.isModified());
        this.modify(fd_abc);
        ICProjectDescription anotherDes = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        ICConfigurationDescription[] anotherCfgDess = anotherDes.getConfigurations();
        ProjectModelTests.assertEquals((int)2, (int)anotherCfgDess.length);
        ICConfigurationDescription anotherCfgDes = anotherCfgDess[0];
        ICResourceDescription[] anotherRcDess = anotherCfgDes.getResourceDescriptions();
        ProjectModelTests.assertEquals((int)1, (int)anotherRcDess.length);
        ProjectModelTests.assertEquals((Object)anotherCfgDes.getRootFolderDescription(), (Object)anotherRcDess[0]);
        ProjectModelTests.assertFalse((boolean)anotherCfgDes.isModified());
        CConfigurationData cfgData = cfgDes.getConfigurationData();
        ProjectModelTests.assertEquals((Object)cfgData, (Object)cfgDes.getConfigurationData());
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        IResourceInfo[] infos = cfg.getResourceInfos();
        ProjectModelTests.assertEquals((int)2, (int)infos.length);
        ICFolderDescription rf = cfgDes.getRootFolderDescription();
        ICResourceDescription[] nestedFis = rf.getNestedResourceDescriptions(8);
        ICResourceDescription[] nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)2, (int)cfgDes.getResourceDescriptions().length);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)1, (int)nestedFis.length);
        ICFileDescription fd_asd = cfgDes.createFileDescription((IPath)new Path("a/s/d.c"), (ICResourceDescription)cfgDes.getRootFolderDescription());
        this.modify(fd_asd);
        ProjectModelTests.assertEquals((int)3, (int)cfgDes.getResourceDescriptions().length);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)2, (int)nestedFis.length);
        IFileInfo fi = cfg.createFileInfo((IPath)new Path("z/x/c.c"));
        this.modify(fi);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)3, (int)nestedFis.length);
        ProjectModelTests.assertEquals((int)4, (int)cfgDes.getResourceDescriptions().length);
        fi = cfg.createFileInfo((IPath)new Path("q/w/e.c"));
        this.modify(fi);
        ICFileDescription fd_qwe = (ICFileDescription)cfgDes.getResourceDescription((IPath)new Path("q/w/e.c"), true);
        ProjectModelTests.assertNotNull((Object)fd_qwe);
        ProjectModelTests.assertEquals((int)5, (int)cfgDes.getResourceDescriptions().length);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)4, (int)nestedFis.length);
        cfgDes.removeResourceDescription((ICResourceDescription)fd_abc);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)3, (int)nestedFis.length);
        ProjectModelTests.assertEquals((int)4, (int)cfgDes.getResourceDescriptions().length);
        cfg.removeResourceInfo((IPath)new Path("a/s/d.c"));
        ProjectModelTests.assertEquals((int)3, (int)cfgDes.getResourceDescriptions().length);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)0, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)2, (int)nestedFis.length);
        IFileInfo fi_qwe = (IFileInfo)cfg.getResourceInfo((IPath)new Path("q/w/e.c"), true);
        ProjectModelTests.assertNotNull((Object)fi_qwe);
        ICFileDescription fid_qwe = (ICFileDescription)cfgDes.getResourceDescription((IPath)new Path("q/w/e.c"), true);
        ProjectModelTests.assertNotNull((Object)fid_qwe);
        fi_qwe.setPath((IPath)new Path("r/t/y.c"));
        ProjectModelTests.assertEquals((Object)fi_qwe, (Object)cfg.getResourceInfo((IPath)new Path("r/t/y.c"), true));
        ProjectModelTests.assertNull((Object)cfgDes.getResourceDescription((IPath)new Path("q/w/e.c"), true));
        ICFileDescription fid_rty = (ICFileDescription)cfgDes.getResourceDescription((IPath)new Path("r/t/y.c"), true);
        ProjectModelTests.assertEquals((Object)fid_qwe, (Object)fid_rty);
        fid_rty.setPath((IPath)new Path("f/g/h.c"));
        ProjectModelTests.assertNull((Object)cfg.getResourceInfo((IPath)new Path("r/t/y.c"), true));
        IFileInfo fi_fgh = (IFileInfo)cfg.getResourceInfo((IPath)new Path("f/g/h.c"), true);
        ProjectModelTests.assertEquals((Object)fi_qwe, (Object)fi_fgh);
        ICFolderDescription fod_fg1 = cfgDes.createFolderDescription((IPath)new Path("f/g/1"), cfgDes.getRootFolderDescription());
        this.modify(fod_fg1);
        ICFolderDescription fod_fg12 = cfgDes.createFolderDescription((IPath)new Path("f/g/1/2"), fod_fg1);
        this.modify(fod_fg12);
        ProjectModelTests.assertEquals((Object)fod_fg12, (Object)fod_fg1.getNestedResourceDescription((IPath)new Path("2"), true));
        ICFileDescription fid_fg13 = cfgDes.createFileDescription((IPath)new Path("f/g/1/3.c"), (ICResourceDescription)fod_fg1);
        this.modify(fid_fg13);
        ProjectModelTests.assertEquals((Object)fid_fg13, (Object)fod_fg1.getNestedResourceDescription((IPath)new Path("3.c"), true));
        ProjectModelTests.assertEquals((int)2, (int)fod_fg1.getNestedResourceDescriptions().length);
        ProjectModelTests.assertEquals((int)1, (int)fod_fg1.getNestedResourceDescriptions(8).length);
        ProjectModelTests.assertEquals((int)1, (int)fod_fg1.getNestedResourceDescriptions(4).length);
        IFolderInfo fo_fg1 = (IFolderInfo)cfg.getResourceInfo((IPath)new Path("f/g/1"), true);
        ProjectModelTests.assertNotNull((Object)fo_fg1);
        fo_fg1.setPath((IPath)new Path("t/y/u"));
        ProjectModelTests.assertEquals((int)2, (int)fod_fg1.getNestedResourceDescriptions().length);
        ProjectModelTests.assertEquals((int)1, (int)fod_fg1.getNestedResourceDescriptions(8).length);
        ProjectModelTests.assertEquals((int)1, (int)fod_fg1.getNestedResourceDescriptions(4).length);
        ProjectModelTests.assertEquals((Object)fod_fg12, (Object)cfgDes.getResourceDescription((IPath)new Path("t/y/u/2"), true));
        ProjectModelTests.assertEquals((Object)fid_fg13, (Object)cfgDes.getResourceDescription((IPath)new Path("t/y/u/3.c"), true));
        ICLanguageSetting[] settings = cfgDes.getRootFolderDescription().getLanguageSettings();
        int i2 = 0;
        while (i2 < settings.length) {
            ICLanguageSetting setting2 = settings[i2];
            ICLanguageSettingEntry[] entries2 = setting2.getSettingEntries(1);
            int j = 0;
            while (j < entries2.length) {
                System.out.println(entries2[j].getName());
                ++j;
            }
            System.out.println(entries2.length);
            ++i2;
        }
        coreModel.setProjectDescription(project, des);
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject("test1");
        ProjectModelTests.assertFalse((boolean)project.exists());
        ProjectModelTests.assertFalse((boolean)project.isOpen());
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertFalse((boolean)project.exists());
        ProjectModelTests.assertFalse((boolean)project.isOpen());
        ProjectModelTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = ProjectModelTests.createProject("test1");
        long time = System.currentTimeMillis();
        des = coreModel.getProjectDescription(project);
        time = System.currentTimeMillis() - time;
        System.out.println("time to load = " + time);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDess = des.getConfigurations();
        cfgDes = cfgDess[0];
        rf = cfgDes.getRootFolderDescription();
        settings = rf.getLanguageSettings();
        Object[] updatedEntries = new ICLanguageSettingEntry[]{};
        int i3 = 0;
        while (i3 < settings.length) {
            setting = settings[i3];
            entries = setting.getSettingEntries(1);
            if (entries.length > 0) {
                ICLanguageSettingEntry[] updated = new ICLanguageSettingEntry[entries.length + 1];
                System.arraycopy(entries, 0, updated, 1, entries.length);
                updated[0] = new CIncludePathEntry("a/b/c", 0);
                setting.setSettingEntries(1, updated);
                updatedEntries = setting.getSettingEntries(1);
                ProjectModelTests.assertEquals((int)updated.length, (int)updatedEntries.length);
                int k = 0;
                while (k < updated.length) {
                    ProjectModelTests.assertEquals((String)updated[i3].getValue(), (String)updatedEntries[i3].getValue());
                    ++k;
                }
            }
            ++i3;
        }
        this.fEventChecker = new CDefaultModelEventChecker();
        coreModel.setProjectDescription(project, des);
        this.fEventChecker = null;
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject("test1");
        ProjectModelTests.assertFalse((boolean)project.exists());
        ProjectModelTests.assertFalse((boolean)project.isOpen());
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = ProjectModelTests.createProject("test1");
        time = System.currentTimeMillis();
        des = coreModel.getProjectDescription(project);
        time = System.currentTimeMillis() - time;
        System.out.println("time to load = " + time);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDess = des.getConfigurations();
        cfgDes = cfgDess[0];
        rf = cfgDes.getRootFolderDescription();
        settings = rf.getLanguageSettings();
        i3 = 0;
        while (i3 < settings.length) {
            setting = settings[i3];
            entries = setting.getSettingEntries(1);
            BuildSystemTestHelper.checkDiff(entries, updatedEntries);
            if (entries.length > 0) {
                ProjectModelTests.assertEquals((int)entries.length, (int)updatedEntries.length);
                int k = 0;
                while (k < entries.length) {
                    ProjectModelTests.assertEquals((String)entries[i3].getValue(), (String)updatedEntries[i3].getValue());
                    ++k;
                }
            }
            ++i3;
        }
        ProjectModelTests.assertEquals((int)2, (int)cfgDess.length);
        nestedFis = rf.getNestedResourceDescriptions(8);
        nestedFos = rf.getNestedResourceDescriptions(4);
        ProjectModelTests.assertEquals((int)2, (int)nestedFos.length);
        ProjectModelTests.assertEquals((int)3, (int)nestedFis.length);
        ProjectModelTests.assertEquals((int)6, (int)cfgDes.getResourceDescriptions().length);
        ManagedBuildTestHelper.createFolder(project, "a/b");
        ICFolderDescription base = (ICFolderDescription)cfgDes.getResourceDescription((IPath)new Path("a/b"), false);
        ICFolderDescription abFoDes = cfgDes.createFolderDescription((IPath)new Path("a/b"), base);
        ICLanguageSetting ls = abFoDes.getLanguageSettingForFile("a.c");
        ProjectModelTests.assertNotNull((Object)ls);
        List list = ls.getSettingEntriesList(1);
        list.add(0, new CIncludePathEntry("zzza/b/c", 0));
        ls.setSettingEntries(1, list);
        System.out.println("setting entries for non-root folder..\n");
        this.fEventChecker = new CDefaultModelEventChecker();
        coreModel.setProjectDescription(project, des);
        this.fEventChecker = null;
        time = System.currentTimeMillis();
        des = coreModel.getProjectDescription(project);
        time = System.currentTimeMillis() - time;
        System.out.println("time to load = " + time);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDess = des.getConfigurations();
        cfgDes = cfgDess[0];
        rf = cfgDes.getRootFolderDescription();
        ManagedBuildTestHelper.createFolder(project, "b/c");
        base = (ICFolderDescription)cfgDes.getResourceDescription((IPath)new Path("b/c"), false);
        ICFolderDescription bcFoDes = cfgDes.createFolderDescription((IPath)new Path("b/c"), base);
        ls = bcFoDes.getLanguageSettingForFile("a.c");
        ProjectModelTests.assertNotNull((Object)ls);
        ICLanguageSetting rLS = rf.getLanguageSettingForFile("a.c");
        ProjectModelTests.assertNotNull((Object)rLS);
        ls.getSettingEntriesList(1);
        rLS.getSettingEntriesList(1);
        System.out.println("default entries for non-root folder..\n");
        this.fEventChecker = new CDefaultModelEventChecker();
        coreModel.setProjectDescription(project, des);
        this.fEventChecker = null;
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testSourceEntries() throws Exception {
        IProject project = ProjectModelTests.createProject("test2");
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"detDescription1 returned not null!", (Object)des);
        des = coreModel.createProjectDescription(project, true);
        ProjectModelTests.assertNotNull((String)"createDescription returned null!", (Object)des);
        ProjectModelTests.assertNull((String)"detDescription2 returned not null!", (Object)coreModel.getProjectDescription(project));
        ProjectModelTests.assertFalse((String)"new des should be not valid", (boolean)des.isValid());
        ProjectModelTests.assertEquals((int)0, (int)des.getConfigurations().length);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.gnu30.exe");
        ProjectModelTests.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            String id = ManagedBuildManager.calculateChildId((String)cfgs[i].getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)cfgs[i], id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ProjectModelTests.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            ++i;
        }
        coreModel.setProjectDescription(project, des);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject("test2");
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = ProjectModelTests.createProject("test2");
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        ICConfigurationDescription[] cfgDess = des.getConfigurations();
        ProjectModelTests.assertEquals((int)2, (int)cfgDess.length);
        ICConfigurationDescription cfgDes = cfgDess[0];
        ICResourceDescription[] rcDess = cfgDes.getResourceDescriptions();
        ProjectModelTests.assertEquals((int)1, (int)rcDess.length);
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)rcDess[0]);
        ProjectModelTests.assertFalse((boolean)cfgDes.isModified());
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals(null, (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), true));
        Object[] s = cfgDes.getSourceEntries();
        IPath projPath = cfgDes.getProjectDescription().getProject().getFullPath();
        ProjectModelTests.assertEquals((int)1, (int)s.length);
        ProjectModelTests.assertEquals((Object)projPath, (Object)s[0].getFullPath());
        ProjectModelTests.assertEquals((int)0, (int)s[0].getExclusionPatterns().length);
        ManagedBuildTestHelper.createFolder(project, "a/b");
        Object[] updatetSEs = new ICSourceEntry[]{new CSourceEntry(projPath.append("a"), (IPath[])new Path[]{new Path("b")}, 8), s[0]};
        cfgDes.setSourceEntries((ICSourceEntry[])updatetSEs);
        s = cfgDes.getSourceEntries();
        updatetSEs[1] = new CSourceEntry(projPath, (IPath[])new Path[]{new Path("a")}, 24);
        this.checkArrays(updatetSEs, s);
        System.out.println("saving updated source entries..\n");
        this.fEventChecker = new CDefaultModelEventChecker();
        coreModel.setProjectDescription(project, des);
        this.fEventChecker = null;
        des = coreModel.getProjectDescription(project);
        cfgDes = des.getConfigurations()[0];
        this.checkArrays(cfgDes.getSourceEntries(), s);
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testMacroEntries() throws Exception {
        IProject project = ProjectModelTests.createProject("test3");
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"detDescription1 returned not null!", (Object)des);
        des = coreModel.createProjectDescription(project, true);
        ProjectModelTests.assertNotNull((String)"createDescription returned null!", (Object)des);
        ProjectModelTests.assertNull((String)"detDescription2 returned not null!", (Object)coreModel.getProjectDescription(project));
        ProjectModelTests.assertFalse((String)"new des should be not valid", (boolean)des.isValid());
        ProjectModelTests.assertEquals((int)0, (int)des.getConfigurations().length);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.gnu30.exe");
        ProjectModelTests.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            String id = ManagedBuildManager.calculateChildId((String)cfgs[i].getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)cfgs[i], id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ProjectModelTests.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            ++i;
        }
        coreModel.setProjectDescription(project, des);
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNotNull((String)"project description is null ", (Object)des);
        ProjectModelTests.assertTrue((String)"des should be valid ", (boolean)des.isValid());
        ICConfigurationDescription[] cfgDess = des.getConfigurations();
        ProjectModelTests.assertEquals((int)2, (int)cfgDess.length);
        ICConfigurationDescription cfgDes = cfgDess[0];
        ICResourceDescription[] rcDess = cfgDes.getResourceDescriptions();
        ProjectModelTests.assertEquals((int)1, (int)rcDess.length);
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)rcDess[0]);
        ProjectModelTests.assertFalse((boolean)cfgDes.isModified());
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), false));
        ProjectModelTests.assertEquals((Object)cfgDes.getRootFolderDescription(), (Object)cfgDes.getResourceDescription((IPath)new Path(""), true));
        ProjectModelTests.assertEquals(null, (Object)cfgDes.getResourceDescription((IPath)new Path("ds/sd/sdf/"), true));
        ICFolderDescription rf = cfgDes.getRootFolderDescription();
        ICLanguageSetting setting = rf.getLanguageSettingForFile("a.c");
        ICLanguageSettingEntry[] entries = setting.getSettingEntries(4);
        int i2 = 0;
        while (i2 < entries.length) {
            System.out.println("name = \"" + entries[i2].getName() + "\", value = \"" + entries[i2].getValue() + "\"");
            ++i2;
        }
        CMacroEntry entry = new CMacroEntry("a", "b", 0);
        ArrayList<CMacroEntry> list = new ArrayList<CMacroEntry>();
        list.add(entry);
        list.addAll((Collection)Arrays.asList(entries));
        setting.setSettingEntries(4, list);
        ICLanguageSettingEntry[] updatedEntries = setting.getSettingEntries(4);
        ProjectModelTests.assertEquals((int)(entries.length + 1), (int)updatedEntries.length);
        boolean found = false;
        int i3 = 0;
        while (i3 < updatedEntries.length) {
            if (updatedEntries[i3].getName().equals("a") && updatedEntries[i3].getValue().equals("b")) {
                found = true;
                break;
            }
            ++i3;
        }
        ProjectModelTests.assertTrue((boolean)found);
    }

    public void testReferences() throws Exception {
        CoreModel coreModel = CoreModel.getDefault();
        IProject project4 = ProjectModelTests.createProject("test4", "cdt.managedbuild.target.gnu30.exe");
        IProject project5 = ProjectModelTests.createProject("test5", "cdt.managedbuild.target.gnu30.exe");
        ProjectModelTests.createProject("test6", "cdt.managedbuild.target.gnu30.exe");
        ProjectModelTests.createProject("test7", "cdt.managedbuild.target.gnu30.exe");
        ICProjectDescription des4 = coreModel.getProjectDescription(project4);
        ICProjectDescription des5 = coreModel.getProjectDescription(project5);
        ICConfigurationDescription[] dess = des5.getConfigurations();
        dess[0].getId();
        dess[1].getId();
        Object[] entries = new ICLanguageSettingEntry[]{new CMacroEntry("a", "b", 0), new CMacroEntry("c", "d", 0), new CIncludePathEntry("a/b/c", 0), new CIncludePathEntry("d/e/f", 0)};
        dess[0].createExternalSetting(null, null, null, (ICSettingEntry[])entries);
        dess[0].setActive();
        ICExternalSetting[] extSettings = dess[0].getExternalSettings();
        ProjectModelTests.assertEquals((int)extSettings.length, (int)1);
        this.checkArrays(extSettings[0].getEntries(), entries);
        ArrayList list = new ArrayList(Arrays.asList(entries));
        list.remove(3);
        list.remove(2);
        this.checkArrays(extSettings[0].getEntries(4), list.toArray());
        list = new ArrayList(Arrays.asList(entries));
        list.remove(0);
        list.remove(0);
        this.checkArrays(extSettings[0].getEntries(1), list.toArray());
        coreModel.setProjectDescription(project5, des5);
        extSettings = coreModel.getProjectDescription(project5).getActiveConfiguration().getExternalSettings();
        ProjectModelTests.assertEquals((int)extSettings.length, (int)1);
        this.checkArrays(extSettings[0].getEntries(), entries);
        list = new ArrayList(Arrays.asList(entries));
        list.remove(3);
        list.remove(2);
        this.checkArrays(extSettings[0].getEntries(4), list.toArray());
        list = new ArrayList(Arrays.asList(entries));
        list.remove(0);
        list.remove(0);
        this.checkArrays(extSettings[0].getEntries(1), list.toArray());
        dess = des4.getConfigurations();
        ICLanguageSetting ls = dess[0].getRootFolderDescription().getLanguageSettingForFile("a.c");
        Object[] macros = ls.getSettingEntries(4);
        Object[] includes = ls.getSettingEntries(1);
        ProjectModelTests.assertFalse((boolean)this.arrayContains(entries[0], macros));
        ProjectModelTests.assertFalse((boolean)this.arrayContains(entries[1], macros));
        ProjectModelTests.assertFalse((boolean)this.arrayContains(entries[2], includes));
        ProjectModelTests.assertFalse((boolean)this.arrayContains(entries[3], includes));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test5", "");
        dess[0].setReferenceInfo(map);
        Object[] updatedMacros = ls.getSettingEntries(4);
        Object[] udatedIncludes = ls.getSettingEntries(1);
        ProjectModelTests.assertTrue((boolean)this.arrayContains(entries[0], updatedMacros));
        ProjectModelTests.assertTrue((boolean)this.arrayContains(entries[1], updatedMacros));
        ProjectModelTests.assertTrue((boolean)this.arrayContains(entries[2], udatedIncludes));
        ProjectModelTests.assertTrue((boolean)this.arrayContains(entries[3], udatedIncludes));
    }

    public void testActiveCfg() throws Exception {
        IProject project = ProjectModelTests.createProject("test8", "cdt.managedbuild.target.gnu30.exe");
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        String id1 = cfgs[0].getId();
        cfgs[1].getId();
        cfgs[0].setActive();
        ProjectModelTests.assertEquals((Object)cfgs[0], (Object)des.getActiveConfiguration());
        coreModel.setProjectDescription(project, des);
        des = coreModel.getProjectDescription(project);
        cfgs = des.getConfigurations();
        ProjectModelTests.assertEquals((String)id1, (String)des.getActiveConfiguration().getId());
        ICConfigurationDescription newActive = null;
        int i = 0;
        while (i < cfgs.length) {
            if (!cfgs[i].getId().equals(id1)) {
                newActive = cfgs[i];
                break;
            }
            ++i;
        }
        String newActiveId = newActive.getId();
        newActive.setActive();
        ProjectModelTests.assertEquals(newActive, (Object)des.getActiveConfiguration());
        coreModel.setProjectDescription(project, des);
        des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertEquals((String)newActiveId, (String)des.getActiveConfiguration().getId());
    }

    private boolean arrayContains(Object el, Object[] a) {
        int i = 0;
        while (i < a.length) {
            if (el.equals(a[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkArrays(Object[] a1, Object[] a2) {
        if (a1 == null) {
            ProjectModelTests.assertTrue((a2 == null ? 1 : 0) != 0);
            return;
        }
        ProjectModelTests.assertTrue((a2 != null ? 1 : 0) != 0);
        ProjectModelTests.assertEquals((int)a1.length, (int)a2.length);
        int i = 0;
        while (i < a1.length) {
            Object o1 = a1[i];
            boolean found = false;
            int j = 0;
            while (j < a2.length) {
                if (o1.equals(a2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                ProjectModelTests.fail((String)("a2 array does not contain the \"" + o1 + "\" element"));
            }
            ++i;
        }
    }

    public static IProject createProject(String name, String projTypeId) throws CoreException {
        IProject project = ProjectModelTests.createProject(name);
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        ProjectModelTests.assertNull((String)"detDescription1 returned not null!", (Object)des);
        des = coreModel.createProjectDescription(project, true);
        ProjectModelTests.assertNotNull((String)"createDescription returned null!", (Object)des);
        ProjectModelTests.assertNull((String)"detDescription2 returned not null!", (Object)coreModel.getProjectDescription(project));
        ProjectModelTests.assertFalse((String)"new des should be not valid", (boolean)des.isValid());
        ProjectModelTests.assertEquals((int)0, (int)des.getConfigurations().length);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)projTypeId);
        ProjectModelTests.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            String id = ManagedBuildManager.calculateChildId((String)cfgs[i].getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)cfgs[i], id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ProjectModelTests.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            ++i;
        }
        coreModel.setProjectDescription(project, des);
        return project;
    }

    public static IProject createProject(String name) throws CoreException {
        return ProjectModelTests.createProject(name, null);
    }

    public static IProject createProject(String name, IPath location) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocation(location);
            }
            project = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    private class CDefaultModelEventChecker
    extends CModelEventChecker {
        private CDefaultModelEventChecker() {
        }

        void checkEvent(ElementChangedEvent event) {
            super.checkEvent(event);
            ProjectModelTests.assertEquals((int)1, (int)event.getType());
            ICElementDelta delta = event.getDelta();
            System.out.println(delta.toString());
        }
    }

    private class CModelEventChecker {
        private boolean fEventOccured;

        private CModelEventChecker() {
        }

        void checkEvent(ElementChangedEvent event) {
            this.fEventOccured = true;
        }
    }
}

