/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.mylyn.internal.ui.CDTStructureBridge;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHistoryManager
extends AbstractContextListener {
    public void contextActivated(IInteractionContext context) {
        this.clearTypeHistory();
        for (IInteractionElement node : context.getInteresting()) {
            this.updateTypeHistory(node, true);
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        ICElement element = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
        if (element instanceof IStructureDeclaration || element instanceof ITypeDef) {
            element.getElementName();
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void contextCleared(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void clearTypeHistory() {
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        for (IInteractionElement node : nodes) {
            this.updateTypeHistory(node, true);
        }
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateTypeHistory(node, false);
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            this.updateTypeHistory(element, false);
        }
    }

    public void landmarkAdded(IInteractionElement node) {
    }

    public void landmarkRemoved(IInteractionElement node) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void contextPreActivated(IInteractionContext context) {
    }
}

