/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.LogWriter;

public class TraceUtil {
    public static final String EOL = System.getProperty("line.separator");
    public static boolean SCANNER_CONFIG = false;
    private static LogWriter logger = null;

    static {
        logger = new LogWriter(MakeCorePlugin.getDefault().getStateLocation().append(".log").toFile());
    }

    protected void finalize() throws Throwable {
        logger.shutdown();
        super.finalize();
    }

    public static boolean isTracing() {
        return SCANNER_CONFIG;
    }

    public static void outputTrace(String prefix, String[] tokens, String postfix) {
        if (TraceUtil.isTracing()) {
            System.out.print(String.valueOf(prefix) + ' ');
            int i = 0;
            while (i < tokens.length) {
                System.out.print(String.valueOf(tokens[i]) + ' ');
                ++i;
            }
            System.out.println(postfix);
        }
    }

    public static void outputTrace(String prefix, String msg, String postfix) {
        if (TraceUtil.isTracing()) {
            System.out.println(String.valueOf(prefix) + ' ' + msg + ' ' + postfix);
        }
    }

    public static void outputTrace(String title, String subtitle1, List item1, List item1new, String subtitle2, List item2) {
        if (TraceUtil.isTracing()) {
            System.out.println(title);
            System.out.println("  " + subtitle1 + " (" + item1.size() + "):");
            int count = 0;
            Iterator i = item1.iterator();
            Iterator j = item1new.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + (String)i.next() + (j.hasNext() ? "' -> '" + (String)j.next() : "") + '\'');
            }
            System.out.println("  " + subtitle2 + " (" + item2.size() + "):");
            count = 0;
            i = item2.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + (String)i.next() + '\'');
            }
        }
    }

    public static void outputError(String string, String line) {
        if (TraceUtil.isTracing()) {
            System.out.println();
            System.out.println("Error: " + string + line);
        }
    }

    public static void outputError(String string, String[] tokens) {
        if (TraceUtil.isTracing()) {
            System.out.println();
            System.out.print("Error: " + string);
            int i = 0;
            while (i < tokens.length) {
                System.out.print(String.valueOf(tokens[i]) + ' ');
                ++i;
            }
            System.out.println();
        }
    }

    public static void metricsTrace(String title, String subtitlePrefix, String subtitlePostfix, Map directoryCommandListMap) {
        try {
            logger.writeln();
            logger.writeln(" *** NEW METRICS TRACE ***");
            logger.writeln();
            for (String dir : directoryCommandListMap.keySet()) {
                logger.writeln(String.valueOf(title) + dir + ":");
                List directoryCommandList = (List)directoryCommandListMap.get(dir);
                if (directoryCommandList == null) {
                    logger.writeln("  --- empty ---" + EOL);
                    return;
                }
                for (Map command21FileListMap : directoryCommandList) {
                    String[] commands = command21FileListMap.keySet().toArray(new String[1]);
                    logger.writeln("  " + subtitlePrefix + commands[0] + subtitlePostfix);
                    List fileList = (List)command21FileListMap.get(commands[0]);
                    for (String fileName : fileList) {
                        logger.writeln("    " + fileName);
                    }
                }
            }
            logger.flushLog();
        }
        catch (IOException iOException) {}
    }

    public static void summaryTrace(String title, int workingDirsN, int commandsN, int filesN) {
        try {
            logger.writeln();
            logger.writeln(" *** METRICS SUMMARY ***");
            logger.writeln();
            logger.writeln(title);
            logger.writeln("  Number of directories visited: " + Integer.toString(workingDirsN));
            logger.writeln("  Number of generic commands:    " + Integer.toString(commandsN));
            logger.writeln("  Number of compiled files:      " + Integer.toString(filesN));
            logger.flushLog();
        }
        catch (IOException iOException) {}
    }

    public static void metricsTrace(String trace) {
        try {
            logger.writeln();
            logger.writeln(" *** NEW METRICS TRACE 2 ***");
            logger.writeln();
            logger.writeln(trace);
            logger.flushLog();
        }
        catch (IOException iOException) {}
    }
}

