/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.util.ILRUCacheable;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CodeReaderCache
implements ICodeReaderCache {
    public static final String CODE_READER_BUFFER = "org.eclipse.cdt.core.codeReaderCache";
    public static final int DEFAULT_CACHE_SIZE_IN_MB = 64;
    public static final String DEFAULT_CACHE_SIZE_IN_MB_STRING = String.valueOf(64);
    private static final int MB_TO_KB_FACTOR = 1024;
    private CodeReaderLRUCache cache = null;
    private final IResourceChangeListener listener = new UpdateCodeReaderCacheListener(this);

    public CodeReaderCache(int size) {
        this.cache = new CodeReaderLRUCache(size * 1024);
    }

    protected void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    public synchronized CodeReader get(String key) {
        CodeReader ret = null;
        if (this.cache.getSpaceLimit() > 0) {
            ret = this.cache.get(key);
        }
        if (ret == null) {
            if (!new File(key).exists()) {
                return null;
            }
            List emptyList = Collections.emptyList();
            ret = ParserUtil.createReader(key, emptyList.iterator());
            if (this.cache.getSpaceLimit() > 0) {
                this.put(ret);
            }
        }
        return ret;
    }

    private synchronized CodeReader put(CodeReader value) {
        if (value == null) {
            return null;
        }
        if (this.cache.isEmpty() && ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        }
        return this.cache.put(String.valueOf(value.filename), value);
    }

    public void setCacheSize(int size) {
        this.cache.setSpaceLimit(size * 1024);
    }

    public synchronized CodeReader remove(String key) {
        CodeReader removed = this.cache.remove(key);
        if (this.cache.isEmpty() && ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
        return removed;
    }

    public int getCurrentSpace() {
        return this.cache.getCurrentSpace();
    }

    public void flush() {
        this.cache.flush();
        if (ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    private class CodeReaderCacheEntry
    implements ILRUCacheable {
        private static final double CHAR_TO_KB_FACTOR = 1024.0;
        CodeReader reader = null;
        int size = 0;

        public CodeReaderCacheEntry(CodeReader value) {
            this.reader = value;
            this.size = (int)Math.ceil((double)this.reader.buffer.length / 1024.0);
        }

        public int getCacheFootprint() {
            return this.size;
        }

        public CodeReader getCodeReader() {
            return this.reader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CodeReaderLRUCache
    extends OverflowingLRUCache<String, CodeReaderCacheEntry> {
        public CodeReaderLRUCache(int size) {
            this.setSpaceLimit(size);
        }

        @Override
        protected boolean close(LRUCache.LRUCacheEntry<String, CodeReaderCacheEntry> entry) {
            CodeReader obj = this.remove((String)entry._fKey);
            return obj != null;
        }

        @Override
        protected OverflowingLRUCache<String, CodeReaderCacheEntry> newInstance(int size, int overflow) {
            return null;
        }

        public CodeReader remove(String key) {
            Object removed = this.removeKey(key);
            if (removed instanceof CodeReaderCacheEntry) {
                return ((CodeReaderCacheEntry)removed).getCodeReader();
            }
            return null;
        }

        @Override
        public CodeReader put(String key, CodeReader value) {
            CodeReaderCacheEntry entry = new CodeReaderCacheEntry(value);
            CodeReaderCacheEntry ret = this.put(key, entry);
            if (ret != null) {
                return ret.getCodeReader();
            }
            return null;
        }

        public CodeReader get(String key) {
            CodeReaderCacheEntry obj = (CodeReaderCacheEntry)this.peek(key);
            if (obj != null) {
                return obj.getCodeReader();
            }
            return null;
        }
    }

    private class UpdateCodeReaderCacheListener
    implements IResourceChangeListener {
        ICodeReaderCache c = null;

        public UpdateCodeReaderCacheListener(ICodeReaderCache cache) {
            this.c = cache;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.c instanceof CodeReaderCache) {
                new RemoveCacheJob(this.c, event).schedule();
            }
        }

        private class RemoveCacheJob
        extends Job {
            private static final String REMOVE_CACHE = "Remove Cache";
            ICodeReaderCache cache1;
            IResourceChangeEvent event;

            public RemoveCacheJob(ICodeReaderCache cache, IResourceChangeEvent event) {
                super(REMOVE_CACHE);
                this.cache1 = null;
                this.event = null;
                this.cache1 = cache;
                this.event = event;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.event.getSource() instanceof IWorkspace && this.event.getDelta() != null) {
                    this.removeKeys(this.event.getDelta().getAffectedChildren());
                }
                this.event = null;
                return Status.OK_STATUS;
            }

            private void removeKeys(IResourceDelta[] deltas) {
                IResourceDelta[] iResourceDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource().getType() == 4 || delta.getResource().getType() == 2) {
                        this.removeKeys(delta.getAffectedChildren());
                    } else if (delta.getResource() instanceof IFile && ((IFile)delta.getResource()).getLocation() != null) {
                        this.removeKey(((IFile)delta.getResource()).getLocation().toOSString());
                    }
                    ++n2;
                }
            }

            private void removeKey(String key) {
                if (key != null && this.cache1 != null) {
                    this.cache1.remove(key);
                }
            }
        }
    }
}

