/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.COwnerConfiguration;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CStorage;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.PathEntryConfigurationDataProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;

public class CConfigBasedDescriptorManager
implements ICDescriptorManager {
    private static CConfigBasedDescriptorManager fInstance;
    public static final String NULL_OWNER_ID = "";
    private Map fOwnerConfigMap = null;
    private ICProjectDescriptionListener fDescriptionListener;
    private static final QualifiedName DESCRIPTOR_PROPERTY;
    private List fListeners = Collections.synchronizedList(new Vector());
    private ThreadLocal fThreadInfo = new ThreadLocal();
    private static final COwnerConfiguration NULLCOwner;
    private ILock fInstanceLock = Job.getJobManager().newLock();

    static {
        DESCRIPTOR_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "CDescriptor");
        NULLCOwner = new COwnerConfiguration(NULL_OWNER_ID, CCorePlugin.getResourceString("CDescriptorManager.internal_owner"));
    }

    private CConfigBasedDescriptorManager() {
    }

    public static CConfigBasedDescriptorManager getInstance() {
        if (fInstance == null) {
            fInstance = CConfigBasedDescriptorManager.getInstanceSynch();
        }
        return fInstance;
    }

    public static synchronized CConfigBasedDescriptorManager getInstanceSynch() {
        if (fInstance == null) {
            fInstance = new CConfigBasedDescriptorManager();
        }
        return fInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IProject project, String id) throws CoreException {
        CConfigBasedDescriptor dr;
        if (id.equals(NULLCOwner.getOwnerID())) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.invalid_ownerID"), null);
            throw new CoreException((IStatus)status);
        }
        CProjectDescriptionManager cProjectDescriptionManager = CProjectDescriptionManager.getInstance();
        synchronized (cProjectDescriptionManager) {
            block9: {
                dr = this.findDescriptor(project, false);
                if (dr != null) {
                    if (dr.getProjectOwner().getID().equals(NULLCOwner.getOwnerID())) {
                        dr = this.updateDescriptor(project, dr, id);
                        break block9;
                    } else {
                        if (!dr.getProjectOwner().getID().equals(id)) {
                            Status status = new Status(4, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptorManager.exception.alreadyConfigured"), null);
                            throw new CoreException((IStatus)status);
                        }
                        return;
                    }
                }
                dr = this.findDescriptor(project, true);
                dr = this.updateDescriptor(project, dr, id);
            }
        }
        dr.apply(true);
        if (dr.isOperationStarted()) {
            dr.setOpEvent(new CDescriptorEvent(dr, 2, 0));
        }
    }

    private CConfigBasedDescriptor updateDescriptor(IProject project, CConfigBasedDescriptor dr, String ownerId) throws CoreException {
        ICConfigurationDescription cfgDes = dr.getConfigurationDescription();
        ICProjectDescription projDes = cfgDes.getProjectDescription();
        CConfigurationSpecSettings settings = ((IInternalCCfgInfo)((Object)cfgDes)).getSpecSettings();
        settings.setCOwner(ownerId);
        COwner owner = settings.getCOwner();
        this.setLoaddedDescriptor(projDes, null);
        dr = this.findDescriptor((CProjectDescription)projDes);
        dr.setApplyOnChange(false);
        owner.configure(project, dr);
        dr.setApplyOnChange(true);
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(IProject project, String id) throws CoreException {
        CConfigBasedDescriptor dr = this.findDescriptor(project, false);
        if (dr == null) {
            throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.0"));
        }
        CProjectDescriptionManager cProjectDescriptionManager = CProjectDescriptionManager.getInstance();
        synchronized (cProjectDescriptionManager) {
            dr = this.updateDescriptor(project, dr, id);
        }
        dr.apply(true);
        if (dr.isOperationStarted()) {
            dr.setOpEvent(new CDescriptorEvent(dr, 1, 16));
        }
    }

    public ICDescriptor getDescriptor(IProject project) throws CoreException {
        return this.getDescriptor(project, true);
    }

    public ICDescriptor getDescriptor(IProject project, boolean create) throws CoreException {
        if (create) {
            CProjectDescriptionManager cProjectDescriptionManager = CProjectDescriptionManager.getInstance();
            synchronized (cProjectDescriptionManager) {
                CConfigBasedDescriptor cConfigBasedDescriptor;
                try {
                    this.fInstanceLock.acquire();
                    cConfigBasedDescriptor = this.findDescriptor(project, create);
                }
                catch (Throwable throwable) {
                    this.fInstanceLock.release();
                    throw throwable;
                }
                this.fInstanceLock.release();
                return cConfigBasedDescriptor;
            }
        }
        return this.findDescriptor(project, create);
    }

    public void addDescriptorListener(ICDescriptorListener listener) {
        this.fListeners.add(listener);
    }

    public void removeDescriptorListener(ICDescriptorListener listener) {
        this.fListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDescriptorOperation(IProject project, ICDescriptorOperation op, IProgressMonitor monitor) throws CoreException {
        CConfigBasedDescriptor dr = this.findDescriptor(project, true);
        if (dr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "Failed to create descriptor", null));
        }
        CDescriptorEvent event = null;
        CProjectDescriptionManager cProjectDescriptionManager = CProjectDescriptionManager.getInstance();
        synchronized (cProjectDescriptionManager) {
            boolean initialApplyOnChange = dr.isApplyOnChange();
            dr.setApplyOnChange(false);
            try {
                dr.operationStart();
                op.execute(dr, monitor);
            }
            finally {
                event = dr.operationStop();
                dr.setApplyOnChange(initialApplyOnChange);
            }
        }
        if (event != null) {
            CConfigBasedDescriptorManager.getInstance().notifyListeners(event);
        }
    }

    public void runDescriptorOperation(IProject project, ICProjectDescription des, ICDescriptorOperation op, IProgressMonitor monitor) throws CoreException {
        CConfigBasedDescriptor dr = this.getOperatingDescriptor(project);
        if (dr != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CConfigBasedDescriptorManager.1"), null));
        }
        if (des.isReadOnly()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CConfigBasedDescriptorManager.2"), null));
        }
        dr = this.loadDescriptor((CProjectDescription)des);
        if (dr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CConfigBasedDescriptorManager.3"), null));
        }
        this.setOperatingDescriptor(project, dr);
        dr.setApplyOnChange(false);
        try {
            op.execute(dr, monitor);
            this.reconsile(dr, des);
        }
        finally {
            this.clearOperatingDescriptor(project);
        }
    }

    private CConfigBasedDescriptor getLoaddedDescriptor(ICProjectDescription des) {
        return (CConfigBasedDescriptor)des.getSessionProperty(DESCRIPTOR_PROPERTY);
    }

    private void setLoaddedDescriptor(ICProjectDescription des, CConfigBasedDescriptor dr) {
        des.setSessionProperty(DESCRIPTOR_PROPERTY, dr);
    }

    private CConfigBasedDescriptor findDescriptor(IProject project, boolean create) throws CoreException {
        CConfigBasedDescriptor dr = this.getOperatingDescriptor(project);
        if (dr != null) {
            return dr;
        }
        CProjectDescription des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        if (des == null && create) {
            des = this.createProjDescriptionForDescriptor(project);
        }
        if (des != null) {
            dr = this.findDescriptor(des);
        }
        return dr;
    }

    private CConfigBasedDescriptor findDescriptor(CProjectDescription des) throws CoreException {
        CConfigBasedDescriptor dr = this.getApplyingDescriptor(des.getProject());
        if (dr != null) {
            return dr;
        }
        if (des.isApplying()) {
            dr = this.loadDescriptor(des);
            this.setApplyingDescriptor(des.getProject(), dr);
            return dr;
        }
        dr = this.getLoaddedDescriptor(des);
        if (dr == null && (dr = this.loadDescriptor(des)) != null) {
            this.setLoaddedDescriptor(des, dr);
        }
        return dr;
    }

    private CProjectDescription createProjDescriptionForDescriptor(IProject project) throws CoreException {
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        CProjectDescription des = (CProjectDescription)mngr.createProjectDescription(project, false, true);
        CConfigurationData data = mngr.createDefaultConfigData(project, PathEntryConfigurationDataProvider.getDataFactory());
        des.createConfiguration("org.eclipse.cdt.core.defaultConfigDataProvider", data);
        return des;
    }

    private CConfigBasedDescriptor loadDescriptor(CProjectDescription des) throws CoreException {
        CConfigBasedDescriptor dr = null;
        if (des != null) {
            ICConfigurationDescription cfgDes;
            if (des.isReadOnly()) {
                des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(des.getProject(), true);
            }
            if ((cfgDes = des.getDefaultSettingConfiguration()) instanceof CConfigurationDescriptionCache) {
                des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(des.getProject(), true);
                cfgDes = des.getDefaultSettingConfiguration();
            }
            if (cfgDes != null) {
                if (cfgDes.isReadOnly()) {
                    throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.4"));
                }
                dr = new CConfigBasedDescriptor(cfgDes);
            } else if (!des.isCdtProjectCreating()) {
                throw ExceptionFactory.createCoreException(CCorePlugin.getResourceString("CConfigBasedDescriptorManager.5"));
            }
        }
        return dr;
    }

    public COwnerConfiguration getOwnerConfiguration(String id) {
        COwnerConfiguration config;
        if (id.equals(NULLCOwner.getOwnerID())) {
            return NULLCOwner;
        }
        if (this.fOwnerConfigMap == null) {
            this.initializeOwnerConfiguration();
        }
        if ((config = (COwnerConfiguration)this.fOwnerConfigMap.get(id)) == null) {
            config = new COwnerConfiguration(id, CCorePlugin.getResourceString("CDescriptorManager.owner_not_Installed"));
            this.fOwnerConfigMap.put(id, config);
        }
        return config;
    }

    private void initializeOwnerConfiguration() {
        IExtensionPoint extpoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CProject");
        IExtension[] extension = extpoint.getExtensions();
        this.fOwnerConfigMap = new HashMap(extension.length);
        int i = 0;
        while (i < extension.length) {
            IConfigurationElement[] element = extension[i].getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                if (element[j].getName().equalsIgnoreCase("cproject")) {
                    this.fOwnerConfigMap.put(extension[i].getUniqueIdentifier(), new COwnerConfiguration(element[j]));
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void startup() {
        if (this.fDescriptionListener == null) {
            this.fDescriptionListener = new ICProjectDescriptionListener(){

                public void handleEvent(CProjectDescriptionEvent event) {
                    CConfigBasedDescriptorManager.this.doHandleEvent(event);
                }
            };
            CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this.fDescriptionListener, 23);
        }
    }

    public void shutdown() {
        if (this.fDescriptionListener != null) {
            CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this.fDescriptionListener);
        }
    }

    private void doHandleEvent(CProjectDescriptionEvent event) {
        try {
            switch (event.getEventType()) {
                case 1: {
                    CProjectDescription des = (CProjectDescription)event.getNewCProjectDescription();
                    CConfigBasedDescriptor dr = this.getLoaddedDescriptor(des);
                    if (dr != null && (des = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(des.getProject(), true)) != null) {
                        ICConfigurationDescription cfgDescription = des.getDefaultSettingConfiguration();
                        if (cfgDescription != null) {
                            dr.updateConfiguration(cfgDescription);
                            dr.setDirty(false);
                            break;
                        }
                        this.setLoaddedDescriptor(des, null);
                    }
                    break;
                }
                case 2: {
                    CConfigBasedDescriptor dr;
                    CProjectDescription des = (CProjectDescription)event.getNewCProjectDescription();
                    if (des != null && (dr = this.getLoaddedDescriptor(des)) != null && dr.getConfigurationDescription().getProjectDescription() != des) {
                        this.reconsile(dr, des);
                    }
                    break;
                }
                case 16: {
                    CConfigBasedDescriptor dr;
                    CProjectDescription des = (CProjectDescription)event.getNewCProjectDescription();
                    if (des != null && (dr = this.clearApplyingDescriptor(event.getProject())) != null) {
                        this.reconsile(dr, des);
                    }
                    break;
                }
                case 4: {
                    CProjectDescription newDes = (CProjectDescription)event.getNewCProjectDescription();
                    CProjectDescription oldDes = (CProjectDescription)event.getOldCProjectDescription();
                    CDescriptorEvent desEvent = null;
                    CConfigBasedDescriptor dr = null;
                    ICConfigurationDescription updatedCfg = null;
                    if (oldDes == null) {
                        dr = this.findDescriptor(newDes);
                        updatedCfg = newDes.getDefaultSettingConfiguration();
                        if (dr != null) {
                            desEvent = new CDescriptorEvent(dr, 2, 0);
                        }
                    } else if (newDes == null) {
                        dr = this.findDescriptor(oldDes);
                        if (dr != null) {
                            desEvent = new CDescriptorEvent(dr, 3, 0);
                        }
                    } else {
                        dr = this.findDescriptor(newDes);
                        updatedCfg = newDes.getDefaultSettingConfiguration();
                        if (dr != null) {
                            ICConfigurationDescription newCfg = newDes.getDefaultSettingConfiguration();
                            ICConfigurationDescription oldCfg = oldDes.getDefaultSettingConfiguration();
                            int flags = 0;
                            if (oldCfg != null && newCfg != null) {
                                if (newCfg.getId().equals(oldCfg.getId())) {
                                    ICDescriptionDelta cfgDelta = this.findCfgDelta(event.getProjectDelta(), newCfg.getId());
                                    if (cfgDelta != null) {
                                        flags = cfgDelta.getChangeFlags() & 0x180000;
                                    }
                                } else {
                                    flags = CProjectDescriptionManager.getInstance().calculateDescriptorFlags(newCfg, oldCfg);
                                }
                            }
                            int drEventFlags = this.descriptionFlagsToDescriptorFlags(flags);
                            desEvent = new CDescriptorEvent(dr, 1, drEventFlags);
                        }
                    }
                    if (updatedCfg != null && dr != null) {
                        CProjectDescription writableDes = (CProjectDescription)CProjectDescriptionManager.getInstance().getProjectDescription(event.getProject(), true);
                        ICConfigurationDescription indexCfg = writableDes.getDefaultSettingConfiguration();
                        dr.updateConfiguration(indexCfg);
                        dr.setDirty(false);
                    }
                    if (desEvent == null) break;
                    this.notifyListeners(desEvent);
                }
                default: {
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private int descriptionFlagsToDescriptorFlags(int flags) {
        int result = 0;
        if ((flags & 0x80000) != 0) {
            result |= 0x20;
        }
        if ((flags & 0x100000) != 0) {
            result |= 0x10;
        }
        return result;
    }

    private ICDescriptionDelta findCfgDelta(ICDescriptionDelta delta, String id) {
        if (delta == null) {
            return null;
        }
        ICDescriptionDelta[] children = delta.getChildren();
        int i = 0;
        while (i < children.length) {
            ICSettingObject s = children[i].getNewSetting();
            if (s != null && id.equals(s.getId())) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(final CDescriptorEvent event) {
        ICDescriptorListener[] listeners;
        List list = this.fListeners;
        synchronized (list) {
            listeners = this.fListeners.toArray(new ICDescriptorListener[this.fListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final int index = i++;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.listenerError"), exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listeners[index].descriptorChanged(event);
                }
            });
        }
    }

    public boolean reconsile(CConfigBasedDescriptor descriptor, ICProjectDescription des) {
        Map<String, Element> map = descriptor.getStorageDataElMap();
        boolean reconsiled = false;
        if (map.size() != 0) {
            for (Map.Entry<String, Element> entry : map.entrySet()) {
                Element el;
                String id = entry.getKey();
                if (!this.reconsile(id, (el = entry.getValue()).getParentNode() != null ? el : null, des)) continue;
                reconsiled = true;
            }
        }
        return reconsiled;
    }

    private boolean reconsile(String id, Element el, ICProjectDescription des) {
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        boolean reconsiled = false;
        int i = 0;
        while (i < cfgs.length) {
            try {
                if (this.reconsile(id, el, cfgs[i])) {
                    reconsiled = true;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        return reconsiled;
    }

    private boolean reconsile(String id, Element el, ICConfigurationDescription cfg) throws CoreException {
        CConfigurationSpecSettings setting = ((IInternalCCfgInfo)((Object)cfg)).getSpecSettings();
        InternalXmlStorageElement storEl = (InternalXmlStorageElement)setting.getStorage(id, false);
        InternalXmlStorageElement newStorEl = el != null ? CStorage.createStorageElement(el, false) : null;
        boolean modified = false;
        if (storEl != null) {
            if (newStorEl == null) {
                setting.removeStorage(id);
                modified = true;
            } else if (!newStorEl.matches(storEl)) {
                setting.importStorage(id, newStorEl);
                modified = true;
            }
        } else if (newStorEl != null) {
            setting.importStorage(id, newStorEl);
            modified = true;
        }
        return modified;
    }

    private CConfigBasedDescriptor getApplyingDescriptor(IProject project) {
        Map map = this.getApplyingDescriptorMap(false);
        if (map != null) {
            return (CConfigBasedDescriptor)map.get(project);
        }
        return null;
    }

    private void setApplyingDescriptor(IProject project, CConfigBasedDescriptor dr) {
        if (dr == null) {
            this.clearApplyingDescriptor(project);
        } else {
            Map map = this.getApplyingDescriptorMap(true);
            map.put(project, dr);
        }
    }

    private CConfigBasedDescriptor clearApplyingDescriptor(IProject project) {
        Map map = this.getApplyingDescriptorMap(false);
        if (map != null) {
            return (CConfigBasedDescriptor)map.remove(project);
        }
        return null;
    }

    private Map getApplyingDescriptorMap(boolean create) {
        ThreadInfo info = this.getThreadInfo(create);
        if (info == null) {
            return null;
        }
        return info.getApplyingDescriptorMap(create);
    }

    private CConfigBasedDescriptor getOperatingDescriptor(IProject project) {
        Map map = this.getOperatingDescriptorMap(false);
        if (map != null) {
            return (CConfigBasedDescriptor)map.get(project);
        }
        return null;
    }

    private void setOperatingDescriptor(IProject project, CConfigBasedDescriptor dr) {
        if (dr == null) {
            this.clearOperatingDescriptor(project);
        } else {
            Map map = this.getOperatingDescriptorMap(true);
            map.put(project, dr);
        }
    }

    private CConfigBasedDescriptor clearOperatingDescriptor(IProject project) {
        Map map = this.getOperatingDescriptorMap(false);
        if (map != null) {
            return (CConfigBasedDescriptor)map.remove(project);
        }
        return null;
    }

    private Map getOperatingDescriptorMap(boolean create) {
        ThreadInfo info = this.getThreadInfo(create);
        if (info == null) {
            return null;
        }
        return info.getOperatingDescriptorMap(create);
    }

    private ThreadInfo getThreadInfo(boolean create) {
        ThreadInfo info = (ThreadInfo)this.fThreadInfo.get();
        if (info == null && create) {
            info = new ThreadInfo();
            this.fThreadInfo.set(info);
        }
        return info;
    }

    private class ThreadInfo {
        Map fApplyingDescriptorMap;
        Map fOperatingDescriptorMap;

        private ThreadInfo() {
        }

        public Map getApplyingDescriptorMap(boolean create) {
            if (this.fApplyingDescriptorMap == null && create) {
                this.fApplyingDescriptorMap = new HashMap(1);
            }
            return this.fApplyingDescriptorMap;
        }

        public Map getOperatingDescriptorMap(boolean create) {
            if (this.fOperatingDescriptorMap == null && create) {
                this.fOperatingDescriptorMap = new HashMap(1);
            }
            return this.fOperatingDescriptorMap;
        }
    }
}

