/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

class ClassTypeMixin {
    private ICPPInternalClassTypeMixinHost host;

    public ClassTypeMixin(ICPPInternalClassTypeMixinHost host) {
        this.host = host;
    }

    public IBinding[] getFriends() {
        IASTDeclaration[] members;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IBinding[]{new ProblemBinding(node, 7, this.host.getNameCharArray())};
            }
        }
        ObjectSet<IBinding> resultSet = new ObjectSet<IBinding>(2);
        IASTDeclaration[] iASTDeclarationArray = members = this.host.getCompositeTypeSpecifier().getMembers();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTDeclSpecifier declSpec;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec.isFriend()) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && dtors.length == 0) {
                        resultSet.put(((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding());
                    } else {
                        IASTDeclarator[] iASTDeclaratorArray = dtors;
                        int n3 = dtors.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTDeclarator dtor = iASTDeclaratorArray[n4];
                            if (dtor != null) {
                                dtor = CPPVisitor.findInnermostDeclarator(dtor);
                                resultSet.put(dtor.getName().resolveBinding());
                                ++n4;
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition && (declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier()).isFriend()) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = CPPVisitor.findInnermostDeclarator(dtor);
                resultSet.put(dtor.getName().resolveBinding());
            }
            ++n2;
        }
        return resultSet.keyArray(IBinding.class);
    }

    public ICPPBase[] getBases() {
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPBase[]{new CPPBaseClause.CPPBaseProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        if ((bases = this.host.getCompositeTypeSpecifier().getBaseSpecifiers()).length == 0) {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
        ICPPBase[] bindings = new ICPPBase[bases.length];
        int i = 0;
        while (i < bases.length) {
            bindings[i] = new CPPBaseClause(bases[i]);
            ++i;
        }
        return bindings;
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        IASTDeclaration[] decls;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPField[]{new CPPField.CPPFieldProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = this.host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                n3 = dtors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n4];
                    binding = CPPVisitor.findInnermostDeclarator(dtor).getName().resolveBinding();
                    if (binding instanceof ICPPField) {
                        result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                    }
                    ++n4;
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs;
                    IBinding[] iBindingArray = bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int n6 = bs.length;
                    n3 = 0;
                    while (n3 < n6) {
                        IBinding element = iBindingArray[n3];
                        if (element instanceof ICPPField) {
                            result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPField) {
                    result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPField[])ArrayUtil.trim(ICPPField.class, result);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        ICPPBase[] bases;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] methods = this.getDeclaredMethods();
        ICPPBase[] iCPPBaseArray = bases = this.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                methods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, methods, ((ICPPClassType)b).getAllDeclaredMethods());
            }
            ++n2;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, methods);
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        IASTDeclaration[] decls;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = this.host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                n3 = dtors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n4];
                    binding = CPPVisitor.findInnermostDeclarator(dtor).getName().resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                    }
                    ++n4;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                binding = (dtor = CPPVisitor.findInnermostDeclarator(dtor)).getName().resolveBinding();
                if (binding instanceof ICPPMethod) {
                    result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs;
                    IBinding[] iBindingArray = bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int n6 = bs.length;
                    n3 = 0;
                    while (n3 < n6) {
                        IBinding element = iBindingArray[n3];
                        if (element instanceof ICPPMethod) {
                            result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPMethod) {
                    result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, result);
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        IASTDeclaration[] members;
        ICPPClassScope scope;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPConstructor[]{new CPPConstructor.CPPConstructorProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        if (ASTInternal.isFullyCached(scope = (ICPPClassScope)this.host.getCompositeScope())) {
            return ((CPPClassScope)scope).getConstructors(true);
        }
        IASTDeclaration[] iASTDeclarationArray = members = this.host.getCompositeTypeSpecifier().getMembers();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                int n3 = dtors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n4];
                    if (dtor != null) {
                        dtor = CPPVisitor.findInnermostDeclarator(dtor);
                        ASTInternal.addName(scope, dtor.getName());
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = CPPVisitor.findInnermostDeclarator(dtor);
                ASTInternal.addName(scope, dtor.getName());
            }
            ++n2;
        }
        return ((CPPClassScope)scope).getConstructors(true);
    }

    public ICPPClassType[] getNestedClasses() {
        IASTDeclaration[] decls;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPClassType[]{new CPPClassType.CPPClassTypeProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] result = null;
        IASTDeclaration[] iASTDeclarationArray = decls = this.host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IBinding binding = null;
                IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && ((IASTSimpleDeclaration)decl).getDeclarators().length == 0) {
                    binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                }
                if (binding instanceof ICPPClassType) {
                    result = (ICPPClassType[])ArrayUtil.append(ICPPClassType.class, result, binding);
                }
            }
            ++n2;
        }
        return (ICPPClassType[])ArrayUtil.trim(ICPPClassType.class, result);
    }

    public IField[] getFields() throws DOMException {
        ICPPBase[] bases;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IField[]{new CPPField.CPPFieldProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] fields = this.getDeclaredFields();
        ICPPBase[] iCPPBaseArray = bases = this.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                fields = (IField[])ArrayUtil.addAll(IField.class, fields, ((ICPPClassType)b).getFields());
            }
            ++n2;
        }
        return (IField[])ArrayUtil.trim(IField.class, fields);
    }

    public IField findField(String name) throws DOMException {
        IBinding[] bindings = CPPSemantics.findBindings(this.host.getCompositeScope(), name, true);
        IField field = null;
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding instanceof IField) {
                if (field == null) {
                    field = (IField)binding;
                } else {
                    IASTNode[] declarations = this.host.getDeclarations();
                    IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                    return new CPPField.CPPFieldProblem(node, 4, name.toCharArray());
                }
            }
            ++n2;
        }
        return field;
    }
}

