/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplateInstantiator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPTemplates {
    public static IASTName getTemplateParameterName(ICPPASTTemplateParameter param) {
        if (param instanceof ICPPASTSimpleTypeTemplateParameter) {
            return ((ICPPASTSimpleTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return ((ICPPASTTemplatedTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTParameterDeclaration) {
            return CPPVisitor.findInnermostDeclarator(((ICPPASTParameterDeclaration)param).getDeclarator()).getName();
        }
        return null;
    }

    private static ICPPTemplateDefinition getContainingTemplate(ICPPASTTemplateParameter param) {
        IASTNode parent = param.getParent();
        IBinding binding = null;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            Object[] templates = new ICPPASTTemplateDeclaration[]{(ICPPASTTemplateDeclaration)parent};
            while (parent.getParent() instanceof ICPPASTTemplateDeclaration) {
                parent = parent.getParent();
                templates = (ICPPASTTemplateDeclaration[])ArrayUtil.append(ICPPASTTemplateDeclaration.class, templates, parent);
            }
            templates = (ICPPASTTemplateDeclaration[])ArrayUtil.trim(ICPPASTTemplateDeclaration.class, templates);
            Object templateDeclaration = templates[0];
            IASTDeclaration decl = templateDeclaration.getDeclaration();
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            IASTName name = null;
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                if (dtors.length == 0) {
                    IASTDeclSpecifier spec = simpleDecl.getDeclSpecifier();
                    if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                        name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                    } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                        name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                    }
                } else {
                    IASTDeclarator dtor = dtors[0];
                    dtor = CPPVisitor.findInnermostDeclarator(dtor);
                    name = dtor.getName();
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = CPPVisitor.findInnermostDeclarator(dtor);
                name = dtor.getName();
            }
            if (name == null) {
                return null;
            }
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns;
                int idx = templates.length;
                int i = 0;
                IASTName[] iASTNameArray = ns = ((ICPPASTQualifiedName)name).getNames();
                int n = ns.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName element = iASTNameArray[n2];
                    if (element instanceof ICPPASTTemplateId && ++i == idx) {
                        binding = ((ICPPASTTemplateId)element).getTemplateName().resolveBinding();
                        break;
                    }
                    ++n2;
                }
                if (binding == null) {
                    binding = ns[ns.length - 1].resolveBinding();
                }
            } else {
                binding = name.resolveBinding();
            }
        } else if (parent instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedParam = (ICPPASTTemplatedTypeTemplateParameter)parent;
            binding = templatedParam.getName().resolveBinding();
        }
        return binding instanceof ICPPTemplateDefinition ? (ICPPTemplateDefinition)binding : null;
    }

    public static IBinding createBinding(ICPPASTTemplateParameter templateParameter) {
        IASTName name;
        ICPPTemplateDefinition template = CPPTemplates.getContainingTemplate(templateParameter);
        IBinding binding = null;
        if (template instanceof CPPTemplateTemplateParameter) {
            binding = ((CPPTemplateTemplateParameter)template).resolveTemplateParameter(templateParameter);
        } else if (template instanceof CPPTemplateDefinition) {
            binding = ((CPPTemplateDefinition)template).resolveTemplateParameter(templateParameter);
        } else if (template != null && (binding = (name = CPPTemplates.getTemplateParameterName(templateParameter)).getBinding()) == null) {
            ICPPASTTemplateDeclaration templateDecl = (ICPPASTTemplateDeclaration)templateParameter.getParent();
            ICPPASTTemplateParameter[] ps = templateDecl.getTemplateParameters();
            int i = 0;
            while (i < ps.length) {
                if (templateParameter == ps[i]) break;
                ++i;
            }
            try {
                ICPPTemplateParameter[] params = template.getTemplateParameters();
                if (i < params.length) {
                    binding = params[i];
                    name.setBinding(binding);
                }
            }
            catch (DOMException dOMException) {}
        }
        return binding;
    }

    public static ICPPScope getContainingScope(IASTNode node) {
        while (node != null) {
            IASTNode parent;
            if (node instanceof ICPPASTTemplateParameter && (parent = node.getParent()) instanceof ICPPASTTemplateDeclaration) {
                return ((ICPPASTTemplateDeclaration)parent).getScope();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IBinding createBinding(ICPPASTTemplateId id) {
        IASTNode parent = id.getParent();
        int segment = -1;
        if (parent instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)parent).getNames();
            segment = ns[ns.length - 1] == id ? 1 : 0;
            parent = parent.getParent();
        }
        IASTNode decl = parent.getParent();
        while (!(decl instanceof IASTDeclaration)) {
            decl = decl.getParent();
        }
        if ((decl = decl.getParent()) instanceof ICPPASTExplicitTemplateInstantiation && parent instanceof ICPPASTElaboratedTypeSpecifier && segment != 0) {
            return CPPTemplates.createClassExplicitInstantiation((ICPPASTElaboratedTypeSpecifier)parent);
        }
        if ((parent instanceof ICPPASTElaboratedTypeSpecifier && decl instanceof ICPPASTTemplateDeclaration || parent instanceof ICPPASTCompositeTypeSpecifier) && segment != 0) {
            return CPPTemplates.createClassSpecialization((ICPPASTDeclSpecifier)parent);
        }
        if (parent instanceof ICPPASTFunctionDeclarator && segment != 0) {
            return CPPTemplates.createFunctionSpecialization(id);
        }
        IBinding template = null;
        if (parent instanceof ICPPASTNamedTypeSpecifier || parent instanceof ICPPASTElaboratedTypeSpecifier || parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || segment == 0) {
            IASTName templateName = id.getTemplateName();
            template = templateName.resolveBinding();
            if (template instanceof ICPPClassTemplatePartialSpecialization) {
                try {
                    template = ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
                }
                catch (DOMException e) {
                    return e.getProblem();
                }
            } else if (template instanceof ICPPSpecialization && !(template instanceof ICPPTemplateDefinition)) {
                template = ((ICPPSpecialization)template).getSpecializedBinding();
            }
            if (template != null && template instanceof ICPPInternalTemplateInstantiator) {
                IType[] types = CPPTemplates.createTemplateArgumentArray(id);
                template = ((ICPPInternalTemplateInstantiator)((Object)template)).instantiate(types);
                return CPPSemantics.postResolution(template, id);
            }
        } else {
            template = CPPVisitor.createBinding(id);
            if (template instanceof ICPPTemplateInstance) {
                IASTName templateName = id.getTemplateName();
                templateName.setBinding(((ICPPTemplateInstance)template).getTemplateDefinition());
            }
        }
        return template;
    }

    protected static IBinding createClassExplicitInstantiation(ICPPASTElaboratedTypeSpecifier elabSpec) {
        ICPPASTTemplateId id;
        IBinding template;
        IASTName name = elabSpec.getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        if (!((template = (id = (ICPPASTTemplateId)name).getTemplateName().resolveBinding()) instanceof ICPPClassTemplate)) {
            return null;
        }
        ICPPClassTemplate classTemplate = (ICPPClassTemplate)template;
        IType[] args = CPPTemplates.createTemplateArgumentArray(id);
        if (classTemplate instanceof ICPPInternalTemplateInstantiator) {
            IBinding binding = ((ICPPInternalTemplateInstantiator)((Object)classTemplate)).instantiate(args);
            return binding;
        }
        return null;
    }

    protected static IBinding createClassSpecialization(ICPPASTDeclSpecifier compSpec) {
        ICPPASTTemplateId id;
        IBinding binding;
        IASTName name = null;
        if (compSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            name = ((ICPPASTElaboratedTypeSpecifier)compSpec).getName();
        } else if (compSpec instanceof ICPPASTCompositeTypeSpecifier) {
            name = ((ICPPASTCompositeTypeSpecifier)compSpec).getName();
        } else {
            return null;
        }
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        if (!((binding = (id = (ICPPASTTemplateId)name).getTemplateName().resolveBinding()) instanceof ICPPClassTemplate)) {
            return null;
        }
        ICPPClassTemplate template = (ICPPClassTemplate)binding;
        ICPPBinding spec = null;
        ICPPASTTemplateDeclaration templateDecl = CPPTemplates.getTemplateDeclaration(id);
        if (templateDecl instanceof ICPPASTTemplateSpecialization) {
            ICPPTemplateParameter[] templateParams = null;
            try {
                templateParams = template.getTemplateParameters();
            }
            catch (DOMException e) {
                return e.getProblem();
            }
            IType[] args = CPPTemplates.createTemplateArgumentArray(id);
            ObjectMap argMap = new ObjectMap(templateParams.length);
            if (templateParams.length != args.length) {
                return null;
            }
            int i = 0;
            while (i < templateParams.length) {
                argMap.put(templateParams[i], args[i]);
                ++i;
            }
            spec = ((ICPPInternalTemplateInstantiator)((Object)template)).getInstance(args);
            if (spec == null) {
                ICPPScope scope = (ICPPScope)CPPVisitor.getContainingScope(id);
                spec = new CPPClassSpecialization(binding, scope, argMap);
                if (template instanceof ICPPInternalTemplate) {
                    ((ICPPInternalTemplate)((Object)template)).addSpecialization(args, (ICPPSpecialization)spec);
                }
            }
            if (spec instanceof ICPPInternalBinding) {
                IASTNode parent = id.getParent();
                while (!(parent instanceof IASTDeclSpecifier)) {
                    parent = parent.getParent();
                }
                if (parent instanceof IASTElaboratedTypeSpecifier) {
                    ((ICPPInternalBinding)spec).addDeclaration(id);
                } else if (parent instanceof IASTCompositeTypeSpecifier) {
                    ((ICPPInternalBinding)spec).addDefinition(id);
                }
            }
            return spec;
        }
        ICPPClassTemplatePartialSpecialization[] specializations = null;
        try {
            specializations = template.getPartialSpecializations();
        }
        catch (DOMException dOMException) {}
        if (specializations != null) {
            ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = specializations;
            int n = specializations.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassTemplatePartialSpecialization specialization = iCPPClassTemplatePartialSpecializationArray[n2];
                if (CPPTemplates.isSameTemplate(specialization, id)) {
                    spec = specialization;
                    break;
                }
                ++n2;
            }
        }
        if (spec != null) {
            if (spec instanceof ICPPInternalBinding) {
                ((ICPPInternalBinding)spec).addDefinition(id);
            }
            return spec;
        }
        spec = new CPPClassTemplatePartialSpecialization(id);
        if (template instanceof ICPPInternalClassTemplate) {
            ((ICPPInternalClassTemplate)((Object)template)).addPartialSpecialization((ICPPClassTemplatePartialSpecialization)spec);
        }
        return spec;
    }

    protected static IBinding createFunctionSpecialization(IASTName name) {
        Object[] map_types;
        LookupData data = new LookupData(name);
        data.forceQualified = true;
        ICPPScope scope = (ICPPScope)CPPVisitor.getContainingScope(name);
        if (scope instanceof ICPPTemplateScope) {
            try {
                scope = (ICPPScope)scope.getParent();
            }
            catch (DOMException dOMException) {}
        }
        try {
            CPPSemantics.lookup(data, scope);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        ICPPFunctionTemplate function = CPPTemplates.resolveTemplateFunctions((Object[])data.foundItems, name);
        if (function == null) {
            return new ProblemBinding(name, 1, name.toCharArray());
        }
        if (function instanceof IProblemBinding) {
            return function;
        }
        if (name instanceof ICPPASTTemplateId) {
            ((ICPPASTTemplateId)name).getTemplateName().setBinding(function);
        }
        IASTNode parent = name.getParent();
        while (parent instanceof IASTName) {
            parent = parent.getParent();
        }
        IASTParameterDeclaration[] ps = ((ICPPASTFunctionDeclarator)parent).getParameters();
        try {
            map_types = CPPTemplates.deduceTemplateFunctionArguments(function, ps, data.templateId);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (map_types != null) {
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            ICPPSpecialization spec = null;
            if (parent.getParent() instanceof ICPPASTExplicitTemplateInstantiation) {
                spec = ((ICPPInternalTemplateInstantiator)((Object)function)).getInstance((IType[])map_types[1]);
                if (spec == null) {
                    spec = (ICPPSpecialization)CPPTemplates.createInstance(scope, function, (ObjectMap)map_types[0], (IType[])map_types[1]);
                }
            } else {
                spec = ((ICPPInternalTemplateInstantiator)((Object)function)).getInstance((IType[])map_types[1]);
                if (spec == null) {
                    spec = function instanceof ICPPConstructor ? new CPPConstructorSpecialization(function, scope, (ObjectMap)map_types[0]) : (function instanceof ICPPMethod ? new CPPMethodSpecialization(function, scope, (ObjectMap)map_types[0]) : new CPPFunctionSpecialization(function, scope, (ObjectMap)map_types[0]));
                }
                if (spec instanceof ICPPInternalBinding) {
                    if (parent instanceof IASTSimpleDeclaration) {
                        ((ICPPInternalBinding)((Object)spec)).addDeclaration(name);
                    } else if (parent instanceof IASTFunctionDefinition) {
                        ((ICPPInternalBinding)((Object)spec)).addDefinition(name);
                    }
                }
            }
            if (function instanceof ICPPInternalTemplate) {
                ((ICPPInternalTemplate)((Object)function)).addSpecialization((IType[])map_types[1], spec);
            }
            return spec;
        }
        return null;
    }

    protected static ICPPFunctionTemplate resolveTemplateFunctions(Object[] items, IASTName name) {
        IASTNode n;
        int numArgs;
        if (items == null) {
            return null;
        }
        Object[] templates = null;
        IBinding temp = null;
        Object[] objectArray = items;
        int n2 = items.length;
        int n3 = 0;
        while (n3 < n2) {
            block30: {
                block29: {
                    Object o;
                    block28: {
                        o = objectArray[n3];
                        if (!(o instanceof IASTName)) break block28;
                        temp = ((IASTName)o).resolveBinding();
                        if (temp != null) break block29;
                        break block30;
                    }
                    if (!(o instanceof IBinding)) break block30;
                    temp = (IBinding)o;
                }
                if (temp instanceof ICPPTemplateInstance) {
                    temp = ((ICPPTemplateInstance)temp).getTemplateDefinition();
                }
                if (temp instanceof ICPPFunctionTemplate) {
                    templates = (ICPPFunctionTemplate[])ArrayUtil.append(ICPPFunctionTemplate.class, templates, temp);
                }
            }
            ++n3;
        }
        if (templates == null) {
            return null;
        }
        IType[] templateArguments = null;
        if (name instanceof ICPPASTTemplateId) {
            templateArguments = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name);
        }
        int n4 = numArgs = templateArguments != null ? templateArguments.length : 0;
        if (name.getParent() instanceof IASTName) {
            name = (IASTName)name.getParent();
        }
        if ((n = name.getParent()) instanceof ICPPASTQualifiedName) {
            n = n.getParent();
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)n;
        IType[] functionParameters = CPPTemplates.createTypeArray(fdtor.getParameters());
        Object result = null;
        int i = 0;
        while (i < templates.length && templates[i] != null) {
            block27: {
                Object tmpl = templates[i];
                ObjectMap map = ObjectMap.EMPTY_MAP;
                try {
                    map = CPPTemplates.deduceTemplateArguments((ICPPFunctionTemplate)tmpl, functionParameters);
                }
                catch (DOMException dOMException) {}
                if (map != null) {
                    ICPPTemplateParameter[] params = null;
                    try {
                        params = tmpl.getTemplateParameters();
                    }
                    catch (DOMException dOMException) {
                        break block27;
                    }
                    int numParams = params.length;
                    IType arg = null;
                    int j = 0;
                    while (j < numParams) {
                        ICPPTemplateParameter param = params[j];
                        arg = j < numArgs && templateArguments != null ? templateArguments[j] : null;
                        if (map.containsKey(param)) {
                            IType t = (IType)map.get(param);
                            if (arg == null) {
                                arg = t;
                            } else if (!CPPTemplates.isSameTemplateArgument(t, arg)) {
                                break block27;
                            }
                        } else if (arg == null || !CPPTemplates.matchTemplateParameterAndArgument(param, arg, map)) break block27;
                        ++j;
                    }
                    if (result != null) {
                        return new CPPFunctionTemplate.CPPFunctionTemplateProblem(name, 4, name.toCharArray());
                    }
                    result = tmpl;
                }
            }
            ++i;
        }
        return result;
    }

    protected static Object[] deduceTemplateFunctionArguments(ICPPFunctionTemplate primaryTemplate, IASTParameterDeclaration[] ps, ICPPASTTemplateId id) throws DOMException {
        ICPPTemplateParameter[] templateParameters = primaryTemplate.getTemplateParameters();
        IType[] arguments = CPPTemplates.createTemplateArgumentArray(id);
        IType[] result = new IType[templateParameters.length];
        ObjectMap map = null;
        if (arguments.length == result.length) {
            map = new ObjectMap(result.length);
            int i = 0;
            while (i < templateParameters.length) {
                result[i] = arguments[i];
                map.put(templateParameters, arguments[i]);
                ++i;
            }
            return new Object[]{map, result};
        }
        IType[] paramTypes = CPPTemplates.createTypeArray(ps);
        map = CPPTemplates.deduceTemplateArguments(primaryTemplate, paramTypes);
        if (map != null) {
            int i = 0;
            while (i < templateParameters.length) {
                ICPPTemplateParameter param = templateParameters[i];
                IType arg = null;
                if (i < arguments.length) {
                    arg = arguments[i];
                    map.put(param, arg);
                } else if (map.containsKey(param)) {
                    arg = (IType)map.get(param);
                }
                if (arg == null || !CPPTemplates.matchTemplateParameterAndArgument(param, arg, map)) {
                    return null;
                }
                result[i] = arg;
                ++i;
            }
            return new Object[]{map, result};
        }
        return null;
    }

    public static IBinding createInstance(ICPPScope scope, IBinding decl, ObjectMap argMap, IType[] args) {
        CPPInstance instance = null;
        if (decl instanceof ICPPClassType) {
            instance = new CPPClassInstance(scope, decl, argMap, args);
        } else if (decl instanceof ICPPConstructor) {
            instance = new CPPConstructorInstance(scope, decl, argMap, args);
        } else if (decl instanceof ICPPMethod) {
            instance = new CPPMethodInstance(scope, decl, argMap, args);
        } else if (decl instanceof ICPPFunction) {
            instance = new CPPFunctionInstance(scope, decl, argMap, args);
        }
        return instance;
    }

    public static ICPPSpecialization createSpecialization(ICPPScope scope, IBinding decl, ObjectMap argMap) {
        CPPSpecialization spec = null;
        if (decl instanceof ICPPClassTemplate) {
            spec = new CPPClassTemplateSpecialization(decl, scope, argMap);
        } else if (decl instanceof ICPPClassType) {
            spec = new CPPClassSpecialization(decl, scope, argMap);
        } else if (decl instanceof ICPPField) {
            spec = new CPPFieldSpecialization(decl, scope, argMap);
        } else if (decl instanceof ICPPFunctionTemplate) {
            spec = decl instanceof ICPPConstructor ? new CPPConstructorTemplateSpecialization(decl, scope, argMap) : (decl instanceof ICPPMethod ? new CPPMethodTemplateSpecialization(decl, scope, argMap) : new CPPFunctionTemplateSpecialization(decl, scope, argMap));
        } else if (decl instanceof ICPPConstructor) {
            spec = new CPPConstructorSpecialization(decl, scope, argMap);
        } else if (decl instanceof ICPPMethod) {
            spec = new CPPMethodSpecialization(decl, scope, argMap);
        } else if (decl instanceof ICPPFunction) {
            spec = new CPPFunctionSpecialization(decl, scope, argMap);
        } else if (decl instanceof ITypedef) {
            spec = new CPPTypedefSpecialization(decl, scope, argMap);
        }
        return spec;
    }

    public static IType instantiateType(IType type, ObjectMap argMap, IScope instantiationScope) {
        if (argMap == null) {
            return type;
        }
        if (type instanceof IFunctionType) {
            IType ret = null;
            IType[] params = null;
            try {
                IType r = ((IFunctionType)type).getReturnType();
                ret = CPPTemplates.instantiateType(r, argMap, instantiationScope);
                IType[] ps = ((IFunctionType)type).getParameterTypes();
                params = CPPTemplates.instantiateTypes(ps, argMap, (ICPPScope)instantiationScope);
                if (ret == r && params == ps) {
                    return type;
                }
            }
            catch (DOMException dOMException) {}
            return new CPPFunctionType(ret, params, ((ICPPFunctionType)type).getThisType());
        }
        if (type instanceof ICPPTemplateParameter) {
            IType t = (IType)argMap.get(type);
            if (t != null) {
                return t;
            }
            int i = 0;
            while (i < argMap.size()) {
                Object key = argMap.keyAt(i);
                if (key instanceof IType && type.isSameType((IType)key)) {
                    return (IType)argMap.getAt(i);
                }
                ++i;
            }
            return type;
        }
        if (type instanceof ICPPUnknownBinding) {
            IBinding binding;
            try {
                binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)type), argMap, (ICPPScope)instantiationScope);
            }
            catch (DOMException e) {
                binding = e.getProblem();
            }
            if (binding instanceof IType) {
                return binding;
            }
            return type;
        }
        if (type instanceof IBinding && (type instanceof ITypedef || type instanceof ICPPClassType)) {
            if (instantiationScope instanceof ICPPClassSpecializationScope) {
                try {
                    IBinding instance = CPPTemplates.instantiateBinding((IBinding)((Object)type), (ICPPClassSpecializationScope)instantiationScope);
                    if (instance instanceof IType) {
                        return (IType)((Object)instance);
                    }
                }
                catch (DOMException dOMException) {}
            }
            return type;
        }
        if (type instanceof ITypeContainer) {
            try {
                IType temp = ((ITypeContainer)type).getType();
                IType newType = CPPTemplates.instantiateType(temp, argMap, instantiationScope);
                if (type instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)type;
                    IType memberOfClass = ptm.getMemberOfClass();
                    IType newMemberOfClass = CPPTemplates.instantiateType(memberOfClass, argMap, instantiationScope);
                    if ((newType != temp || newMemberOfClass != memberOfClass) && newMemberOfClass instanceof ICPPClassType) {
                        return new CPPPointerToMemberType(newType, (ICPPClassType)newMemberOfClass, ptm.isConst(), ptm.isVolatile());
                    }
                }
                if (newType != temp) {
                    temp = (IType)type.clone();
                    ((ITypeContainer)temp).setType(newType);
                    return temp;
                }
            }
            catch (DOMException dOMException) {}
            return type;
        }
        return type;
    }

    /*
     * Unable to fully structure code
     */
    private static IBinding instantiateBinding(IBinding originalBinding, ICPPClassSpecializationScope instantiationScope) throws DOMException {
        originalClassType = instantiationScope.getOriginalClassType();
        scope = originalBinding.getScope();
        found = false;
        classTypes = new LinkedList<ICPPClassType>();
        while (scope instanceof ICPPClassScope) {
            ct = ((ICPPClassScope)scope).getClassType();
            if (ct.isSameType(originalClassType)) {
                found = true;
                break;
            }
            classTypes.add(ct);
            scope = scope.getParent();
        }
        if (found) ** GOTO lbl22
        return originalBinding;
lbl-1000:
        // 1 sources

        {
            ct = (ICPPClassType)classTypes.removeLast();
            binding = instantiationScope.getInstance(ct);
            scope = binding.getScope();
            if (!(scope instanceof ICPPClassSpecializationScope)) {
                return originalBinding;
            }
            instantiationScope = (ICPPClassSpecializationScope)scope;
lbl22:
            // 2 sources

            ** while (!classTypes.isEmpty())
        }
lbl23:
        // 1 sources

        return instantiationScope.getInstance(originalBinding);
    }

    public static IType[] instantiateTypes(IType[] types, ObjectMap argMap, ICPPScope instantiationScope) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = CPPTemplates.instantiateType(types[i], argMap, instantiationScope);
            if (result != types) {
                result[i] = type;
            } else if (type != types[i]) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = type;
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTName name) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (name == null) {
                            return null;
                        }
                        parent = name.getParent();
                        while (parent instanceof IASTName) {
                            parent = parent.getParent();
                        }
                        if (!(parent instanceof IASTDeclSpecifier)) ** GOTO lbl13
                        if (!(parent instanceof IASTCompositeTypeSpecifier) && !(parent instanceof IASTElaboratedTypeSpecifier)) {
                            return null;
                        }
                        parent = parent.getParent();
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            parent = parent.getParent();
lbl13:
                            // 2 sources

                            ** while (parent instanceof IASTDeclarator)
                        }
                    }
                    if (!(parent instanceof IASTDeclaration)) {
                        return null;
                    }
                    if (!((parent = parent.getParent()) instanceof ICPPASTTemplateDeclaration)) break block13;
                    templateDecl = (ICPPASTTemplateDeclaration)parent;
                    if (!(name instanceof ICPPASTQualifiedName)) break block14;
                    ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns[ns.length - 1];
                    ** GOTO lbl31
                }
                if (!(name.getParent() instanceof ICPPASTQualifiedName)) break block15;
                ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (true) ** GOTO lbl31
            }
            return templateDecl;
            do {
                templateDecl = (ICPPASTTemplateDeclaration)templateDecl.getParent();
lbl31:
                // 3 sources

            } while (templateDecl.getParent() instanceof ICPPASTTemplateDeclaration);
            j = 0;
            while (j < ns.length) {
                singleName = ns[j];
                if (singleName == name) {
                    if (singleName instanceof ICPPASTTemplateId || j == ns.length - 1) {
                        return templateDecl;
                    }
                    return null;
                }
                if (singleName instanceof ICPPASTTemplateId) {
                    next = templateDecl.getDeclaration();
                    if (next instanceof ICPPASTTemplateDeclaration) {
                        templateDecl = (ICPPASTTemplateDeclaration)next;
                    } else {
                        return null;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    public static IASTName getTemplateName(ICPPASTTemplateDeclaration templateDecl) {
        if (templateDecl == null) {
            return null;
        }
        ICPPASTTemplateDeclaration decl = templateDecl;
        while (decl.getParent() instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)decl.getParent();
        }
        IASTDeclaration nestedDecl = templateDecl.getDeclaration();
        while (nestedDecl instanceof ICPPASTTemplateDeclaration) {
            nestedDecl = ((ICPPASTTemplateDeclaration)nestedDecl).getDeclaration();
        }
        IASTName name = null;
        if (nestedDecl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)nestedDecl;
            if (simple.getDeclarators().length == 1) {
                IASTDeclarator dtor = simple.getDeclarators()[0];
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                name = dtor.getName();
            } else if (simple.getDeclarators().length == 0) {
                IASTDeclSpecifier spec = simple.getDeclSpecifier();
                if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                    name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                    name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                }
            }
        } else if (nestedDecl instanceof IASTFunctionDefinition) {
            IASTDeclarator declarator = ((IASTFunctionDefinition)nestedDecl).getDeclarator();
            declarator = CPPVisitor.findInnermostDeclarator(declarator);
            name = declarator.getName();
        }
        if (name != null) {
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                IASTDeclaration currDecl = decl;
                int j = 0;
                while (j < ns.length) {
                    if (ns[j] instanceof ICPPASTTemplateId || j + 1 == ns.length) {
                        if (currDecl == templateDecl) {
                            return ns[j];
                        }
                        if (currDecl instanceof ICPPASTTemplateDeclaration) {
                            currDecl = currDecl.getDeclaration();
                        } else {
                            return null;
                        }
                    }
                    ++j;
                }
            } else {
                return name;
            }
        }
        return null;
    }

    public static boolean isSameTemplate(ICPPTemplateDefinition definition, IASTName name) {
        boolean result;
        ObjectSet<IBinding> bindingsToClear;
        ICPPASTTemplateDeclaration templateDecl;
        block23: {
            ICPPTemplateParameter[] defParams = null;
            try {
                defParams = definition.getTemplateParameters();
            }
            catch (DOMException dOMException) {
                return false;
            }
            templateDecl = CPPTemplates.getTemplateDeclaration(name);
            if (templateDecl == null) {
                return false;
            }
            ICPPASTTemplateParameter[] templateParams = templateDecl.getTemplateParameters();
            if (defParams.length != templateParams.length) {
                return false;
            }
            bindingsToClear = null;
            int i = 0;
            while (i < templateParams.length) {
                IASTName tn = CPPTemplates.getTemplateParameterName(templateParams[i]);
                if (tn.getBinding() != null) {
                    return tn.getBinding() == defParams[i];
                }
                if (bindingsToClear == null) {
                    bindingsToClear = new ObjectSet<IBinding>(templateParams.length);
                }
                tn.setBinding(defParams[i]);
                if (defParams[i] instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)((Object)defParams[i])).addDeclaration(tn);
                }
                bindingsToClear.put(defParams[i]);
                ++i;
            }
            result = false;
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTFunctionDeclarator) {
                try {
                    IASTParameterDeclaration[] params = ((ICPPASTFunctionDeclarator)parent).getParameters();
                    IParameter[] ps = ((ICPPFunction)((Object)definition)).getParameters();
                    if (ps.length != params.length) break block23;
                    int i2 = 0;
                    while (i2 < ps.length) {
                        IType t2;
                        IType t1 = CPPVisitor.createType(params[i2].getDeclarator());
                        if (!t1.isSameType(t2 = ps[i2].getType())) break;
                        ++i2;
                    }
                    if (i2 == ps.length) {
                        result = true;
                    }
                }
                catch (DOMException dOMException) {}
            } else if (parent instanceof IASTDeclSpecifier) {
                if (name instanceof ICPPASTTemplateId) {
                    if (definition instanceof ICPPClassTemplatePartialSpecialization) {
                        ICPPClassTemplatePartialSpecialization spec = (ICPPClassTemplatePartialSpecialization)definition;
                        IType[] args = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name);
                        try {
                            IType[] specArgs = spec.getArguments();
                            if (args.length == specArgs.length) {
                                int i3 = 0;
                                while (i3 < args.length) {
                                    if (!CPPTemplates.isSameTemplateArgument(specArgs[i3], args[i3])) break;
                                    ++i3;
                                }
                                result = i3 == args.length;
                            }
                        }
                        catch (DOMException dOMException) {
                            result = false;
                        }
                    }
                } else {
                    result = CharArrayUtils.equals(definition.getNameCharArray(), name.toCharArray());
                }
            }
        }
        if (bindingsToClear != null && !result) {
            ClearBindingAction action = new ClearBindingAction(bindingsToClear);
            templateDecl.accept(action);
        }
        return result;
    }

    public static final boolean isSameTemplateArgument(IType argA, IType argB) {
        if (argA instanceof ICPPBasicType && argB instanceof ICPPBasicType) {
            try {
                IASTExpression eA = ((ICPPBasicType)argA).getValue();
                IASTExpression eB = ((ICPPBasicType)argB).getValue();
                if (eA != null && eB != null) {
                    return CPPTemplates.isNonTypeArgumentConvertible(argA, argB) && CPPTemplates.expressionsEquivalent(eA, eB);
                }
            }
            catch (DOMException de) {
                CCorePlugin.log(de);
                return false;
            }
        }
        return argA != null && argB != null && argA.isSameType(argB);
    }

    public static IType[] createTemplateArgumentArray(ICPPASTTemplateId id) {
        IType[] result = IType.EMPTY_TYPE_ARRAY;
        if (id != null) {
            IASTNode[] params = id.getTemplateArguments();
            result = new IType[params.length];
            int i = 0;
            while (i < params.length) {
                IType type;
                IASTNode param = params[i];
                if (param instanceof IASTIdExpression) {
                    param = CPPVisitor.reverseConstantPropogationLookup((IASTIdExpression)param);
                }
                result[i] = (type = CPPVisitor.createType(param)) == null ? new CPPBasicType(-1, 0) : type;
                ++i;
            }
        }
        return result;
    }

    public static IType[] createTypeArray(Object[] params) {
        if (params == null) {
            return IType.EMPTY_TYPE_ARRAY;
        }
        if (params instanceof IType[]) {
            return (IType[])params;
        }
        IType[] result = new IType[params.length];
        int i = 0;
        while (i < params.length) {
            IType type = null;
            Object param = params[i];
            if (param instanceof IASTNode) {
                type = CPPVisitor.createType((IASTNode)param);
            } else if (param instanceof IParameter) {
                try {
                    type = ((IParameter)param).getType();
                }
                catch (DOMException e) {
                    type = e.getProblem();
                }
            }
            result[i] = type == null ? new CPPBasicType(-1, 0) : type;
            ++i;
        }
        return result;
    }

    protected static IFunction[] selectTemplateFunctions(ObjectSet<IFunction> templates, Object[] functionArguments, IASTName name) {
        if (templates == null || templates.size() == 0) {
            return null;
        }
        Object[] instances = null;
        int size = templates.size();
        int numTemplateArgs = 0;
        IType[] templateArguments = null;
        if (name instanceof ICPPASTTemplateId) {
            templateArguments = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name);
            numTemplateArgs = templateArguments.length;
        }
        IType[] fnArgs = CPPTemplates.createTypeArray(functionArguments);
        int idx = 0;
        while (idx < size) {
            block21: {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)templates.keyAt(idx);
                ObjectMap map = null;
                try {
                    map = CPPTemplates.deduceTemplateArguments(template, fnArgs);
                }
                catch (DOMException dOMException) {
                    break block21;
                }
                if (map != null) {
                    ICPPTemplateParameter[] templateParams = null;
                    try {
                        templateParams = template.getTemplateParameters();
                    }
                    catch (DOMException dOMException) {
                        break block21;
                    }
                    int numTemplateParams = templateParams.length;
                    Object[] instanceArgs = null;
                    int i = 0;
                    while (i < numTemplateParams) {
                        IType arg = i < numTemplateArgs && templateArguments != null ? templateArguments[i] : null;
                        IType mapped = (IType)map.get(templateParams[i]);
                        if (arg != null && mapped != null) {
                            if (!arg.isSameType(mapped)) break block21;
                            instanceArgs = (IType[])ArrayUtil.append(IType.class, instanceArgs, arg);
                        } else if (arg == null && mapped == null) {
                            Object def;
                            block22: {
                                def = null;
                                try {
                                    if (templateParams[i] instanceof ICPPTemplateTypeParameter) {
                                        def = ((ICPPTemplateTypeParameter)templateParams[i]).getDefault();
                                        break block22;
                                    }
                                    if (templateParams[i] instanceof ICPPTemplateTemplateParameter) {
                                        def = ((ICPPTemplateTemplateParameter)templateParams[i]).getDefault();
                                        break block22;
                                    }
                                    if (!(templateParams[i] instanceof ICPPTemplateNonTypeParameter)) break block22;
                                    def = CPPVisitor.getExpressionType(((ICPPTemplateNonTypeParameter)templateParams[i]).getDefault());
                                }
                                catch (DOMException dOMException) {
                                    break block21;
                                }
                            }
                            if (def == null) break block21;
                            if (def instanceof ICPPTemplateParameter) {
                                int j = 0;
                                while (j < i) {
                                    if (templateParams[j] == def && instanceArgs != null) {
                                        def = instanceArgs[j];
                                    }
                                    ++j;
                                }
                            }
                            instanceArgs = (IType[])ArrayUtil.append(IType.class, instanceArgs, def);
                        } else {
                            instanceArgs = (IType[])ArrayUtil.append(IType.class, instanceArgs, arg != null ? arg : mapped);
                        }
                        ++i;
                    }
                    ICPPSpecialization temp = (ICPPSpecialization)((ICPPInternalTemplateInstantiator)((Object)template)).instantiate((IType[])(instanceArgs = (IType[])ArrayUtil.trim(IType.class, instanceArgs)));
                    if (temp != null) {
                        instances = (IFunction[])ArrayUtil.append(IFunction.class, instances, temp);
                    }
                }
            }
            ++idx;
        }
        return (IFunction[])ArrayUtil.trim(IFunction.class, instances);
    }

    private static ObjectMap deduceTemplateArguments(ICPPFunctionTemplate template, IType[] arguments) throws DOMException {
        ICPPFunction function = (ICPPFunction)((Object)template);
        IType[] functionParameters = null;
        try {
            functionParameters = function.getType().getParameterTypes();
        }
        catch (DOMException dOMException) {
            return null;
        }
        return CPPTemplates.deduceTemplateArguments(functionParameters, arguments, false);
    }

    public static ObjectMap deduceTemplateArguments(IType[] specArgs, IType[] args, boolean all) {
        if (specArgs == null || all && specArgs.length != args.length) {
            return null;
        }
        ObjectMap map = new ObjectMap(specArgs.length);
        int len = all ? specArgs.length : Math.min(specArgs.length, args.length);
        int j = 0;
        while (j < len) {
            try {
                if (!CPPTemplates.deduceTemplateArgument(map, specArgs[j], args[j])) {
                    return null;
                }
            }
            catch (DOMException dOMException) {
                return null;
            }
            ++j;
        }
        return map;
    }

    private static IType getParameterTypeForDeduction(IType pType) {
        IType result = pType;
        try {
            if (pType instanceof IQualifierType) {
                result = ((IQualifierType)pType).getType();
            } else if (pType instanceof ICPPReferenceType) {
                result = ((ICPPReferenceType)pType).getType();
            } else if (pType instanceof CPPPointerType) {
                result = ((CPPPointerType)pType).stripQualifiers();
            }
        }
        catch (DOMException e) {
            result = e.getProblem();
        }
        return result;
    }

    private static IType getArgumentTypeForDeduction(IType aType, boolean pIsAReferenceType) {
        if (aType instanceof ICPPReferenceType) {
            try {
                aType = ((ICPPReferenceType)aType).getType();
            }
            catch (DOMException dOMException) {}
        }
        IType result = aType;
        if (!pIsAReferenceType) {
            try {
                if (aType instanceof IArrayType) {
                    result = new CPPPointerType(((IArrayType)aType).getType());
                } else if (aType instanceof IFunctionType) {
                    result = new CPPPointerType(aType);
                } else if (aType instanceof IQualifierType) {
                    result = ((IQualifierType)aType).getType();
                } else if (aType instanceof CPPPointerType) {
                    result = ((CPPPointerType)aType).stripQualifiers();
                }
            }
            catch (DOMException e) {
                result = e.getProblem();
            }
        }
        return result;
    }

    private static boolean expressionsEquivalent(IASTExpression e1, IASTExpression e2) {
        if (e1 == null) {
            return true;
        }
        e1 = CPPVisitor.reverseConstantPropogationLookup(e1);
        e2 = CPPVisitor.reverseConstantPropogationLookup(e2);
        if (e1 instanceof IASTLiteralExpression && e2 instanceof IASTLiteralExpression) {
            IType t1 = e1.getExpressionType();
            IType t2 = e2.getExpressionType();
            try {
                if (t1 instanceof ICPPBasicType && t2 instanceof ICPPBasicType) {
                    BigInteger i1 = CPPVisitor.parseIntegral(e1.toString());
                    BigInteger i2 = CPPVisitor.parseIntegral(e2.toString());
                    return i1.equals(i2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return e1.toString().equals(e2.toString());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private static boolean deduceTemplateArgument(ObjectMap map, IType p, IType a) throws DOMException {
        pIsAReferenceType = p instanceof ICPPReferenceType;
        p = CPPTemplates.getParameterTypeForDeduction(p);
        a = CPPTemplates.getArgumentTypeForDeduction(a, pIsAReferenceType);
        if (!(p instanceof IBasicType)) ** GOTO lbl80
        if (a instanceof IBasicType == false) return false;
        pbt = (IBasicType)p;
        abt = (IBasicType)a;
        if (pbt.getValue() == null) return p.isSameType(a);
        if (abt.getValue() == null) return p.isSameType(a);
        if (CPPTemplates.isNonTypeArgumentConvertible(p, a) == false) return false;
        if (CPPTemplates.expressionsEquivalent(pbt.getValue(), abt.getValue()) == false) return false;
        return true;
        {
            a = ((ITypedef)a).getType();
            do {
                block27: {
                    block26: {
                        if (a instanceof ITypedef) continue block0;
                        if (p instanceof IBasicType) {
                            return p.isSameType(a);
                        }
                        if (p instanceof ICPPPointerToMemberType) {
                            if (!(a instanceof ICPPPointerToMemberType)) {
                                return false;
                            }
                            if (!CPPTemplates.deduceTemplateArgument(map, ((ICPPPointerToMemberType)p).getMemberOfClass(), ((ICPPPointerToMemberType)a).getMemberOfClass())) {
                                return false;
                            }
                            p = ((ICPPPointerToMemberType)p).getType();
                            a = ((ICPPPointerToMemberType)a).getType();
                            continue;
                        }
                        if (p instanceof IPointerType) {
                            if (!(a instanceof IPointerType)) {
                                return false;
                            }
                            p = ((IPointerType)p).getType();
                            a = ((IPointerType)a).getType();
                            continue;
                        }
                        if (p instanceof IQualifierType) {
                            if (a instanceof IQualifierType) {
                                a = ((IQualifierType)a).getType();
                            }
                            p = ((IQualifierType)p).getType();
                            continue;
                        }
                        if (!(p instanceof IFunctionType)) break block26;
                        if (!(a instanceof IFunctionType)) {
                            return false;
                        }
                        if (!CPPTemplates.deduceTemplateArgument(map, ((IFunctionType)p).getReturnType(), ((IFunctionType)a).getReturnType())) {
                            return false;
                        }
                        pParams = ((IFunctionType)p).getParameterTypes();
                        if (pParams.length != (aParams = ((IFunctionType)a).getParameterTypes()).length) {
                            return false;
                        }
                        i = 0;
                        if (true) ** GOTO lbl86
                    }
                    if (p instanceof ICPPTemplateParameter) {
                        if (map.containsKey(p)) {
                            current = (IType)map.get(p);
                            return current.isSameType(a);
                        }
                        if (a == null) {
                            return false;
                        }
                        map.put(p, a);
                        return true;
                    }
                    if (!(p instanceof ICPPTemplateInstance)) {
                        if (p instanceof ICPPUnknownBinding == false) return p.isSameType(a);
                        return true;
                    }
                    if (!(a instanceof ICPPTemplateInstance)) {
                        return false;
                    }
                    pInst = (ICPPTemplateInstance)p;
                    aInst = (ICPPTemplateInstance)a;
                    pArgs = pInst.getArguments();
                    pArgs = pArgs == null ? IType.EMPTY_TYPE_ARRAY : pArgs;
                    aMap = aInst.getArgumentMap();
                    if (aMap == null || aInst.getTemplateDefinition() instanceof ICPPClassTemplatePartialSpecialization) break block27;
                    aParams = aInst.getTemplateDefinition().getTemplateParameters();
                    if (pArgs.length != aParams.length) {
                        return false;
                    }
                    i = 0;
                    if (true) ** GOTO lbl93
                }
                aArgs = aInst.getArguments();
                v0 = aArgs = aArgs == null ? IType.EMPTY_TYPE_ARRAY : aArgs;
                if (aArgs.length != pArgs.length) {
                    return false;
                }
                i = 0;
                if (true) ** GOTO lbl99
lbl80:
                // 4 sources

            } while (p != null);
        }
        return false;
        do {
            if (!CPPTemplates.deduceTemplateArgument(map, pParams[i], aParams[i])) {
                return false;
            }
            ++i;
lbl86:
            // 2 sources

        } while (i < pParams.length);
        return true;
        do {
            if ((t = (IType)aMap.get(aParams[i])) == null) return false;
            if (!CPPTemplates.deduceTemplateArgument(map, pArgs[i], t)) {
                return false;
            }
            ++i;
lbl93:
            // 2 sources

        } while (i < pArgs.length);
        return true;
        do {
            if (!CPPTemplates.deduceTemplateArgument(map, pArgs[i], aArgs[i])) {
                return false;
            }
            ++i;
lbl99:
            // 2 sources

        } while (i < pArgs.length);
        return true;
    }

    private static IType[] createArgsForFunctionTemplateOrdering(ICPPFunctionTemplate template) throws DOMException {
        ICPPTemplateParameter[] paramList = template.getTemplateParameters();
        int size = paramList.length;
        IType[] args = new IType[size];
        int i = 0;
        while (i < size) {
            ICPPTemplateParameter param = paramList[i];
            if (param instanceof ICPPTemplateNonTypeParameter) {
                IType t = ((ICPPTemplateNonTypeParameter)param).getType();
                if (t instanceof CPPBasicType) {
                    CPPASTLiteralExpression exp = new CPPASTLiteralExpression();
                    exp.setValue(String.valueOf(i));
                    CPPBasicType temp = (CPPBasicType)t.clone();
                    temp.setValue(exp);
                    args[i] = temp;
                }
            } else {
                args[i] = new CPPBasicType(-1, 0);
            }
            ++i;
        }
        return args;
    }

    protected static int orderTemplateFunctions(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2) throws DOMException {
        IType[] args = CPPTemplates.createArgsForFunctionTemplateOrdering(f1);
        ICPPFunction function = (ICPPFunction)((ICPPInternalTemplateInstantiator)((Object)f1)).instantiate(args);
        ObjectMap m1 = null;
        if (function != null) {
            m1 = CPPTemplates.deduceTemplateArguments(f2, function.getType().getParameterTypes());
        }
        args = CPPTemplates.createArgsForFunctionTemplateOrdering(f2);
        function = (ICPPFunction)((ICPPInternalTemplateInstantiator)((Object)f2)).instantiate(args);
        ObjectMap m2 = null;
        if (function != null) {
            m2 = CPPTemplates.deduceTemplateArguments(f1, function.getType().getParameterTypes());
        }
        if (m1 == null) {
            if (m2 == null) {
                return 0;
            }
            return -1;
        }
        if (m2 == null) {
            return 1;
        }
        int d1 = 0;
        int i = 0;
        while (i < m1.size()) {
            if (m1.getAt(i) instanceof IQualifierType) {
                ++d1;
            }
            ++i;
        }
        int d2 = 0;
        int i2 = 0;
        while (i2 < m2.size()) {
            if (m2.getAt(i2) instanceof IQualifierType) {
                ++d2;
            }
            ++i2;
        }
        return d1 - d2;
    }

    public static ICPPTemplateDefinition matchTemplatePartialSpecialization(ICPPClassTemplate template, IType[] args) throws DOMException {
        if (template == null) {
            return null;
        }
        args = SemanticUtil.getSimplifiedTypes(args);
        ICPPClassTemplatePartialSpecialization[] specializations = template.getPartialSpecializations();
        if (specializations == null) {
            return template;
        }
        int size = specializations.length;
        if (size == 0) {
            return template;
        }
        ICPPClassTemplatePartialSpecialization bestMatch = null;
        ICPPClassTemplatePartialSpecialization spec = null;
        boolean bestMatchIsBest = true;
        int i = 0;
        while (i < size) {
            spec = specializations[i];
            ObjectMap map = CPPTemplates.deduceTemplateArguments(spec.getArguments(), args, true);
            if (map != null) {
                int compare = CPPTemplates.orderSpecializations(bestMatch, spec);
                if (compare == 0) {
                    bestMatchIsBest = false;
                } else if (compare < 0) {
                    bestMatch = spec;
                    bestMatchIsBest = true;
                }
            }
            ++i;
        }
        if (!bestMatchIsBest) {
            return new CPPTemplateDefinition.CPPTemplateProblem(null, 4, null);
        }
        return bestMatch;
    }

    private static int orderSpecializations(ICPPClassTemplatePartialSpecialization spec1, ICPPClassTemplatePartialSpecialization spec2) throws DOMException {
        if (spec1 == null) {
            return -1;
        }
        ICPPFunctionTemplate template1 = null;
        ICPPFunctionTemplate template2 = null;
        template1 = CPPTemplates.classTemplateSpecializationToFunctionTemplate(spec1);
        template2 = CPPTemplates.classTemplateSpecializationToFunctionTemplate(spec2);
        return CPPTemplates.orderTemplateFunctions(template1, template2);
    }

    private static ICPPFunctionTemplate classTemplateSpecializationToFunctionTemplate(ICPPClassTemplatePartialSpecialization specialization) {
        ICPPClassTemplatePartialSpecialization template = specialization;
        IType[] args = null;
        try {
            args = specialization.getArguments();
        }
        catch (DOMException dOMException) {
            return null;
        }
        IType paramType = (IType)((Object)((ICPPInternalTemplateInstantiator)((Object)template)).instantiate(args));
        IParameter[] functionParameters = new IParameter[]{new CPPParameter(paramType)};
        try {
            return new CPPImplicitFunctionTemplate(specialization.getTemplateParameters(), functionParameters);
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    private static boolean isValidArgument(ICPPTemplateParameter param, IType argument) {
        try {
            while (argument instanceof ITypeContainer) {
                argument = ((ITypeContainer)argument).getType();
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return !(argument instanceof IProblemBinding);
    }

    protected static boolean matchTemplateParameterAndArgument(ICPPTemplateParameter param, IType argument, ObjectMap map) {
        if (!CPPTemplates.isValidArgument(param, argument)) {
            return false;
        }
        if (param instanceof ICPPTemplateTypeParameter) {
            return true;
        }
        if (param instanceof ICPPTemplateTemplateParameter) {
            if (!(argument instanceof ICPPTemplateDefinition)) {
                return false;
            }
            ICPPTemplateParameter[] pParams = null;
            ICPPTemplateParameter[] aParams = null;
            try {
                pParams = ((ICPPTemplateTemplateParameter)param).getTemplateParameters();
                aParams = ((ICPPTemplateDefinition)((Object)argument)).getTemplateParameters();
            }
            catch (DOMException dOMException) {
                return false;
            }
            int size = pParams.length;
            if (aParams.length != size) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (pParams[i] instanceof ICPPTemplateTypeParameter && !(aParams[i] instanceof ICPPTemplateTypeParameter) || pParams[i] instanceof ICPPTemplateTemplateParameter && !(aParams[i] instanceof ICPPTemplateTemplateParameter) || pParams[i] instanceof ICPPTemplateNonTypeParameter && !(aParams[i] instanceof ICPPTemplateNonTypeParameter)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        try {
            IType pType = ((ICPPTemplateNonTypeParameter)param).getType();
            if (map != null && pType != null && map.containsKey(pType)) {
                pType = (IType)map.get(pType);
            }
            return CPPTemplates.isNonTypeArgumentConvertible(pType, argument);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean isNonTypeArgumentConvertible(IType paramType, IType arg) throws DOMException {
        if (paramType instanceof IFunctionType) {
            paramType = new CPPPointerType(paramType);
        } else if (paramType instanceof IArrayType) {
            try {
                paramType = new CPPPointerType(((IArrayType)paramType).getType());
            }
            catch (DOMException e) {
                paramType = e.getProblem();
            }
        }
        Cost cost = Conversions.checkStandardConversionSequence(arg, paramType, false);
        return cost != null && cost.rank != -1;
    }

    public static IBinding instantiateWithinClassTemplate(ICPPClassTemplate template) throws DOMException {
        IType[] args = null;
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            args = ((ICPPClassTemplatePartialSpecialization)template).getArguments();
        } else {
            ICPPTemplateParameter[] templateParameters = template.getTemplateParameters();
            args = new IType[templateParameters.length];
            int i = 0;
            while (i < templateParameters.length) {
                if (templateParameters[i] instanceof IType) {
                    args[i] = (IType)((Object)templateParameters[i]);
                } else if (templateParameters[i] instanceof ICPPTemplateNonTypeParameter) {
                    args[i] = ((ICPPTemplateNonTypeParameter)templateParameters[i]).getType();
                }
                ++i;
            }
        }
        if (template instanceof ICPPInternalTemplateInstantiator) {
            return ((ICPPInternalTemplateInstantiator)((Object)template)).instantiate(args);
        }
        return template;
    }

    public static boolean isDependentType(IType t) {
        if (t instanceof ICPPTemplateParameter) {
            return true;
        }
        t = SemanticUtil.getUltimateType(t, false);
        return t instanceof ICPPUnknownBinding;
    }

    public static boolean containsDependentArg(ObjectMap argMap) {
        Object[] objectArray = argMap.valueArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (CPPTemplates.isDependentType((IType)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IBinding instantiateTemplate(ICPPTemplateDefinition template, IType[] arguments, ObjectMap specializedArgs) {
        ICPPTemplateParameter[] parameters = null;
        try {
            parameters = template.getTemplateParameters();
        }
        catch (DOMException e1) {
            return e1.getProblem();
        }
        if (parameters == null) {
            return null;
        }
        int numParams = parameters.length;
        int numArgs = arguments.length;
        if (numParams == 0) {
            return null;
        }
        ObjectMap map = new ObjectMap(numParams);
        ICPPTemplateParameter param = null;
        IType arg = null;
        IType[] actualArgs = new IType[numParams];
        boolean argsContainDependentType = false;
        arguments = SemanticUtil.getSimplifiedTypes(arguments);
        int i = 0;
        while (i < numParams) {
            arg = null;
            param = parameters[i];
            if (i < numArgs) {
                arg = arguments[i];
            } else {
                IType defaultType = null;
                try {
                    if (param instanceof ICPPTemplateTypeParameter) {
                        defaultType = ((ICPPTemplateTypeParameter)param).getDefault();
                    } else if (param instanceof ICPPTemplateTemplateParameter) {
                        defaultType = ((ICPPTemplateTemplateParameter)param).getDefault();
                    } else if (param instanceof ICPPTemplateNonTypeParameter) {
                        defaultType = CPPVisitor.getExpressionType(((ICPPTemplateNonTypeParameter)param).getDefault());
                    }
                }
                catch (DOMException e) {
                    defaultType = e.getProblem();
                }
                if (defaultType != null) {
                    if (defaultType instanceof ICPPTemplateParameter) {
                        if (map.containsKey(defaultType)) {
                            arg = (IType)map.get(defaultType);
                        }
                    } else if (defaultType instanceof ICPPUnknownBinding) {
                        IType resolvedType = null;
                        try {
                            IBinding resolved = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)defaultType), map, null);
                            if (resolved instanceof IType) {
                                resolvedType = (IType)((Object)resolved);
                            }
                        }
                        catch (DOMException dOMException) {}
                        arg = resolvedType == null ? defaultType : resolvedType;
                    } else {
                        arg = defaultType;
                    }
                } else {
                    return null;
                }
            }
            if (CPPTemplates.matchTemplateParameterAndArgument(param, arg, map)) {
                if (!param.equals(arg)) {
                    map.put(param, arg);
                }
                actualArgs[i] = arg;
                if (CPPTemplates.isDependentType(arg)) {
                    argsContainDependentType = true;
                }
            } else {
                return null;
            }
            ++i;
        }
        if (argsContainDependentType) {
            return ((ICPPInternalTemplateInstantiator)((Object)template)).deferredInstance(map, actualArgs);
        }
        ICPPSpecialization instance = ((ICPPInternalTemplateInstantiator)((Object)template)).getInstance(actualArgs);
        if (instance != null) {
            return instance;
        }
        if (specializedArgs != null) {
            int i2 = 0;
            while (i2 < specializedArgs.size()) {
                map.put(specializedArgs.keyAt(i2), specializedArgs.getAt(i2));
                ++i2;
            }
        }
        ICPPScope scope = null;
        try {
            scope = (ICPPScope)template.getScope();
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        instance = (ICPPTemplateInstance)CPPTemplates.createInstance(scope, template, map, actualArgs);
        if (template instanceof ICPPInternalTemplate) {
            ICPPInternalTemplate internalTmpl = (ICPPInternalTemplate)((Object)template);
            internalTmpl.addSpecialization(arguments, instance);
            internalTmpl.addSpecialization(actualArgs, instance);
        }
        return instance;
    }

    public static ICPPBase[] getBases(ICPPTemplateInstance classInstance) throws DOMException {
        assert (classInstance instanceof ICPPClassType);
        ICPPBase[] pdomBases = ((ICPPClassType)((Object)classInstance.getTemplateDefinition())).getBases();
        if (pdomBases != null) {
            Object[] result = null;
            ICPPBase[] iCPPBaseArray = pdomBases;
            int n = pdomBases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase origBase = iCPPBaseArray[n2];
                ICPPBase specBase = (ICPPBase)((ICPPInternalBase)((Object)origBase)).clone();
                IBinding origClass = origBase.getBaseClass();
                if (origClass instanceof IType) {
                    IType specClass = CPPTemplates.instantiateType((IType)((Object)origClass), classInstance.getArgumentMap(), ((ICPPClassType)((Object)classInstance)).getCompositeScope());
                    if ((specClass = SemanticUtil.getUltimateType(specClass, true)) instanceof IBinding) {
                        ((ICPPInternalBase)((Object)specBase)).setBaseClass((IBinding)((Object)specClass));
                    }
                    result = (ICPPBase[])ArrayUtil.append(ICPPBase.class, result, specBase);
                }
                ++n2;
            }
            return (ICPPBase[])ArrayUtil.trim(ICPPBase.class, result);
        }
        return new ICPPBase[0];
    }

    public static IBinding resolveUnknown(ICPPUnknownBinding unknown, ObjectMap argMap, ICPPScope instantiationScope) throws DOMException {
        IBinding binding;
        ICPPUnknownBinding unknownParent = unknown.getUnknownContainerBinding();
        IBinding result = unknown;
        IType t = null;
        if (unknownParent instanceof ICPPTemplateTypeParameter) {
            t = CPPTemplates.instantiateType((ICPPTemplateTypeParameter)((Object)unknownParent), argMap, null);
        } else if (unknownParent instanceof ICPPUnknownClassType && (binding = CPPTemplates.resolveUnknown(unknownParent, argMap, instantiationScope)) instanceof IType) {
            t = (IType)((Object)binding);
        }
        if (t != null) {
            IASTName name;
            IScope s;
            if ((t = SemanticUtil.getUltimateType(t, false)) instanceof ICPPUnknownBinding) {
                result = unknown.resolvePartially((ICPPUnknownBinding)((Object)t), argMap, instantiationScope);
            } else if (t instanceof ICPPClassType && (s = ((ICPPClassType)t).getCompositeScope()) != null && ASTInternal.isFullyCached(s) && (name = unknown.getUnknownName()) != null) {
                if (name.getParent() != null) {
                    result = s.getBinding(name, true);
                } else {
                    IBinding[] bindings = s.find(name.toString());
                    if (bindings != null && bindings.length > 0) {
                        result = bindings[0];
                    }
                }
                if (unknown instanceof ICPPUnknownClassInstance && result instanceof ICPPInternalTemplateInstantiator) {
                    IType[] newArgs = CPPTemplates.instantiateTypes(((ICPPUnknownClassInstance)unknown).getArguments(), argMap, null);
                    result = ((ICPPInternalTemplateInstantiator)((Object)result)).instantiate(newArgs);
                }
            }
        } else if (unknown instanceof ICPPDeferredTemplateInstance) {
            result = unknown.resolvePartially(null, argMap, instantiationScope);
        }
        return result;
    }

    public static final class CPPImplicitFunctionTemplate
    extends CPPFunctionTemplate {
        IParameter[] functionParameters = null;
        ICPPTemplateParameter[] templateParameters = null;

        public CPPImplicitFunctionTemplate(ICPPTemplateParameter[] templateParameters, IParameter[] functionParameters) {
            super(null);
            this.functionParameters = functionParameters;
            this.templateParameters = templateParameters;
        }

        public IParameter[] getParameters() {
            return this.functionParameters;
        }

        public ICPPTemplateParameter[] getTemplateParameters() {
            return this.templateParameters;
        }

        public IScope getScope() {
            return null;
        }

        public IFunctionType getType() {
            if (this.type == null) {
                this.type = CPPVisitor.createImplicitFunctionType(new CPPBasicType(1, 0), this.functionParameters, null);
            }
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClearBindingAction
    extends CPPASTVisitor {
        public ObjectSet<IBinding> bindings = null;

        public ClearBindingAction(ObjectSet<IBinding> bindings) {
            this.shouldVisitNames = true;
            this.shouldVisitStatements = true;
            this.bindings = bindings;
        }

        @Override
        public int visit(IASTName name) {
            if (name.getBinding() != null) {
                IBinding binding = name.getBinding();
                boolean clear = this.bindings.containsKey(name.getBinding());
                if (!clear && binding instanceof ICPPTemplateInstance) {
                    IType[] args;
                    IType[] iTypeArray = args = ((ICPPTemplateInstance)binding).getArguments();
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType arg = iTypeArray[n2];
                        if (arg instanceof IBinding && this.bindings.containsKey((IBinding)((Object)arg))) {
                            clear = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (clear) {
                    if (binding instanceof ICPPInternalBinding) {
                        ((ICPPInternalBinding)binding).removeDeclaration(name);
                    }
                    name.setBinding(null);
                }
            }
            return 3;
        }

        @Override
        public int visit(IASTStatement statement) {
            return 1;
        }
    }
}

