/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.TextUtilities;

public class FileHelper {
    private static final String DEFAULT_LINE_DELIMITTER = "\n";

    public static IFile getIFilefromIASTNode(IASTNode node) {
        Path implPath = new Path(node.getContainingFilename());
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)implPath);
    }

    public static boolean isFirstWithinSecondLocation(IASTFileLocation loc1, IASTFileLocation loc2) {
        boolean isEquals = true;
        isEquals &= loc1.getFileName().equals(loc2.getFileName());
        isEquals &= loc1.getNodeOffset() >= loc2.getNodeOffset();
        return isEquals &= loc1.getNodeOffset() + loc1.getNodeLength() <= loc2.getNodeOffset() + loc2.getNodeLength();
    }

    public static String determineLineDelimiter(IFile file) {
        StringBuilder fileContent = new StringBuilder();
        try {
            int read;
            InputStream fis = file.getContents();
            byte[] buffer = new byte[1024];
            while ((read = fis.read(buffer)) >= 0) {
                fileContent.append(new String(buffer, 0, read));
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {}
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject();
        IScopeContext[] scopeContext = project != null ? new IScopeContext[]{new ProjectScope(project)} : new IScopeContext[]{new InstanceScope()};
        String platformDefaultLineDelimiter = System.getProperty("line.separator", DEFAULT_LINE_DELIMITTER);
        String defaultLineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefaultLineDelimiter, scopeContext);
        return TextUtilities.determineLineDelimiter((String)fileContent.toString(), (String)defaultLineDelimiter);
    }
}

