/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.EmptyCIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.Messages;
import org.eclipse.cdt.internal.core.index.WritableCIndex;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFactory {
    private static final int ADD_DEPENDENCIES = 1;
    private static final int ADD_DEPENDENT = 2;
    private static final int SKIP_PROVIDED = 4;
    private PDOMManager fPDOMManager;

    public IndexFactory(PDOMManager manager) {
        this.fPDOMManager = manager;
    }

    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        projects = (ICProject[])ArrayUtil.removeNulls(ICProject.class, projects);
        boolean addDependencies = (options & 1) != 0;
        boolean addDependent = (options & 2) != 0;
        boolean skipProvided = (options & 4) != 0;
        HashMap<IProject, Integer> map = new HashMap<IProject, Integer>();
        Collection<ICProject> selectedProjects = this.getProjects(projects, addDependencies, addDependent, map, new Integer(1));
        LinkedHashMap<String, IIndexFragment> fragments = new LinkedHashMap<String, IIndexFragment>();
        for (ICProject cproject : selectedProjects) {
            IPDOM pdom = this.fPDOMManager.getPDOM(cproject);
            if (pdom == null) continue;
            this.safeAddFragment(fragments, pdom);
            if (skipProvided) continue;
            this.safeAddProvidedFragments(cproject, fragments);
        }
        if (fragments.isEmpty()) {
            return EmptyCIndex.INSTANCE;
        }
        int primaryFragmentCount = fragments.size();
        if (!addDependencies) {
            projects = selectedProjects.toArray(new ICProject[selectedProjects.size()]);
            selectedProjects.clear();
            selectedProjects = this.getProjects(projects, true, false, map, new Integer(2));
            for (ICProject cproject : selectedProjects) {
                IPDOM pdom = this.fPDOMManager.getPDOM(cproject);
                this.safeAddFragment(fragments, pdom);
                if (skipProvided) continue;
                this.safeAddProvidedFragments(cproject, fragments);
            }
        }
        Collection pdoms = ((HashMap)fragments).values();
        return new CIndex(pdoms.toArray(new IIndexFragment[pdoms.size()]), primaryFragmentCount);
    }

    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        LinkedHashMap<String, IIndexFragment> readOnlyFrag = new LinkedHashMap<String, IIndexFragment>();
        IWritableIndexFragment pdom = (IWritableIndexFragment)((Object)this.fPDOMManager.getPDOM(project));
        if (pdom == null) {
            throw new CoreException(CCorePlugin.createStatus(MessageFormat.format(Messages.IndexFactory_errorNoSuchPDOM0, project.getElementName())));
        }
        this.safeAddProvidedFragments(project, readOnlyFrag);
        Collection<ICProject> selectedProjects = this.getProjects(new ICProject[]{project}, true, false, new HashMap<IProject, Integer>(), new Integer(1));
        selectedProjects.remove(project);
        for (ICProject cproject : selectedProjects) {
            this.safeAddFragment(readOnlyFrag, this.fPDOMManager.getPDOM(cproject));
        }
        Collection roPdoms = readOnlyFrag.values();
        return new WritableCIndex(pdom, roPdoms.toArray(new IIndexFragment[roPdoms.size()]));
    }

    private Collection<ICProject> getProjects(ICProject[] projects, boolean addDependencies, boolean addDependent, HashMap<IProject, Integer> map, Integer markWith) {
        ArrayList<IProject> projectsToSearch = new ArrayList<IProject>();
        ICProject[] iCProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ICProject cproject = iCProjectArray[n2];
            IProject project = cproject.getProject();
            this.checkAddProject(project, map, projectsToSearch, markWith);
            projectsToSearch.add(project);
            ++n2;
        }
        if (addDependencies || addDependent) {
            int i = 0;
            while (i < projectsToSearch.size()) {
                IProject project = (IProject)projectsToSearch.get(i);
                try {
                    if (addDependencies) {
                        IProject[] iProjectArray = project.getReferencedProjects();
                        int j = 0;
                        while (j < iProjectArray.length) {
                            this.checkAddProject(iProjectArray[j], map, projectsToSearch, markWith);
                            ++j;
                        }
                    }
                    if (addDependent) {
                        IProject[] iProjectArray = project.getReferencingProjects();
                        int j = 0;
                        while (j < iProjectArray.length) {
                            this.checkAddProject(iProjectArray[j], map, projectsToSearch, markWith);
                            ++j;
                        }
                    }
                }
                catch (CoreException coreException) {
                    map.put(project, new Integer(0));
                }
                ++i;
            }
        }
        CoreModel cm = CoreModel.getDefault();
        ArrayList<ICProject> result = new ArrayList<ICProject>();
        for (Map.Entry entry : map.entrySet()) {
            ICProject cproject;
            if (entry.getValue() != markWith || (cproject = cm.create((IProject)entry.getKey())) == null) continue;
            result.add(cproject);
        }
        return result;
    }

    private void checkAddProject(IProject project, HashMap<IProject, Integer> map, List<IProject> projectsToSearch, Integer markWith) {
        if (map.get(project) == null) {
            if (project.isOpen()) {
                map.put(project, markWith);
                projectsToSearch.add(project);
            } else {
                map.put(project, new Integer(0));
            }
        }
    }

    private void safeAddFragment(Map<String, IIndexFragment> id2fragment, IIndexFragment fragment) {
        if (fragment != null) {
            try {
                fragment.acquireReadLock();
                try {
                    String id = fragment.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                    id2fragment.put(id, fragment);
                }
                finally {
                    fragment.releaseReadLock();
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            catch (InterruptedException ie) {
                CCorePlugin.log(ie);
            }
        }
    }

    private void safeAddProvidedFragments(ICProject cproject, Map<String, IIndexFragment> fragments) {
        ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(cproject.getProject(), false);
        if (pd != null) {
            IndexProviderManager ipm = CCoreInternals.getPDOMManager().getIndexProviderManager();
            ICConfigurationDescription cfg = pd.getDefaultSettingConfiguration();
            if (cfg != null) {
                try {
                    IIndexFragment[] pFragments;
                    IIndexFragment[] iIndexFragmentArray = pFragments = ipm.getProvidedIndexFragments(cfg);
                    int n = pFragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexFragment fragment = iIndexFragmentArray[n2];
                        this.safeAddFragment(fragments, fragment);
                        ++n2;
                    }
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            }
        }
    }
}

