/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexerTask
extends PDOMWriter {
    private static final int MAX_ERRORS = 500;
    private int fUpdateFlags = 1;
    private boolean fIndexHeadersWithoutContext = true;
    private boolean fIndexFilesWithoutConfiguration = true;
    private HashMap<FileKey, FileContent> fFileInfos = new HashMap();
    private Object[] fFilesToUpdate;
    private List<Object> fFilesToRemove = new ArrayList<Object>();
    private List<String> fFilesUpFront = new ArrayList<String>();
    private int fASTOptions;
    private int fForceNumberFiles = 0;
    protected IWritableIndex fIndex;
    private ITodoTaskUpdater fTodoTaskUpdater;
    private final boolean fIsFastIndexer;
    private ICodeReaderFactory fCodeReaderFactory;
    private static Object NO_CONTEXT = new Object();

    public AbstractIndexerTask(Object[] filesToUpdate, Object[] filesToRemove, IndexerInputAdapter resolver, boolean fastIndexer) {
        super(resolver);
        this.fIsFastIndexer = fastIndexer;
        this.fFilesToUpdate = filesToUpdate;
        this.fFilesToRemove.addAll((Collection<Object>)Arrays.asList(filesToRemove));
        this.updateRequestedFiles(this.fFilesToUpdate.length + this.fFilesToRemove.size());
    }

    public final void setIndexHeadersWithoutContext(boolean val) {
        this.fIndexHeadersWithoutContext = val;
    }

    public final void setIndexFilesWithoutBuildConfiguration(boolean val) {
        this.fIndexFilesWithoutConfiguration = val;
    }

    public final void setUpdateFlags(int flags) {
        this.fUpdateFlags = flags;
    }

    public final void setParseUpFront(String[] astFilePaths) {
        this.fFilesUpFront.addAll((Collection<String>)Arrays.asList(astFilePaths));
    }

    public final void setForceFirstFiles(int number) {
        this.fForceNumberFiles = number;
    }

    protected abstract IWritableIndex createIndex();

    protected abstract ICodeReaderFactory createReaderFactory();

    protected abstract AbstractLanguage[] getLanguages(String var1);

    protected ITodoTaskUpdater createTodoTaskUpdater() {
        return null;
    }

    protected IScannerInfo createDefaultScannerConfig(int linkageID) {
        return new ScannerInfo();
    }

    protected String getASTPathForParsingUpFront() {
        return "______";
    }

    private final IASTTranslationUnit createAST(String code, AbstractLanguage lang, IScannerInfo scanInfo, int options, IProgressMonitor monitor) throws CoreException {
        String dummyName = this.getASTPathForParsingUpFront();
        if (dummyName != null) {
            IIndexFileLocation dummyLoc = this.fResolver.resolveASTPath(dummyName);
            this.setIndexed(lang.getLinkageID(), dummyLoc);
            CodeReader codeReader = new CodeReader(dummyName, code.toCharArray());
            return this.createAST(lang, codeReader, scanInfo, options, monitor);
        }
        return null;
    }

    private final IASTTranslationUnit createAST(Object tu, AbstractLanguage language, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        CodeReader codeReader = this.fResolver.getCodeReader(tu);
        if (codeReader == null) {
            return null;
        }
        if (this.fResolver.isSourceUnit(tu)) {
            options |= 8;
        }
        return this.createAST(language, codeReader, scanInfo, options, pm);
    }

    private final IASTTranslationUnit createAST(AbstractLanguage language, CodeReader codeReader, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        if (this.fCodeReaderFactory == null) {
            this.fCodeReaderFactory = this.fIsFastIndexer ? new IndexBasedCodeReaderFactory(this.fIndex, this.fResolver, language.getLinkageID(), this.createReaderFactory(), this) : this.createReaderFactory();
        } else if (this.fIsFastIndexer) {
            ((IndexBasedCodeReaderFactory)this.fCodeReaderFactory).setLinkage(language.getLinkageID());
        }
        try {
            IASTTranslationUnit ast = language.getASTTranslationUnit(codeReader, scanInfo, this.fCodeReaderFactory, this.fIndex, options, this.getLogService());
            if (pm.isCanceled()) {
                return null;
            }
            IASTTranslationUnit iASTTranslationUnit = ast;
            return iASTTranslationUnit;
        }
        finally {
            if (this.fIsFastIndexer) {
                ((IndexBasedCodeReaderFactory)this.fCodeReaderFactory).cleanupAfterTranslationUnit();
            }
        }
    }

    protected IParserLogService getLogService() {
        return ParserUtil.getParserLogService();
    }

    public final void runTask(IProgressMonitor monitor) throws InterruptedException {
        if (!this.fIndexFilesWithoutConfiguration) {
            this.fIndexHeadersWithoutContext = false;
        }
        this.fIndex = this.createIndex();
        if (this.fIndex == null) {
            return;
        }
        this.fTodoTaskUpdater = this.createTodoTaskUpdater();
        this.fASTOptions = 6;
        if (this.getSkipReferences() == SKIP_ALL_REFERENCES) {
            this.fASTOptions |= 1;
        }
        this.fIndex.resetCacheCounters();
        this.fIndex.acquireReadLock();
        try {
            try {
                try {
                    HashMap<Integer, List<Object>> files = new HashMap<Integer, List<Object>>();
                    ArrayList<IIndexFragmentFile> ifilesToRemove = new ArrayList<IIndexFragmentFile>();
                    this.extractFiles(files, ifilesToRemove, monitor);
                    this.removeFilesInIndex(this.fFilesToRemove, ifilesToRemove, monitor);
                    this.parseFilesUpFront(monitor);
                    this.parseLinkage(1, files, monitor);
                    this.parseLinkage(2, files, monitor);
                    this.parseLinkage(3, files, monitor);
                }
                finally {
                    this.fIndex.flush();
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fIndex.releaseReadLock();
            }
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    private void extractFiles(Map<Integer, List<Object>> files, List<IIndexFragmentFile> iFilesToRemove, IProgressMonitor monitor) throws CoreException {
        boolean forceAll = (this.fUpdateFlags & 1) != 0;
        boolean checkTimestamps = (this.fUpdateFlags & 2) != 0;
        boolean checkConfig = (this.fUpdateFlags & 4) != 0;
        int count = 0;
        int forceFirst = this.fForceNumberFiles;
        Object[] objectArray = this.fFilesToUpdate;
        int n = this.fFilesToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            Object tu = objectArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            boolean force = forceAll || --forceFirst >= 0;
            IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
            if (ifl != null) {
                int n3;
                boolean isSourceUnit = this.fResolver.isSourceUnit(tu);
                boolean isExcludedSource = isSourceUnit && !this.fIndexFilesWithoutConfiguration && !this.fResolver.isFileBuildConfigured(tu);
                IIndexFragmentFile[] indexFiles = this.fIndex.getWritableFiles(ifl);
                if (isSourceUnit && !isExcludedSource || this.fIndexHeadersWithoutContext) {
                    AbstractLanguage[] langs;
                    AbstractLanguage[] abstractLanguageArray = langs = this.fResolver.getLanguages(tu);
                    int n4 = langs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        AbstractLanguage lang = abstractLanguageArray[n3];
                        int linkageID = lang.getLinkageID();
                        IIndexFragmentFile ifile = this.getFile(linkageID, indexFiles);
                        if (ifile == null || !ifile.hasContent()) {
                            this.store(tu, linkageID, isSourceUnit, files);
                            this.requestUpdate(linkageID, ifl, null);
                            ++count;
                        } else {
                            this.takeFile(ifile, indexFiles);
                            boolean update = false;
                            if (checkConfig) {
                                update = isSourceUnit ? this.isSourceUnitConfigChange(tu, ifile) : this.isHeaderConfigChange(tu, ifile);
                            }
                            boolean bl = update = update || force || checkTimestamps && this.fResolver.getLastModified(ifl) != ifile.getTimestamp();
                            if (update) {
                                this.requestUpdate(linkageID, ifl, ifile);
                                this.store(tu, linkageID, isSourceUnit, files);
                                ++count;
                            }
                        }
                        ++n3;
                    }
                }
                IIndexFragmentFile[] iIndexFragmentFileArray = indexFiles;
                n3 = indexFiles.length;
                int n5 = 0;
                while (n5 < n3) {
                    IIndexFragmentFile ifile = iIndexFragmentFileArray[n5];
                    if (ifile != null && ifile.hasContent()) {
                        IIndexInclude ctx = ifile.getParsedInContext();
                        if (ctx == null) {
                            iFilesToRemove.add(ifile);
                            ++count;
                        } else {
                            boolean update = false;
                            if (checkConfig && ifile.getParsedInContext() != null) {
                                update = this.isHeaderConfigChange(tu, ifile);
                            }
                            boolean bl = update = update || force || checkTimestamps && this.fResolver.getLastModified(ifl) != ifile.getTimestamp();
                            if (update) {
                                int linkageID = ifile.getLinkageID();
                                this.requestUpdate(linkageID, ifl, ifile);
                                this.store(tu, linkageID, false, files);
                                ++count;
                            }
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        this.updateRequestedFiles(count - this.fFilesToUpdate.length);
        this.fFilesToUpdate = null;
    }

    private void requestUpdate(int linkageID, IIndexFileLocation ifl, IIndexFragmentFile ifile) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        FileContent info = this.fFileInfos.get(key);
        if (info == null) {
            info = this.createFileInfo(key, null);
        }
        info.fIndexFile = ifile;
        info.fRequestUpdate = true;
    }

    private void setIndexed(int linkageID, IIndexFileLocation ifl) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        FileContent info = this.fFileInfos.get(key);
        if (info == null) {
            info = this.createFileInfo(key, null);
        }
        info.fIsUpdated = true;
        info.fMacros = null;
    }

    private FileContent createFileInfo(FileKey key, IIndexFile ifile) {
        FileContent info = new FileContent();
        this.fFileInfos.put(key, info);
        info.fIndexFile = ifile;
        return info;
    }

    private FileContent getFileInfo(int linkageID, IIndexFileLocation ifl) {
        FileKey key = new FileKey(linkageID, ifl.getURI());
        return this.fFileInfos.get(key);
    }

    private boolean isSourceUnitConfigChange(Object tu, IIndexFragmentFile ifile) {
        return false;
    }

    private boolean isHeaderConfigChange(Object tu, IIndexFragmentFile ifile) {
        return false;
    }

    private IIndexFragmentFile getFile(int linkageID, IIndexFragmentFile[] indexFiles) throws CoreException {
        IIndexFragmentFile[] iIndexFragmentFileArray = indexFiles;
        int n = indexFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
            if (ifile != null && ifile.getLinkageID() == linkageID) {
                return ifile;
            }
            ++n2;
        }
        return null;
    }

    private void takeFile(IIndexFragmentFile ifile, IIndexFragmentFile[] indexFiles) {
        int i = 0;
        while (i < indexFiles.length) {
            if (indexFiles[i] == ifile) {
                indexFiles[i] = null;
                return;
            }
            ++i;
        }
    }

    private void store(Object tu, int linkageID, boolean isSourceUnit, Map<Integer, List<Object>> files) {
        Integer key = this.getFileListKey(linkageID, isSourceUnit);
        List<Object> list = files.get(key);
        if (list == null) {
            list = new LinkedList<Object>();
            files.put(key, list);
        }
        list.add(tu);
    }

    private Integer getFileListKey(int linkageID, boolean isSourceUnit) {
        Integer key = new Integer(linkageID * 2 + (isSourceUnit ? 0 : 1));
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeFilesInIndex(List<Object> filesToRemove, List<IIndexFragmentFile> ifilesToRemove, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!filesToRemove.isEmpty() || !ifilesToRemove.isEmpty()) {
            this.fIndex.acquireWriteLock(1);
            try {
                for (Object tu : this.fFilesToRemove) {
                    IIndexFragmentFile[] ifiles;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
                    if (ifl == null) continue;
                    IIndexFragmentFile[] iIndexFragmentFileArray = ifiles = this.fIndex.getWritableFiles(ifl);
                    int n = ifiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
                        this.fIndex.clearFile(ifile, null);
                        ++n2;
                    }
                    this.updateRequestedFiles(-1);
                }
                for (IIndexFragmentFile ifile : ifilesToRemove) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.fIndex.clearFile(ifile, null);
                    this.updateRequestedFiles(-1);
                }
            }
            finally {
                this.fIndex.releaseWriteLock(1);
            }
        }
        this.fFilesToRemove.clear();
    }

    private void parseFilesUpFront(IProgressMonitor monitor) throws CoreException {
        for (String upfront : this.fFilesUpFront) {
            if (monitor.isCanceled()) {
                return;
            }
            String filePath = upfront;
            if ((filePath = filePath.trim()).length() == 0) continue;
            Path path = new Path(filePath);
            String fileName = path.lastSegment();
            try {
                AbstractLanguage[] langs;
                if (this.fShowActivity) {
                    System.out.println("Indexer: parsing " + filePath + " up front");
                }
                monitor.subTask(this.getMessage(MessageKind.parsingFileTask, fileName, path.removeLastSegments(1).toString()));
                AbstractLanguage[] abstractLanguageArray = langs = this.getLanguages(fileName);
                int n = langs.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractLanguage lang = abstractLanguageArray[n2];
                    int linkageID = lang.getLinkageID();
                    String code = "#include \"" + filePath + "\"\n";
                    IScannerInfo scanInfo = this.createDefaultScannerConfig(linkageID);
                    if (scanInfo != null) {
                        long start = System.currentTimeMillis();
                        IASTTranslationUnit ast = this.createAST(code, lang, scanInfo, this.fASTOptions, monitor);
                        this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
                        if (ast != null) {
                            this.writeToIndex(linkageID, ast, AbstractIndexerTask.computeHashCode(scanInfo), monitor);
                            this.updateFileCount(0, 0, 1);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                this.swallowError((IPath)path, e);
            }
        }
        this.fFilesUpFront.clear();
    }

    private void parseLinkage(int linkageID, Map<Integer, List<Object>> fileListMap, IProgressMonitor monitor) throws CoreException, InterruptedException {
        List<Object> files = fileListMap.get(this.getFileListKey(linkageID, true));
        if (files != null) {
            for (Object tu : files) {
                FileContent info;
                if (monitor.isCanceled()) {
                    return;
                }
                IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
                if (ifl == null || (info = this.getFileInfo(linkageID, ifl)) == null || !info.fRequestUpdate || info.fIsUpdated) continue;
                info.fRequestIsCounted = false;
                IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, tu);
                this.parseFile(tu, linkageID, ifl, scannerInfo, monitor);
                if (!info.fIsUpdated) continue;
                this.updateFileCount(1, 0, 0);
            }
            files.clear();
        }
        HashMap<IIndexFragmentFile, Object> contextMap = new HashMap<IIndexFragmentFile, Object>();
        files = fileListMap.get(this.getFileListKey(linkageID, false));
        if (files != null) {
            FileContent info;
            IIndexFileLocation ifl;
            Object header;
            Iterator<Object> iter = files.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                header = iter.next();
                ifl = this.fResolver.resolveFile(header);
                info = this.getFileInfo(linkageID, ifl);
                if (info != null && info.fRequestUpdate && !info.fIsUpdated) {
                    Object tu;
                    if (info.fIndexFile == null || !this.fIndex.isWritableFile(info.fIndexFile) || (tu = this.findContext((IIndexFragmentFile)info.fIndexFile, contextMap)) == null) continue;
                    IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, tu);
                    info.fRequestIsCounted = false;
                    this.parseFile(tu, linkageID, this.fResolver.resolveFile(tu), scannerInfo, monitor);
                    if (!info.fIsUpdated) continue;
                    this.updateFileCount(0, 0, 1);
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            contextMap = null;
            iter = files.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                header = iter.next();
                ifl = this.fResolver.resolveFile(header);
                info = this.getFileInfo(linkageID, ifl);
                if (info == null || !info.fRequestUpdate || info.fIsUpdated) continue;
                info.fRequestIsCounted = false;
                IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, header);
                this.parseFile(header, linkageID, ifl, scannerInfo, monitor);
                if (!info.fIsUpdated) continue;
                this.updateFileCount(0, 1, 1);
                iter.remove();
            }
        }
    }

    private Object findContext(IIndexFragmentFile ifile, HashMap<IIndexFragmentFile, Object> contextMap) {
        Object cachedContext = contextMap.get(ifile);
        if (cachedContext != null) {
            return cachedContext == NO_CONTEXT ? null : cachedContext;
        }
        try {
            IIndexFragmentFile contextIFile;
            Object context = this.fResolver.getInputFile(ifile.getLocation());
            if (context != null && this.fResolver.isSourceUnit(context)) {
                contextMap.put(ifile, context);
                return context;
            }
            contextMap.put(ifile, NO_CONTEXT);
            IIndexInclude contextInclude = ifile.getParsedInContext();
            if (contextInclude != null && (context = this.findContext(contextIFile = (IIndexFragmentFile)contextInclude.getIncludedBy(), contextMap)) != null) {
                contextMap.put(ifile, context);
                return context;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    private void parseFile(Object tu, int linkageID, IIndexFileLocation ifl, IScannerInfo scanInfo, IProgressMonitor pm) throws CoreException, InterruptedException {
        IPath path = this.getPathForLabel(ifl);
        AbstractLanguage[] langs = this.fResolver.getLanguages(tu);
        AbstractLanguage lang = null;
        AbstractLanguage[] abstractLanguageArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractLanguage lang2 = abstractLanguageArray[n2];
            if (lang2.getLinkageID() == linkageID) {
                lang = lang2;
                break;
            }
            ++n2;
        }
        if (lang == null) {
            return;
        }
        Throwable th = null;
        try {
            if (this.fShowActivity) {
                System.out.println("Indexer: parsing " + path.toOSString());
            }
            pm.subTask(this.getMessage(MessageKind.parsingFileTask, path.lastSegment(), path.removeLastSegments(1).toString()));
            long start = System.currentTimeMillis();
            IASTTranslationUnit ast = this.createAST(tu, lang, scanInfo, this.fASTOptions, pm);
            this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
            if (ast != null) {
                this.writeToIndex(linkageID, ast, AbstractIndexerTask.computeHashCode(scanInfo), pm);
            }
        }
        catch (CoreException e) {
            th = e;
        }
        catch (RuntimeException e) {
            th = e;
        }
        catch (PDOMNotImplementedError e) {
            th = e;
        }
        catch (StackOverflowError e) {
            th = e;
        }
        catch (Error e) {
            try {
                this.swallowError(path, e);
            }
            catch (Throwable throwable) {}
            throw e;
        }
        if (th != null) {
            this.swallowError(path, th);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeToIndex(int linkageID, IASTTranslationUnit ast, int configHash, IProgressMonitor pm) throws CoreException, InterruptedException {
        enteredFiles = new HashSet<IIndexFileLocation>();
        orderedIFLs = new ArrayList<IIndexFileLocation>();
        topIfl = this.fResolver.resolveASTPath(ast.getFilePath());
        enteredFiles.add(topIfl);
        tree = ast.getDependencyTree();
        var13_10 = inclusions = tree.getInclusions();
        var12_11 = inclusions.length;
        var11_13 = 0;
        while (var11_13 < var12_11) {
            inclusion = var13_10[var11_13];
            this.collectOrderedIFLs(linkageID, inclusion, enteredFiles, orderedIFLs);
            ++var11_13;
        }
        info = this.getFileInfo(linkageID, topIfl);
        if (info != null && FileContent.access$3(info) && !FileContent.access$4(info)) {
            orderedIFLs.add(topIfl);
        }
        ifls = orderedIFLs.toArray(new IIndexFileLocation[orderedIFLs.size()]);
        try {
            this.addSymbols(ast, ifls, this.fIndex, 1, false, configHash, this.fTodoTaskUpdater, pm);
        }
        finally {
            var16_17 = ifls;
            var15_19 = ifls.length;
            var14_21 = 0;
            ** while (var14_21 < var15_19)
        }
lbl-1000:
        // 1 sources

        {
            ifl = var16_17[var14_21];
            info = this.getFileInfo(linkageID, ifl);
            Assert.isNotNull((Object)info);
            FileContent.access$2(info, true);
            ++var14_21;
            continue;
        }
lbl34:
        // 1 sources

    }

    private void collectOrderedIFLs(int linkageID, IASTTranslationUnit.IDependencyTree.IASTInclusionNode inclusion, HashSet<IIndexFileLocation> enteredFiles, ArrayList<IIndexFileLocation> orderedIFLs) throws CoreException {
        IASTPreprocessorIncludeStatement id = inclusion.getIncludeDirective();
        if (id.isActive() && id.isResolved()) {
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] nested;
            IIndexFileLocation ifl = this.fResolver.resolveASTPath(id.getPath());
            boolean isFirstEntry = enteredFiles.add(ifl);
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] iASTInclusionNodeArray = nested = inclusion.getNestedInclusions();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IASTTranslationUnit.IDependencyTree.IASTInclusionNode element = iASTInclusionNodeArray[n2];
                this.collectOrderedIFLs(linkageID, element, enteredFiles, orderedIFLs);
                ++n2;
            }
            if (isFirstEntry && this.needToUpdateHeader(linkageID, ifl)) {
                orderedIFLs.add(ifl);
            }
        }
    }

    public final boolean needToUpdateHeader(int linkageID, IIndexFileLocation ifl) throws CoreException {
        boolean needUpdate;
        FileContent info = this.getFileInfo(linkageID, ifl);
        if (info == null) {
            IIndexFile ifile = null;
            if (this.fResolver.canBePartOfSDK(ifl)) {
                ifile = this.fIndex.getFile(linkageID, ifl);
            } else {
                IIndexFragmentFile fragFile = this.fIndex.getWritableFile(linkageID, ifl);
                if (fragFile != null && fragFile.hasContent()) {
                    ifile = fragFile;
                }
            }
            info = this.createFileInfo(new FileKey(linkageID, ifl.getURI()), ifile);
            if (ifile == null) {
                info.fRequestIsCounted = false;
                info.fRequestUpdate = true;
            }
        }
        boolean bl = needUpdate = !info.fIsUpdated && info.fRequestUpdate;
        if (needUpdate && info.fRequestIsCounted) {
            this.updateFileCount(0, 1, 0);
            info.fRequestIsCounted = false;
        }
        return needUpdate;
    }

    private IPath getPathForLabel(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            return new Path(fullPath);
        }
        IPath path = IndexLocationFactory.getAbsolutePath(ifl);
        if (path != null) {
            return path;
        }
        URI uri = ifl.getURI();
        return new Path(uri.getPath());
    }

    private void swallowError(IPath file, Throwable e) throws CoreException {
        IStatus s;
        if (e instanceof CoreException) {
            s = ((CoreException)e).getStatus();
            if (s.getException() == null) {
                s = new Status(s.getSeverity(), s.getPlugin(), s.getCode(), s.getMessage(), e);
            }
        } else {
            s = CCorePlugin.createStatus(this.getMessage(MessageKind.errorWhileParsing, file), e);
        }
        this.logError(s);
        if (++this.fStatistics.fErrorCount > 500) {
            throw new CoreException(this.createStatus(this.getMessage(MessageKind.tooManyIndexProblems, new Object[0])));
        }
    }

    protected void logError(IStatus s) {
        CCorePlugin.log(s);
    }

    private static int computeHashCode(IScannerInfo scannerInfo) {
        String[] a;
        int result = 0;
        Map<String, String> macros = scannerInfo.getDefinedSymbols();
        if (macros != null) {
            for (Map.Entry<String, String> entry : macros.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                result = AbstractIndexerTask.addToHashcode(result, key);
                if (value == null || value.length() <= 0) continue;
                result = AbstractIndexerTask.addToHashcode(result, value);
            }
        }
        if ((a = scannerInfo.getIncludePaths()) != null) {
            String[] stringArray = a;
            int n = a.length;
            int key = 0;
            while (key < n) {
                String element = stringArray[key];
                result = AbstractIndexerTask.addToHashcode(result, element);
                ++key;
            }
        }
        if (scannerInfo instanceof IExtendedScannerInfo) {
            String element;
            String[] stringArray;
            IExtendedScannerInfo esi = (IExtendedScannerInfo)scannerInfo;
            a = esi.getIncludeFiles();
            if (a != null) {
                stringArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    element = stringArray[n2];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n2;
                }
            }
            if ((a = esi.getLocalIncludePath()) != null) {
                stringArray = a;
                int n = a.length;
                int n3 = 0;
                while (n3 < n) {
                    element = stringArray[n3];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n3;
                }
            }
            if ((a = esi.getMacroFiles()) != null) {
                stringArray = a;
                int n = a.length;
                int n4 = 0;
                while (n4 < n) {
                    element = stringArray[n4];
                    result = AbstractIndexerTask.addToHashcode(result, element);
                    ++n4;
                }
            }
        }
        return result;
    }

    private static int addToHashcode(int result, String key) {
        return result * 31 + key.hashCode();
    }

    public final FileContent getFileContent(int linkageID, IIndexFileLocation ifl) throws CoreException {
        if (!this.needToUpdateHeader(linkageID, ifl)) {
            FileContent info = this.getFileInfo(linkageID, ifl);
            Assert.isNotNull((Object)info);
            if (info.fIndexFile == null) {
                info.fIndexFile = this.fIndex.getFile(linkageID, ifl);
                if (info.fIndexFile == null) {
                    return null;
                }
            }
            if (info.fMacros == null) {
                info.fMacros = info.fIndexFile.getMacros();
            }
            if (info.fDirectives == null) {
                info.fDirectives = info.fIndexFile.getUsingDirectives();
            }
            return info;
        }
        return null;
    }

    protected String getMessage(MessageKind kind, Object ... arguments) {
        switch (kind) {
            case parsingFileTask: {
                return NLS.bind((String)Messages.AbstractIndexerTask_parsingFileTask, (Object[])arguments);
            }
            case errorWhileParsing: {
                return NLS.bind((String)Messages.AbstractIndexerTask_errorWhileParsing, (Object[])arguments);
            }
            case tooManyIndexProblems: {
                return Messages.AbstractIndexerTask_tooManyIndexProblems;
            }
        }
        return null;
    }

    protected IStatus createStatus(String msg) {
        return CCorePlugin.createStatus(msg);
    }

    public static class FileContent {
        private IIndexFile fIndexFile = null;
        private boolean fRequestUpdate = false;
        private boolean fRequestIsCounted = true;
        private boolean fIsUpdated = false;
        public IIndexMacro[] fMacros;
        public ICPPUsingDirective[] fDirectives;
    }

    private static class FileKey {
        final URI fUri;
        final int fLinkageID;

        public FileKey(int linkageID, URI uri) {
            this.fUri = uri;
            this.fLinkageID = linkageID;
        }

        public int hashCode() {
            return this.fUri.hashCode() * 31 + this.fLinkageID;
        }

        public boolean equals(Object obj) {
            FileKey other = (FileKey)obj;
            return this.fLinkageID == other.fLinkageID && this.fUri.equals(other.fUri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MessageKind {
        parsingFileTask,
        errorWhileParsing,
        tooManyIndexProblems;

    }
}

