/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPNamespaceAlias
extends PDOMCPPBinding
implements ICPPNamespaceAlias {
    private static final int NAMESPACE_BINDING = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCPPNamespaceAlias(PDOM pdom, PDOMNode parent, ICPPNamespaceAlias alias) throws CoreException {
        super(pdom, parent, alias.getNameCharArray());
        this.setTargetBinding(parent.getLinkageImpl(), alias.getBinding());
    }

    public PDOMCPPNamespaceAlias(PDOM pdom, int record) {
        super(pdom, record);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPNamespaceAlias) {
            ICPPNamespaceAlias alias = (ICPPNamespaceAlias)newBinding;
            IBinding oldTarget = this.getBinding();
            IBinding newTarget = alias.getBinding();
            this.setTargetBinding(linkage, newTarget);
            if (oldTarget != null) {
                linkage.deleteBinding(oldTarget);
            }
        }
    }

    private void setTargetBinding(PDOMLinkage linkage, IBinding target) throws CoreException {
        PDOMBinding namespace = this.getLinkageImpl().adaptBinding(target);
        this.pdom.getDB().putInt(this.record + 28, namespace != null ? namespace.getRecord() : 0);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 12;
    }

    public ICPPNamespaceScope getNamespaceScope() throws DOMException {
        return this.getNamespaceScope(this, 20);
    }

    private ICPPNamespaceScope getNamespaceScope(PDOMCPPNamespaceAlias alias, int maxDepth) {
        IBinding binding = alias.getBinding();
        if (binding instanceof ICPPNamespaceScope) {
            return (ICPPNamespaceScope)((Object)binding);
        }
        if (maxDepth <= 0) {
            return null;
        }
        if (binding instanceof PDOMCPPNamespaceAlias) {
            return this.getNamespaceScope((PDOMCPPNamespaceAlias)binding, maxDepth - 1);
        }
        return null;
    }

    public IBinding[] getMemberBindings() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding getBinding() {
        try {
            return (IBinding)((Object)this.getLinkageImpl().getNode(this.getPDOM().getDB().getInt(this.record + 28)));
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }
}

