/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.cdtvariables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableStatus;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplierBasedCdtVariableSubstitutor
implements IVariableSubstitutor {
    private static final String EMPTY_STRING = "";
    private IVariableContextInfo fContextInfo;
    private String fInexistentMacroValue;
    private String fListDelimiter;
    private String fIncorrectlyReferencedMacroValue;
    private Map<?, ?> fDelimiterMap;
    private Map<String, ResolvedMacro> fResolvedMacros = new HashMap<String, ResolvedMacro>();
    private HashSet<String> fMacrosUnderResolution = new HashSet();
    private Stack<MacroDescriptor> fMacroDescriptors = new Stack();

    public SupplierBasedCdtVariableSubstitutor(IVariableContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
        this(contextInfo, inexistentMacroValue, listDelimiter, null, inexistentMacroValue);
    }

    public SupplierBasedCdtVariableSubstitutor(IVariableContextInfo contextInfo, String inexistentMacroValue, String listDelimiter, Map<?, ?> delimiterMap, String incorrectlyReferencedMacroValue) {
        this.fContextInfo = contextInfo;
        this.fInexistentMacroValue = inexistentMacroValue;
        this.fListDelimiter = listDelimiter;
        this.fDelimiterMap = delimiterMap;
        this.fIncorrectlyReferencedMacroValue = incorrectlyReferencedMacroValue;
    }

    protected String resolveToString(MacroDescriptor des) throws CdtVariableException {
        String result = null;
        ResolvedMacro value = this.getResolvedMacro(des);
        result = value.getStringValue();
        return result;
    }

    protected String[] resolveToStringList(MacroDescriptor des) throws CdtVariableException {
        String[] result = null;
        ResolvedMacro value = this.getResolvedMacro(des);
        result = value.getStringListValue();
        return result;
    }

    @Override
    public String resolveToString(String macroName) throws CdtVariableException {
        return this.resolveToString(new MacroDescriptor(macroName, this.fContextInfo));
    }

    public void setMacroContextInfo(IVariableContextInfo info) throws CdtVariableException {
        if (this.checkEqual(this.fContextInfo, info)) {
            return;
        }
        this.reset();
        this.fContextInfo = info;
    }

    protected ResolvedMacro getResolvedMacro(MacroDescriptor des) throws CdtVariableException {
        ResolvedMacro value = this.checkResolvingMacro(des);
        if (value == null) {
            try {
                value = this.resolveMacro(des);
            }
            finally {
                if (value != null) {
                    this.addResolvedMacro(des, value);
                } else {
                    value = new ResolvedMacro(des.fName, this.fInexistentMacroValue, false);
                    this.addResolvedMacro(des, value);
                }
            }
        }
        return value;
    }

    protected ResolvedMacro resolveMacro(MacroDescriptor des) throws CdtVariableException {
        return des.fMacro != null ? this.resolveMacro(des.fMacro) : this.resolveMacro(des.fName);
    }

    @Override
    public String[] resolveToStringList(String macroName) throws CdtVariableException {
        return this.resolveToStringList(new MacroDescriptor(macroName, this.fContextInfo));
    }

    protected ResolvedMacro resolveMacro(String macroName) throws CdtVariableException {
        return this.resolveMacro(SupplierBasedCdtVariableManager.getVariable(macroName, this.fContextInfo, true));
    }

    protected ResolvedMacro resolveParentMacro(MacroDescriptor macroDes) throws CdtVariableException {
        MacroDescriptor des = macroDes.getNext();
        ResolvedMacro macro = null;
        if (des != null) {
            try {
                this.fMacroDescriptors.push(des);
                macro = this.resolveMacro(des.getMacro());
            }
            finally {
                this.fMacroDescriptors.pop();
            }
        }
        return macro;
    }

    protected ResolvedMacro resolveMacro(ICdtVariable macro) throws CdtVariableException {
        if (macro == null) {
            return null;
        }
        String macroName = macro.getName();
        SupplierBasedCdtVariableSubstitutor substitutor = this;
        ResolvedMacro resolvedMacro = null;
        if (CdtVariableResolver.isStringListVariable(macro.getValueType())) {
            String[] result = null;
            String[] unresolvedValues = macro.getStringListValue();
            if (unresolvedValues == null || unresolvedValues.length == 0) {
                resolvedMacro = new ResolvedMacro(macroName, EMPTY_STRING);
            } else {
                String[][] resolvedValues = new String[unresolvedValues.length][];
                int i = 0;
                while (i < unresolvedValues.length) {
                    try {
                        resolvedValues[i] = CdtVariableResolver.resolveToStringList(unresolvedValues[i], substitutor);
                    }
                    catch (CdtVariableException e) {
                        ICdtVariableStatus status;
                        ICdtVariableStatus[] statuses = e.getVariableStatuses();
                        if (statuses != null && statuses.length == 1 && (status = statuses[0]).getVariableName() == null) {
                            SupplierBasedCdtVariableStatus eStatus = new SupplierBasedCdtVariableStatus(status.getCode(), macro.getName(), status.getExpression(), status.getReferencedMacroName(), this.fContextInfo);
                            e = new CdtVariableException(eStatus);
                        }
                        throw e;
                    }
                    ++i;
                }
                if (resolvedValues.length == 1) {
                    result = resolvedValues[0];
                } else {
                    ArrayList list = new ArrayList();
                    String[][] stringArrayArray = resolvedValues;
                    int n = resolvedValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] resolvedValue = stringArrayArray[n2];
                        list.addAll(Arrays.asList(resolvedValue));
                        ++n2;
                    }
                    result = list.toArray(new String[list.size()]);
                }
                resolvedMacro = new ResolvedMacro(macroName, result);
            }
        } else {
            try {
                resolvedMacro = new ResolvedMacro(macroName, CdtVariableResolver.resolveToString(macro.getStringValue(), substitutor));
            }
            catch (CdtVariableException e) {
                ICdtVariableStatus status;
                ICdtVariableStatus[] statuses = e.getVariableStatuses();
                if (statuses != null && statuses.length == 1 && (status = statuses[0]).getVariableName() == null) {
                    SupplierBasedCdtVariableStatus eStatus = new SupplierBasedCdtVariableStatus(status.getCode(), macro.getName(), status.getExpression(), status.getReferencedMacroName(), this.fContextInfo);
                    e = new CdtVariableException(eStatus);
                }
                throw e;
            }
        }
        return resolvedMacro;
    }

    private ResolvedMacro checkResolvingMacro(MacroDescriptor des) throws CdtVariableException {
        String name = des.fName;
        ResolvedMacro value = this.fResolvedMacros.get(name);
        if (value == null) {
            if (this.fMacrosUnderResolution.add(name)) {
                this.fMacroDescriptors.push(des);
            } else {
                MacroDescriptor last = (MacroDescriptor)this.fMacroDescriptors.lastElement();
                if (last != null && last.fName.equals(name)) {
                    value = this.resolveParentMacro(last);
                    if (value == null) {
                        value = new ResolvedMacro(name, EMPTY_STRING, false);
                    }
                } else if (this.fIncorrectlyReferencedMacroValue != null) {
                    value = new ResolvedMacro(name, this.fIncorrectlyReferencedMacroValue, false);
                } else {
                    SupplierBasedCdtVariableStatus status = new SupplierBasedCdtVariableStatus(3, null, null, name, this.fContextInfo);
                    throw new CdtVariableException(status);
                }
            }
        }
        return value;
    }

    protected void addResolvedMacro(MacroDescriptor des, ResolvedMacro value) {
        String name = des.fName;
        this.fMacrosUnderResolution.remove(name);
        this.fResolvedMacros.put(name, value);
        this.fMacroDescriptors.pop();
    }

    protected ResolvedMacro removeResolvedMacro(String name) {
        return this.fResolvedMacros.remove(name);
    }

    public IVariableContextInfo getMacroContextInfo() {
        return this.fContextInfo;
    }

    public void reset() throws CdtVariableException {
        if (this.fMacrosUnderResolution.size() != 0) {
            throw new CdtVariableException(-1, null, null, null);
        }
        this.fResolvedMacros.clear();
    }

    public Map<?, ?> getDelimiterMap() {
        return this.fDelimiterMap;
    }

    public void setDelimiterMap(Map<?, ?> delimiterMap) throws CdtVariableException {
        if (this.checkEqual(this.fDelimiterMap, delimiterMap)) {
            return;
        }
        this.reset();
        this.fDelimiterMap = delimiterMap;
    }

    public String getIncorrectlyReferencedMacroValue() {
        return this.fIncorrectlyReferencedMacroValue;
    }

    protected boolean checkEqual(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public void setIncorrectlyReferencedMacroValue(String incorrectlyReferencedMacroValue) throws CdtVariableException {
        if (this.checkEqual(this.fIncorrectlyReferencedMacroValue, incorrectlyReferencedMacroValue)) {
            return;
        }
        this.reset();
        this.fIncorrectlyReferencedMacroValue = incorrectlyReferencedMacroValue;
    }

    public String getInexistentMacroValue() {
        return this.fInexistentMacroValue;
    }

    public void setInexistentMacroValue(String inexistentMacroValue) throws CdtVariableException {
        if (this.checkEqual(this.fInexistentMacroValue, inexistentMacroValue)) {
            return;
        }
        this.reset();
        this.fInexistentMacroValue = inexistentMacroValue;
    }

    public String getListDelimiter() {
        return this.fListDelimiter;
    }

    public void setListDelimiter(String listDelimiter) throws CdtVariableException {
        if (this.checkEqual(this.fListDelimiter, listDelimiter)) {
            return;
        }
        this.reset();
        this.fListDelimiter = listDelimiter;
    }

    protected class MacroDescriptor {
        private String fName;
        private IVariableContextInfo fInfo;
        private ICdtVariable fMacro;
        private boolean fInitialized;
        private int fSupplierNum;

        public MacroDescriptor(String name, IVariableContextInfo info) {
            this.fName = name;
            this.fInfo = info;
        }

        public MacroDescriptor(String name, IVariableContextInfo info, int supplierNum) {
            this.fName = name;
            this.fInfo = info;
            this.fSupplierNum = supplierNum;
        }

        public MacroDescriptor(ICdtVariable macro, IVariableContextInfo info, int supplierNum) {
            this.fName = macro.getName();
            this.fInfo = info;
            this.fMacro = macro;
            this.fSupplierNum = supplierNum;
            this.fInitialized = true;
        }

        public MacroDescriptor getNext() {
            return new MacroDescriptor(this.fName, this.getInfo(), this.getSupplierNum() + 1);
        }

        public int getSupplierNum() {
            this.init();
            return this.fSupplierNum;
        }

        private void init() {
            if (this.fInitialized) {
                return;
            }
            this.fInitialized = true;
            while (this.fInfo != null) {
                ICdtVariableSupplier[] suppliers = this.fInfo.getSuppliers();
                if (suppliers != null) {
                    while (this.fSupplierNum < suppliers.length) {
                        this.fMacro = suppliers[this.fSupplierNum].getVariable(this.fName, this.fInfo);
                        if (this.fMacro != null) {
                            return;
                        }
                        ++this.fSupplierNum;
                    }
                }
                this.fSupplierNum = 0;
                this.fInfo = this.fInfo.getNext();
            }
        }

        protected IVariableContextInfo getInfo() {
            this.init();
            return this.fInfo;
        }

        public ICdtVariable getMacro() {
            this.init();
            return this.fMacro;
        }
    }

    protected class ResolvedMacro
    extends CdtVariable {
        private boolean fIsDefined;
        private boolean fIsList;

        public ResolvedMacro(String name) {
            super(name, 1, (String)null);
            this.fIsDefined = false;
        }

        public ResolvedMacro(String name, String value, boolean isDefined) {
            super(name, 1, value);
            this.fIsDefined = isDefined;
            this.fIsList = false;
        }

        public ResolvedMacro(String name, String value) {
            super(name, 1, value);
            this.fIsDefined = true;
            this.fIsList = false;
        }

        public ResolvedMacro(String name, String[] value) {
            super(name, 2, value);
            this.fIsDefined = true;
            this.fIsList = true;
        }

        public String getStringValue() throws CdtVariableException {
            if (this.fIsList && this.fStringValue == null) {
                this.fStringValue = this.stringListToString(this.fStringListValue);
            }
            return this.fStringValue;
        }

        public String[] getStringListValue() throws CdtVariableException {
            if (!this.fIsList && this.fStringListValue == null) {
                this.fStringListValue = this.fStringValue != null && this.fStringValue.length() != 0 ? new String[]{this.fStringValue} : new String[0];
            }
            return this.fStringListValue;
        }

        protected String getDelimiter() {
            Object delimiter;
            if (SupplierBasedCdtVariableSubstitutor.this.fDelimiterMap != null && (delimiter = SupplierBasedCdtVariableSubstitutor.this.fDelimiterMap.get(this.fName)) instanceof String) {
                return (String)delimiter;
            }
            return SupplierBasedCdtVariableSubstitutor.this.fListDelimiter;
        }

        protected String stringListToString(String[] values) throws CdtVariableException {
            String result = null;
            if (values != null) {
                if (values.length == 0) {
                    result = SupplierBasedCdtVariableSubstitutor.EMPTY_STRING;
                } else if (values.length == 1) {
                    result = values[0];
                } else {
                    String delimiter = this.getDelimiter();
                    if (delimiter != null) {
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < values.length) {
                            buffer.append(values[i]);
                            if (i < values.length - 1) {
                                buffer.append(delimiter);
                            }
                            ++i;
                        }
                        result = buffer.toString();
                    } else {
                        SupplierBasedCdtVariableStatus eStatus = new SupplierBasedCdtVariableStatus(4, null, null, this.fName, SupplierBasedCdtVariableSubstitutor.this.fContextInfo);
                        throw new CdtVariableException(eStatus);
                    }
                }
            }
            return result;
        }

        public boolean isList() {
            return this.fIsList;
        }

        public boolean isDefined() {
            return this.fIsDefined;
        }
    }
}

