/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CRegisterManager {
    private static final String ELEMENT_REGISTER_GROUP_LIST = "registerGroups";
    private static final String ELEMENT_REGISTER_GROUP = "group";
    private static final String ATTR_REGISTER_GROUP_MEMENTO = "memento";
    private CDebugTarget fDebugTarget;
    protected List fRegisterGroups;
    private IRegisterDescriptor[] fRegisterDescriptors;
    private boolean fUseDefaultRegisterGroups = true;
    private CStackFrame fCurrentFrame;

    public CRegisterManager(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public Object getAdapter(Class adapter) {
        if (CRegisterManager.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = CRegisterManager.this.fRegisterGroups;
                synchronized (list) {
                    Iterator it = CRegisterManager.this.fRegisterGroups.iterator();
                    while (it.hasNext()) {
                        ((CRegisterGroup)it.next()).dispose();
                    }
                    CRegisterManager.this.fRegisterGroups.clear();
                }
            }
        });
    }

    public IRegisterDescriptor[] getAllRegisterDescriptors() throws DebugException {
        return this.fRegisterDescriptors;
    }

    public IRegisterGroup[] getRegisterGroups(CStackFrame frame) throws DebugException {
        IRegisterGroup[] groups = this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
        if (this.getCurrentFrame() != frame) {
            int i = 0;
            while (i < groups.length) {
                ((CRegisterGroup)groups[i]).resetRegisterValues();
                ++i;
            }
            this.setCurrentFrame(frame);
        }
        return groups;
    }

    public void initialize() {
        ICDIRegisterGroup[] groups = new ICDIRegisterGroup[]{};
        try {
            groups = this.getDebugTarget().getCDITarget().getRegisterGroups();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        ArrayList<CRegisterDescriptor> list = new ArrayList<CRegisterDescriptor>();
        int i = 0;
        while (i < groups.length) {
            try {
                ICDIRegisterDescriptor[] cdiDescriptors = groups[i].getRegisterDescriptors();
                int j = 0;
                while (j < cdiDescriptors.length) {
                    list.add(new CRegisterDescriptor(groups[i], cdiDescriptors[j]));
                    ++j;
                }
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
            ++i;
        }
        this.fRegisterDescriptors = list.toArray(new IRegisterDescriptor[list.size()]);
        this.createRegisterGroups();
    }

    public void addRegisterGroup(final String name, final IRegisterDescriptor[] descriptors) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                CRegisterManager.this.fRegisterGroups.add(new CRegisterGroup(CRegisterManager.this.getDebugTarget(), name, descriptors));
                CRegisterManager.this.setUseDefaultRegisterGroups(false);
                CRegisterManager.this.getDebugTarget().fireChangeEvent(512);
            }
        });
    }

    public void removeAllRegisterGroups() {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = CRegisterManager.this.fRegisterGroups;
                synchronized (list) {
                    Iterator it = CRegisterManager.this.fRegisterGroups.iterator();
                    while (it.hasNext()) {
                        ((CRegisterGroup)it.next()).dispose();
                    }
                    CRegisterManager.this.fRegisterGroups.clear();
                }
                CRegisterManager.this.setUseDefaultRegisterGroups(false);
                CRegisterManager.this.getDebugTarget().fireChangeEvent(512);
            }
        });
    }

    public void removeRegisterGroups(final IRegisterGroup[] groups) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < groups.length) {
                    ((CRegisterGroup)groups[i]).dispose();
                    ++i;
                }
                CRegisterManager.this.fRegisterGroups.removeAll((Collection)Arrays.asList(groups));
                CRegisterManager.this.setUseDefaultRegisterGroups(false);
                CRegisterManager.this.getDebugTarget().fireChangeEvent(512);
            }
        });
    }

    public void restoreDefaults() {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = CRegisterManager.this.fRegisterGroups;
                synchronized (list) {
                    Iterator it = CRegisterManager.this.fRegisterGroups.iterator();
                    while (it.hasNext()) {
                        ((CRegisterGroup)it.next()).dispose();
                    }
                    CRegisterManager.this.fRegisterGroups.clear();
                    CRegisterManager.this.initializeDefaults();
                }
                CRegisterManager.this.getDebugTarget().fireChangeEvent(512);
            }
        });
    }

    private void createRegisterGroups() {
        this.fRegisterGroups = Collections.synchronizedList(new ArrayList(20));
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_REGISTER_GROUPS", "");
            if (memento != null && memento.length() > 0) {
                this.initializeFromMemento(memento);
                return;
            }
        }
        catch (CoreException coreException) {}
        this.initializeDefaults();
    }

    public void targetSuspended() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)it.next()).targetSuspended();
        }
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void initializeFromMemento(String memento) throws CoreException {
        Element element;
        Element node = DebugPlugin.parseDocument((String)memento);
        if (node.getNodeType() != 1) {
            this.abort(InternalDebugCoreMessages.getString("CRegisterManager.0"), null);
        }
        if (!ELEMENT_REGISTER_GROUP_LIST.equals((element = node).getNodeName())) {
            this.abort(InternalDebugCoreMessages.getString("CRegisterManager.1"), null);
        }
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            Element child;
            if (childNode.getNodeType() == 1 && ELEMENT_REGISTER_GROUP.equals((child = (Element)childNode).getNodeName())) {
                String groupMemento = child.getAttribute(ATTR_REGISTER_GROUP_MEMENTO);
                CRegisterGroup group = new CRegisterGroup(this.getDebugTarget());
                try {
                    group.initializeFromMemento(groupMemento);
                    this.doAddRegisterGroup(group);
                }
                catch (CoreException coreException) {}
            }
            childNode = childNode.getNextSibling();
        }
        this.setUseDefaultRegisterGroups(false);
    }

    protected void initializeDefaults() {
        this.setUseDefaultRegisterGroups(true);
        String current = null;
        int startIndex = 0;
        int i = 0;
        while (i < this.fRegisterDescriptors.length) {
            CRegisterDescriptor d = (CRegisterDescriptor)this.fRegisterDescriptors[i];
            if (current != null && d.getGroupName().compareTo(current) != 0) {
                IRegisterDescriptor[] descriptors = new IRegisterDescriptor[i - startIndex];
                System.arraycopy(this.fRegisterDescriptors, startIndex, descriptors, 0, descriptors.length);
                this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), current, descriptors));
                startIndex = i;
            }
            current = d.getGroupName();
            ++i;
        }
        if (startIndex < this.fRegisterDescriptors.length) {
            IRegisterDescriptor[] descriptors = new IRegisterDescriptor[this.fRegisterDescriptors.length - startIndex];
            System.arraycopy(this.fRegisterDescriptors, startIndex, descriptors, 0, descriptors.length);
            this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), current, descriptors));
        }
    }

    protected synchronized void doAddRegisterGroup(IRegisterGroup group) {
        this.fRegisterGroups.add(group);
    }

    public void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_REGISTER_GROUPS", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private String getMemento() throws CoreException {
        if (this.useDefaultRegisterGroups() || this.fRegisterGroups == null) {
            return "";
        }
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(ELEMENT_REGISTER_GROUP_LIST);
        for (CRegisterGroup group : this.fRegisterGroups) {
            Element child = document.createElement(ELEMENT_REGISTER_GROUP);
            child.setAttribute(ATTR_REGISTER_GROUP_MEMENTO, group.getMemento());
            element.appendChild(child);
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    private void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, exception);
        throw new CoreException((IStatus)status);
    }

    public IRegisterDescriptor findDescriptor(String groupName, String name) {
        int i = 0;
        while (i < this.fRegisterDescriptors.length) {
            IRegisterDescriptor d = this.fRegisterDescriptors[i];
            if (groupName.equals(d.getGroupName()) && name.equals(d.getName())) {
                return d;
            }
            ++i;
        }
        return null;
    }

    public void modifyRegisterGroup(final IPersistableRegisterGroup group, final IRegisterDescriptor[] descriptors) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                group.setRegisterDescriptors(descriptors);
                ((CRegisterGroup)group).fireChangeEvent(512);
            }
        });
    }

    protected boolean useDefaultRegisterGroups() {
        return this.fUseDefaultRegisterGroups;
    }

    protected void setUseDefaultRegisterGroups(boolean useDefaultRegisterGroups) {
        this.fUseDefaultRegisterGroups = useDefaultRegisterGroups;
    }

    public CStackFrame getCurrentFrame() {
        return this.fCurrentFrame;
    }

    private void setCurrentFrame(CStackFrame currentFrame) {
        this.fCurrentFrame = currentFrame;
    }
}

