/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action.cpp;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionTryBlockDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypenameExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.IParserActionTokenProvider;
import org.eclipse.cdt.core.dom.lrparser.LPGTokenAdapter;
import org.eclipse.cdt.core.dom.lrparser.action.BuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPASTAmbiguousDeclarator;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.ICPPASTNodeFactory;
import org.eclipse.cdt.core.parser.util.CollectionUtils;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPExpressionParser;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPNoCastExpressionParser;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPNoFunctionDeclaratorParser;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPParsersym;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPSizeofExpressionParser;
import org.eclipse.cdt.internal.core.dom.lrparser.cpp.CPPTemplateTypeParameterParser;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPBuildASTParserAction
extends BuildASTParserAction {
    private final ITokenMap tokenMap;
    protected final ICPPASTNodeFactory nodeFactory;

    public CPPBuildASTParserAction(ICPPASTNodeFactory nodeFactory, IParserActionTokenProvider parser, IASTTranslationUnit tu) {
        super(nodeFactory, parser, tu);
        this.nodeFactory = nodeFactory;
        this.tokenMap = new TokenMap(CPPParsersym.orderedTerminalSymbols, parser.getOrderedTerminalSymbols());
    }

    private int baseKind(IToken token) {
        return this.tokenMap.mapKind(token.getKind());
    }

    @Override
    protected boolean isCompletionToken(IToken token) {
        return this.baseKind(token) == 2;
    }

    @Override
    protected boolean isIdentifierToken(IToken token) {
        return this.baseKind(token) == 1;
    }

    @Override
    protected IParser getExpressionParser() {
        return new CPPExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    @Override
    protected IParser getNoCastExpressionParser() {
        return new CPPNoCastExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    @Override
    protected IParser getSizeofExpressionParser() {
        return new CPPSizeofExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    protected IParser getTemplateTypeParameterParser() {
        return new CPPTemplateTypeParameterParser(this.parser.getOrderedTerminalSymbols());
    }

    protected IParser getNoFunctionDeclaratorParser() {
        return new CPPNoFunctionDeclaratorParser(this.parser.getOrderedTerminalSymbols());
    }

    public void consumeExpressionNew(boolean isNewTypeId) {
        IASTExpression initializer = (IASTExpression)this.astStack.pop();
        List arrayExpressions = this.astStack.closeScope();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTExpression placement = (IASTExpression)this.astStack.pop();
        boolean hasDoubleColon = this.astStack.pop() != null;
        ICPPASTNewExpression newExpression = this.nodeFactory.newCPPNewExpression(placement, initializer, typeId);
        newExpression.setIsGlobal(hasDoubleColon);
        newExpression.setIsNewTypeId(isNewTypeId);
        for (Object expr : arrayExpressions) {
            newExpression.addNewTypeIdArrayExpression((IASTExpression)expr);
        }
        this.setOffsetAndLength((IASTNode)newExpression);
        this.astStack.push(newExpression);
    }

    public void consumeNewDeclarator() {
        IASTName name = this.nodeFactory.newName();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        for (Object pointer : this.astStack.closeScope()) {
            declarator.addPointerOperator((IASTPointerOperator)pointer);
        }
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeExpressionThrow(boolean hasExpr) {
        IASTExpression operand = hasExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(12, operand);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionDelete(boolean isVectorized) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        boolean hasDoubleColon = this.astStack.pop() != null;
        ICPPASTDeleteExpression deleteExpr = this.nodeFactory.newDeleteExpression(operand);
        deleteExpr.setIsGlobal(hasDoubleColon);
        deleteExpr.setIsVectored(isVectorized);
        this.setOffsetAndLength((IASTNode)deleteExpr);
        this.astStack.push(deleteExpr);
    }

    public void consumeExpressionFieldReference(boolean isPointerDereference, boolean hasTemplateKeyword) {
        IASTName name = (IASTName)this.astStack.pop();
        IASTExpression owner = (IASTExpression)this.astStack.pop();
        IASTFieldReference expr = this.nodeFactory.newFieldReference(name, owner, isPointerDereference, hasTemplateKeyword);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionSimpleTypeConstructor() {
        IASTExpression expression = (IASTExpression)this.astStack.pop();
        IToken token = (IToken)this.astStack.pop();
        int type = this.asICPPASTSimpleTypeConstructorExpressionType(token);
        ICPPASTSimpleTypeConstructorExpression typeConstructor = this.nodeFactory.newCPPSimpleTypeConstructorExpression(type, expression);
        this.setOffsetAndLength((IASTNode)typeConstructor);
        this.astStack.push(typeConstructor);
    }

    private int asICPPASTSimpleTypeConstructorExpressionType(IToken token) {
        assert (token != null);
        switch (this.baseKind(token)) {
            case 14: {
                return 2;
            }
            case 23: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 19: {
                return 8;
            }
            case 17: {
                return 3;
            }
            case 18: {
                return 9;
            }
            case 20: {
                return 10;
            }
            case 21: {
                return 11;
            }
            case 16: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 22: {
                return 1;
            }
        }
        assert (false) : "type parsed wrong";
        return 0;
    }

    public void consumeExpressionTypeName() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTName name = (IASTName)this.astStack.pop();
        boolean isTemplate = this.astStack.pop() == PLACE_HOLDER;
        LinkedList nestedNames = (LinkedList)this.astStack.pop();
        IToken dColon = (IToken)this.astStack.pop();
        nestedNames.addFirst(name);
        int startOffset = dColon == null ? CPPBuildASTParserAction.offset((IASTNode)nestedNames.getLast()) : CPPBuildASTParserAction.offset(dColon);
        int endOffset = CPPBuildASTParserAction.endOffset((IASTNode)name);
        IASTName qualifiedName = this.createQualifiedName(nestedNames, startOffset, endOffset, dColon != null);
        ICPPASTTypenameExpression typenameExpr = this.nodeFactory.newCPPTypenameExpression(qualifiedName, expr, isTemplate);
        this.setOffsetAndLength((IASTNode)typenameExpr);
        this.astStack.push(typenameExpr);
    }

    public void consumeConditionDeclaration() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.pop();
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        IASTInitializerExpression initializer = this.nodeFactory.newInitializerExpression(expr);
        CPPBuildASTParserAction.setOffsetAndLength((IASTNode)initializer, CPPBuildASTParserAction.offset((IASTNode)expr), CPPBuildASTParserAction.length((IASTNode)expr));
        declarator.setInitializer((IASTInitializer)initializer);
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration(declSpec);
        declaration.addDeclarator(declarator);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeTemplateId() {
        List templateArguments = this.astStack.closeScope();
        IASTName name = (IASTName)this.astStack.pop();
        ICPPASTTemplateId templateId = this.nodeFactory.newCPPTemplateId(name);
        for (Object arg : templateArguments) {
            if (arg instanceof IASTExpression) {
                templateId.addTemplateArgument((IASTExpression)arg);
                continue;
            }
            if (arg instanceof IASTTypeId) {
                templateId.addTemplateArgument((IASTTypeId)arg);
                continue;
            }
            if (!(arg instanceof ICPPASTAmbiguousTemplateArgument)) continue;
            templateId.addTemplateArgument((ICPPASTAmbiguousTemplateArgument)arg);
        }
        this.setOffsetAndLength((IASTNode)templateId);
        this.astStack.push(templateId);
    }

    public void consumeTemplateArgumentTypeId() {
        IParser secondaryParser = this.getExpressionParser();
        IASTNode result = this.runSecondaryParser(secondaryParser);
        if (!(result instanceof IASTIdExpression)) {
            return;
        }
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTIdExpression idExpression = (IASTIdExpression)result;
        ICPPASTAmbiguousTemplateArgument ambiguityNode = this.nodeFactory.newAmbiguousTemplateArgument(typeId, idExpression);
        this.astStack.push(ambiguityNode);
    }

    public void consumeOperatorName() {
        List<IToken> tokens = this.parser.getRuleTokens();
        tokens = tokens.subList(1, tokens.size());
        OverloadableOperator operator = this.getOverloadableOperator(tokens);
        ICPPASTOperatorName name = this.nodeFactory.newCPPOperatorName(operator);
        this.setOffsetAndLength((IASTNode)name);
        this.astStack.push(name);
    }

    private OverloadableOperator getOverloadableOperator(List<IToken> tokens) {
        if (tokens.size() == 1) {
            LPGTokenAdapter coreToken = (LPGTokenAdapter)tokens.get(0);
            return OverloadableOperator.valueOf((org.eclipse.cdt.core.parser.IToken)coreToken.getWrappedToken());
        }
        if (CPPBuildASTParserAction.matchTokens(tokens, this.tokenMap, 65, 58, 118)) {
            return OverloadableOperator.NEW_ARRAY;
        }
        if (CPPBuildASTParserAction.matchTokens(tokens, this.tokenMap, 63, 58, 118)) {
            return OverloadableOperator.DELETE_ARRAY;
        }
        if (CPPBuildASTParserAction.matchTokens(tokens, this.tokenMap, 58, 118)) {
            return OverloadableOperator.BRACKET;
        }
        if (CPPBuildASTParserAction.matchTokens(tokens, this.tokenMap, 3, 73)) {
            return OverloadableOperator.PAREN;
        }
        return null;
    }

    public void consumeConversionName() {
        String rep = this.createStringRepresentation(this.parser.getRuleTokens());
        char[] chars = rep.toCharArray();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        ICPPASTConversionName name = this.nodeFactory.newCPPConversionName(chars, typeId);
        this.setOffsetAndLength((IASTNode)name);
        this.astStack.push(name);
    }

    public void consumeDestructorName() {
        char[] chars = ("~" + this.parser.getRightIToken()).toCharArray();
        IASTName name = this.nodeFactory.newName(chars);
        this.setOffsetAndLength((IASTNode)name);
        this.astStack.push(name);
    }

    public void consumeDestructorNameTemplateId() {
        ICPPASTTemplateId templateId = (ICPPASTTemplateId)this.astStack.peek();
        IASTName oldName = templateId.getTemplateName();
        char[] newChars = ("~" + oldName).toCharArray();
        IASTName newName = this.nodeFactory.newName(newChars);
        int offset = CPPBuildASTParserAction.offset(this.parser.getLeftIToken());
        int length = offset - CPPBuildASTParserAction.endOffset((IASTNode)oldName);
        CPPBuildASTParserAction.setOffsetAndLength((IASTNode)newName, offset, length);
        templateId.setTemplateName(newName);
    }

    public void consumeGlobalQualifiedId() {
        IASTName name = (IASTName)this.astStack.pop();
        ICPPASTQualifiedName qualifiedName = this.nodeFactory.newCPPQualifiedName();
        qualifiedName.addName(name);
        qualifiedName.setFullyQualified(true);
        ((CPPASTQualifiedName)qualifiedName).setSignature("::" + name.toString());
        this.setOffsetAndLength((IASTNode)qualifiedName);
        this.astStack.push(qualifiedName);
    }

    public void consumeStatementSwitch() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        Object condition = this.astStack.pop();
        IASTSwitchStatement stat = condition instanceof IASTExpression ? this.nodeFactory.newSwitchStatment((IASTExpression)condition, body) : this.nodeFactory.newSwitchStatment((IASTDeclaration)condition, body);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementIf(boolean hasElse) {
        IASTStatement elseClause = hasElse ? (IASTStatement)this.astStack.pop() : null;
        IASTStatement thenClause = (IASTStatement)this.astStack.pop();
        Object condition = this.astStack.pop();
        IASTIfStatement ifStatement = condition instanceof IASTExpression ? this.nodeFactory.newIfStatement((IASTExpression)condition, thenClause, elseClause) : this.nodeFactory.newIfStatement((IASTDeclaration)condition, thenClause, elseClause);
        this.setOffsetAndLength((IASTNode)ifStatement);
        this.astStack.push(ifStatement);
    }

    public void consumeStatementWhileLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        Object condition = this.astStack.pop();
        IASTWhileStatement whileStatement = condition instanceof IASTExpression ? this.nodeFactory.newWhileStatement((IASTExpression)condition, body) : this.nodeFactory.newWhileStatement((IASTDeclaration)condition, body);
        this.setOffsetAndLength((IASTNode)whileStatement);
        this.astStack.push(whileStatement);
    }

    public void consumeStatementForLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        Object condition = this.astStack.pop();
        IASTStatement initializer = (IASTStatement)this.astStack.pop();
        int TK_EOC = 8;
        List<IToken> tokens = this.parser.getRuleTokens();
        if (CPPBuildASTParserAction.matchTokens(tokens, this.tokenMap, 83, 3, 2, TK_EOC, TK_EOC, TK_EOC, TK_EOC)) {
            IASTName name = this.createName(tokens.get(2));
            IASTIdExpression idExpression = this.nodeFactory.newIdExpression(name);
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)idExpression, CPPBuildASTParserAction.offset((IASTNode)name), CPPBuildASTParserAction.length((IASTNode)name));
            initializer = this.nodeFactory.newExpressionStatement((IASTExpression)idExpression);
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)initializer, CPPBuildASTParserAction.offset((IASTNode)name), CPPBuildASTParserAction.length((IASTNode)name));
        }
        IASTForStatement forStat = condition instanceof IASTExpression ? this.nodeFactory.newForStatement(initializer, (IASTExpression)condition, expr, body) : this.nodeFactory.newForStatement(initializer, (IASTDeclaration)condition, expr, body);
        this.setOffsetAndLength((IASTNode)forStat);
        this.astStack.push(forStat);
    }

    public void consumeStatementTryBlock() {
        List handlerSeq = this.astStack.closeScope();
        IASTStatement body = (IASTStatement)this.astStack.pop();
        ICPPASTTryBlockStatement tryStatement = this.nodeFactory.newTryBlockStatement(body);
        for (Object handler : handlerSeq) {
            tryStatement.addCatchHandler((ICPPASTCatchHandler)handler);
        }
        this.setOffsetAndLength((IASTNode)tryStatement);
        this.astStack.push(tryStatement);
    }

    public void consumeStatementCatchHandler(boolean hasEllipsis) {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTDeclaration decl = hasEllipsis ? null : (IASTDeclaration)this.astStack.pop();
        ICPPASTCatchHandler catchHandler = this.nodeFactory.newCatchHandler(decl, body);
        catchHandler.setIsCatchAll(hasEllipsis);
        this.setOffsetAndLength((IASTNode)catchHandler);
        this.astStack.push(catchHandler);
    }

    public void consumeNestedNameSpecifier(boolean hasNested) {
        LinkedList names = hasNested ? (LinkedList)this.astStack.pop() : new LinkedList();
        IASTName name = (IASTName)this.astStack.pop();
        names.add(name);
        this.astStack.push(names);
    }

    public void consumeNestedNameSpecifierEmpty() {
        this.astStack.push(new LinkedList());
    }

    public void consumeNameWithTemplateKeyword() {
        IASTName name = (IASTName)this.astStack.pop();
        this.astStack.pop();
        this.astStack.push(name);
    }

    public void consumeQualifiedId(boolean hasTemplateKeyword) {
        IASTName qualifiedName = this.subRuleQualifiedName(hasTemplateKeyword);
        this.astStack.push(qualifiedName);
    }

    private IASTName createQualifiedName(LinkedList<IASTName> nestedNames, int startOffset, int endOffset, boolean startsWithColonColon) {
        return this.createQualifiedName(nestedNames, startOffset, endOffset, startsWithColonColon, false);
    }

    private IASTName createQualifiedName(LinkedList<IASTName> names, int startOffset, int endOffset, boolean startsWithColonColon, boolean endsWithColonColon) {
        if (!endsWithColonColon && !startsWithColonColon && names.size() == 1) {
            return names.getFirst();
        }
        ICPPASTQualifiedName qualifiedName = this.nodeFactory.newCPPQualifiedName();
        qualifiedName.setFullyQualified(startsWithColonColon);
        CPPBuildASTParserAction.setOffsetAndLength((IASTNode)qualifiedName, startOffset, endOffset - startOffset);
        for (IASTName name : CollectionUtils.reverseIterable(names)) {
            qualifiedName.addName(name);
        }
        if (qualifiedName instanceof CPPASTQualifiedName) {
            List<IToken> nameTokens = CPPBuildASTParserAction.tokenOffsetSubList(this.parser.getRuleTokens(), startOffset, endOffset);
            String signature = this.createStringRepresentation(nameTokens);
            ((CPPASTQualifiedName)qualifiedName).setSignature(signature);
        }
        if (endsWithColonColon) {
            IASTName dummyName = this.nodeFactory.newName();
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)dummyName, endOffset, 0);
            qualifiedName.addName(dummyName);
        }
        return qualifiedName;
    }

    private String createStringRepresentation(List<IToken> nameTokens) {
        StringBuilder sb = new StringBuilder();
        IToken prev = null;
        for (IToken t : nameTokens) {
            if (this.needSpaceBetween(prev, t)) {
                sb.append(' ');
            }
            sb.append(t.toString());
            prev = t;
        }
        return sb.toString();
    }

    private boolean needSpaceBetween(IToken prev, IToken iter) {
        if (prev == null) {
            return false;
        }
        int prevKind = this.baseKind(prev);
        int iterKind = this.baseKind(iter);
        return prevKind != 4 && prevKind != 1 && prevKind != 28 && prevKind != 5 && iterKind != 62 && prevKind != 58 && iterKind != 118 && iterKind != 4;
    }

    private IASTName subRuleQualifiedName(boolean hasOptionalKeyword) {
        IASTName lastName = (IASTName)this.astStack.pop();
        if (hasOptionalKeyword) {
            this.astStack.pop();
        }
        LinkedList nestedNames = (LinkedList)this.astStack.pop();
        IToken dColon = (IToken)this.astStack.pop();
        if (nestedNames.isEmpty() && dColon == null) {
            return lastName;
        }
        nestedNames.addFirst(lastName);
        int startOffset = dColon == null ? CPPBuildASTParserAction.offset((IASTNode)nestedNames.getLast()) : CPPBuildASTParserAction.offset(dColon);
        int endOffset = CPPBuildASTParserAction.endOffset((IASTNode)lastName);
        return this.createQualifiedName(nestedNames, startOffset, endOffset, dColon != null);
    }

    public void consumePsudoDestructorName(boolean hasExtraTypeName) {
        IASTName destructorTypeName = (IASTName)this.astStack.pop();
        IASTName extraName = hasExtraTypeName ? (IASTName)this.astStack.pop() : null;
        LinkedList nestedNames = (LinkedList)this.astStack.pop();
        IToken dColon = (IToken)this.astStack.pop();
        if (hasExtraTypeName) {
            nestedNames.addFirst(extraName);
        }
        nestedNames.addFirst(destructorTypeName);
        int startOffset = dColon == null ? CPPBuildASTParserAction.offset((IASTNode)nestedNames.getLast()) : CPPBuildASTParserAction.offset(dColon);
        int endOffset = CPPBuildASTParserAction.endOffset((IASTNode)destructorTypeName);
        IASTName qualifiedName = this.createQualifiedName(nestedNames, startOffset, endOffset, dColon != null);
        this.setOffsetAndLength((IASTNode)qualifiedName);
        this.astStack.push(qualifiedName);
    }

    public void consumeDeclarationASM() {
        String s = this.parser.getRuleTokens().get(2).toString();
        IASTASMDeclaration asm = this.nodeFactory.newASMDeclaration(s);
        this.setOffsetAndLength((IASTNode)asm);
        this.astStack.push(asm);
    }

    public void consumeNamespaceAliasDefinition() {
        IASTName qualifiedName = this.subRuleQualifiedName(false);
        IASTName alias = this.createName(this.parser.getRuleTokens().get(1));
        ICPPASTNamespaceAlias namespaceAlias = this.nodeFactory.newNamespaceAlias(alias, qualifiedName);
        this.setOffsetAndLength((IASTNode)namespaceAlias);
        this.astStack.push(namespaceAlias);
    }

    public void consumeUsingDeclaration() {
        IASTName qualifiedName = this.subRuleQualifiedName(false);
        boolean hasTypenameKeyword = this.astStack.pop() == PLACE_HOLDER;
        ICPPASTUsingDeclaration usingDeclaration = this.nodeFactory.newUsingDeclaration(qualifiedName);
        usingDeclaration.setIsTypename(hasTypenameKeyword);
        this.setOffsetAndLength((IASTNode)usingDeclaration);
        this.astStack.push(usingDeclaration);
    }

    public void consumeUsingDirective() {
        IASTName qualifiedName = this.subRuleQualifiedName(false);
        ICPPASTUsingDirective usingDirective = this.nodeFactory.newUsingDirective(qualifiedName);
        this.setOffsetAndLength((IASTNode)usingDirective);
        this.astStack.push(usingDirective);
    }

    public void consumeLinkageSpecification() {
        String name = this.parser.getRuleTokens().get(1).toString();
        ICPPASTLinkageSpecification linkageSpec = this.nodeFactory.newLinkageSpecification(name);
        for (Object declaration : this.astStack.closeScope()) {
            linkageSpec.addDeclaration((IASTDeclaration)declaration);
        }
        this.setOffsetAndLength((IASTNode)linkageSpec);
        this.astStack.push(linkageSpec);
    }

    public void consumeNamespaceDefinition(boolean hasName) {
        List declarations = this.astStack.closeScope();
        IASTName namespaceName = hasName ? (IASTName)this.astStack.pop() : this.nodeFactory.newName();
        ICPPASTNamespaceDefinition definition = this.nodeFactory.newNamespaceDefinition(namespaceName);
        for (Object declaration : declarations) {
            definition.addDeclaration((IASTDeclaration)declaration);
        }
        this.setOffsetAndLength((IASTNode)definition);
        this.astStack.push(definition);
    }

    public void consumeTemplateDeclaration() {
        IASTDeclaration declaration = (IASTDeclaration)this.astStack.pop();
        CPPBuildASTParserAction.resolveAmbiguousDeclaratorsToFunction(declaration);
        ICPPASTTemplateDeclaration templateDeclaration = this.nodeFactory.newTemplateDeclaration(declaration);
        for (Object param : this.astStack.closeScope()) {
            templateDeclaration.addTemplateParamter((ICPPASTTemplateParameter)param);
        }
        boolean hasExportKeyword = this.astStack.pop() == PLACE_HOLDER;
        templateDeclaration.setExported(hasExportKeyword);
        this.setOffsetAndLength((IASTNode)templateDeclaration);
        this.astStack.push(templateDeclaration);
    }

    private static void resolveAmbiguousDeclaratorsToFunction(IASTDeclaration declaration) {
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)declaration).getDeclarators();
            int n = iASTDeclaratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                if (declarator instanceof CPPASTAmbiguousDeclarator) {
                    IASTAmbiguityParent owner = (IASTAmbiguityParent)declaration;
                    CPPASTAmbiguousDeclarator ambiguity = (CPPASTAmbiguousDeclarator)declarator;
                    owner.replace((IASTNode)ambiguity, ambiguity.getNodes()[0]);
                }
                ++n2;
            }
        }
    }

    public void consumeTemplateExplicitInstantiation() {
        IASTDeclaration declaration = (IASTDeclaration)this.astStack.pop();
        ICPPASTExplicitTemplateInstantiation instantiation = this.nodeFactory.newExplicitTemplateInstantiation(declaration);
        this.setOffsetAndLength((IASTNode)instantiation);
        this.astStack.push(instantiation);
    }

    public void consumeTemplateExplicitSpecialization() {
        IASTDeclaration declaration = (IASTDeclaration)this.astStack.pop();
        ICPPASTTemplateSpecialization specialization = this.nodeFactory.newTemplateSpecialization(declaration);
        this.setOffsetAndLength((IASTNode)specialization);
        this.astStack.push(specialization);
    }

    protected void setSpecifier(ICPPASTDeclSpecifier node, IToken token) {
        int kind = this.baseKind(token);
        switch (kind) {
            case 50: {
                node.setStorageClass(1);
                return;
            }
            case 12: {
                node.setStorageClass(2);
                return;
            }
            case 46: {
                node.setStorageClass(3);
                return;
            }
            case 35: {
                node.setStorageClass(4);
                return;
            }
            case 43: {
                node.setStorageClass(5);
                return;
            }
            case 42: {
                node.setStorageClass(6);
                return;
            }
            case 41: {
                node.setInline(true);
                return;
            }
            case 33: {
                node.setConst(true);
                return;
            }
            case 40: {
                node.setFriend(true);
                return;
            }
            case 31: {
                node.setVirtual(true);
                return;
            }
            case 34: {
                node.setVolatile(true);
                return;
            }
            case 38: {
                node.setExplicit(true);
                return;
            }
        }
        if (node instanceof ICPPASTSimpleDeclSpecifier) {
            ICPPASTSimpleDeclSpecifier n = (ICPPASTSimpleDeclSpecifier)node;
            switch (kind) {
                case 22: {
                    n.setType(1);
                    return;
                }
                case 14: {
                    n.setType(2);
                    return;
                }
                case 17: {
                    n.setType(3);
                    return;
                }
                case 16: {
                    n.setType(4);
                    return;
                }
                case 15: {
                    n.setType(5);
                    return;
                }
                case 13: {
                    n.setType(6);
                    return;
                }
                case 23: {
                    n.setType(7);
                    return;
                }
                case 20: {
                    n.setSigned(true);
                    return;
                }
                case 21: {
                    n.setUnsigned(true);
                    return;
                }
                case 18: {
                    n.setLong(true);
                    return;
                }
                case 19: {
                    n.setShort(true);
                    return;
                }
            }
        }
    }

    public void consumeDeclarationSpecifiersSimple() {
        ICPPASTSimpleDeclSpecifier declSpec = this.nodeFactory.newCPPSimpleDeclSpecifier();
        for (Object token : this.astStack.closeScope()) {
            this.setSpecifier((ICPPASTDeclSpecifier)declSpec, (IToken)token);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersComposite() {
        List topScope = this.astStack.closeScope();
        ICPPASTDeclSpecifier declSpec = (ICPPASTDeclSpecifier)CollectionUtils.findFirstAndRemove(topScope, ICPPASTDeclSpecifier.class);
        for (Object token : topScope) {
            this.setSpecifier(declSpec, (IToken)token);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersTypeName() {
        List topScope = this.astStack.closeScope();
        IASTName typeName = (IASTName)CollectionUtils.findFirstAndRemove(topScope, IASTName.class);
        ICPPASTNamedTypeSpecifier declSpec = this.nodeFactory.newCPPNamedTypeSpecifier(typeName, false);
        for (Object token : topScope) {
            this.setSpecifier((ICPPASTDeclSpecifier)declSpec, (IToken)token);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeTypeSpecifierElaborated(boolean hasOptionalTemplateKeyword) {
        IASTName name = this.subRuleQualifiedName(hasOptionalTemplateKeyword);
        int kind = this.getElaboratedTypeSpecifier(this.parser.getLeftIToken());
        IASTElaboratedTypeSpecifier typeSpecifier = this.nodeFactory.newElaboratedTypeSpecifier(kind, name);
        this.setOffsetAndLength((IASTNode)typeSpecifier);
        this.astStack.push(typeSpecifier);
    }

    private int getElaboratedTypeSpecifier(IToken token) {
        int kind = this.baseKind(token);
        switch (kind) {
            default: {
                assert (false) : "wrong token kind: " + kind;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 64: {
                return 0;
            }
            case 60: 
        }
        return 3;
    }

    public void consumeDeclarationSimple(boolean hasDeclaratorList) {
        List declarators = hasDeclaratorList ? this.astStack.closeScope() : Collections.emptyList();
        ICPPASTDeclSpecifier declSpecifier = (ICPPASTDeclSpecifier)this.astStack.pop();
        List<IToken> ruleTokens = this.parser.getRuleTokens();
        IToken nameToken = null;
        if (CPPBuildASTParserAction.matchTokens(ruleTokens, this.tokenMap, 8)) {
            return;
        }
        if (CPPBuildASTParserAction.matchTokens(ruleTokens, this.tokenMap, 2, 8)) {
            IASTName name = this.createName(this.parser.getLeftIToken());
            declSpecifier = this.nodeFactory.newCPPNamedTypeSpecifier(name, false);
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declSpecifier, CPPBuildASTParserAction.offset((IASTNode)name), CPPBuildASTParserAction.length((IASTNode)name));
            declarators = Collections.emptyList();
        } else if (declSpecifier == null) {
            declSpecifier = this.nodeFactory.newCPPSimpleDeclSpecifier();
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declSpecifier, this.parser.getLeftIToken().getStartOffset(), 0);
        } else if (declarators.isEmpty() && declSpecifier instanceof ICPPASTNamedTypeSpecifier && ruleTokens.size() >= 2 && this.baseKind(nameToken = ruleTokens.get(ruleTokens.size() - 2)) == 1) {
            declSpecifier = this.nodeFactory.newCPPSimpleDeclSpecifier();
            for (IToken t : ruleTokens.subList(0, ruleTokens.size() - 1)) {
                this.setSpecifier(declSpecifier, t);
            }
            int offset = CPPBuildASTParserAction.offset(this.parser.getLeftIToken());
            int length = CPPBuildASTParserAction.endOffset(ruleTokens.get(ruleTokens.size() - 2)) - offset;
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declSpecifier, offset, length);
            IASTName name = this.createName(nameToken);
            IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declarator, nameToken);
            declarators.add(declarator);
        }
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration((IASTDeclSpecifier)declSpecifier);
        this.setOffsetAndLength((IASTNode)declaration);
        for (Object declarator : declarators) {
            declaration.addDeclarator((IASTDeclarator)declarator);
        }
        this.astStack.push(declaration);
    }

    public void consumeInitDeclaratorComplete() {
        if (this.completionNode != null) {
            return;
        }
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.peek();
        if (!(declarator instanceof IASTFunctionDeclarator)) {
            return;
        }
        IParser secondaryParser = this.getNoFunctionDeclaratorParser();
        IASTNode alternateDeclarator = this.runSecondaryParser(secondaryParser);
        if (alternateDeclarator == null || alternateDeclarator instanceof IASTProblemDeclaration) {
            return;
        }
        this.astStack.pop();
        CPPASTAmbiguousDeclarator ambiguityNode = new CPPASTAmbiguousDeclarator(declarator, (IASTDeclarator)alternateDeclarator);
        this.setOffsetAndLength((IASTNode)ambiguityNode);
        this.astStack.push(ambiguityNode);
    }

    public void consumeVisibilityLabel() {
        IToken specifier = (IToken)this.astStack.pop();
        int visibility = this.getAccessSpecifier(specifier);
        ICPPASTVisibilityLabel visibilityLabel = this.nodeFactory.newVisibilityLabel(visibility);
        this.setOffsetAndLength((IASTNode)visibilityLabel);
        this.astStack.push(visibilityLabel);
    }

    private int getAccessSpecifier(IToken token) {
        int kind = this.baseKind(token);
        switch (kind) {
            default: {
                assert (false) : "wrong token kind: " + kind;
            }
            case 114: {
                return 3;
            }
            case 116: {
                return 1;
            }
            case 115: 
        }
        return 2;
    }

    public void consumeBaseSpecifier(boolean hasAccessSpecifier, boolean isVirtual) {
        IToken accessSpecifierToken;
        IASTName name = this.subRuleQualifiedName(false);
        int visibility = 0;
        if (hasAccessSpecifier && (accessSpecifierToken = (IToken)this.astStack.pop()) != null) {
            visibility = this.getAccessSpecifier(accessSpecifierToken);
        }
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier = this.nodeFactory.newBaseSpecifier(name, visibility, isVirtual);
        this.setOffsetAndLength((IASTNode)baseSpecifier);
        this.astStack.push(baseSpecifier);
    }

    public void consumeAccessKeywordToken() {
        this.astStack.push(this.parser.getRightIToken());
    }

    public void consumeClassSpecifier() {
        List declarations = this.astStack.closeScope();
        IASTCompositeTypeSpecifier classSpecifier = (IASTCompositeTypeSpecifier)this.astStack.pop();
        for (Object declaration : declarations) {
            classSpecifier.addMemberDeclaration((IASTDeclaration)declaration);
        }
        this.setOffsetAndLength((IASTNode)classSpecifier);
        this.astStack.push(classSpecifier);
    }

    public void consumeClassHead(boolean hasNestedNameSpecifier) {
        int key = this.getCompositeTypeSpecifier(this.parser.getLeftIToken());
        List baseSpecifiers = this.astStack.closeScope();
        IASTName className = (IASTName)this.astStack.pop();
        if (hasNestedNameSpecifier) {
            LinkedList nestedNames = (LinkedList)this.astStack.pop();
            nestedNames.addFirst(className);
            int startOffset = CPPBuildASTParserAction.offset((IASTNode)nestedNames.getLast());
            int endOffset = CPPBuildASTParserAction.endOffset((IASTNode)className);
            className = this.createQualifiedName(nestedNames, startOffset, endOffset, false);
        }
        if (className == null) {
            className = this.nodeFactory.newName();
        }
        ICPPASTCompositeTypeSpecifier classSpecifier = this.nodeFactory.newCPPCompositeTypeSpecifier(key, className);
        for (Object base : baseSpecifiers) {
            classSpecifier.addBaseSpecifier((ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier)base);
        }
        this.astStack.push(classSpecifier);
    }

    private int getCompositeTypeSpecifier(IToken token) {
        int kind = this.baseKind(token);
        switch (kind) {
            default: {
                assert (false) : "wrong token kind: " + kind;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 60: 
        }
        return 3;
    }

    public void consumePointer() {
        IASTPointer pointer = this.nodeFactory.newCPPPointer();
        List<Object> tokens = this.astStack.closeScope();
        this.addCVQualifiersToPointer(pointer, tokens);
        this.setOffsetAndLength((IASTNode)pointer);
        this.astStack.push(pointer);
    }

    private void addCVQualifiersToPointer(IASTPointer pointer, List<Object> tokens) {
        for (Object t : tokens) {
            IToken token = (IToken)t;
            int kind = this.baseKind(token);
            switch (kind) {
                default: {
                    assert (false);
                }
                case 33: {
                    pointer.setConst(true);
                    break;
                }
                case 34: {
                    pointer.setVolatile(true);
                }
            }
        }
    }

    public void consumeReferenceOperator() {
        ICPPASTReferenceOperator referenceOperator = this.nodeFactory.newReferenceOperator();
        this.setOffsetAndLength((IASTNode)referenceOperator);
        this.astStack.push(referenceOperator);
    }

    public void consumePointerToMember() {
        List<Object> qualifiers = this.astStack.closeScope();
        LinkedList nestedNames = (LinkedList)this.astStack.pop();
        IToken dColon = (IToken)this.astStack.pop();
        int startOffset = dColon == null ? CPPBuildASTParserAction.offset((IASTNode)nestedNames.getLast()) : CPPBuildASTParserAction.offset(dColon);
        int endOffset = CPPBuildASTParserAction.endOffset((IASTNode)nestedNames.getFirst());
        for (IToken t : CollectionUtils.reverseIterable(this.parser.getRuleTokens())) {
            if (this.baseKind(t) != 4) continue;
            endOffset = CPPBuildASTParserAction.endOffset(t);
            break;
        }
        IASTName name = this.createQualifiedName(nestedNames, startOffset, endOffset, dColon != null, true);
        ICPPASTPointerToMember pointer = this.nodeFactory.newPointerToMember(name);
        this.addCVQualifiersToPointer((IASTPointer)pointer, qualifiers);
        this.setOffsetAndLength((IASTNode)pointer);
        this.astStack.push(pointer);
    }

    public void consumeInitializerConstructor() {
        IASTExpression expression = (IASTExpression)this.astStack.pop();
        ICPPASTConstructorInitializer initializer = this.nodeFactory.newConstructorInitializer(expression);
        this.setOffsetAndLength((IASTNode)initializer);
        this.astStack.push(initializer);
    }

    public void consumeDirectDeclaratorFunctionDeclarator(boolean hasDeclarator) {
        IASTName name = this.nodeFactory.newName();
        ICPPASTFunctionDeclarator declarator = this.nodeFactory.newCPPFunctionDeclarator(name);
        for (Object typeId : this.astStack.closeScope()) {
            declarator.addExceptionSpecificationTypeId((IASTTypeId)typeId);
        }
        for (Object token : this.astStack.closeScope()) {
            int kind = this.baseKind((IToken)token);
            switch (kind) {
                default: {
                    assert (false) : "wrong token kind: " + kind;
                }
                case 33: {
                    declarator.setConst(true);
                    break;
                }
                case 34: {
                    declarator.setVolatile(true);
                }
            }
        }
        boolean isVarArgs = this.astStack.pop() == PLACE_HOLDER;
        declarator.setVarArgs(isVarArgs);
        for (Object o : this.astStack.closeScope()) {
            declarator.addParameterDeclaration((IASTParameterDeclaration)o);
        }
        if (hasDeclarator) {
            int endOffset = CPPBuildASTParserAction.endOffset(this.parser.getRightIToken());
            this.addFunctionModifier((IASTFunctionDeclarator)declarator, endOffset);
        } else {
            this.setOffsetAndLength((IASTNode)declarator);
            this.astStack.push(declarator);
        }
    }

    public void consumeAbstractDeclaratorEmpty() {
        IASTName name = this.nodeFactory.newName();
        CPPBuildASTParserAction.setOffsetAndLength((IASTNode)name, CPPBuildASTParserAction.offset(this.parser.getLeftIToken()) + 1, 0);
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(name);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeConstructorChainInitializer() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTName name = (IASTName)this.astStack.pop();
        ICPPASTConstructorChainInitializer initializer = this.nodeFactory.newConstructorChainInitializer(name, expr);
        this.setOffsetAndLength((IASTNode)initializer);
        this.astStack.push(initializer);
    }

    public void consumeFunctionDefinition(boolean isTryBlockDeclarator) {
        List handlers = isTryBlockDeclarator ? this.astStack.closeScope() : Collections.emptyList();
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        List initializers = this.astStack.closeScope();
        ICPPASTFunctionDeclarator declarator = (ICPPASTFunctionDeclarator)this.astStack.pop();
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)this.astStack.pop();
        if (declSpec == null) {
            declSpec = this.nodeFactory.newSimpleDeclSpecifier();
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declSpec, this.parser.getLeftIToken().getStartOffset(), 0);
        }
        if (isTryBlockDeclarator) {
            ICPPASTFunctionTryBlockDeclarator tryBlockDeclarator = this.nodeFactory.newFunctionTryBlockDeclarator(declarator.getName());
            tryBlockDeclarator.setConst(declarator.isConst());
            tryBlockDeclarator.setVolatile(declarator.isVolatile());
            tryBlockDeclarator.setPureVirtual(declarator.isPureVirtual());
            tryBlockDeclarator.setVarArgs(declarator.takesVarArgs());
            IASTParameterDeclaration[] iASTParameterDeclarationArray = declarator.getParameters();
            int n = iASTParameterDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration parameter = iASTParameterDeclarationArray[n2];
                tryBlockDeclarator.addParameterDeclaration(parameter);
                ++n2;
            }
            iASTParameterDeclarationArray = declarator.getExceptionSpecification();
            n = iASTParameterDeclarationArray.length;
            n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration exception = iASTParameterDeclarationArray[n2];
                tryBlockDeclarator.addExceptionSpecificationTypeId((IASTTypeId)exception);
                ++n2;
            }
            for (Iterator handler : handlers) {
                tryBlockDeclarator.addCatchHandler((ICPPASTCatchHandler)handler);
            }
            declarator = tryBlockDeclarator;
        }
        if (initializers != null && !initializers.isEmpty()) {
            for (Object initializer : initializers) {
                declarator.addConstructorToChain((ICPPASTConstructorChainInitializer)initializer);
            }
            IASTNode lastInitializer = (IASTNode)initializers.get(initializers.size() - 1);
            int offset = CPPBuildASTParserAction.offset((IASTNode)declarator);
            int length = CPPBuildASTParserAction.endOffset(lastInitializer) - offset;
            CPPBuildASTParserAction.setOffsetAndLength((IASTNode)declarator, offset, length);
        }
        IASTFunctionDefinition definition = this.nodeFactory.newFunctionDefinition(declSpec, (IASTFunctionDeclarator)declarator, (IASTStatement)body);
        this.setOffsetAndLength((IASTNode)definition);
        this.astStack.push(definition);
    }

    public void consumeMemberDeclarationQualifiedId() {
        IASTName qualifiedId = this.subRuleQualifiedName(true);
        IASTDeclarator declarator = this.nodeFactory.newDeclarator(qualifiedId);
        this.setOffsetAndLength((IASTNode)declarator);
        IASTDeclSpecifier emptySpecifier = this.nodeFactory.newSimpleDeclSpecifier();
        CPPBuildASTParserAction.setOffsetAndLength((IASTNode)emptySpecifier, this.parser.getLeftIToken().getStartOffset(), 0);
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration(emptySpecifier);
        this.setOffsetAndLength((IASTNode)declaration);
        declaration.addDeclarator(declarator);
        this.astStack.push(declaration);
    }

    public void consumeMemberDeclaratorWithInitializer() {
        IASTExpression expr;
        IASTInitializerExpression initializer = (IASTInitializerExpression)this.astStack.pop();
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.peek();
        this.setOffsetAndLength((IASTNode)declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator && (expr = initializer.getExpression()) instanceof IASTLiteralExpression && "0".equals(expr.toString())) {
            ((ICPPASTFunctionDeclarator)declarator).setPureVirtual(true);
            return;
        }
        declarator.setInitializer((IASTInitializer)initializer);
    }

    public void consumeSimpleTypeTemplateParameter(boolean hasTypeId) {
        IASTTypeId typeId = hasTypeId ? (IASTTypeId)this.astStack.pop() : null;
        IASTName name = (IASTName)this.astStack.pop();
        if (name == null) {
            name = this.nodeFactory.newName();
        }
        int type = this.getTemplateParameterType(this.parser.getLeftIToken());
        ICPPASTSimpleTypeTemplateParameter templateParameter = this.nodeFactory.newSimpleTypeTemplateParameter(type, name, typeId);
        this.setOffsetAndLength((IASTNode)templateParameter);
        this.astStack.push(templateParameter);
    }

    private int getTemplateParameterType(IToken token) {
        int kind = this.baseKind(token);
        switch (kind) {
            default: {
                assert (false) : "wrong token kind: " + kind;
            }
            case 60: {
                return 1;
            }
            case 10: 
        }
        return 2;
    }

    public void consumeTemplateParamterDeclaration() {
        IParser typeParameterParser = this.getTemplateTypeParameterParser();
        IASTNode alternate = this.runSecondaryParser(typeParameterParser);
        if (alternate == null || alternate instanceof IASTProblemDeclaration) {
            return;
        }
        this.astStack.pop();
        this.astStack.push(alternate);
    }

    public void consumeTemplatedTypeTemplateParameter(boolean hasIdExpr) {
        IASTExpression idExpression = hasIdExpr ? (IASTExpression)this.astStack.pop() : null;
        IASTName name = (IASTName)this.astStack.pop();
        ICPPASTTemplatedTypeTemplateParameter templateParameter = this.nodeFactory.newTemplatedTypeTemplateParameter(name, idExpression);
        for (Object param : this.astStack.closeScope()) {
            templateParameter.addTemplateParamter((ICPPASTTemplateParameter)param);
        }
        this.setOffsetAndLength((IASTNode)templateParameter);
        this.astStack.push(templateParameter);
    }
}

