/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingPathEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.AbstractEntryStorage;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.SettingsSet;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.IReverseOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildSystemSpecificVariableSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.PathInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ProfileInfoProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BuildEntryStorage
extends AbstractEntryStorage {
    private BuildLanguageData fLangData;
    private String fBuildDirName;

    public BuildEntryStorage(int kind, BuildLanguageData lData) {
        super(kind);
        this.fLangData = lData;
    }

    protected SettingsSet createEmptySettings() {
        SettingsSet settings = new SettingsSet(3);
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        boolean override = this.isDiscoveredEntriesOverridable();
        int readOnlyFlag = override ? 0 : 2;
        levels[0].setFlagsToClear(3);
        levels[0].setFlagsToSet(0);
        levels[0].setReadOnly(false);
        levels[0].setOverrideSupported(override);
        levels[1].setFlagsToClear(1);
        levels[1].setFlagsToSet(readOnlyFlag | 0x10);
        levels[1].setReadOnly(true);
        levels[1].setOverrideSupported(false);
        levels[2].setFlagsToClear(0);
        levels[2].setFlagsToSet(readOnlyFlag | 1 | 0x10);
        levels[2].setReadOnly(true);
        levels[2].setOverrideSupported(false);
        return settings;
    }

    private boolean isDiscoveredEntriesOverridable() {
        return this.fLangData.getUndefOptionsForKind(this.getKind()).length != 0;
    }

    private String getBuildDitName() {
        if (this.fBuildDirName == null) {
            this.fBuildDirName = this.fLangData.getConfiguration().getName();
        }
        return this.fBuildDirName;
    }

    protected void obtainEntriesFromLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                if (level == null) {
                    this.restoreDefaults();
                    break;
                }
                SettingsSet.EntryInfo[] infos = level.getInfos();
                UserEntryInfo[] userInfos = new UserEntryInfo[infos.length];
                int i = 0;
                while (i < infos.length) {
                    UserEntryInfo uei = (UserEntryInfo)infos[i].getCustomInfo();
                    if (uei == null) {
                        uei = new UserEntryInfo(infos[i].getEntry(), null, null, null);
                    }
                    userInfos[i] = uei;
                    ++i;
                }
                this.setUserEntries(userInfos, (List)level.getContext());
                this.setUserUndefinedStringSet(level.containsOverrideInfo() ? level.getOverrideSet() : null);
            }
        }
    }

    private void restoreDefaults() {
        IOption option;
        IOption[] options = this.fLangData.getOptionsForKind(this.getKind());
        ITool tool = this.fLangData.getTool();
        int i = 0;
        while (i < options.length) {
            option = options[i];
            if (option.getParent() == tool) {
                tool.removeOption(option);
            }
            ++i;
        }
        options = this.fLangData.getUndefOptionsForKind(this.getKind());
        i = 0;
        while (i < options.length) {
            option = options[i];
            if (option.getParent() == tool) {
                tool.removeOption(option);
            }
            ++i;
        }
    }

    protected void putEntriesToLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                ArrayList emptyEntryInfos = new ArrayList();
                UserEntryInfo[] userEntries = this.getUserEntries(level.getFlags(0), true, emptyEntryInfos);
                int i = 0;
                while (i < userEntries.length) {
                    level.addEntry(userEntries[i].fEntry, (Object)userEntries[i]);
                    ++i;
                }
                level.addOverrideNameSet((Set)this.getUserUndefinedStringSet());
                if (emptyEntryInfos.size() == 0) break;
                level.setContext(emptyEntryInfos);
                break;
            }
            case 1: {
                ICLanguageSettingEntry[] envEntries = this.getEnvEntries(level.getFlags(0));
                level.addEntries(envEntries);
                break;
            }
            case 2: {
                ICLanguageSettingEntry[] discoveredEntries = this.getDiscoveredEntries(level.getFlags(0));
                level.addEntries(discoveredEntries);
            }
        }
    }

    private ICLanguageSettingEntry[] getDiscoveredEntries(int flags) {
        UserEntryInfo[] infos;
        ICLanguageSettingEntry[] entries = ProfileInfoProvider.getInstance().getEntryValues(this.fLangData, this.getKind(), flags);
        if ((entries == null || entries.length == 0) && (infos = this.getUserEntries(flags, false, null)).length != 0) {
            entries = new ICLanguageSettingEntry[infos.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = infos[i].fEntry;
                ++i;
            }
        }
        return entries;
    }

    private SupplierBasedCdtVariableSubstitutor createSubstitutor(IOption option, boolean bsVarsOnly) {
        OptionContextData ocd = new OptionContextData(option, this.fLangData.getTool());
        DefaultMacroContextInfo ci = new DefaultMacroContextInfo(2, ocd);
        return bsVarsOnly ? new BuildSystemSpecificVariableSubstitutor(ci) : new SupplierBasedCdtVariableSubstitutor((IVariableContextInfo)ci, "", " ");
    }

    private UserEntryInfo[] getUserEntries(int flags, boolean usr, List emptyValuesInfos) {
        IOption[] options = this.fLangData.getOptionsForKind(this.getKind());
        if (options.length > 0) {
            ArrayList<UserEntryInfo> entryList = new ArrayList<UserEntryInfo>();
            int i = 0;
            while (i < options.length) {
                int size;
                Option option = (Option)options[i];
                List list = usr ? (List)option.getExactValue() : option.getExactBuiltinsList();
                int n = size = list != null ? list.size() : 0;
                if (size > 0) {
                    SupplierBasedCdtVariableSubstitutor subst = this.createSubstitutor(option, false);
                    SupplierBasedCdtVariableSubstitutor bSVarsSubst = this.createSubstitutor(option, true);
                    int j = 0;
                    while (j < size) {
                        OptionStringValue ve = (OptionStringValue)list.get(j);
                        OptionStringValue[] rVes = this.resolve(ve, (IOption)option, bSVarsSubst);
                        if (rVes.length == 0) {
                            if (emptyValuesInfos != null) {
                                emptyValuesInfos.add(new EmptyEntryInfo(ve, j));
                            }
                        } else {
                            boolean isMultiple = rVes.length > 1;
                            ArrayList sequense = isMultiple ? new ArrayList(rVes.length) : null;
                            int k = 0;
                            while (k < rVes.length) {
                                OptionStringValue rVe = rVes[k];
                                ICLanguageSettingEntry entry = this.createUserEntry(option, rVe, flags, subst);
                                entryList.add(new UserEntryInfo(entry, ve, rVe, sequense));
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return entryList.toArray(new UserEntryInfo[entryList.size()]);
        }
        return new UserEntryInfo[0];
    }

    private static String stripQuotes(String value, boolean nullIfNone) {
        if (value.indexOf(34) == 0 && value.lastIndexOf(34) == value.length() - 1 && value.length() != 1) {
            return value.substring(1, value.length() - 1);
        }
        return nullIfNone ? null : value;
    }

    private static OptionStringValue substituteValue(OptionStringValue ov, String value) {
        return new OptionStringValue(value, ov.isBuiltIn(), ov.getSourceAttachmentPath(), ov.getSourceAttachmentRootPath(), ov.getSourceAttachmentPrefixMapping());
    }

    private HashSet getUserUndefinedStringSet() {
        HashSet set = null;
        IOption[] options = this.fLangData.getUndefOptionsForKind(this.getKind());
        if (options.length > 0) {
            int i = 0;
            while (i < options.length) {
                IOption option = options[i];
                List list = (List)option.getValue();
                if (list.size() != 0) {
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.addAll(list);
                }
                ++i;
            }
        }
        return set;
    }

    private PathInfo fromBuildToProj(PathInfo info) {
        String projPath;
        if (info.isAbsolute()) {
            return info;
        }
        Path path = new Path(info.getUnresolvedPath());
        if (path.segmentCount() != 0 && "..".equals(path.segment(0))) {
            projPath = path.removeFirstSegments(1).toString();
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getBuildDitName()).append('/').append(info.getUnresolvedPath());
            projPath = buf.toString();
        }
        return new PathInfo(projPath, info.isWorkspacePath(), info.getSubstitutor());
    }

    private PathInfo fromProjToBuild(PathInfo info) {
        String projPath;
        if (info.isAbsolute()) {
            return info;
        }
        Path path = new Path(info.getUnresolvedPath());
        if (path.segmentCount() != 0 && this.getBuildDitName().equals(path.segment(0))) {
            projPath = path.removeFirstSegments(1).toString();
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append("../").append(info.getUnresolvedPath());
            projPath = buf.toString();
        }
        return new PathInfo(projPath, info.isWorkspacePath(), info.getSubstitutor());
    }

    private String[] resolve(String v, IOption option, SupplierBasedCdtVariableSubstitutor sub) {
        try {
            return CdtVariableResolver.resolveToStringList((String)v, (IVariableSubstitutor)sub);
        }
        catch (CdtVariableException e) {
            ManagedBuilderCorePlugin.log(e);
            return new String[0];
        }
    }

    private OptionStringValue[] resolve(OptionStringValue ov, IOption option, SupplierBasedCdtVariableSubstitutor sub) {
        String value = ov.getValue();
        value = BuildEntryStorage.stripQuotes(value, false);
        String[] rValues = this.resolve(value, option, sub);
        OptionStringValue[] result = new OptionStringValue[rValues.length];
        int i = 0;
        while (i < result.length) {
            result[i] = BuildEntryStorage.substituteValue(ov, BuildEntryStorage.stripQuotes(rValues[i], false));
            ++i;
        }
        return result;
    }

    private ICLanguageSettingEntry[] getEnvEntries(int flags) {
        String[] paths = null;
        int kind = this.getKind();
        switch (kind) {
            case 1: {
                IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
                paths = provider.getBuildPaths(this.fLangData.getConfiguration(), 1);
                break;
            }
            case 16: {
                IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
                paths = provider.getBuildPaths(this.fLangData.getConfiguration(), 2);
            }
        }
        if (paths != null && paths.length != 0) {
            ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[paths.length];
            int i = 0;
            while (i < paths.length) {
                entries[i] = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)paths[i].toString(), null, null, (int)flags);
                ++i;
            }
            return entries;
        }
        return new ICLanguageSettingEntry[0];
    }

    private ICLanguageSettingEntry createUserEntry(Option option, OptionStringValue optionValue, int flags, SupplierBasedCdtVariableSubstitutor subst) {
        int kind = this.getKind();
        CMacroEntry entry = null;
        Path srcPath = null;
        Path srcRootPath = null;
        Path srcPrefixMapping = null;
        switch (kind) {
            case 4: {
                String[] nv = BuildEntryStorage.macroNameValueFromValue(optionValue.getValue());
                entry = new CMacroEntry(nv[0], nv[1], flags);
                break;
            }
            case 32: {
                String tmp = optionValue.getSourceAttachmentPath();
                if (tmp != null) {
                    srcPath = new Path(tmp);
                }
                if ((tmp = optionValue.getSourceAttachmentRootPath()) != null) {
                    srcRootPath = new Path(tmp);
                }
                if ((tmp = optionValue.getSourceAttachmentPrefixMapping()) != null) {
                    srcPrefixMapping = new Path(tmp);
                }
            }
            default: {
                IPath path;
                IOptionPathConverter optionPathConverter = this.fLangData.getTool().getOptionPathConverter();
                PathInfo pInfo = BuildEntryStorage.optionPathValueToEntry(optionValue.getValue(), subst);
                if (pInfo.isWorkspacePath()) {
                    flags |= 8;
                } else if (optionPathConverter != null && (path = optionPathConverter.convertToPlatformLocation(pInfo.getUnresolvedPath(), option, this.fLangData.getTool())) != null) {
                    pInfo = new PathInfo(path.toString(), false, subst);
                }
                pInfo = this.fromBuildToProj(pInfo);
                entry = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)pInfo.getUnresolvedPath(), null, null, (int)flags, (IPath)srcPath, (IPath)srcRootPath, (IPath)srcPrefixMapping);
            }
        }
        return entry;
    }

    private OptionStringValue createOptionValue(IOption option, UserEntryInfo info, SupplierBasedCdtVariableSubstitutor subst) {
        if (info.fOriginalValue != null) {
            return info.fOriginalValue;
        }
        return this.entryValueToOption(option, info.fEntry, subst);
    }

    private OptionStringValue entryValueToOption(IOption option, ICLanguageSettingEntry entry, SupplierBasedCdtVariableSubstitutor subst) {
        String optionValue = this.entryValueToOptionStringValue(option, entry, subst);
        if (entry.getKind() == 32) {
            ICLibraryFileEntry libFile = (ICLibraryFileEntry)entry;
            return new OptionStringValue(optionValue, false, BuildEntryStorage.pathToString(libFile.getSourceAttachmentPath()), BuildEntryStorage.pathToString(libFile.getSourceAttachmentRootPath()), BuildEntryStorage.pathToString(libFile.getSourceAttachmentPrefixMapping()));
        }
        return new OptionStringValue(optionValue);
    }

    private static String pathToString(IPath path) {
        return path != null ? path.toString() : null;
    }

    private String entryValueToOptionStringValue(IOption option, ICLanguageSettingEntry entry, SupplierBasedCdtVariableSubstitutor subst) {
        String result;
        boolean checkQuote = true;
        if (entry.getKind() == 4 && entry.getValue().length() > 0) {
            result = new StringBuffer(entry.getName()).append('=').append(entry.getValue()).toString();
        } else if (entry instanceof ICLanguageSettingPathEntry) {
            IOptionPathConverter converter = this.fLangData.getTool().getOptionPathConverter();
            if (converter instanceof IReverseOptionPathConverter) {
                result = ((IReverseOptionPathConverter)((Object)converter)).convertToOptionValue((ICSettingEntry)entry, option, this.fLangData.getTool());
                checkQuote = false;
            } else {
                ICLanguageSettingPathEntry pathEntry = (ICLanguageSettingPathEntry)entry;
                result = this.doConvertToOptionValue(option, pathEntry, subst);
            }
        } else {
            result = entry.getName();
        }
        if (checkQuote) {
            result = BuildEntryStorage.doubleQuotePath(result, false);
        }
        return result;
    }

    private String doConvertToOptionValue(IOption option, ICLanguageSettingPathEntry pathEntry, SupplierBasedCdtVariableSubstitutor subst) {
        String result;
        boolean isWsp = pathEntry.isValueWorkspacePath();
        PathInfo pInfo = new PathInfo(pathEntry.getName(), isWsp, subst);
        if (isWsp) {
            if (!pInfo.isAbsolute()) {
                IConfiguration cfg = this.fLangData.getConfiguration();
                IResource rc = cfg.getOwner();
                if (rc != null) {
                    IProject proj = rc.getProject();
                    String path = pInfo.getUnresolvedPath();
                    IPath p = proj.getFullPath().append(path);
                    result = p.toString();
                } else {
                    result = pathEntry.getName();
                }
            } else {
                result = pathEntry.getName();
            }
            result = ManagedBuildManager.fullPathToLocation(result);
        } else {
            pInfo = this.fromProjToBuild(pInfo);
            result = pInfo.getUnresolvedPath();
        }
        return result;
    }

    private static String doubleQuotePath(String pathName, boolean nullIfNone) {
        boolean bStartsWithQuote = (pathName = pathName.trim()).indexOf(34) == 0;
        boolean bEndsWithQuote = pathName.lastIndexOf(34) == pathName.length() - 1;
        boolean quoted = false;
        int i = pathName.indexOf(32) + pathName.indexOf(92) + pathName.indexOf("${");
        if (i != -3) {
            if (!bStartsWithQuote) {
                pathName = "\"" + pathName;
                quoted = true;
            }
            if (!bEndsWithQuote) {
                pathName = String.valueOf(pathName) + "\"";
                quoted = true;
            }
        }
        if (quoted) {
            return pathName;
        }
        return nullIfNone ? null : pathName;
    }

    public static String[] macroNameValueFromValue(String value) {
        String[] nv = new String[2];
        int index = value.indexOf(61);
        if (index > 0) {
            nv[0] = value.substring(0, index);
            nv[1] = value.substring(index + 1);
        } else {
            nv[0] = value;
            nv[1] = "";
        }
        return nv;
    }

    private static PathInfo optionPathValueToEntry(String str, SupplierBasedCdtVariableSubstitutor subst) {
        boolean isWorkspacePath;
        String unresolvedStr = ManagedBuildManager.locationToFullPath(str);
        if (unresolvedStr != null) {
            isWorkspacePath = true;
        } else {
            unresolvedStr = str;
            isWorkspacePath = false;
        }
        return new PathInfo(unresolvedStr, isWorkspacePath, subst);
    }

    private void setUserEntries(UserEntryInfo[] entries, List emptyEntryInfos) {
        int kind = this.getKind();
        IOption[] options = this.fLangData.getOptionsForKind(kind);
        if (options.length != 0) {
            OptionStringValue[] optValue;
            IOption option = options[0];
            if (entries.length != 0) {
                entries = this.combineSequenses(entries);
                entries = this.addEmptyEntries(entries, emptyEntryInfos);
                optValue = new OptionStringValue[entries.length];
                SupplierBasedCdtVariableSubstitutor subst = this.createSubstitutor(option, false);
                int i = 0;
                while (i < entries.length) {
                    optValue[i] = this.createOptionValue(option, entries[i], subst);
                    ++i;
                }
            } else {
                optValue = Option.EMPTY_LV_ARRAY;
            }
            ITool tool = this.fLangData.getTool();
            IResourceInfo rcInfo = tool.getParentResourceInfo();
            IOption newOption = ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, optValue);
            options = this.fLangData.getOptionsForKind(kind);
            int i = 0;
            while (i < options.length) {
                if (options[i] != newOption) {
                    ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, new String[0]);
                }
                ++i;
            }
        }
    }

    private UserEntryInfo[] addEmptyEntries(UserEntryInfo[] infos, List emptyEntryInfos) {
        if (emptyEntryInfos == null || emptyEntryInfos.size() == 0) {
            return infos;
        }
        LinkedList<UserEntryInfo> list = new LinkedList<UserEntryInfo>();
        list.addAll((Collection)Arrays.asList(infos));
        int i = 0;
        while (i < emptyEntryInfos.size()) {
            EmptyEntryInfo ei = (EmptyEntryInfo)emptyEntryInfos.get(i);
            int index = ei.fPosition;
            if (index > list.size()) {
                index = list.size();
            }
            list.add(index, new UserEntryInfo(null, ei.fOriginalValue, ei.fOriginalValue, null));
            ++i;
        }
        return list.toArray(new UserEntryInfo[list.size()]);
    }

    private UserEntryInfo[] combineSequenses(UserEntryInfo[] infos) {
        if (infos.length == 0) {
            return infos;
        }
        ArrayList<UserEntryInfo> list = new ArrayList<UserEntryInfo>(infos.length);
        int i = 0;
        while (i < infos.length) {
            UserEntryInfo info = infos[i];
            if (info.fSequense != null) {
                int k;
                boolean match = true;
                int seqSize = info.fSequense.size();
                if (seqSize > infos.length - i) {
                    match = false;
                } else {
                    k = 0;
                    while (k < seqSize) {
                        if (info.fSequense.get(k) != infos[i + k]) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (match) {
                    i = i + seqSize - 1;
                } else {
                    infos[i] = BuildEntryStorage.createDesecuencedEntry(info);
                    k = i + 1;
                    while (k < infos.length) {
                        if (infos[k].fSequense == info.fSequense) {
                            infos[k] = BuildEntryStorage.createDesecuencedEntry(infos[k]);
                        }
                        ++k;
                    }
                    info = infos[i];
                }
            }
            list.add(info);
            ++i;
        }
        return list.toArray(new UserEntryInfo[list.size()]);
    }

    private static UserEntryInfo createDesecuencedEntry(UserEntryInfo info) {
        String v;
        OptionStringValue resolvedValue = info.fBsResolvedValue;
        if (resolvedValue != null && (v = BuildEntryStorage.doubleQuotePath(resolvedValue.getValue(), true)) != null) {
            resolvedValue = BuildEntryStorage.substituteValue(resolvedValue, v);
        }
        return new UserEntryInfo(info.fEntry, resolvedValue, resolvedValue, null);
    }

    private void setUserUndefinedStringSet(Set set) {
        int kind = this.getKind();
        IOption[] options = this.fLangData.getUndefOptionsForKind(kind);
        if (options.length != 0) {
            if (set != null && set.size() == 0) {
                set = null;
            }
            String[] optValue = set != null ? set.toArray(new String[set.size()]) : new String[]{};
            IOption option = options[0];
            ITool tool = this.fLangData.getTool();
            IResourceInfo rcInfo = tool.getParentResourceInfo();
            IOption newOption = ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, optValue);
            options = this.fLangData.getUndefOptionsForKind(kind);
            int i = 0;
            while (i < options.length) {
                if (options[i] != newOption) {
                    ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, option, new String[0]);
                }
                ++i;
            }
        }
    }

    void optionsChanged() {
    }

    private static class EmptyEntryInfo {
        private OptionStringValue fOriginalValue;
        private int fPosition;

        EmptyEntryInfo(OptionStringValue value, int position) {
            this.fOriginalValue = value;
            this.fPosition = position;
        }
    }

    private static class UserEntryInfo {
        private ICLanguageSettingEntry fEntry;
        private OptionStringValue fOriginalValue;
        private OptionStringValue fBsResolvedValue;
        private List fSequense;

        UserEntryInfo(ICLanguageSettingEntry entry, OptionStringValue originalValue, OptionStringValue bsResolvedValue, List sequense) {
            this.fEntry = entry;
            this.fOriginalValue = originalValue;
            this.fBsResolvedValue = bsResolvedValue;
            this.fSequense = sequense;
            if (sequense != null) {
                sequense.add(this);
            }
        }
    }
}

