/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConfigurationModification;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.FileInfoModification;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.FolderInfoModification;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.IObjectSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectSetList;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.ObjectSetListBasedDefinition;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.RulesManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IFileInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.core.runtime.IPath;

public class ToolChainModificationManager
implements IToolChainModificationManager {
    private static ToolChainModificationManager fInstance;

    private ToolChainModificationManager() {
    }

    public static ToolChainModificationManager getInstance() {
        if (fInstance == null) {
            fInstance = ToolChainModificationManager.getInstanceSynch();
        }
        return fInstance;
    }

    private static synchronized ToolChainModificationManager getInstanceSynch() {
        if (fInstance == null) {
            fInstance = new ToolChainModificationManager();
        }
        return fInstance;
    }

    public void start() {
        RulesManager.getInstance().start();
    }

    public IFileInfoModification createModification(IFileInfo rcInfo) {
        return new FileInfoModification((ResourceConfiguration)rcInfo);
    }

    public IFolderInfoModification createModification(IFolderInfo rcInfo) {
        FolderInfo foInfo = (FolderInfo)rcInfo;
        if (foInfo.isRoot()) {
            return new ConfigurationModification(foInfo);
        }
        return new FolderInfoModification(foInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFolderInfoModification createModification(IConfiguration cfg, IFolderInfoModification base) throws IllegalArgumentException {
        FolderInfo folderInfo;
        IResourceInfo baseRcInfo = base.getResourceInfo();
        IPath path = baseRcInfo.getPath();
        IResourceInfo rcInfo = cfg.getResourceInfo(path, true);
        if (rcInfo != null) {
            if (!(rcInfo instanceof FolderInfo)) throw new IllegalArgumentException();
            folderInfo = (FolderInfo)rcInfo;
            return folderInfo.isRoot() ? new ConfigurationModification(folderInfo, (ConfigurationModification)base) : new FolderInfoModification(folderInfo, (FolderInfoModification)base);
        } else {
            folderInfo = (FolderInfo)cfg.createFolderInfo(path);
        }
        return folderInfo.isRoot() ? new ConfigurationModification(folderInfo, (ConfigurationModification)base) : new FolderInfoModification(folderInfo, (FolderInfoModification)base);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFileInfoModification createModification(IConfiguration cfg, IFileInfoModification base) throws IllegalArgumentException {
        ResourceConfiguration fileInfo;
        IResourceInfo baseRcInfo = base.getResourceInfo();
        IPath path = baseRcInfo.getPath();
        IResourceInfo rcInfo = cfg.getResourceInfo(path, true);
        if (rcInfo != null) {
            if (!(rcInfo instanceof ResourceConfiguration)) throw new IllegalArgumentException();
            fileInfo = (ResourceConfiguration)rcInfo;
            return new FileInfoModification(fileInfo, (FileInfoModification)base);
        } else {
            fileInfo = (ResourceConfiguration)cfg.createFileInfo(path);
        }
        return new FileInfoModification(fileInfo, (FileInfoModification)base);
    }

    public static boolean checkFlags(int flags, int value) {
        return (flags & value) == value;
    }

    public static int addFlags(int flags, int value) {
        return flags |= value;
    }

    public static int clearFlags(int flags, int value) {
        return flags &= ~value;
    }

    private boolean getMatchingObjects(int type, IObjectSet[] oSets, Set skipSet, IRealBuildObjectAssociation additionalSkip, Set result) {
        HashSet tmp = null;
        boolean added = false;
        int i = 0;
        while (i < oSets.length) {
            IObjectSet os = oSets[i];
            int setType = os.getObjectType();
            if (setType == type) {
                if (tmp == null) {
                    tmp = new HashSet();
                } else {
                    tmp.clear();
                }
                os.getRealBuildObjects(tmp);
                if (skipSet != null) {
                    tmp.removeAll(skipSet);
                }
                if (additionalSkip != null) {
                    tmp.remove(additionalSkip);
                }
                if (result.addAll(tmp)) {
                    added = true;
                }
            }
            ++i;
        }
        return added;
    }

    public ConflictMatchSet getConflictInfo(int objType, PerTypeMapStorage parent) {
        ConflictMatchSet conflicts = this.getConflictMatches(objType, parent, null);
        return conflicts;
    }

    private ConflictMatchSet getConflictMatches(int type, PerTypeMapStorage rtToPath, PerTypeSetStorage skip) {
        ArrayList<ConflictMatch> conflictList = new ArrayList<ConflictMatch>();
        HashMap objToConflictMatchMap = new HashMap();
        ObjectSetListBasedDefinition[] defs = RulesManager.getInstance().getRules(1);
        int i = 0;
        while (i < defs.length) {
            ObjectSetListBasedDefinition def = defs[i];
            ObjectSetList sl = def.getObjectSetList();
            IObjectSet[] oss = sl.getObjectSets();
            int k = 0;
            while (k < oss.length) {
                IObjectSet os = oss[k];
                int objType = os.getObjectType();
                Map rtToPathMap = rtToPath.getMap(objType, false);
                if (rtToPathMap != null) {
                    rtToPathMap = (Map)((HashMap)rtToPathMap).clone();
                    Set skipSet = skip != null ? skip.getSet(objType, false) : null;
                    Set objSet = rtToPathMap.keySet();
                    if (skipSet != null) {
                        objSet.removeAll(skipSet);
                    }
                    os.retainMatches(objSet);
                    if (objSet.size() != 0) {
                        ArrayList remainingList = new ArrayList(Arrays.asList(oss));
                        remainingList.remove(os);
                        IObjectSet[] remaining = remainingList.toArray(new IObjectSet[remainingList.size()]);
                        skipSet = skip != null ? skip.getSet(type, false) : null;
                        HashSet matchingObjects = new HashSet();
                        this.getMatchingObjects(type, remaining, skipSet, null, matchingObjects);
                        if (matchingObjects.size() != 0) {
                            ConflictMatch conflict = new ConflictMatch(objType, rtToPathMap, type, matchingObjects);
                            Iterator iter = matchingObjects.iterator();
                            while (iter.hasNext()) {
                                TcModificationUtil.getArrayList(objToConflictMatchMap, iter.next()).add(conflict);
                            }
                            conflictList.add(conflict);
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
        return new ConflictMatchSet(conflictList.toArray(new ConflictMatch[conflictList.size()]), objToConflictMatchMap);
    }

    public static class ConflictMatch {
        final int fMatchType;
        final Map fRObjToPathMap;
        final int fConflictType;
        final Set fConflicts;

        ConflictMatch(int matchType, Map robjToPathMap, int conflictType, Set conflicts) {
            this.fMatchType = matchType;
            this.fRObjToPathMap = Collections.unmodifiableMap(robjToPathMap);
            this.fConflictType = conflictType;
            this.fConflicts = Collections.unmodifiableSet(conflicts);
        }
    }

    public static class ConflictMatchSet {
        ConflictMatch[] fConflicts;
        Map fObjToConflictListMap;

        ConflictMatchSet(ConflictMatch[] coflicts, Map objToConflictMap) {
            this.fConflicts = coflicts;
            this.fObjToConflictListMap = objToConflictMap;
        }
    }
}

