/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCalculator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyInfo;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyPreBuild;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuDependencyGroupInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.IManagedBuildGnuToolInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.ManagedBuildGnuToolInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator2 {
    private static final IPath DOT_SLASH_PATH = new Path("./");
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.file");
    protected static final String MESSAGE_START_DEPENDENCY = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.dependency");
    protected static final String MESSAGE_NO_TARGET_TOOL = ManagedMakeMessages.getResourceString("MakefileGenerator.message.no.target");
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_VARS = "MakefileGenerator.comment.module.variables";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String BUILD_TOP = "MakefileGenerator.comment.build.toprules";
    private static final String ALL_TARGET = "MakefileGenerator.comment.build.alltarget";
    private static final String MAINBUILD_TARGET = "MakefileGenerator.comment.build.mainbuildtarget";
    private static final String BUILD_TARGETS = "MakefileGenerator.comment.build.toptargets";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String OBJS_MACRO = "OBJS";
    private static final String MACRO_ADDITION_ADDPREFIX_HEADER = "${addprefix ";
    private static final String MACRO_ADDITION_ADDPREFIX_SUFFIX = ", \\\n";
    private static final String MACRO_ADDITION_PREFIX_SUFFIX = "+= \\\n";
    private static final String PREBUILD = "pre-build";
    private static final String MAINBUILD = "main-build";
    private static final String POSTBUILD = "post-build";
    private static final String SECONDARY_OUTPUTS = "secondary-outputs";
    public static final int PROJECT_RELATIVE = 1;
    public static final int PROJECT_SUBDIR_RELATIVE = 2;
    public static final int ABSOLUTE = 3;
    private String buildTargetName;
    private String buildTargetExt;
    private IConfiguration config;
    private IBuilder builder;
    private PathSettingsContainer toolInfos;
    private Vector deletedFileList;
    private Vector deletedDirList;
    private Vector invalidDirList;
    private Vector modifiedList;
    private IProgressMonitor monitor;
    private IProject project;
    private IResource[] projectResources;
    private Vector ruleList;
    private Vector depLineList;
    private Vector depRuleList;
    private Vector subdirList;
    private IPath topBuildDir;
    private HashMap buildSrcVars = new HashMap();
    private HashMap buildOutVars = new HashMap();
    private HashMap buildDepVars = new HashMap();
    private LinkedHashMap topBuildOutVars = new LinkedHashMap();
    private ICSourceEntry[] srcEntries;
    public static String ECHO_BLANK_LINE = "echo ' '" + NEWLINE;

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        try {
            this.projectResources = project.members();
        }
        catch (CoreException coreException) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.buildTargetName = info.getBuildArtifactName();
        this.buildTargetExt = info.getBuildArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, "", " ", 3, info.getDefaultConfiguration());
        }
        catch (BuildMacroException buildMacroException) {}
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, "", " ", 3, info.getDefaultConfiguration());
            if (resolved != null && (resolved = resolved.trim()).length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        if (this.buildTargetExt == null) {
            this.buildTargetExt = new String();
        }
        this.config = info.getDefaultConfiguration();
        this.builder = this.config.getEditableBuilder();
        this.initToolInfos();
        this.topBuildDir = project.getFolder(info.getConfigurationName()).getFullPath();
    }

    private void callDependencyPostProcessors(IResourceInfo rcInfo, ToolInfoHolder h, IFile depFile, IManagedDependencyGenerator2[] postProcessors, boolean callPopulateDummyTargets, boolean force) throws CoreException {
        try {
            this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
            if (postProcessors != null) {
                IPath absolutePath = depFile.getLocation();
                IPath depPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), absolutePath);
                int i = 0;
                while (i < postProcessors.length) {
                    IManagedDependencyGenerator2 depGen = postProcessors[i];
                    if (depGen != null) {
                        depGen.postProcessDependencyFile(depPath, this.config, h.buildTools[i], this.getTopBuildDir());
                    }
                    ++i;
                }
            }
            if (callPopulateDummyTargets) {
                GnuMakefileGenerator.populateDummyTargets(rcInfo, depFile, force);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException iOException) {}
    }

    private boolean collectDependencyGeneratorInformation(ToolInfoHolder h, Vector depExts, IManagedDependencyGenerator2[] postProcessors) {
        boolean callPopulateDummyTargets = false;
        int i = 0;
        while (i < h.buildTools.length) {
            ITool tool = h.buildTools[i];
            IManagedDependencyGeneratorType depType = tool.getDependencyGeneratorForExtension(tool.getDefaultInputExtension());
            if (depType != null) {
                IManagedDependencyGenerator2 depGen;
                String depExt;
                int calcType = depType.getCalculatorType();
                if (calcType <= 3) {
                    IManagedDependencyGenerator cfr_ignored_0 = (IManagedDependencyGenerator)depType;
                    if (calcType == 1) {
                        callPopulateDummyTargets = true;
                        depExts.add("d");
                    }
                } else if ((calcType == 5 || calcType == 6) && (depExt = (depGen = (IManagedDependencyGenerator2)depType).getDependencyFileExtension(this.config, tool)) != null) {
                    postProcessors[i] = depGen;
                    depExts.add(depExt);
                }
            }
            ++i;
        }
        return callPopulateDummyTargets;
    }

    protected boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    public void generateDependencies() throws CoreException {
        final PathSettingsContainer postProcs = PathSettingsContainer.createRootContainer();
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                IManagedDependencyGenerator2[] postProcessors;
                Vector depExts;
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                boolean callPopulateDummyTargets = GnuMakefileGenerator.this.collectDependencyGeneratorInformation(h, depExts = new Vector(), postProcessors = new IManagedDependencyGenerator2[h.buildTools.length]);
                if (!callPopulateDummyTargets) {
                    int i = 0;
                    while (i < postProcessors.length) {
                        if (postProcessors[i] != null) break;
                        ++i;
                    }
                    if (i == postProcessors.length) {
                        return true;
                    }
                }
                PathSettingsContainer child = postProcs.getChildContainer(container.getPath(), true, true);
                DepInfo di = new DepInfo();
                di.depExts = depExts;
                di.postProcessors = postProcessors;
                di.callPopulateDummyTargets = callPopulateDummyTargets;
                child.setValue((Object)di);
                return true;
            }
        });
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        Iterator subDirs = this.getSubdirList().listIterator();
        while (subDirs.hasNext()) {
            IContainer subDir = (IContainer)subDirs.next();
            IPath projectRelativePath = subDir.getProjectRelativePath();
            IResourceInfo rcInfo = this.config.getResourceInfo(projectRelativePath, false);
            PathSettingsContainer cr = postProcs.getChildContainer(rcInfo.getPath(), false, true);
            if (cr == null || cr.getValue() == null) continue;
            DepInfo di = (DepInfo)cr.getValue();
            ToolInfoHolder h = this.getToolInfo(projectRelativePath);
            IPath buildRelativePath = this.topBuildDir.append(projectRelativePath);
            IFolder buildFolder = root.getFolder(buildRelativePath);
            if (buildFolder == null) continue;
            IResource[] files = buildFolder.members();
            int index = 0;
            while (index < files.length) {
                IResource file = files[index];
                String fileExt = file.getFileExtension();
                for (String ext : di.depExts) {
                    IFile depFile;
                    if (!ext.equals(fileExt) || (depFile = root.getFile(file.getFullPath())) == null) continue;
                    this.callDependencyPostProcessors(rcInfo, h, depFile, di.postProcessors, di.callPopulateDummyTargets, false);
                }
                ++index;
            }
        }
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        MultiStatus status;
        IContainer subDir;
        IFolder folder = this.project.getFolder(this.config.getName());
        if (!folder.exists()) {
            return this.regenerateMakefiles();
        }
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.calc.delta", this.project.getName()));
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.config);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.finding.sources", this.project.getName()));
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.config);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.config.getName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildDepVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subdirectory = (IContainer)iter.next();
            if (this.getModifiedList().contains(subdirectory)) continue;
            if (!subdirectory.exists()) {
                this.appendDeletedSubdirectory(subdirectory);
                continue;
            }
            IPath fragmentPath = this.getBuildWorkingDir().append(subdirectory.getProjectRelativePath()).append("subdir.mk");
            IFile makeFragment = this.project.getFile(fragmentPath);
            if (makeFragment.exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        iter = this.getDeletedFileList().listIterator();
        while (iter.hasNext()) {
            IResource deletedFile = (IResource)iter.next();
            this.deleteDepFile(deletedFile);
            this.deleteBuildTarget(deletedFile);
        }
        iter = this.getModifiedList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            if (!subDir.exists()) {
                this.appendDeletedSubdirectory(subDir);
                continue;
            }
            this.checkCancel();
        }
        iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        iter = this.getDeletedDirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir2 = (IContainer)iter.next();
            this.removeGeneratedDirectory(subDir2);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    public String getMakefileName() {
        return new String("makefile");
    }

    public boolean isGeneratedResource(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String[] configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            String name = configNames[i];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
        final IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        final CoreException[] es = new CoreException[1];
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                IManagedDependencyGenerator2[] postProcessors;
                Vector depExts;
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                boolean callPopulateDummyTargets = GnuMakefileGenerator.this.collectDependencyGeneratorInformation(h, depExts = new Vector(), postProcessors = new IManagedDependencyGenerator2[h.buildTools.length]);
                if (!callPopulateDummyTargets) {
                    int i = 0;
                    while (i < postProcessors.length) {
                        if (postProcessors[i] != null) break;
                        ++i;
                    }
                    if (i == postProcessors.length) {
                        return true;
                    }
                }
                Iterator iter = GnuMakefileGenerator.this.getDependencyMakefiles(h).listIterator();
                IResourceInfo rcInfo = GnuMakefileGenerator.this.config.getResourceInfo(container.getPath(), false);
                while (iter.hasNext()) {
                    IPath relDepFilePath = GnuMakefileGenerator.this.topBuildDir.append((IPath)((Path)iter.next()));
                    IFile depFile = root.getFile(relDepFilePath);
                    if (depFile == null || !depFile.isAccessible()) continue;
                    try {
                        GnuMakefileGenerator.this.callDependencyPostProcessors(rcInfo, h, depFile, postProcessors, callPopulateDummyTargets, true);
                    }
                    catch (CoreException e) {
                        es[0] = e;
                        return false;
                    }
                }
                return true;
            }
        });
        if (es[0] != null) {
            throw es[0];
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.config);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.config.getName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildDepVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        IPath objFilePath = this.topBuildDir.append("objects.mk");
        IFile objsFileHandle = this.createFile(objFilePath);
        this.populateObjectsMakefile(objsFileHandle);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.gen.source.makefile", moduleOutputPath.toString()));
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.append("subdir.mk"));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addFragmentMakefileHeader());
        makeBuf.append(this.addSources(module));
        Util.save((StringBuffer)makeBuf, (IFile)modMakefile);
    }

    protected void populateObjectsMakefile(IFile fileHandle) throws CoreException {
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(GnuMakefileGenerator.addDefaultHeader());
        HashMap outputMacros = new HashMap();
        List valueList = new ArrayList<String>();
        String[] libs = this.config.getLibs(this.buildTargetExt);
        int i = 0;
        while (i < libs.length) {
            String string = libs[i];
            valueList.add(string);
            ++i;
        }
        outputMacros.put("LIBS", valueList);
        valueList = new ArrayList();
        String[] userObjs = this.config.getUserObjects(this.buildTargetExt);
        int i2 = 0;
        while (i2 < userObjs.length) {
            String string = userObjs[i2];
            valueList.add(string);
            ++i2;
        }
        outputMacros.put("USER_OBJS", valueList);
        Iterator iterator = outputMacros.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            macroBuffer.append(String.valueOf((String)entry.getKey()) + " :=");
            valueList = (List)entry.getValue();
            for (String path : valueList) {
                path = path.replace('\\', '/');
                path = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(path);
                macroBuffer.append(" ");
                macroBuffer.append(path);
            }
            macroBuffer.append(NEWLINE);
            if (!iterator.hasNext()) continue;
            macroBuffer.append(NEWLINE);
        }
        Util.save((StringBuffer)macroBuffer, (IFile)fileHandle);
    }

    protected void populateSourcesMakefile(IFile fileHandle) throws CoreException {
        String macroName;
        StringBuffer buffer = GnuMakefileGenerator.addDefaultHeader();
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                ITool[] buildTools = h.buildTools;
                HashSet<String> handledInputExtensions = new HashSet<String>();
                int i = 0;
                while (i < buildTools.length) {
                    if (!buildTools[i].getCustomBuildStep()) {
                        String buildMacro;
                        String[] extensionsList = buildTools[i].getAllInputExtensions();
                        int j = 0;
                        while (j < extensionsList.length) {
                            String extensionName = extensionsList[j];
                            if (!handledInputExtensions.contains(extensionName)) {
                                int calcType;
                                IManagedDependencyGeneratorType depType;
                                handledInputExtensions.add(extensionName);
                                buildMacro = GnuMakefileGenerator.this.getSourceMacroName(extensionName).toString();
                                if (!GnuMakefileGenerator.this.buildSrcVars.containsKey(buildMacro)) {
                                    GnuMakefileGenerator.this.buildSrcVars.put(buildMacro, new ArrayList());
                                }
                                if ((depType = buildTools[i].getDependencyGeneratorForExtension(extensionName)) != null && ((calcType = depType.getCalculatorType()) == 1 || calcType == 5 || calcType == 6)) {
                                    buildMacro = GnuMakefileGenerator.this.getDepMacroName(extensionName).toString();
                                    if (!GnuMakefileGenerator.this.buildDepVars.containsKey(buildMacro)) {
                                        GnuMakefileGenerator.this.buildDepVars.put(buildMacro, new GnuDependencyGroupInfo(buildMacro, calcType != 6));
                                    }
                                    if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                        GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                                    }
                                }
                            }
                            ++j;
                        }
                        IOutputType[] outTypes = buildTools[i].getOutputTypes();
                        if (outTypes != null && outTypes.length > 0) {
                            int j2 = 0;
                            while (j2 < outTypes.length) {
                                buildMacro = outTypes[j2].getBuildVariable();
                                if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                    GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                                }
                                ++j2;
                            }
                        } else {
                            buildMacro = GnuMakefileGenerator.OBJS_MACRO;
                            if (!GnuMakefileGenerator.this.buildOutVars.containsKey(buildMacro)) {
                                GnuMakefileGenerator.this.buildOutVars.put(buildMacro, new ArrayList());
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
        });
        for (Map.Entry entry : this.buildSrcVars.entrySet()) {
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + NEWLINE);
        }
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + NEWLINE);
        }
        buffer.append(String.valueOf(NEWLINE) + this.addSubdirectories());
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addMacros());
        ArrayList outputVarsAdditionsList = new ArrayList();
        StringBuffer targetRules = this.addTargets(outputVarsAdditionsList, rebuild);
        buffer.append(this.writeTopAdditionMacros(outputVarsAdditionsList, this.getTopBuildOutputVars()));
        buffer.append(targetRules);
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected StringBuffer addTopHeader() {
        return GnuMakefileGenerator.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-include ../makefile.init" + NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("RM := ");
        String cleanCommand = this.config.getCleanCommand();
        try {
            cleanCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.config.getCleanCommand(), EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {}
        buffer.append(String.valueOf(cleanCommand) + NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("# " + ManagedMakeMessages.getResourceString(SRC_LISTS) + NEWLINE);
        buffer.append("-include sources.mk" + NEWLINE);
        buffer.append("-include subdir.mk" + NEWLINE);
        for (IContainer subDir : this.getSubdirList()) {
            IPath projectRelativePath = subDir.getProjectRelativePath();
            if (projectRelativePath.toString().equals("")) continue;
            buffer.append("-include " + GnuMakefileGenerator.escapeWhitespaces(projectRelativePath.toString()) + "/" + "subdir.mk" + NEWLINE);
        }
        buffer.append("-include objects.mk" + NEWLINE + NEWLINE);
        if (!this.buildDepVars.isEmpty()) {
            buffer.append("ifneq ($(MAKECMDGOALS),clean)" + NEWLINE);
            for (Map.Entry entry : this.buildDepVars.entrySet()) {
                String depsMacro = (String)entry.getKey();
                GnuDependencyGroupInfo info = (GnuDependencyGroupInfo)entry.getValue();
                buffer.append("ifneq ($(strip $(" + depsMacro + ")),)" + NEWLINE);
                if (info.conditionallyInclude) {
                    buffer.append("-include $(" + depsMacro + ")" + NEWLINE);
                } else {
                    buffer.append("include $(" + depsMacro + ")" + NEWLINE);
                }
                buffer.append("endif" + NEWLINE);
            }
            buffer.append("endif" + NEWLINE + NEWLINE);
        }
        buffer.append("-include ../makefile.defs" + NEWLINE);
        return buffer.append(NEWLINE);
    }

    private StringBuffer addTargets(List outputVarsAdditionsList, boolean rebuild) {
        int i;
        IOutputType[] secondaryOutputs;
        StringBuffer buffer = new StringBuffer();
        String prebuildStep = this.config.getPrebuildStep();
        try {
            prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {}
        prebuildStep = prebuildStep.trim();
        String postbuildStep = this.config.getPostbuildStep();
        try {
            postbuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(postbuildStep, EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {}
        postbuildStep = postbuildStep.trim();
        String preannouncebuildStep = this.config.getPreannouncebuildStep();
        String postannouncebuildStep = this.config.getPostannouncebuildStep();
        String targets = rebuild ? "clean all" : "all";
        ITool targetTool = this.config.calculateTargetTool();
        IConfiguration[] refConfigs = ManagedBuildManager.getReferencedConfigurations(this.config);
        String defaultTarget = "all:";
        if (prebuildStep.length() > 0) {
            buffer.append("# " + ManagedMakeMessages.getResourceString(ALL_TARGET) + NEWLINE);
            buffer.append(String.valueOf(defaultTarget) + " ");
            buffer.append("pre-build ");
            defaultTarget = MAINBUILD;
            buffer.append(defaultTarget);
            defaultTarget = defaultTarget.concat(":");
            buffer.append(String.valueOf(NEWLINE) + NEWLINE);
            buffer.append("# " + ManagedMakeMessages.getResourceString(MAINBUILD_TARGET) + NEWLINE);
        } else {
            buffer.append("# " + ManagedMakeMessages.getResourceString(ALL_TARGET) + NEWLINE);
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(String.valueOf(defaultTarget) + " " + outputPrefix + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append("." + this.buildTargetExt);
        }
        if ((secondaryOutputs = this.config.getToolChain().getSecondaryOutputs()).length > 0) {
            buffer.append(" secondary-outputs");
        }
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        Vector<String> managedProjectOutputs = new Vector<String>(refConfigs.length);
        if (refConfigs.length > 0) {
            boolean addDeps = true;
            i = 0;
            while (i < refConfigs.length) {
                IConfiguration depCfg = refConfigs[i];
                if (depCfg.isManagedBuildOn()) {
                    if (addDeps) {
                        buffer.append("dependents:" + NEWLINE);
                        addDeps = false;
                    }
                    String buildDir = depCfg.getOwner().getLocation().toString();
                    String depTargets = targets;
                    buildDir = String.valueOf(buildDir) + "/" + depCfg.getName();
                    String depTarget = depCfg.getArtifactName();
                    String depExt = depCfg.getArtifactExtension();
                    try {
                        depExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depExt, "", " ", 3, this.config);
                    }
                    catch (BuildMacroException buildMacroException) {}
                    try {
                        String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depTarget, "", " ", 3, this.config);
                        resolved = resolved.trim();
                        if (resolved.length() > 0) {
                            depTarget = resolved;
                        }
                    }
                    catch (BuildMacroException buildMacroException) {}
                    String depPrefix = depCfg.getOutputPrefix(depExt);
                    if (depCfg.needsRebuild()) {
                        depTargets = "clean all";
                    }
                    String dependency = String.valueOf(buildDir) + "/" + depPrefix + depTarget;
                    if (depExt.length() > 0) {
                        dependency = String.valueOf(dependency) + "." + depExt;
                    }
                    dependency = GnuMakefileGenerator.escapeWhitespaces(dependency);
                    managedProjectOutputs.add(dependency);
                    buffer.append("\t-cd " + GnuMakefileGenerator.escapeWhitespaces(buildDir) + " " + "&&" + " " + "$(MAKE) " + depTargets + NEWLINE);
                }
                ++i;
            }
            buffer.append(NEWLINE);
        }
        buffer.append(this.addTargetsRules(targetTool, outputVarsAdditionsList, managedProjectOutputs, postbuildStep.length() > 0));
        if (prebuildStep.length() > 0) {
            buffer.append("pre-build:" + NEWLINE);
            if (preannouncebuildStep.length() > 0) {
                buffer.append("\t-@" + GnuMakefileGenerator.escapedEcho(preannouncebuildStep));
            }
            buffer.append("\t-" + prebuildStep + NEWLINE);
            buffer.append("\t-@" + ECHO_BLANK_LINE + NEWLINE);
        }
        if (postbuildStep.length() > 0) {
            buffer.append("post-build:" + NEWLINE);
            if (postannouncebuildStep.length() > 0) {
                buffer.append("\t-@" + GnuMakefileGenerator.escapedEcho(postannouncebuildStep));
            }
            buffer.append("\t-" + postbuildStep + NEWLINE);
            buffer.append("\t-@" + ECHO_BLANK_LINE + NEWLINE);
        }
        if (secondaryOutputs.length > 0) {
            buffer.append("secondary-outputs:");
            Vector outs2 = this.calculateSecondaryOutputs(secondaryOutputs);
            i = 0;
            while (i < outs2.size()) {
                buffer.append(" $(" + (String)outs2.get(i) + ")");
                ++i;
            }
            buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        }
        buffer.append(".PHONY: all clean dependents" + NEWLINE);
        buffer.append(".SECONDARY:");
        if (prebuildStep.length() > 0) {
            buffer.append(" main-build pre-build");
        }
        if (postbuildStep.length() > 0) {
            buffer.append(" post-build");
        }
        buffer.append(NEWLINE);
        Iterator refIter = managedProjectOutputs.listIterator();
        while (refIter.hasNext()) {
            buffer.append(String.valueOf((String)refIter.next()) + ":" + NEWLINE);
        }
        buffer.append(NEWLINE);
        buffer.append("-include ../makefile.targets" + NEWLINE);
        return buffer;
    }

    private StringBuffer addTargetsRules(ITool targetTool, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean postbuildStep) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(BUILD_TOP) + NEWLINE);
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        boolean[] buildToolsUsed = h.buildToolsUsed;
        if (targetTool != null) {
            if (this.addRuleForTool(targetTool, buffer, true, this.buildTargetName, this.buildTargetExt, outputVarsAdditionsList, managedProjectOutputs, postbuildStep)) {
                i = 0;
                while (i < buildTools.length) {
                    if (targetTool == buildTools[i]) {
                        buildToolsUsed[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_NO_TARGET_TOOL) + " " + "$@"));
        }
        i = 0;
        while (i < buildTools.length) {
            ITool tool = buildTools[i];
            IInputType type = tool.getPrimaryInputType();
            if (type != null && type.getMultipleOfType() && !buildToolsUsed[i]) {
                this.addRuleForTool(tool, buffer, false, null, null, outputVarsAdditionsList, null, false);
                buildToolsUsed[i] = true;
                this.generateRulesForConsumers(tool, outputVarsAdditionsList, buffer);
            }
            ++i;
        }
        buffer.append("# " + ManagedMakeMessages.getResourceString(BUILD_TARGETS) + NEWLINE);
        buffer.append("clean:" + NEWLINE);
        buffer.append("\t-$(RM) ");
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            String macroName = (String)entry.getKey();
            buffer.append("$(" + macroName + ")");
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(" " + outputPrefix + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append("." + this.buildTargetExt);
        }
        buffer.append(NEWLINE);
        buffer.append("\t-@" + ECHO_BLANK_LINE + NEWLINE);
        return buffer;
    }

    protected boolean addRuleForTool(ITool tool, StringBuffer buffer, boolean bTargetTool, String targetName, String targetExt, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean bEmitPostBuildStepCall) {
        Vector inputs = new Vector();
        Vector dependencies = new Vector();
        Vector outputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        Vector outputVariables = new Vector();
        Vector additionalTargets = new Vector();
        String outputPrefix = EMPTY_STRING;
        if (!this.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, additionalTargets, bTargetTool, managedProjectOutputs)) {
            return false;
        }
        if (enumeratedPrimaryOutputs.size() == 0) {
            enumeratedPrimaryOutputs = enumeratedSecondaryOutputs;
            enumeratedSecondaryOutputs.clear();
        }
        outputVarsAdditionsList.addAll(outputVariables);
        String buildRule = EMPTY_STRING;
        String outflag = tool.getOutputFlag();
        String primaryOutputs = EMPTY_STRING;
        boolean first = true;
        int i = 0;
        while (i < enumeratedPrimaryOutputs.size()) {
            String output = (String)enumeratedPrimaryOutputs.get(i);
            if (!first) {
                primaryOutputs = String.valueOf(primaryOutputs) + " ";
            }
            first = false;
            primaryOutputs = String.valueOf(primaryOutputs) + output;
            ++i;
        }
        buildRule = String.valueOf(buildRule) + primaryOutputs + ":" + " ";
        first = true;
        String calculatedDependencies = EMPTY_STRING;
        int i2 = 0;
        while (i2 < dependencies.size()) {
            String input = (String)dependencies.get(i2);
            if (!first) {
                calculatedDependencies = String.valueOf(calculatedDependencies) + " ";
            }
            first = false;
            calculatedDependencies = String.valueOf(calculatedDependencies) + input;
            ++i2;
        }
        buildRule = String.valueOf(buildRule) + calculatedDependencies;
        if (!this.getRuleList().contains(buildRule)) {
            String[] flags;
            this.getRuleList().add(buildRule);
            buffer.append(String.valueOf(buildRule) + NEWLINE);
            if (bTargetTool) {
                buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_BUILD) + " " + "$@"));
            }
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(tool.getAnnouncement()));
            try {
                flags = tool.getToolCommandFlags(null, null);
            }
            catch (BuildException buildException) {
                flags = EMPTY_STRING_ARRAY;
            }
            String command = tool.getToolCommand();
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(command, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    command = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            String[] cmdInputs = inputs.toArray(new String[inputs.size()]);
            IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
            IManagedCommandLineInfo cmdLInfo = gen.generateCommandLineInfo(tool, command, flags, outflag, outputPrefix, primaryOutputs, cmdInputs, tool.getCommandLinePattern());
            String buildCmd = null;
            if (cmdLInfo == null) {
                String toolFlags;
                try {
                    toolFlags = tool.getToolCommandFlagsString(null, null);
                }
                catch (BuildException buildException) {
                    toolFlags = EMPTY_STRING;
                }
                buildCmd = String.valueOf(command) + " " + toolFlags + " " + outflag + " " + outputPrefix + primaryOutputs + " " + "$<";
            } else {
                buildCmd = cmdLInfo.getCommandLine();
            }
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            buffer.append("\t" + buildCmd);
            buffer.append(NEWLINE);
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(bTargetTool ? MESSAGE_FINISH_BUILD : MESSAGE_FINISH_FILE) + " " + "$@"));
            buffer.append("\t@" + ECHO_BLANK_LINE);
            if (bEmitPostBuildStepCall) {
                buffer.append("\t$(MAKE) --no-print-directory post-build" + NEWLINE + NEWLINE);
            } else {
                buffer.append(NEWLINE);
            }
        }
        if (enumeratedSecondaryOutputs.size() > 0 || additionalTargets.size() > 0) {
            String primaryOutput = (String)enumeratedPrimaryOutputs.get(0);
            Vector addlOutputs = new Vector();
            addlOutputs.addAll(enumeratedSecondaryOutputs);
            addlOutputs.addAll(additionalTargets);
            int i3 = 0;
            while (i3 < addlOutputs.size()) {
                String output = (String)addlOutputs.get(i3);
                String depLine = String.valueOf(output) + ":" + " " + primaryOutput + " " + calculatedDependencies + NEWLINE;
                if (!this.getDepLineList().contains(depLine)) {
                    this.getDepLineList().add(depLine);
                    buffer.append(depLine);
                }
                ++i3;
            }
            buffer.append(NEWLINE);
        }
        return true;
    }

    private void generateRulesForConsumers(ITool generatingTool, List outputVarsAdditionsList, StringBuffer buffer) {
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        boolean[] buildToolsUsed = h.buildToolsUsed;
        IOutputType[] outTypes = generatingTool.getOutputTypes();
        int i = 0;
        while (i < outTypes.length) {
            String[] outExts = outTypes[i].getOutputExtensions(generatingTool);
            String outVariable = outTypes[i].getBuildVariable();
            if (outExts != null) {
                int j = 0;
                while (j < outExts.length) {
                    int k = 0;
                    while (k < buildTools.length) {
                        IInputType inType;
                        ITool tool = buildTools[k];
                        if (!buildToolsUsed[k] && (inType = tool.getInputType(outExts[j])) != null) {
                            String inVariable = inType.getBuildVariable();
                            if ((outVariable == null && inVariable == null || outVariable != null && inVariable != null && outVariable.equals(inVariable)) && this.addRuleForTool(buildTools[k], buffer, false, null, null, outputVarsAdditionsList, null, false)) {
                                buildToolsUsed[k] = true;
                                this.generateRulesForConsumers(buildTools[k], outputVarsAdditionsList, buffer);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean getToolInputsOutputs(ITool tool, Vector inputs, Vector dependencies, Vector outputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs, Vector outputVariables, Vector additionalTargets, boolean bTargetTool, Vector managedProjectOutputs) {
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
        IManagedBuildGnuToolInfo toolInfo = null;
        int i = 0;
        while (i < buildTools.length) {
            if (tool == buildTools[i]) {
                toolInfo = gnuToolInfos[i];
                break;
            }
            ++i;
        }
        if (toolInfo == null) {
            return false;
        }
        inputs.addAll(toolInfo.getCommandInputs());
        outputs.addAll(toolInfo.getCommandOutputs());
        enumeratedPrimaryOutputs.addAll(toolInfo.getEnumeratedPrimaryOutputs());
        enumeratedSecondaryOutputs.addAll(toolInfo.getEnumeratedSecondaryOutputs());
        outputVariables.addAll(toolInfo.getOutputVariables());
        Vector unprocessedDependencies = toolInfo.getCommandDependencies();
        for (String path : unprocessedDependencies) {
            dependencies.add(this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(path));
        }
        additionalTargets.addAll(toolInfo.getAdditionalTargets());
        if (bTargetTool && managedProjectOutputs != null) {
            Iterator refIter = managedProjectOutputs.listIterator();
            while (refIter.hasNext()) {
                dependencies.add((String)refIter.next());
            }
        }
        return true;
    }

    protected Vector calculateSecondaryOutputs(IOutputType[] secondaryOutputs) {
        ToolInfoHolder h = (ToolInfoHolder)this.toolInfos.getValue();
        ITool[] buildTools = h.buildTools;
        Vector<String> buildVars = new Vector<String>();
        int i = 0;
        while (i < buildTools.length) {
            IOutputType[] outTypes = buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    block2: while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId())) continue;
                            buildVars.add(outType.getBuildVariable());
                            break block2;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return buildVars;
    }

    protected boolean isSecondaryOutputVar(ToolInfoHolder h, IOutputType[] secondaryOutputs, String varName) {
        ITool[] buildTools = h.buildTools;
        int i = 0;
        while (i < buildTools.length) {
            IOutputType[] outTypes = buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId()) || !outType.getBuildVariable().equals(varName)) continue;
                            return true;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_LIST) + NEWLINE);
        buffer.append("SUBDIRS := \\\n");
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer container = (IContainer)iter.next();
            this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.adding.source.folder", container.getFullPath().toString()));
            if (container.getFullPath() == this.project.getFullPath()) {
                buffer.append(". \\\n");
                continue;
            }
            IPath path = container.getProjectRelativePath();
            buffer.append(String.valueOf(GnuMakefileGenerator.escapeWhitespaces(path.toString())) + " " + "\\\n");
        }
        buffer.append(NEWLINE);
        return buffer;
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return GnuMakefileGenerator.addDefaultHeader();
    }

    protected StringBuffer addSources(IContainer module) throws CoreException {
        String macroName;
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : "/");
        LinkedHashMap buildVarToRuleStringMap = new LinkedHashMap();
        for (Map.Entry entry : this.buildSrcVars.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, null, false);
        }
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, "./" + relativePath, false);
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer("# " + ManagedMakeMessages.getResourceString(MOD_RULES) + NEWLINE);
        IResource[] resources = module.members();
        IFolder folder = this.project.getFolder(this.config.getName());
        int i = 0;
        while (i < resources.length) {
            IPath rcProjRelPath;
            IResource resource = resources[i];
            if (resource.getType() == 1 && this.isSource(rcProjRelPath = resource.getProjectRelativePath())) {
                IResourceInfo rcInfo = this.config.getResourceInfo(rcProjRelPath, false);
                this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, resource, resource.getLocation(), rcInfo, null, false);
            }
            ++i;
        }
        buffer.append(this.writeAdditionMacros(buildVarToRuleStringMap));
        return buffer.append(ruleBuffer + NEWLINE);
    }

    protected void addFragmentMakefileEntriesForSource(LinkedHashMap buildVarToRuleStringMap, StringBuffer ruleBuffer, IFolder folder, String relativePath, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, String varName, boolean generatedSource) {
        int j;
        IFileInfo fi;
        ITool[] tools;
        String ext = sourceLocation.getFileExtension();
        ITool tool = null;
        if (rcInfo instanceof IFileInfo && (tools = (fi = (IFileInfo)rcInfo).getToolsToInvoke()) != null && tools.length > 0) {
            tool = tools[0];
            this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
        }
        ToolInfoHolder h = this.getToolInfo(rcInfo.getPath());
        ITool[] buildTools = h.buildTools;
        if (tool == null) {
            h = this.getToolInfo((IPath)Path.EMPTY);
            buildTools = h.buildTools;
            j = 0;
            while (j < buildTools.length) {
                if (buildTools[j].buildsFileType(ext)) {
                    if (tool == null) {
                        tool = buildTools[j];
                    }
                    this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                    break;
                }
                ++j;
            }
        }
        if (tool != null) {
            IInputType primaryInputType = tool.getPrimaryInputType();
            IInputType inputType = tool.getInputType(ext);
            if (primaryInputType != null && !primaryInputType.getMultipleOfType() || inputType == null && tool != this.config.calculateTargetTool()) {
                Vector generatedOutputs = new Vector();
                Vector generatedDepFiles = new Vector();
                this.addRuleForSource(relativePath, ruleBuffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, generatedOutputs);
                if (generatedDepFiles.size() > 0) {
                    int k = 0;
                    while (k < generatedDepFiles.size()) {
                        IPath generatedDepFile = (IPath)generatedDepFiles.get(k);
                        this.addMacroAdditionFile(buildVarToRuleStringMap, this.getDepMacroName(ext).toString(), String.valueOf(generatedDepFile.isAbsolute() ? "" : "./") + generatedDepFile.toString());
                        ++k;
                    }
                }
                IOutputType outType = tool.getPrimaryOutputType();
                String buildVariable = null;
                if (outType != null) {
                    if (tool.getCustomBuildStep()) {
                        if (generatedOutputs.size() > 0) {
                            IPath firstOutput = (IPath)generatedOutputs.get(0);
                            String firstExt = firstOutput.getFileExtension();
                            ToolInfoHolder tmpH = this.getFolderToolInfo(rcInfo.getPath());
                            ITool[] tmpBuildTools = tmpH.buildTools;
                            int j2 = 0;
                            while (j2 < tmpBuildTools.length) {
                                String bV;
                                if (tmpBuildTools[j2].buildsFileType(firstExt) && (bV = tmpBuildTools[j2].getPrimaryInputType().getBuildVariable()).length() > 0) {
                                    buildVariable = bV;
                                    break;
                                }
                                ++j2;
                            }
                        }
                    } else {
                        buildVariable = outType.getBuildVariable();
                    }
                } else {
                    buildVariable = OBJS_MACRO;
                }
                int k = 0;
                while (k < generatedOutputs.size()) {
                    IFile generateOutputResource;
                    IPath generatedOutput;
                    if (((IPath)generatedOutputs.get(k)).isAbsolute()) {
                        generatedOutput = (IPath)generatedOutputs.get(k);
                        generateOutputResource = this.project.getFile(generatedOutput);
                    } else {
                        generatedOutput = this.project.getLocation().append(this.getBuildWorkingDir()).append((IPath)generatedOutputs.get(k));
                        generateOutputResource = this.project.getFile(this.getBuildWorkingDir().append((IPath)generatedOutputs.get(k)));
                    }
                    IResourceInfo nextRcInfo = rcInfo instanceof IFileInfo ? this.config.getResourceInfo(rcInfo.getPath().removeLastSegments(1), false) : rcInfo;
                    this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, (IResource)generateOutputResource, generatedOutput, nextRcInfo, buildVariable, true);
                    ++k;
                }
            }
        } else if (varName == null) {
            j = 0;
            while (j < buildTools.length) {
                if (buildTools[j].isInputFileType(ext)) {
                    this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                    break;
                }
                ++j;
            }
        } else {
            IOutputType[] secondaryOutputs = this.config.getToolChain().getSecondaryOutputs();
            if (secondaryOutputs.length > 0 && this.isSecondaryOutputVar(h, secondaryOutputs, varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    protected void addToBuildVar(LinkedHashMap buildVarToRuleStringMap, String ext, String varName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        List varList = null;
        if (varName == null) {
            varName = this.getSourceMacroName(ext).toString();
            varList = (List)this.buildSrcVars.get(varName);
        } else {
            varList = (List)this.buildOutVars.get(varName);
        }
        if (varList != null && !varList.contains(sourceLocation)) {
            varList.add(sourceLocation);
            if (buildVarToRuleStringMap.containsKey(varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    private IManagedCommandLineInfo generateToolCommandLineInfo(ITool tool, String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(" ") != -1 || outputLocation != null && outputLocation.toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
    }

    protected void addRuleForSource(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector generatedDepFiles, Vector enumeratedOutputs) {
        String depLine;
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String inputExtension = sourceLocation.getFileExtension();
        ITool tool = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                tool = tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            tool = foInfo.getToolFromInputExtension(inputExtension);
        }
        ToolInfoHolder h = this.getToolInfo(rcInfo.getPath());
        String outputExtension = tool.getOutputExtension(inputExtension);
        if (outputExtension == null) {
            outputExtension = EMPTY_STRING;
        }
        IManagedDependencyGenerator oldDepGen = null;
        IManagedDependencyGenerator2 depGen = null;
        IManagedDependencyInfo depInfo = null;
        IManagedDependencyCommands depCommands = null;
        IManagedDependencyPreBuild depPreBuild = null;
        IPath[] depFiles = null;
        boolean doDepGen = false;
        IManagedDependencyGeneratorType t = tool.getDependencyGeneratorForExtension(inputExtension);
        if (t != null) {
            int calcType = t.getCalculatorType();
            if (calcType <= 3) {
                oldDepGen = (IManagedDependencyGenerator)t;
                boolean bl = doDepGen = calcType == 1;
                if (doDepGen) {
                    IPath depFile = Path.fromOSString((String)(String.valueOf(relativePath) + fileName + "." + "d"));
                    this.getDependencyMakefiles(h).add(depFile);
                    generatedDepFiles.add(depFile);
                }
            } else {
                depGen = (IManagedDependencyGenerator2)t;
                doDepGen = calcType == 5;
                IResourceInfo buildContext = rcInfo;
                depInfo = depGen.getDependencySourceInfo(resource.getProjectRelativePath(), resource, buildContext, tool, this.getBuildWorkingDir());
                if (calcType == 5) {
                    depCommands = (IManagedDependencyCommands)depInfo;
                    depFiles = depCommands.getDependencyFiles();
                } else if (calcType == 6) {
                    depPreBuild = (IManagedDependencyPreBuild)depInfo;
                    depFiles = depPreBuild.getDependencyFiles();
                }
                if (depFiles != null) {
                    int i = 0;
                    while (i < depFiles.length) {
                        this.getDependencyMakefiles(h).add(depFiles[i]);
                        generatedDepFiles.add(depFiles[i]);
                        ++i;
                    }
                }
            }
        }
        String optDotExt = EMPTY_STRING;
        if (outputExtension != null && outputExtension.length() > 0) {
            optDotExt = "." + outputExtension;
        }
        Vector ruleOutputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        this.calculateOutputsForSource(tool, relativePath, resource, sourceLocation, ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs);
        enumeratedOutputs.addAll(enumeratedPrimaryOutputs);
        enumeratedOutputs.addAll(enumeratedSecondaryOutputs);
        String primaryOutputName = null;
        primaryOutputName = enumeratedPrimaryOutputs.size() > 0 ? GnuMakefileGenerator.escapeWhitespaces(((IPath)enumeratedPrimaryOutputs.get(0)).toString()) : GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + fileName + optDotExt);
        String otherPrimaryOutputs = EMPTY_STRING;
        int i = 1;
        while (i < enumeratedPrimaryOutputs.size()) {
            otherPrimaryOutputs = String.valueOf(otherPrimaryOutputs) + " " + GnuMakefileGenerator.escapeWhitespaces(((IPath)enumeratedPrimaryOutputs.get(i)).toString());
            ++i;
        }
        String projectLocation = this.project.getLocation().toString();
        IPath outputLocation = Path.fromOSString((String)primaryOutputName);
        if (!outputLocation.isAbsolute()) {
            outputLocation = this.project.getLocation().append(this.getBuildWorkingDir()).append(primaryOutputName);
        }
        boolean resourceNameRequiresExplicitRule = resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) || !resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(resource.getProjectRelativePath().toString());
        boolean needExplicitRuleForFile = resourceNameRequiresExplicitRule || BuildMacroProvider.getReferencedExplitFileMacros(tool).length > 0 || BuildMacroProvider.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(sourceLocation, outputLocation, null, tool)).length > 0;
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        String defaultOutputName = EMPTY_STRING;
        String primaryDependencyName = EMPTY_STRING;
        String patternPrimaryDependencyName = EMPTY_STRING;
        String home = generatedSource ? "." : "..";
        String resourcePath = null;
        boolean patternRule = true;
        boolean isItLinked = false;
        if (!sourceLocation.toString().startsWith(projectLocation)) {
            isItLinked = true;
            resourcePath = sourceLocation.toString();
            defaultOutputName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + fileName + optDotExt);
            primaryDependencyName = GnuMakefileGenerator.escapeWhitespaces(resourcePath);
            patternRule = false;
        } else {
            resourcePath = relativePath;
            if (rcInfo instanceof IFileInfo || needExplicitRuleForFile) {
                defaultOutputName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(resourcePath) + fileName + optDotExt);
                patternRule = false;
            } else {
                defaultOutputName = String.valueOf(relativePath) + "%" + optDotExt;
            }
            primaryDependencyName = GnuMakefileGenerator.escapeWhitespaces(String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension);
            patternPrimaryDependencyName = String.valueOf(home) + "/" + resourcePath + "%" + "." + inputExtension;
        }
        boolean needExplicitDependencyCommands = false;
        if (depCommands != null) {
            boolean bl = needExplicitDependencyCommands = !depCommands.areCommandsGeneric();
        }
        if (patternRule) {
            patternRule = false;
            int i2 = 0;
            while (i2 < ruleOutputs.size()) {
                String ruleOutput = ((IPath)ruleOutputs.get(i2)).toString();
                if (ruleOutput.indexOf(37) >= 0) {
                    patternRule = true;
                    break;
                }
                ++i2;
            }
            if (patternRule) {
                patternRule = !needExplicitDependencyCommands;
            }
        }
        String buildRule = EMPTY_STRING;
        if (patternRule) {
            if (ruleOutputs.size() == 0) {
                buildRule = String.valueOf(buildRule) + defaultOutputName;
            } else {
                boolean first = true;
                int i3 = 0;
                while (i3 < ruleOutputs.size()) {
                    String ruleOutput = ((IPath)ruleOutputs.get(i3)).toString();
                    if (ruleOutput.indexOf(37) >= 0) {
                        if (first) {
                            first = false;
                        } else {
                            buildRule = String.valueOf(buildRule) + " ";
                        }
                        buildRule = String.valueOf(buildRule) + ruleOutput;
                    }
                    ++i3;
                }
            }
        } else {
            buildRule = String.valueOf(buildRule) + primaryOutputName;
        }
        String buildRuleDependencies = primaryDependencyName;
        String patternBuildRuleDependencies = patternPrimaryDependencyName;
        IPath[] addlDepPaths = tool.getAdditionalDependencies();
        int i4 = 0;
        while (i4 < addlDepPaths.length) {
            IPath tempPath;
            IPath addlPath = addlDepPaths[i4];
            if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append((IPath)new Path(GnuMakefileGenerator.ensureUnquoted(addlPath.toString())))) != null) {
                addlPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
            }
            String suitablePath = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(addlPath.toString());
            buildRuleDependencies = String.valueOf(buildRuleDependencies) + " " + suitablePath;
            patternBuildRuleDependencies = String.valueOf(patternBuildRuleDependencies) + " " + suitablePath;
            ++i4;
        }
        buildRule = String.valueOf(buildRule) + ": " + (patternRule ? patternBuildRuleDependencies : buildRuleDependencies);
        if (!this.getRuleList().contains(buildRule)) {
            String buildCmd;
            String[] preToolCommands;
            this.getRuleList().add(buildRule);
            buffer.append(String.valueOf(buildRule) + NEWLINE);
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_FILE) + " " + "$<"));
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(tool.getAnnouncement()));
            if (depCommands != null && (preToolCommands = depCommands.getPreToolDependencyCommands()) != null && preToolCommands.length > 0) {
                int i5 = 0;
                while (i5 < preToolCommands.length) {
                    try {
                        String preCmd = preToolCommands[i5];
                        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                        String resolvedCommand = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(preCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : provider.resolveValue(preCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        if (resolvedCommand != null) {
                            buffer.append(String.valueOf(resolvedCommand) + NEWLINE);
                        }
                    }
                    catch (BuildMacroException buildMacroException) {}
                    ++i5;
                }
            }
            Vector<String> inputs = new Vector<String>();
            inputs.add("$<");
            IPath[] addlInputPaths = this.getAdditionalResourcesForSource(tool);
            int i6 = 0;
            while (i6 < addlInputPaths.length) {
                IPath tempPath;
                IPath addlPath = addlInputPaths[i6];
                if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                    addlPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
                }
                inputs.add(addlPath.toString());
                ++i6;
            }
            String[] inputStrings = inputs.toArray(new String[inputs.size()]);
            String[] flags = null;
            try {
                flags = tool.getToolCommandFlags(sourceLocation, outputLocation);
            }
            catch (BuildException buildException) {
                flags = EMPTY_STRING_ARRAY;
            }
            if (depCommands != null) {
                flags = this.addDependencyOptions(depCommands, flags);
            }
            IManagedCommandLineInfo cmdLInfo = null;
            String outflag = null;
            String outputPrefix = null;
            if (rcInfo instanceof IFileInfo || needExplicitRuleForFile || needExplicitDependencyCommands) {
                outflag = tool.getOutputFlag();
                outputPrefix = tool.getOutputPrefix();
                IManagedCommandLineGenerator cmdLGen = tool.getCommandLineGenerator();
                cmdLInfo = cmdLGen.generateCommandLineInfo(tool, cmd, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputStrings, tool.getCommandLinePattern());
            } else {
                outflag = tool.getOutputFlag();
                outputPrefix = tool.getOutputPrefix();
                cmdLInfo = this.generateToolCommandLineInfo(tool, inputExtension, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputStrings, sourceLocation, outputLocation);
            }
            if (cmdLInfo != null) {
                buildCmd = cmdLInfo.getCommandLine();
            } else {
                StringBuffer buildFlags = new StringBuffer();
                int index = 0;
                while (index < flags.length) {
                    if (flags[index] != null) {
                        buildFlags.append(String.valueOf(flags[index]) + " ");
                    }
                    ++index;
                }
                buildCmd = String.valueOf(cmd) + " " + buildFlags.toString().trim() + " " + outflag + " " + outputPrefix + "$@" + otherPrimaryOutputs + " " + "$<";
            }
            try {
                IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                String resolvedCommand = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : provider.resolveValue(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            buffer.append("\t" + buildCmd);
            if (doDepGen) {
                String[] depCmds = null;
                if (oldDepGen != null) {
                    depCmds = new String[]{oldDepGen.getDependencyCommand(resource, ManagedBuildManager.getBuildInfo((IResource)this.project))};
                } else if (depCommands != null) {
                    depCmds = depCommands.getPostToolDependencyCommands();
                }
                if (depCmds != null) {
                    int i7 = 0;
                    while (i7 < depCmds.length) {
                        buffer.append(" && \\\n");
                        String depCmd = depCmds[i7];
                        try {
                            depCmd = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(depCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        }
                        catch (BuildMacroException buildMacroException) {}
                        buffer.append(depCmd);
                        ++i7;
                    }
                }
            }
            buffer.append(NEWLINE);
            buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_FINISH_FILE) + " " + "$<"));
            buffer.append("\t@" + ECHO_BLANK_LINE + NEWLINE);
        }
        IPath[] addlDeps = null;
        IPath[] addlTargets = null;
        String calculatedDependencies = null;
        boolean addedDepLines = false;
        if (oldDepGen != null && oldDepGen.getCalculatorType() != 1) {
            addlDeps = this.oldCalculateDependenciesForSource(oldDepGen, tool, relativePath, resource);
        } else if (depGen != null && depGen.getCalculatorType() == 7 && depInfo instanceof IManagedDependencyCalculator) {
            IManagedDependencyCalculator depCalculator = (IManagedDependencyCalculator)depInfo;
            addlDeps = this.calculateDependenciesForSource(depCalculator);
            addlTargets = depCalculator.getAdditionalTargets();
        }
        if (addlDeps != null && addlDeps.length > 0) {
            calculatedDependencies = new String();
            int i8 = 0;
            while (i8 < addlDeps.length) {
                calculatedDependencies = String.valueOf(calculatedDependencies) + " " + GnuMakefileGenerator.escapeWhitespaces(addlDeps[i8].toString());
                ++i8;
            }
        }
        if (calculatedDependencies != null) {
            depLine = String.valueOf(primaryOutputName) + ":" + calculatedDependencies + NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
        }
        Vector addlOutputs = new Vector();
        if (enumeratedPrimaryOutputs.size() > 1) {
            int i9 = 1;
            while (i9 < enumeratedPrimaryOutputs.size()) {
                addlOutputs.add(enumeratedPrimaryOutputs.get(i9));
                ++i9;
            }
        }
        addlOutputs.addAll(enumeratedSecondaryOutputs);
        if (addlTargets != null) {
            int i10 = 0;
            while (i10 < addlTargets.length) {
                addlOutputs.add(addlTargets[i10]);
                ++i10;
            }
        }
        int i11 = 0;
        while (i11 < addlOutputs.size()) {
            depLine = String.valueOf(GnuMakefileGenerator.escapeWhitespaces(((IPath)addlOutputs.get(i11)).toString())) + ":" + " " + primaryOutputName;
            if (calculatedDependencies != null) {
                depLine = String.valueOf(depLine) + calculatedDependencies;
            }
            depLine = String.valueOf(depLine) + NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
            ++i11;
        }
        if (addedDepLines) {
            buffer.append(NEWLINE);
        }
        if (depPreBuild != null && depFiles != null) {
            addedDepLines = false;
            String[] preBuildCommands = depPreBuild.getDependencyCommands();
            if (preBuildCommands != null) {
                depLine = "";
                patternRule = !isItLinked && !needExplicitRuleForFile && depPreBuild.areCommandsGeneric();
                int i12 = 0;
                while (i12 < depFiles.length) {
                    if (i12 > 0) {
                        depLine = String.valueOf(depLine) + " ";
                    }
                    if (patternRule) {
                        optDotExt = EMPTY_STRING;
                        String depExt = depFiles[i12].getFileExtension();
                        if (depExt != null && depExt.length() > 0) {
                            optDotExt = "." + depExt;
                        }
                        depLine = String.valueOf(depLine) + GnuMakefileGenerator.escapeWhitespaces(String.valueOf(relativePath) + "%" + optDotExt);
                    } else {
                        depLine = String.valueOf(depLine) + GnuMakefileGenerator.escapeWhitespaces(depFiles[i12].toString());
                    }
                    ++i12;
                }
                depLine = String.valueOf(depLine) + ": " + (patternRule ? patternBuildRuleDependencies : buildRuleDependencies);
                if (!this.getDepRuleList().contains(depLine)) {
                    this.getDepRuleList().add(depLine);
                    addedDepLines = true;
                    buffer.append(String.valueOf(depLine) + NEWLINE);
                    buffer.append("\t@" + GnuMakefileGenerator.escapedEcho(String.valueOf(MESSAGE_START_DEPENDENCY) + " " + "$@"));
                    i12 = 0;
                    while (i12 < preBuildCommands.length) {
                        depLine = preBuildCommands[i12];
                        try {
                            depLine = !needExplicitRuleForFile ? ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depLine, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValue(depLine, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                        }
                        catch (BuildMacroException buildMacroException) {}
                        buffer.append("\t" + depLine + NEWLINE);
                        ++i12;
                    }
                }
                if (addedDepLines) {
                    buffer.append("\t@" + ECHO_BLANK_LINE + NEWLINE);
                }
            }
        }
    }

    private String[] addDependencyOptions(IManagedDependencyCommands depCommands, String[] flags) {
        String[] depOptions = depCommands.getDependencyCommandOptions();
        if (depOptions != null && depOptions.length > 0) {
            int flagsLen = flags.length;
            String[] flagsCopy = new String[flags.length + depOptions.length];
            int i = 0;
            while (i < flags.length) {
                flagsCopy[i] = flags[i];
                ++i;
            }
            i = 0;
            while (i < depOptions.length) {
                flagsCopy[i + flagsLen] = depOptions[i];
                ++i;
            }
            flags = flagsCopy;
        }
        return flags;
    }

    protected IPath[] getAdditionalResourcesForSource(ITool tool) {
        ArrayList<IPath> allRes = new ArrayList<IPath>();
        IInputType[] types = tool.getInputTypes();
        int i = 0;
        while (i < types.length) {
            IInputType type = types[i];
            IPath[] res = type.getAdditionalResources();
            int j = 0;
            while (j < res.length) {
                allRes.add(res[j]);
                ++j;
            }
            if (type != tool.getPrimaryInputType()) {
                String var = type.getBuildVariable();
                if (var != null && var.length() > 0) {
                    allRes.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
                } else {
                    String[] typeExts = type.getSourceExtensions(tool);
                    int j2 = 0;
                    while (j2 < this.projectResources.length) {
                        if (this.projectResources[j2].getType() == 1) {
                            String fileExt = this.projectResources[j2].getFileExtension();
                            if (fileExt == null) {
                                fileExt = "";
                            }
                            int k = 0;
                            while (k < typeExts.length) {
                                if (fileExt.equals(typeExts[k])) {
                                    allRes.add(this.projectResources[j2].getProjectRelativePath());
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j2;
                    }
                }
                IOption assignToOption = tool.getOptionBySuperClassId(type.getAssignToOptionId());
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                if (assignToOption != null && option == null) {
                    try {
                        int optType = assignToOption.getValueType();
                        IResourceInfo rcInfo = tool.getParentResourceInfo();
                        if (rcInfo != null) {
                            int j3;
                            if (optType == 2) {
                                String optVal = "";
                                j3 = 0;
                                while (j3 < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    String resPath;
                                    if (j3 != 0) {
                                        optVal = String.valueOf(optVal) + " ";
                                    }
                                    if (!(resPath = allRes.get(j3).toString()).startsWith("$(") && (addlResource = this.project.getFile(resPath)) != null && (addlPath = addlResource.getLocation()) != null) {
                                        resPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    optVal = String.valueOf(optVal) + ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), Path.fromOSString((String)resPath)).toString();
                                    ++j3;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, optVal);
                            } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                                String[] paths = new String[allRes.size()];
                                j3 = 0;
                                while (j3 < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    paths[j3] = allRes.get(j3).toString();
                                    if (!paths[j3].startsWith("$(") && (addlResource = this.project.getFile(paths[j3])) != null && (addlPath = addlResource.getLocation()) != null) {
                                        paths[j3] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    ++j3;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, paths);
                            } else if (optType == 0) {
                                boolean b = false;
                                if (allRes.size() > 0) {
                                    b = true;
                                }
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, b);
                            } else if (optType == 1 && allRes.size() > 0) {
                                String s = allRes.get(0).toString();
                                ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)tool, assignToOption, s);
                            }
                            allRes.clear();
                        }
                    }
                    catch (BuildException buildException) {}
                }
            }
            ++i;
        }
        return allRes.toArray(new IPath[allRes.size()]);
    }

    protected void calculateOutputsForSource(ITool tool, String relativePath, IResource resource, IPath sourceLocation, Vector ruleOutputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs) {
        String inExt = sourceLocation.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        tool.getParentResourceInfo();
        IOutputType[] outTypes = tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                IOutputType type = outTypes[i];
                boolean primaryOutput = type == tool.getPrimaryOutputType();
                String outputPrefix = type.getOutputPrefix();
                try {
                    outputPrefix = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputPrefix, "", " ", 3, this.config) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputPrefix, "", " ", 3, this.config);
                }
                catch (BuildMacroException buildMacroException) {}
                boolean multOfType = type.getMultipleOfType();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                IManagedOutputNameProvider nameProvider = type.getNameProvider();
                String[] outputNames = type.getOutputNames();
                if (option != null) {
                    try {
                        int j;
                        List<String> outputList = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                            outputList = (List)option.getValue();
                            ((Tool)tool).filterValues(optType, outputList);
                            if (outputPrefix.length() > 0) {
                                j = 0;
                                while (j < outputList.size()) {
                                    outputList.set(j, String.valueOf(outputPrefix) + outputList.get(j));
                                    ++j;
                                }
                            }
                        }
                        j = 0;
                        while (j < outputList.size()) {
                            IPath outPath;
                            String outputName = (String)outputList.get(j);
                            try {
                                String resolved = null;
                                resolved = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    outputName = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                                outPath = Path.fromOSString((String)(String.valueOf(relativePath) + (String)outputList.get(j)));
                            }
                            if (primaryOutput) {
                                ruleOutputs.add(j, outPath);
                                enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                            } else {
                                ruleOutputs.add(outPath);
                                enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                            }
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                } else if (nameProvider != null) {
                    IPath[] inPaths = new IPath[]{sourceLocation};
                    IPath[] outPaths = nameProvider.getOutputNames(tool, inPaths);
                    int j = 0;
                    while (j < outPaths.length) {
                        IPath outPath = outPaths[j];
                        String outputName = outPaths[j].toString();
                        try {
                            String resolved = null;
                            resolved = GnuMakefileGenerator.containsSpecialCharacters(sourceLocation.toString()) ? ManagedBuildManager.getBuildMacroProvider().resolveValue(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                outputName = resolved;
                            }
                        }
                        catch (BuildMacroException buildMacroException) {}
                        if (outPath.segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (outputNames != null) {
                    int j = 0;
                    while (j < outputNames.length) {
                        IPath outPath;
                        String outputName = outputNames[j];
                        try {
                            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                outputName = resolved;
                            }
                        }
                        catch (BuildMacroException buildMacroException) {}
                        if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (!multOfType) {
                    String namePattern = type.getNamePattern();
                    IPath namePatternPath = null;
                    if (namePattern == null || namePattern.length() == 0) {
                        namePattern = String.valueOf(relativePath) + outputPrefix + "%";
                        if (outExt != null && outExt.length() > 0) {
                            namePattern = String.valueOf(namePattern) + "." + outExt;
                        }
                        namePatternPath = Path.fromOSString((String)namePattern);
                    } else {
                        if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                            namePatternPath = Path.fromOSString((String)(String.valueOf(relativePath) + namePatternPath.toString()));
                        }
                    }
                    if (primaryOutput) {
                        ruleOutputs.add(0, namePatternPath);
                        enumeratedPrimaryOutputs.add(0, this.resolvePercent(namePatternPath, sourceLocation));
                    } else {
                        ruleOutputs.add(namePatternPath);
                        enumeratedSecondaryOutputs.add(this.resolvePercent(namePatternPath, sourceLocation));
                    }
                }
                ++i;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPrefix + "%"));
            outPath = outPath.addFileExtension(outExt);
            ruleOutputs.add(0, outPath);
            enumeratedPrimaryOutputs.add(0, this.resolvePercent(outPath, sourceLocation));
        }
    }

    protected IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        IPath result = Path.fromOSString((String)outName);
        return DOT_SLASH_PATH.isPrefixOf(outPath) ? DOT_SLASH_PATH.append(result) : result;
    }

    protected IPath[] oldCalculateDependenciesForSource(IManagedDependencyGenerator depGen, ITool tool, String relativePath, IResource resource) {
        Vector<IPath> deps = new Vector<IPath>();
        int type = depGen.getCalculatorType();
        switch (type) {
            case 2: 
            case 3: {
                IResource[] res = depGen.findDependencies(resource, this.project);
                if (res == null) break;
                int i = 0;
                while (i < res.length) {
                    IPath addlPath;
                    IPath dep = null;
                    if (res[i] != null && (addlPath = res[i].getLocation()) != null) {
                        dep = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath);
                    }
                    if (dep != null) {
                        deps.add(dep);
                    }
                    ++i;
                }
                break;
            }
        }
        return deps.toArray(new IPath[deps.size()]);
    }

    protected IPath[] calculateDependenciesForSource(IManagedDependencyCalculator depCalculator) {
        IPath[] addlDeps = depCalculator.getDependencies();
        if (addlDeps != null) {
            int i = 0;
            while (i < addlDeps.length) {
                if (!addlDeps[i].isAbsolute()) {
                    IPath absolutePath = this.project.getLocation().append(addlDeps[i]);
                    addlDeps[i] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), absolutePath);
                }
                ++i;
            }
        }
        return addlDeps;
    }

    public StringBuffer getSourceMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public StringBuffer getDepMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_DEPS");
        return macroName;
    }

    public Set getOutputExtensions(ToolInfoHolder h) {
        if (h.outputExtensionsSet == null) {
            h.outputExtensionsSet = new HashSet();
            int i = 0;
            while (i < h.buildTools.length) {
                ITool tool = h.buildTools[i];
                String[] outputs = tool.getAllOutputExtensions();
                if (outputs != null) {
                    h.outputExtensionsSet.addAll((Collection)Arrays.asList(outputs));
                }
                ++i;
            }
        }
        return h.outputExtensionsSet;
    }

    public static boolean populateDummyTargets(IConfiguration cfg, IFile makefile, boolean force) throws CoreException, IOException {
        return GnuMakefileGenerator.populateDummyTargets(cfg.getRootFolderInfo(), makefile, force);
    }

    public static boolean populateDummyTargets(IResourceInfo rcInfo, IFile makefile, boolean force) throws CoreException, IOException {
        String firstToken;
        if (makefile == null || !makefile.exists()) {
            return false;
        }
        InputStream contentStream = makefile.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        StringBuffer inBuffer = null;
        int chunkSize = contentStream.available();
        inBuffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            inBuffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        if (inBuffer == null) {
            return false;
        }
        String inBufferString = inBuffer.toString();
        if (!force && inBufferString.startsWith("#")) {
            return false;
        }
        String[] bufferLines = inBufferString.split("[\\r\\n]");
        int i = 0;
        while (i < bufferLines.length) {
            String bufferLine = bufferLines[i];
            if (bufferLine.endsWith(":")) {
                StringBuffer outBuffer = GnuMakefileGenerator.addDefaultHeader();
                outBuffer.append(inBuffer);
                Util.save((StringBuffer)outBuffer, (IFile)makefile);
                return true;
            }
            ++i;
        }
        Vector bufferTokens = new Vector(Arrays.asList(inBufferString.split("\\s")));
        Vector<String> deps = new Vector<String>(bufferTokens.size());
        Iterator tokenIter = bufferTokens.iterator();
        while (tokenIter.hasNext()) {
            String token = (String)tokenIter.next();
            if (token.lastIndexOf("\\") == token.length() - 1 && token.length() > 1) {
                while (tokenIter.hasNext()) {
                    String nextToken = (String)tokenIter.next();
                    token = String.valueOf(token) + " " + nextToken;
                    if (!nextToken.endsWith("\\")) break;
                }
            }
            deps.add(token);
        }
        deps.trimToSize();
        boolean save = false;
        StringBuffer outBuffer = null;
        try {
            firstToken = (String)deps.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        outBuffer = !firstToken.startsWith("#") ? GnuMakefileGenerator.addDefaultHeader() : new StringBuffer();
        if (firstToken.startsWith("-n")) {
            String fourthToken;
            String thirdToken;
            String secondToken;
            try {
                secondToken = (String)deps.get(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                secondToken = new String();
            }
            if (secondToken.startsWith("'")) {
                outBuffer.append(String.valueOf(secondToken.substring(1)) + " ");
            } else {
                outBuffer.append(String.valueOf(secondToken) + " ");
            }
            try {
                thirdToken = (String)deps.get(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                thirdToken = new String();
            }
            int lastIndex = thirdToken.lastIndexOf("'");
            if (lastIndex != -1) {
                if (lastIndex == 0) {
                    outBuffer.append(" ");
                } else {
                    outBuffer.append(thirdToken.substring(0, lastIndex - 1));
                }
            } else {
                outBuffer.append(thirdToken);
            }
            int nToken = 3;
            try {
                while ((fourthToken = (String)deps.get(nToken++)).length() == 0) {
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                fourthToken = new String();
            }
            outBuffer.append(String.valueOf(fourthToken) + " ");
            try {
                Iterator iter = deps.listIterator(nToken);
                while (iter.hasNext()) {
                    String nextElement = (String)iter.next();
                    if (nextElement.endsWith("\\")) {
                        outBuffer.append(String.valueOf(nextElement) + NEWLINE + " ");
                        continue;
                    }
                    outBuffer.append(String.valueOf(nextElement) + " ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            outBuffer.append(inBuffer);
        }
        outBuffer.append(NEWLINE);
        save = true;
        IFolderInfo fo = null;
        if (rcInfo instanceof IFolderInfo) {
            fo = (IFolderInfo)rcInfo;
        } else {
            IConfiguration c = rcInfo.getParent();
            fo = (IFolderInfo)c.getResourceInfo(rcInfo.getPath().removeLastSegments(1), false);
        }
        for (String dummy : deps) {
            Path dep = new Path(dummy);
            String extension = dep.getFileExtension();
            if (!fo.isHeaderFile(extension)) continue;
            outBuffer.append(String.valueOf(dummy) + ":" + NEWLINE + NEWLINE);
        }
        if (save) {
            Util.save((StringBuffer)outBuffer, (IFile)makefile);
            return true;
        }
        return false;
    }

    public static String escapedEcho(String string) {
        String escapedString = string.replaceAll("'", "'\"'\"'");
        return "echo '" + escapedString + "'" + NEWLINE;
    }

    protected static StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        GnuMakefileGenerator.outputCommentLine(buffer);
        buffer.append("# " + ManagedMakeMessages.getResourceString(HEADER) + NEWLINE);
        GnuMakefileGenerator.outputCommentLine(buffer);
        buffer.append(NEWLINE);
        return buffer;
    }

    protected static void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(NEWLINE);
    }

    public static boolean containsSpecialCharacters(String path) {
        return path.matches(".*(\\s|[\\{\\}\\(\\)\\$\\@%=;]).*");
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    protected void addMacroAdditionPrefix(LinkedHashMap map, String macroName, String relativePath, boolean addPrefix) {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append(String.valueOf(macroName) + " " + MACRO_ADDITION_PREFIX_SUFFIX);
        if (addPrefix) {
            tempBuffer.append(MACRO_ADDITION_ADDPREFIX_HEADER + relativePath + MACRO_ADDITION_ADDPREFIX_SUFFIX);
        }
        map.put(macroName, tempBuffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String filename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        filename = GnuMakefileGenerator.escapeWhitespaces(filename);
        buffer.append(String.valueOf(filename) + " " + "\\\n");
        map.put(macroName, buffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.project.getLocation();
        if (generatedSource) {
            dirLocation = dirLocation.append(this.getBuildWorkingDir());
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            srcName = generatedSource ? "./" + srcPath.toString() : "../" + srcPath.toString();
        } else {
            srcName = generatedSource && !sourceLocation.isAbsolute() ? "./" + relativePath + sourceLocation.lastSegment().toString() : sourceLocation.toString();
        }
        this.addMacroAdditionFile(map, macroName, srcName);
    }

    public void addMacroAdditionFiles(HashMap map, String macroName, Vector filenames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        int i = 0;
        while (i < filenames.size()) {
            String filename = (String)filenames.get(i);
            if (filename.length() > 0) {
                buffer.append(String.valueOf(filename) + " " + "\\\n");
            }
            ++i;
        }
        map.put(macroName, buffer.toString());
    }

    protected StringBuffer writeAdditionMacros(LinkedHashMap map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_VARS) + NEWLINE);
        Collection bufferCollection = map.values();
        Iterator collectionIterator = bufferCollection.iterator();
        while (collectionIterator.hasNext()) {
            String macroString = collectionIterator.next().toString();
            if (macroString.endsWith(MACRO_ADDITION_PREFIX_SUFFIX)) continue;
            StringBuffer currentBuffer = new StringBuffer();
            if (macroString.endsWith("\\\n")) {
                macroString = String.valueOf(macroString.substring(0, macroString.length() - 2)) + NEWLINE;
            }
            currentBuffer.append(macroString);
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
        }
        return buffer.append(NEWLINE);
    }

    protected StringBuffer writeTopAdditionMacros(List varList, HashMap varMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_VARS) + NEWLINE);
        int i = 0;
        while (i < varList.size()) {
            String addition = (String)varMap.get((String)varList.get(i));
            StringBuffer currentBuffer = new StringBuffer();
            currentBuffer.append(addition);
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
            ++i;
        }
        return buffer.append(NEWLINE);
    }

    protected void calculateToolInputsOutputs() {
        this.toolInfos.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                ToolInfoHolder h = (ToolInfoHolder)container.getValue();
                ITool[] buildTools = h.buildTools;
                ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
                boolean done = false;
                boolean lastChance = false;
                int[] doneState = new int[buildTools.length];
                ITool targetTool = GnuMakefileGenerator.this.config.calculateTargetTool();
                if (buildTools.length != 0 && buildTools[0].getCustomBuildStep()) {
                    return true;
                }
                int i = 0;
                while (i < buildTools.length) {
                    if (buildTools[i] == targetTool) {
                        String ext = GnuMakefileGenerator.this.config.getArtifactExtension();
                        try {
                            ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, GnuMakefileGenerator.this.config);
                        }
                        catch (BuildMacroException buildMacroException) {}
                        String name = GnuMakefileGenerator.this.config.getArtifactName();
                        try {
                            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, GnuMakefileGenerator.this.config);
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                name = resolved;
                            }
                        }
                        catch (BuildMacroException buildMacroException) {}
                        gnuToolInfos[i] = new ManagedBuildGnuToolInfo(GnuMakefileGenerator.this.project, buildTools[i], true, name, ext);
                    } else {
                        gnuToolInfos[i] = new ManagedBuildGnuToolInfo(GnuMakefileGenerator.this.project, buildTools[i], false, null, null);
                    }
                    doneState[i] = 0;
                    ++i;
                }
                LinkedHashMap map = GnuMakefileGenerator.this.getTopBuildOutputVars();
                for (Map.Entry entry : GnuMakefileGenerator.this.buildOutVars.entrySet()) {
                    String macroName = (String)entry.getKey();
                    GnuMakefileGenerator.this.addMacroAdditionPrefix(map, macroName, "", false);
                }
                HashSet handledDepsInputExtensions = new HashSet();
                HashSet handledOutsInputExtensions = new HashSet();
                while (!done) {
                    int[] testState = new int[doneState.length];
                    int i2 = 0;
                    while (i2 < testState.length) {
                        testState[i2] = 0;
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areInputsCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateInputs(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, GnuMakefileGenerator.this.projectResources, h, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areDependenciesCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateDependencies(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, handledDepsInputExtensions, h, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < gnuToolInfos.length) {
                        if (gnuToolInfos[i2].areOutputsCalculated()) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        } else if (gnuToolInfos[i2].calculateOutputs(GnuMakefileGenerator.this, GnuMakefileGenerator.this.config, handledOutsInputExtensions, lastChance)) {
                            int n = i2;
                            testState[n] = testState[n] + 1;
                        }
                        ++i2;
                    }
                    done = true;
                    i2 = 0;
                    while (i2 < testState.length) {
                        if (testState[i2] != 3) {
                            done = false;
                            break;
                        }
                        ++i2;
                    }
                    if (!done) {
                        done = true;
                        i2 = 0;
                        while (i2 < testState.length) {
                            if (testState[i2] != doneState[i2]) {
                                done = false;
                                break;
                            }
                            ++i2;
                        }
                    }
                    if (done && !lastChance) {
                        lastChance = true;
                        done = false;
                    }
                    if (done) continue;
                    doneState = testState;
                }
                return true;
            }
        });
    }

    public List getBuildVariableList(ToolInfoHolder h, String variable, int locationType, IPath directory, boolean getAll) {
        ManagedBuildGnuToolInfo[] gnuToolInfos = h.gnuToolInfos;
        boolean done = true;
        int i = 0;
        while (i < gnuToolInfos.length) {
            if (!gnuToolInfos[i].areOutputVariablesCalculated()) {
                done = false;
            }
            ++i;
        }
        if (!done && getAll) {
            return null;
        }
        List list = (List)this.buildSrcVars.get(variable);
        if (list == null) {
            list = (List)this.buildOutVars.get(variable);
        }
        Vector<String> fileList = null;
        if (list != null) {
            IPath dirLocation = null;
            if (locationType != 3) {
                dirLocation = this.project.getLocation();
                if (locationType == 2) {
                    dirLocation = dirLocation.append(directory);
                }
            }
            int i2 = 0;
            while (i2 < list.size()) {
                IPath path = (IPath)list.get(i2);
                if (locationType != 3 && dirLocation.isPrefixOf(path)) {
                    path = path.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
                }
                if (fileList == null) {
                    fileList = new Vector<String>();
                }
                fileList.add(path.toString());
                ++i2;
            }
        }
        return fileList;
    }

    public List getTopBuildVariableList(String variable) {
        return (List)this.topBuildOutVars.get(variable);
    }

    public HashMap getBuildOutputVars() {
        return this.buildOutVars;
    }

    public LinkedHashMap getTopBuildOutputVars() {
        return this.topBuildOutVars;
    }

    protected Vector getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    protected Vector getDepLineList() {
        if (this.depLineList == null) {
            this.depLineList = new Vector();
        }
        return this.depLineList;
    }

    protected Vector getDepRuleList() {
        if (this.depRuleList == null) {
            this.depRuleList = new Vector();
        }
        return this.depRuleList;
    }

    protected void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    protected void appendDeletedSubdirectory(IContainer container) {
        IContainer parent = container.getParent();
        if (!this.getDeletedDirList().contains(container) && !this.getDeletedDirList().contains(parent)) {
            this.getDeletedDirList().add(container);
        }
    }

    protected void appendDeletedFile(IResource resource) {
        this.getDeletedFileList().add(resource);
    }

    protected void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    protected void cancel(String message) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void deleteBuildTarget(IResource deletedFile) {
        String targetExtension;
        String fileName = this.getFileName(deletedFile);
        String srcExtension = deletedFile.getFileExtension();
        Object folderPath = this.inFullPathFromOutFullPath(deletedFile.getFullPath().removeLastSegments(1));
        folderPath = folderPath != null ? folderPath.removeFirstSegments(1) : new Path("");
        IResourceInfo rcInfo = this.config.getResourceInfo((IPath)folderPath, false);
        if (rcInfo instanceof IFileInfo) {
            rcInfo = this.config.getResourceInfo(folderPath.removeLastSegments(1), false);
        }
        if ((targetExtension = ((IFolderInfo)rcInfo).getOutputExtension(srcExtension)) != "") {
            fileName = String.valueOf(fileName) + "." + targetExtension;
        }
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath targetFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(targetFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private IPath inFullPathFromOutFullPath(IPath path) {
        IPath inPath = null;
        if (this.topBuildDir.isPrefixOf(path)) {
            inPath = path.removeFirstSegments(this.topBuildDir.segmentCount());
            inPath = this.project.getFullPath().append(path);
        }
        return inPath;
    }

    private void deleteDepFile(IResource deletedFile) {
        IPath[] depFilePaths = null;
        ITool tool = null;
        IManagedDependencyGeneratorType depType = null;
        String sourceExtension = deletedFile.getFileExtension();
        Object folderPath = this.inFullPathFromOutFullPath(deletedFile.getFullPath().removeLastSegments(1));
        folderPath = folderPath != null ? folderPath.removeFirstSegments(1) : new Path("");
        ToolInfoHolder h = this.getToolInfo((IPath)folderPath);
        ITool[] tools = h.buildTools;
        int index = 0;
        while (index < tools.length) {
            if (tools[index].buildsFileType(sourceExtension)) {
                tool = tools[index];
                depType = tool.getDependencyGeneratorForExtension(sourceExtension);
                break;
            }
            ++index;
        }
        if (depType != null) {
            IManagedDependencyGenerator2 depGen;
            IManagedDependencyInfo depInfo;
            int calcType = depType.getCalculatorType();
            if (calcType == 1) {
                depFilePaths = new IPath[1];
                IPath absolutePath = deletedFile.getLocation();
                depFilePaths[0] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), absolutePath);
                depFilePaths[0] = depFilePaths[0].removeFileExtension().addFileExtension("d");
            } else if ((calcType == 5 || calcType == 6) && (depInfo = (depGen = (IManagedDependencyGenerator2)depType).getDependencySourceInfo(deletedFile.getProjectRelativePath(), deletedFile, this.config, tool, this.getBuildWorkingDir())) != null) {
                if (calcType == 5) {
                    IManagedDependencyCommands depCommands = (IManagedDependencyCommands)depInfo;
                    depFilePaths = depCommands.getDependencyFiles();
                } else if (calcType == 6) {
                    IManagedDependencyPreBuild depPreBuild = (IManagedDependencyPreBuild)depInfo;
                    depFilePaths = depPreBuild.getDependencyFiles();
                }
            }
        }
        if (depFilePaths != null) {
            int i = 0;
            while (i < depFilePaths.length) {
                IPath depFilePath = this.getBuildWorkingDir().append(depFilePaths[i]);
                IResource depFile = this.project.findMember(depFilePath);
                if (depFile != null && depFile.exists()) {
                    try {
                        depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
    }

    private Vector getDeletedDirList() {
        if (this.deletedDirList == null) {
            this.deletedDirList = new Vector();
        }
        return this.deletedDirList;
    }

    private Vector getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private List getDependencyMakefiles(ToolInfoHolder h) {
        if (h.dependencyMakefiles == null) {
            h.dependencyMakefiles = new ArrayList();
        }
        return h.dependencyMakefiles;
    }

    private String getFileName(IResource file) {
        String answer = new String();
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    private Vector getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    private Vector getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new Vector();
        }
        return this.modifiedList;
    }

    private Vector getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new Vector();
        }
        return this.subdirList;
    }

    private void removeGeneratedDirectory(IContainer subDir) {
        try {
            if (subDir.exists() && subDir.members().length > 0) {
                return;
            }
        }
        catch (CoreException coreException) {}
        IPath moduleRelativePath = subDir.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IFolder folder = this.project.getFolder(moduleOutputPath);
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    protected void updateMonitor(String msg) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(msg);
            this.monitor.worked(1);
        }
    }

    public IPath getTopBuildDir() {
        return this.project.getLocation().append(this.getBuildWorkingDir());
    }

    public String ensurePathIsGNUMakeTargetRuleCompatibleSyntax(String path) {
        return GnuMakefileGenerator.escapeWhitespaces(GnuMakefileGenerator.ensureUnquoted(path));
    }

    public static String ensureUnquoted(String path) {
        boolean doubleQuoted = path.startsWith("\"") && path.endsWith("\"");
        boolean singleQuoted = path.startsWith("'") && path.endsWith("'");
        return doubleQuoted || singleQuoted ? path.substring(1, path.length() - 1) : path;
    }

    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.project = cfg.getOwner().getProject();
        if (builder == null) {
            builder = cfg.getEditableBuilder();
        }
        try {
            this.projectResources = this.project.members();
        }
        catch (CoreException coreException) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.buildTargetName = cfg.getArtifactName();
        this.buildTargetExt = cfg.getArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, "", " ", 3, builder);
        }
        catch (BuildMacroException buildMacroException) {}
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, "", " ", 3, builder);
            resolved = resolved.trim();
            if (resolved.length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        if (this.buildTargetExt == null) {
            this.buildTargetExt = new String();
        }
        this.config = cfg;
        this.builder = builder;
        this.initToolInfos();
        this.topBuildDir = this.project.getFolder(cfg.getName()).getFullPath();
        this.srcEntries = this.config.getSourceEntries();
        if (this.srcEntries.length == 0) {
            this.srcEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.config);
            this.srcEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.srcEntries, (ICConfigurationDescription)cfgDes);
        }
    }

    private void initToolInfos() {
        this.toolInfos = PathSettingsContainer.createRootContainer();
        IResourceInfo[] rcInfos = this.config.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rcInfo = rcInfos[i];
            if (!rcInfo.isExcluded()) {
                ToolInfoHolder h = this.getToolInfo(rcInfo.getPath(), true);
                if (rcInfo instanceof IFolderInfo) {
                    IFolderInfo fo = (IFolderInfo)rcInfo;
                    h.buildTools = fo.getFilteredTools();
                    h.buildToolsUsed = new boolean[h.buildTools.length];
                    h.gnuToolInfos = new ManagedBuildGnuToolInfo[h.buildTools.length];
                } else {
                    IFileInfo fi = (IFileInfo)rcInfo;
                    h.buildTools = fi.getToolsToInvoke();
                    h.buildToolsUsed = new boolean[h.buildTools.length];
                    h.gnuToolInfos = new ManagedBuildGnuToolInfo[h.buildTools.length];
                }
            }
            ++i;
        }
    }

    private ToolInfoHolder getToolInfo(IPath path) {
        return this.getToolInfo(path, false);
    }

    private ToolInfoHolder getFolderToolInfo(IPath path) {
        IResourceInfo rcInfo = this.config.getResourceInfo(path, false);
        while (rcInfo instanceof IFileInfo) {
            path = path.removeLastSegments(1);
            rcInfo = this.config.getResourceInfo(path, false);
        }
        return this.getToolInfo(path, false);
    }

    private ToolInfoHolder getToolInfo(IPath path, boolean create) {
        PathSettingsContainer child = this.toolInfos.getChildContainer(path, create, create);
        ToolInfoHolder h = null;
        if (child != null && (h = (ToolInfoHolder)child.getValue()) == null && create) {
            h = new ToolInfoHolder();
            child.setValue((Object)h);
        }
        return h;
    }

    private class DepInfo {
        Vector depExts;
        IManagedDependencyGenerator2[] postProcessors;
        boolean callPopulateDummyTargets;

        private DepInfo() {
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private GnuMakefileGenerator generator;
        private IConfiguration config;

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
        }

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
            IFolderInfo fo = null;
            boolean isSource = GnuMakefileGenerator.this.isSource(resource.getProjectRelativePath());
            if (rcInfo instanceof IFolderInfo) {
                fo = (IFolderInfo)rcInfo;
            }
            if (isSource) {
                if (resource.getType() == 1) {
                    String ext = resource.getFileExtension();
                    switch (delta.getKind()) {
                        case 1: {
                            if (this.generator.isGeneratedResource(resource) || fo != null && !fo.buildsFileType(ext)) break;
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        case 2: {
                            if (this.generator.isGeneratedResource(resource) || fo != null && !fo.buildsFileType(ext)) break;
                            this.generator.appendDeletedFile(resource);
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        default: {
                            keepLooking = true;
                        }
                    }
                }
                if (resource.getType() == 2) {
                    switch (delta.getKind()) {
                        case 2: {
                            if (this.generator.isGeneratedResource(resource)) break;
                            this.generator.appendDeletedSubdirectory((IContainer)resource);
                        }
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (resource.getType() == 8 || isSource && !this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private GnuMakefileGenerator generator;
        private IConfiguration config;

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
        }

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            IResource resource = proxy.requestResource();
            boolean isSource = GnuMakefileGenerator.this.isSource(resource.getProjectRelativePath());
            if (proxy.getType() == 1) {
                IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                if (isSource) {
                    boolean willBuild = false;
                    if (rcInfo instanceof IFolderInfo) {
                        String ext = resource.getFileExtension();
                        if (((IFolderInfo)rcInfo).buildsFileType(ext) && !this.generator.isGeneratedResource(resource)) {
                            willBuild = true;
                        }
                    } else {
                        willBuild = true;
                    }
                    if (willBuild) {
                        this.generator.appendBuildSubdirectory(resource);
                    }
                }
                return false;
            }
            if (proxy.getType() == 2) {
                return isSource && !this.generator.isGeneratedResource(resource);
            }
            return true;
        }
    }

    class ToolInfoHolder {
        ITool[] buildTools;
        boolean[] buildToolsUsed;
        ManagedBuildGnuToolInfo[] gnuToolInfos;
        Set outputExtensionsSet;
        List dependencyMakefiles;

        ToolInfoHolder() {
        }
    }
}

