/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.indexview.IndexNode;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class IndexLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof IndexNode) {
            return ((IndexNode)element).fText;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IndexNode) {
            return ((IndexNode)element).fImage;
        }
        ImageDescriptor desc = null;
        if (element instanceof ICProject) {
            desc = CPluginImages.DESC_OBJS_SEARCHHIERPROJECT;
        } else if (element instanceof ICContainer) {
            desc = CPluginImages.DESC_OBJS_SEARCHHIERFODLER;
        } else if (element instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            ImageDescriptor imageDescriptor = desc = tu.isHeaderUnit() ? CPluginImages.DESC_OBJS_TUNIT_HEADER : CPluginImages.DESC_OBJS_TUNIT;
        }
        if (desc != null) {
            return CUIPlugin.getImageDescriptorRegistry().get(desc);
        }
        return super.getImage(element);
    }

    public static String getText(IPDOMNode element) {
        if (element instanceof PDOMNamedNode) {
            try {
                String result = ((PDOMNamedNode)element).getDBName().getString();
                if (element instanceof ICPPTemplateInstance) {
                    StringBuffer buffer = null;
                    buffer = element instanceof ICPPDeferredTemplateInstance ? new StringBuffer("Dfrd: ") : new StringBuffer("Inst: ");
                    buffer.append(result);
                    buffer.append('<');
                    IType[] types = ((ICPPTemplateInstance)element).getArguments();
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(ASTTypeUtil.getType((IType)types[i]));
                        ++i;
                    }
                    buffer.append('>');
                    result = buffer.toString();
                } else if (element instanceof ICPPClassTemplatePartialSpecialization) {
                    StringBuffer buffer = new StringBuffer("Part: ");
                    buffer.append(result);
                    buffer.append('<');
                    try {
                        IType[] types = ((ICPPClassTemplatePartialSpecialization)element).getArguments();
                        int i = 0;
                        while (i < types.length) {
                            if (i > 0) {
                                buffer.append(',');
                            }
                            buffer.append(ASTTypeUtil.getType((IType)types[i]));
                            ++i;
                        }
                    }
                    catch (DOMException dOMException) {}
                    buffer.append('>');
                    result = buffer.toString();
                } else if (element instanceof ICPPSpecialization) {
                    ICPPSpecialization spec = (ICPPSpecialization)element;
                    StringBuffer buffer = null;
                    buffer = new StringBuffer("Spec: ");
                    buffer.append(result);
                    if (!(spec instanceof ICPPTemplateDefinition) && spec.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
                        ICPPTemplateDefinition template = (ICPPTemplateDefinition)spec.getSpecializedBinding();
                        try {
                            ICPPTemplateParameter[] params = template.getTemplateParameters();
                            buffer.append('<');
                            ObjectMap argMap = ((ICPPSpecialization)element).getArgumentMap();
                            int i = 0;
                            while (i < params.length) {
                                if (i > 0) {
                                    buffer.append(',');
                                }
                                buffer.append(ASTTypeUtil.getType((IType)((IType)argMap.get((Object)params[i]))));
                                ++i;
                            }
                            buffer.append('>');
                        }
                        catch (DOMException dOMException) {}
                    }
                    result = buffer.toString();
                }
                if (element instanceof IFunction) {
                    try {
                        result = String.valueOf(result) + " " + ASTTypeUtil.getParameterTypeString((IFunctionType)((IFunction)element).getType());
                    }
                    catch (DOMException dOMException) {}
                }
                return result;
            }
            catch (CoreException e) {
                return e.getMessage();
            }
        }
        return "";
    }

    public static Image getImage(IPDOMNode element) {
        ImageDescriptor desc = null;
        if (element instanceof IVariable) {
            desc = CElementImageProvider.getVariableImageDescriptor();
        } else if (element instanceof IFunction) {
            desc = CElementImageProvider.getFunctionImageDescriptor();
        } else if (element instanceof ICPPClassType) {
            try {
                switch (((ICPPClassType)element).getKey()) {
                    case 3: {
                        desc = CElementImageProvider.getClassImageDescriptor();
                        break;
                    }
                    case 1: {
                        desc = CElementImageProvider.getStructImageDescriptor();
                        break;
                    }
                    case 2: {
                        desc = CElementImageProvider.getUnionImageDescriptor();
                    }
                }
            }
            catch (DOMException e) {
                CUIPlugin.log(e);
            }
        } else if (element instanceof ICompositeType) {
            desc = CElementImageProvider.getStructImageDescriptor();
        } else if (element instanceof ICPPNamespace) {
            desc = CElementImageProvider.getNamespaceImageDescriptor();
        } else if (element instanceof IEnumeration) {
            desc = CElementImageProvider.getEnumerationImageDescriptor();
        } else if (element instanceof IEnumerator) {
            desc = CElementImageProvider.getEnumeratorImageDescriptor();
        } else if (element instanceof ITypedef) {
            desc = CElementImageProvider.getTypedefImageDescriptor();
        }
        if (desc != null) {
            return CUIPlugin.getImageDescriptorRegistry().get(desc);
        }
        if (element instanceof PDOMLinkage) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
        return null;
    }
}

