/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.Iterator;
import org.eclipse.cdt.internal.corext.template.c.CodeTemplateContextType;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeTemplateSourceViewerConfiguration
extends SimpleCSourceViewerConfiguration {
    private final TemplateVariableProcessor fProcessor;

    public CodeTemplateSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore store, ITextEditor editor, TemplateVariableProcessor processor) {
        super(colorManager, store, editor, "___c_partitioning", false);
        this.fProcessor = processor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__c_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__c_character");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__c_singleline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__c_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__c_preprocessor");
        ContentAssistPreference.configure(assistant, store);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        });
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TemplateVariableTextHover(this.fProcessor);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fProcessor.getContextType() instanceof CodeTemplateContextType) {
            return super.getPresentationReconciler(sourceViewer);
        }
        return null;
    }

    private static class TemplateVariableTextHover
    implements ITextHover {
        private TemplateVariableProcessor fProcessor;

        public TemplateVariableTextHover(TemplateVariableProcessor processor) {
            this.fProcessor = processor;
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
            try {
                IDocument doc = textViewer.getDocument();
                int offset = subject.getOffset();
                if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                    String varName = doc.get(offset, subject.getLength());
                    TemplateContextType contextType = this.fProcessor.getContextType();
                    if (contextType != null) {
                        Iterator iter = contextType.resolvers();
                        while (iter.hasNext()) {
                            TemplateVariableResolver var = (TemplateVariableResolver)iter.next();
                            if (!varName.equals(var.getType())) continue;
                            return var.getDescription();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            if (textViewer != null) {
                return CWordFinder.findWord(textViewer.getDocument(), offset);
            }
            return null;
        }
    }
}

