/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedef;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractedFunctionConstructionHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.ExpressionCopier;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractExpression
extends ExtractedFunctionConstructionHelper {
    ExpressionCopier expCopier = new ExpressionCopier();

    @Override
    public void constructMethodBody(IASTCompoundStatement compound, List<IASTNode> list, ASTRewrite rewrite, TextEditGroup group) {
        CPPASTReturnStatement statement = new CPPASTReturnStatement();
        CPPASTLiteralExpression nullReturnExp = new CPPASTLiteralExpression(0, "0");
        statement.setReturnValue((IASTExpression)nullReturnExp);
        ASTRewrite nestedRewrite = rewrite.insertBefore((IASTNode)compound, null, (IASTNode)statement, group);
        nestedRewrite.replace((IASTNode)nullReturnExp, (IASTNode)this.getExpression(list), group);
    }

    private IASTExpression getExpression(List<IASTNode> list) {
        if (list.size() > 1) {
            CPPASTBinaryExpression bExp = new CPPASTBinaryExpression();
            bExp.setParent(list.get(0).getParent());
            bExp.setOperand1(this.expCopier.createCopy((IASTExpression)list.get(0)));
            bExp.setOperator(((IASTBinaryExpression)list.get(1).getParent()).getOperator());
            bExp.setOperand2(this.getExpression(list.subList(1, list.size())));
            return bExp;
        }
        return this.expCopier.createCopy((IASTExpression)list.get(0));
    }

    @Override
    public IASTDeclSpecifier determineReturnType(IASTNode extractedNode, NodeContainer.NameInformation _) {
        IASTDeclSpecifier declSpecifier = null;
        if (extractedNode instanceof ICPPASTBinaryExpression) {
            declSpecifier = this.handleBinaryExpression((ICPPASTBinaryExpression)extractedNode);
        }
        if (extractedNode instanceof ICPPASTNewExpression) {
            declSpecifier = this.handleNewExpression((ICPPASTNewExpression)extractedNode);
        }
        if (extractedNode instanceof IASTFunctionCallExpression) {
            declSpecifier = ExtractExpression.handleFunctionCallExpression((IASTFunctionCallExpression)extractedNode);
        }
        if (extractedNode instanceof IASTLiteralExpression) {
            declSpecifier = this.handleLiteralExpression((IASTLiteralExpression)extractedNode);
        }
        if (declSpecifier == null) {
            return ExtractExpression.createSimpleDeclSpecifier(1);
        }
        return declSpecifier;
    }

    private IASTDeclSpecifier handleLiteralExpression(IASTLiteralExpression extractedNode) {
        switch (extractedNode.getKind()) {
            case 2: {
                return ExtractExpression.createSimpleDeclSpecifier(2);
            }
            case 1: {
                return ExtractExpression.createSimpleDeclSpecifier(4);
            }
            case 0: {
                return ExtractExpression.createSimpleDeclSpecifier(3);
            }
            case 3: {
                return ExtractExpression.createSimpleDeclSpecifier(7);
            }
            case 5: 
            case 6: {
                return ExtractExpression.createSimpleDeclSpecifier(6);
            }
        }
        return null;
    }

    private IASTDeclSpecifier handleNewExpression(ICPPASTNewExpression expression) {
        return expression.getTypeId().getDeclSpecifier();
    }

    private IASTDeclSpecifier handleBinaryExpression(ICPPASTBinaryExpression node) {
        switch (node.getOperator()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return ExtractExpression.createSimpleDeclSpecifier(6);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                if (!(node.getOperand1() instanceof CPPASTIdExpression)) break;
                IType expressionType = ((CPPASTIdExpression)node.getOperand1()).getExpressionType();
                if (expressionType instanceof CPPBasicType) {
                    CPPBasicType basicType = (CPPBasicType)expressionType;
                    return ExtractExpression.createSimpleDeclSpecifier(basicType.getType());
                }
                if (expressionType instanceof CPPTypedef) {
                    CPPTypedef typedef = (CPPTypedef)expressionType;
                    return new CPPASTNamedTypeSpecifier((IASTName)typedef.getDefinition(), false);
                }
                if (!(expressionType instanceof CPPClassType)) break;
                CPPClassType classType = (CPPClassType)expressionType;
                return new CPPASTNamedTypeSpecifier((IASTName)classType.getDefinition(), false);
            }
        }
        return null;
    }

    private static IASTDeclSpecifier createSimpleDeclSpecifier(int type) {
        CPPASTSimpleDeclSpecifier declSpec = new CPPASTSimpleDeclSpecifier();
        declSpec.setType(type);
        return declSpec;
    }

    private static IASTName findCalledFunctionName(IASTFunctionCallExpression callExpression) {
        IASTExpression functionNameExpression = callExpression.getFunctionNameExpression();
        IASTName functionName = null;
        if (functionNameExpression instanceof CPPASTIdExpression) {
            CPPASTIdExpression idExpression = (CPPASTIdExpression)functionNameExpression;
            functionName = idExpression.getName();
        } else if (functionNameExpression instanceof CPPASTFieldReference) {
            CPPASTFieldReference fieldReference = (CPPASTFieldReference)functionNameExpression;
            functionName = fieldReference.getFieldName();
        }
        return functionName;
    }

    private static IASTDeclSpecifier handleFunctionCallExpression(IASTFunctionCallExpression callExpression) {
        IASTName functionName = ExtractExpression.findCalledFunctionName(callExpression);
        if (functionName != null) {
            IBinding binding = functionName.resolveBinding();
            if (binding instanceof CPPFunction) {
                IASTNode parent;
                CPPFunction function = (CPPFunction)binding;
                if (function.getDefinition() != null) {
                    IASTNode parent2 = function.getDefinition().getParent();
                    if (parent2 instanceof CPPASTFunctionDefinition) {
                        CPPASTFunctionDefinition definition = (CPPASTFunctionDefinition)parent2;
                        return definition.getDeclSpecifier();
                    }
                } else if (ExtractExpression.hasDeclaration(function) && (parent = function.getDeclarations()[0].getParent()) instanceof CPPASTSimpleDeclaration) {
                    CPPASTSimpleDeclaration declaration = (CPPASTSimpleDeclaration)parent;
                    return declaration.getDeclSpecifier();
                }
            } else if (binding instanceof CPPTypedef) {
                CPPTypedef typedef = (CPPTypedef)binding;
                return new CPPASTNamedTypeSpecifier((IASTName)new CPPASTName(typedef.getNameCharArray()), false);
            }
        }
        return null;
    }

    @Override
    protected boolean isReturnTypeAPointer(IASTNode node) {
        IBinding binding;
        if (node instanceof ICPPASTNewExpression) {
            return true;
        }
        if (!(node instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTName functionName = ExtractExpression.findCalledFunctionName((IASTFunctionCallExpression)node);
        if (functionName != null && (binding = functionName.resolveBinding()) instanceof CPPFunction) {
            IASTNode parent;
            CPPFunction function = (CPPFunction)binding;
            if (function.getDefinition() != null) {
                IASTNode parent2 = function.getDefinition().getParent();
                if (parent2 instanceof CPPASTFunctionDefinition) {
                    CPPASTFunctionDefinition definition = (CPPASTFunctionDefinition)parent2;
                    return definition.getDeclarator().getPointerOperators().length > 0;
                }
            } else if (ExtractExpression.hasDeclaration(function) && (parent = function.getDeclarations()[0].getParent()) instanceof CPPASTSimpleDeclaration) {
                CPPASTSimpleDeclaration declaration = (CPPASTSimpleDeclaration)parent;
                return declaration.getDeclarators().length > 0 && declaration.getDeclarators()[0].getPointerOperators().length > 0;
            }
        }
        return false;
    }

    private static boolean hasDeclaration(CPPFunction function) {
        return function != null && function.getDeclarations() != null && function.getDeclarations().length > 0;
    }

    @Override
    public IASTNode createReturnAssignment(IASTNode node, IASTExpressionStatement stmt, IASTExpression callExpression) {
        return callExpression;
    }
}

