/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FunctionFactory;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterInsertEditProvider;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterAndSetterContext
implements ITreeContentProvider {
    public ArrayList<IASTSimpleDeclaration> existingFields = new ArrayList();
    public ArrayList<IASTFunctionDefinition> existingFunctionDefinitions = new ArrayList();
    public ArrayList<IASTSimpleDeclaration> existingFunctionDeclarations = new ArrayList();
    public ArrayList<GetterSetterInsertEditProvider> selectedFunctions = new ArrayList();
    private IASTTranslationUnit unit;
    public IASTName selectedName;

    public Object[] getChildren(Object parentElement) {
        ArrayList<GetterSetterInsertEditProvider> children = new ArrayList<GetterSetterInsertEditProvider>();
        if (parentElement instanceof FieldWrapper) {
            FieldWrapper wrapper = (FieldWrapper)parentElement;
            if (!wrapper.getter.exists()) {
                children.add(this.createGetterInserter(wrapper.field));
            }
            if (!wrapper.setter.exists() && !wrapper.field.getDeclSpecifier().isConst()) {
                children.add(this.createSetterInserter(wrapper.field));
            }
        }
        return children.toArray();
    }

    public GetterSetterInsertEditProvider createGetterInserter(IASTSimpleDeclaration simpleDeclaration) {
        String varName = simpleDeclaration.getDeclarators()[0].getName().toString();
        IASTFunctionDefinition getter = FunctionFactory.createGetter(varName, simpleDeclaration);
        getter.setParent((IASTNode)this.unit);
        return new GetterSetterInsertEditProvider(getter);
    }

    public GetterSetterInsertEditProvider createSetterInserter(IASTSimpleDeclaration simpleDeclaration) {
        String varName = simpleDeclaration.getDeclarators()[0].getName().toString();
        IASTFunctionDefinition setter = FunctionFactory.createSetter(varName, simpleDeclaration);
        setter.setParent((IASTNode)this.unit);
        return new GetterSetterInsertEditProvider(setter);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FieldWrapper) {
            FieldWrapper wrapper = (FieldWrapper)element;
            return wrapper.missingGetterOrSetter();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getWrappedFields().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setUnit(IASTTranslationUnit unit) {
        this.unit = unit;
    }

    private ArrayList<FieldWrapper> getWrappedFields() {
        ArrayList<FieldWrapper> wrappedFields = new ArrayList<FieldWrapper>();
        for (IASTSimpleDeclaration currentField : this.existingFields) {
            FieldWrapper wrapper = new FieldWrapper();
            wrapper.field = currentField;
            wrapper.getter = this.getGetterForField(currentField);
            wrapper.setter = this.getSetterForField(currentField);
            if (!wrapper.missingGetterOrSetter()) continue;
            wrappedFields.add(wrapper);
        }
        return wrappedFields;
    }

    private FunctionWrapper getGetterForField(IASTSimpleDeclaration currentField) {
        FunctionWrapper wrapper = new FunctionWrapper();
        String trimmedName = NameHelper.trimFieldName(currentField.getDeclarators()[0].getName().toString());
        String getterName = "get" + NameHelper.makeFirstCharUpper(trimmedName);
        this.setFunctionToWrapper(wrapper, getterName);
        return wrapper;
    }

    private FunctionWrapper getSetterForField(IASTSimpleDeclaration currentField) {
        FunctionWrapper wrapper = new FunctionWrapper();
        String trimmedName = NameHelper.trimFieldName(currentField.getDeclarators()[0].getName().toString());
        String setterName = "set" + NameHelper.makeFirstCharUpper(trimmedName);
        this.setFunctionToWrapper(wrapper, setterName);
        return wrapper;
    }

    private void setFunctionToWrapper(FunctionWrapper wrapper, String getterName) {
        for (IASTFunctionDefinition currentDefinition : this.existingFunctionDefinitions) {
            if (!currentDefinition.getDeclarator().getName().toString().endsWith(getterName)) continue;
            wrapper.functionDefinition = currentDefinition;
        }
        for (IASTSimpleDeclaration currentDeclaration : this.existingFunctionDeclarations) {
            if (!currentDeclaration.getDeclarators()[0].getName().toString().endsWith(getterName)) continue;
            wrapper.functionDeclaration = currentDeclaration;
        }
    }

    protected class FieldWrapper {
        protected IASTSimpleDeclaration field;
        protected FunctionWrapper getter;
        protected FunctionWrapper setter;

        protected FieldWrapper() {
        }

        public String toString() {
            return this.field.getDeclarators()[0].getName().toString();
        }

        public boolean missingGetterOrSetter() {
            return !this.getter.exists() || !this.setter.exists();
        }
    }

    protected class FunctionWrapper {
        protected IASTSimpleDeclaration functionDeclaration;
        protected IASTFunctionDefinition functionDefinition;

        protected FunctionWrapper() {
        }

        public boolean exists() {
            return this.functionDeclaration != null || this.functionDefinition != null;
        }
    }
}

