/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.TrailNodeEqualityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTHelper {
    private ASTHelper() {
    }

    public static IASTNode getDeclarationForNode(IASTNode tmpNode) {
        while (tmpNode != null && !(tmpNode instanceof IASTSimpleDeclaration) && !(tmpNode instanceof IASTParameterDeclaration)) {
            tmpNode = tmpNode.getParent();
        }
        return tmpNode;
    }

    public static IASTDeclarator getDeclaratorForNode(IASTNode aNode) {
        IASTNode tmpNode = ASTHelper.getDeclarationForNode(aNode);
        IASTDeclarator declarator = null;
        if (tmpNode instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration decl = (IASTSimpleDeclaration)tmpNode;
            if (decl.getDeclarators().length > 0) {
                declarator = decl.getDeclarators()[0];
            }
        } else if (tmpNode instanceof IASTParameterDeclaration) {
            IASTParameterDeclaration decl = (IASTParameterDeclaration)tmpNode;
            declarator = decl.getDeclarator();
        }
        return declarator;
    }

    public static IASTDeclSpecifier getDeclarationSpecifier(IASTNode declaration) {
        if (declaration != null) {
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)declaration;
                return simpleDecl.getDeclSpecifier();
            }
            if (declaration instanceof ICPPASTParameterDeclaration) {
                ICPPASTParameterDeclaration paramDecl = (ICPPASTParameterDeclaration)declaration;
                return paramDecl.getDeclSpecifier();
            }
        }
        return null;
    }

    public static boolean samePointers(IASTPointerOperator[] pointerOperators1, IASTPointerOperator[] pointerOperators2, TrailNodeEqualityChecker checker) {
        if (pointerOperators2.length == pointerOperators1.length) {
            int i = 0;
            while (i < pointerOperators2.length) {
                IASTPointerOperator operator1 = pointerOperators1[i];
                IASTPointerOperator operator2 = pointerOperators2[i];
                if (!checker.isEquals((IASTNode)operator1, (IASTNode)operator2)) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isClassDeklarationName(IASTName astName) {
        if (astName == null) {
            return false;
        }
        IASTNode parent = astName.getParent();
        if (parent instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier typeSpecifier = (ICPPASTCompositeTypeSpecifier)parent;
            return typeSpecifier.getKey() == 3;
        }
        return false;
    }

    public static ArrayList<ICPPASTNamespaceDefinition> getNamespaces(IASTNode node) {
        ArrayList<ICPPASTNamespaceDefinition> namespaces = new ArrayList<ICPPASTNamespaceDefinition>();
        IASTNode aktNode = node;
        while (aktNode != null) {
            if (aktNode instanceof ICPPASTNamespaceDefinition) {
                namespaces.add(0, (ICPPASTNamespaceDefinition)aktNode);
            } else if (aktNode instanceof ICPPASTQualifiedName) {
                namespaces.addAll(ASTHelper.getNamespaces((ICPPASTQualifiedName)aktNode));
            }
            aktNode = aktNode.getParent();
        }
        return namespaces;
    }

    public static ArrayList<ICPPASTNamespaceDefinition> getNamespaces(ICPPASTQualifiedName qualifiedName) {
        ArrayList<ICPPASTNamespaceDefinition> namespaces = new ArrayList<ICPPASTNamespaceDefinition>();
        IASTName[] iASTNameArray = qualifiedName.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName aktQualifiedPartName = iASTNameArray[n2];
            IBinding binding = aktQualifiedPartName.resolveBinding();
            IASTName[] iASTNameArray2 = qualifiedName.getTranslationUnit().getDefinitionsInAST(binding);
            int n3 = iASTNameArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IASTName aktResolvedName = iASTNameArray2[n4];
                if (aktResolvedName.getParent() instanceof ICPPASTNamespaceDefinition) {
                    namespaces.add((ICPPASTNamespaceDefinition)aktResolvedName.getParent());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return namespaces;
    }

    public static Collection<IASTDeclSpecifier> getCompositTypeSpecifiers(IASTNode baseNode) {
        final ArrayList<IASTDeclSpecifier> specifiers = new ArrayList<IASTDeclSpecifier>();
        ASTVisitor visitor = new ASTVisitor(){

            public int visit(IASTDeclSpecifier declSpec) {
                specifiers.add(declSpec);
                return super.visit(declSpec);
            }
        };
        visitor.shouldVisitDeclSpecifiers = true;
        baseNode.accept(visitor);
        return specifiers;
    }

    public static Collection<IASTPreprocessorStatement> getAllInFilePreprocessorStatements(IASTTranslationUnit unit, String aktFileName) {
        ArrayList<IASTPreprocessorStatement> statements = new ArrayList<IASTPreprocessorStatement>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = unit.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement aktStatement = iASTPreprocessorStatementArray[n2];
            if (aktStatement.getFileLocation() != null && aktStatement.getFileLocation().getFileName().equals(aktFileName)) {
                statements.add(aktStatement);
            }
            ++n2;
        }
        return statements;
    }

    public static Collection<IASTDeclaration> getAllInFileDeclarations(IASTTranslationUnit unit, String aktFileName) {
        ArrayList<IASTDeclaration> decls = new ArrayList<IASTDeclaration>();
        IASTDeclaration[] iASTDeclarationArray = unit.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration aktDecl = iASTDeclarationArray[n2];
            if (aktDecl.getFileLocation() != null && aktDecl.getFileLocation().getFileName().equals(aktFileName)) {
                decls.add(aktDecl);
            }
            ++n2;
        }
        return decls;
    }

    public static ICPPASTUsingDirective getActiveUsingDirecitveForNode(IASTNode node, IASTTranslationUnit unit) {
        ICPPASTUsingDirective activeDirective = null;
        for (IASTDeclaration aktDeclaration : ASTHelper.getAllInFileDeclarations(unit, node.getFileLocation().getFileName())) {
            if (aktDeclaration.getFileLocation().getNodeOffset() >= node.getFileLocation().getNodeOffset()) break;
            if (!(aktDeclaration instanceof ICPPASTUsingDirective)) continue;
            activeDirective = (ICPPASTUsingDirective)aktDeclaration;
        }
        return activeDirective;
    }

    public static Collection<ICPPASTUsingDeclaration> getUsingDeclarations(IASTTranslationUnit unit) {
        ArrayList<ICPPASTUsingDeclaration> usingDecls = new ArrayList<ICPPASTUsingDeclaration>();
        IASTDeclaration[] iASTDeclarationArray = unit.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration aktDecl = iASTDeclarationArray[n2];
            if (aktDecl instanceof ICPPASTUsingDeclaration) {
                usingDecls.add((ICPPASTUsingDeclaration)aktDecl);
            }
            ++n2;
        }
        return usingDecls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClassDefinitionName(IASTName name) {
        try {
            if (!(name.getParent().getParent().getParent() instanceof IASTFunctionDefinition)) {
                return false;
            }
            ICPPASTQualifiedName qName = (ICPPASTQualifiedName)name.getParent();
            IASTName secondLastName = qName.getNames()[qName.getNames().length - 2];
            if (!name.equals(secondLastName)) {
                return false;
            }
            IBinding binding = name.resolveBinding();
            IASTName[] iASTNameArray = name.getTranslationUnit().getDeclarationsInAST(binding);
            int n = iASTNameArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IASTName aktName = iASTNameArray[n2];
                if (!ASTHelper.isClassDeklarationName(aktName)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static IASTCompositeTypeSpecifier getCompositeTypeSpecifierForName(IASTName name) {
        IBinding binding = name.resolveBinding();
        IASTName[] iASTNameArray = name.getTranslationUnit().getDefinitionsInAST(binding);
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName aktName = iASTNameArray[n2];
            if (aktName.getParent() instanceof IASTCompositeTypeSpecifier) {
                return (IASTCompositeTypeSpecifier)aktName.getParent();
            }
            ++n2;
        }
        return null;
    }

    public static Collection<IASTFunctionDeclarator> getFunctionDeclaratorsForClass(IASTCompositeTypeSpecifier klass) {
        ArrayList<IASTFunctionDeclarator> declarators = new ArrayList<IASTFunctionDeclarator>();
        IASTDeclaration[] iASTDeclarationArray = klass.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration aktDeclaration = iASTDeclarationArray[n2];
            if (aktDeclaration instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)aktDeclaration).getDeclarators();
                int n3 = iASTDeclaratorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator aktDeclarator = iASTDeclaratorArray[n4];
                    if (aktDeclarator instanceof IASTFunctionDeclarator) {
                        declarators.add((IASTFunctionDeclarator)aktDeclarator);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return declarators;
    }

    public static Collection<IASTFunctionDefinition> getFunctionDefinitionsForClass(IASTCompositeTypeSpecifier klass) {
        ArrayList<IASTFunctionDefinition> definitions = new ArrayList<IASTFunctionDefinition>();
        for (IASTFunctionDeclarator aktDeclarator : ASTHelper.getFunctionDeclaratorsForClass(klass)) {
            IBinding binding = aktDeclarator.getName().resolveBinding();
            IASTName[] iASTNameArray = aktDeclarator.getTranslationUnit().getDefinitionsInAST(binding);
            int n = iASTNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName aktName = iASTNameArray[n2];
                if (aktName.getParent().getParent().getParent() instanceof IASTFunctionDefinition) {
                    definitions.add((IASTFunctionDefinition)aktName.getParent().getParent().getParent());
                }
                ++n2;
            }
        }
        return definitions;
    }
}

