/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;

public class SelectionHelper {
    public static Region getRegion(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection txtSelection = (ITextSelection)selection;
            return new Region(txtSelection.getOffset(), txtSelection.getLength());
        }
        return null;
    }

    public static IASTSimpleDeclaration findFirstSelectedDeclaration(final Region textSelection, IASTTranslationUnit translationUnit) {
        final Container container = new Container();
        translationUnit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof IASTSimpleDeclaration && SelectionHelper.isSelectionOnExpression(textSelection, (IASTNode)declaration)) {
                    container.setObject((IASTSimpleDeclaration)declaration);
                }
                return super.visit(declaration);
            }
        });
        return (IASTSimpleDeclaration)container.getObject();
    }

    public static boolean isSelectionOnExpression(Region textSelection, IASTNode expression) {
        Region exprPos = SelectionHelper.createExpressionPosition(expression);
        int selStart = textSelection.getOffset();
        int selEnd = textSelection.getLength() + selStart;
        return exprPos.getOffset() + exprPos.getLength() >= selStart && exprPos.getOffset() <= selEnd;
    }

    public static boolean isExpressionWhollyInSelection(Region textSelection, IASTNode expression) {
        Region exprPos = SelectionHelper.createExpressionPosition(expression);
        int selStart = textSelection.getOffset();
        int selEnd = textSelection.getLength() + selStart;
        return exprPos.getOffset() >= selStart && exprPos.getOffset() + exprPos.getLength() <= selEnd;
    }

    public static boolean isInSameFile(IASTNode node, IFile file) {
        Path path = new Path(node.getContainingFilename());
        IFile locFile = ResourcesPlugin.getWorkspace().getRoot().getFile(file.getLocation());
        IFile tmpFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return locFile.equals((Object)tmpFile);
    }

    public static boolean isInSameFileSelection(Region textSelection, IASTNode node, IFile file) {
        if (SelectionHelper.isInSameFile(node, file)) {
            return SelectionHelper.isSelectionOnExpression(textSelection, node);
        }
        return false;
    }

    public static boolean isSelectedFile(Region textSelection, IASTNode node, IFile file) {
        if (SelectionHelper.isInSameFile(node, file)) {
            return SelectionHelper.isExpressionWhollyInSelection(textSelection, node);
        }
        return false;
    }

    protected static Region createExpressionPosition(IASTNode expression) {
        int start = 0;
        int nodeLength = 0;
        IASTNodeLocation[] nodeLocations = expression.getNodeLocations();
        if (nodeLocations.length != 1) {
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    start = macroLoc.asFileLocation().getNodeOffset();
                    nodeLength = macroLoc.asFileLocation().getNodeLength();
                }
                ++n2;
            }
        } else if (nodeLocations[0] instanceof IASTMacroExpansionLocation) {
            IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)nodeLocations[0];
            start = macroLoc.asFileLocation().getNodeOffset();
            nodeLength = macroLoc.asFileLocation().getNodeLength();
        } else {
            IASTFileLocation loc = expression.getFileLocation();
            start = loc.getNodeOffset();
            nodeLength = loc.getNodeLength();
        }
        return new Region(start, nodeLength);
    }
}

