/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDeclarationsAction
extends SelectionParseAction
implements ASTCache.ASTRunnable {
    public static boolean sIsJUnitTest = false;
    public static boolean sAllowFallback = true;
    private static final int KIND_OTHER = 0;
    private static final int KIND_USING_DECL = 1;
    private static final int KIND_DEFINITION = 2;
    ITextSelection fTextSelection;
    private String fSelectedText;
    private ITranslationUnit fWorkingCopy;
    private IIndex fIndex;
    private IProgressMonitor fMonitor;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
    }

    protected IStatus performNavigation(IProgressMonitor monitor) throws CoreException {
        this.clearStatusLine();
        this.fMonitor = monitor;
        ICElement celem = this.fEditor.getInputCElement();
        if (!(celem instanceof ITranslationUnit)) {
            return Status.CANCEL_STATUS;
        }
        this.fWorkingCopy = (ITranslationUnit)celem;
        this.fIndex = CCorePlugin.getIndexManager().getIndex(this.fWorkingCopy.getCProject(), 3);
        try {
            this.fIndex.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            IStatus iStatus = ASTProvider.getASTProvider().runOnAST((ICElement)this.fWorkingCopy, ASTProvider.WAIT_ACTIVE_ONLY, monitor, this);
            return iStatus;
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
        if (ast == null) {
            return Status.OK_STATUS;
        }
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName searchName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        if (searchName != null) {
            boolean found = false;
            IASTNode parent = searchName.getParent();
            if (parent instanceof IASTPreprocessorIncludeStatement) {
                this.openInclude((IASTPreprocessorIncludeStatement)parent);
                return Status.OK_STATUS;
            }
            IBinding binding = searchName.resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                IName[] declNames;
                int isKind = 0;
                if (searchName.isDefinition()) {
                    isKind = binding instanceof ICPPUsingDeclaration ? 1 : 2;
                }
                if ((declNames = this.findNames(this.fIndex, ast, isKind, binding)).length == 0) {
                    ICPPMethod method;
                    if (binding instanceof ICPPSpecialization) {
                        IBinding specialized = ((ICPPSpecialization)binding).getSpecializedBinding();
                        if (specialized != null && !(specialized instanceof IProblemBinding)) {
                            declNames = this.findNames(this.fIndex, ast, 2, specialized);
                        }
                    } else if (binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit()) {
                        try {
                            ICPPClassType clsBinding = method.getClassOwner();
                            if (clsBinding != null && !(clsBinding instanceof IProblemBinding)) {
                                declNames = this.findNames(this.fIndex, ast, 0, (IBinding)clsBinding);
                            }
                        }
                        catch (DOMException dOMException) {}
                    }
                }
                found = this.navigateViaCElements(this.fWorkingCopy.getCProject(), this.fIndex, declNames) ? true : this.navigateOneLocation(declNames);
            }
            if (!found && !this.navigationFallBack(ast)) {
                this.reportSymbolLookupFailure(new String(searchName.toCharArray()));
            }
            return Status.OK_STATUS;
        }
        IASTNode node = nodeSelector.findEnclosingNode(selectionStart, selectionLength);
        if (node instanceof IASTPreprocessorIncludeStatement) {
            this.openInclude((IASTPreprocessorIncludeStatement)node);
            return Status.OK_STATUS;
        }
        if (!this.navigationFallBack(ast)) {
            this.reportSelectionMatchFailure();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - void declaration
     */
    private boolean navigationFallBack(IASTTranslationUnit ast) {
        if (sAllowFallback && this.fSelectedText != null && this.fSelectedText.length() > 0) {
            try {
                IIndexMacro[] macros;
                void var12_12;
                IIndexBinding[] idxBindings;
                IASTName[] candidates;
                ICProject project = this.fWorkingCopy.getCProject();
                char[] name = this.fSelectedText.toCharArray();
                ArrayList<ICElement> elems = new ArrayList<ICElement>();
                HashSet<Object> bindings = new HashSet<Object>();
                HashSet<IIndexBinding> ignoreIndexBindings = new HashSet<IIndexBinding>();
                ASTNameCollector nc = new ASTNameCollector(this.fSelectedText);
                ast.accept((ASTVisitor)nc);
                IASTName[] iASTNameArray = candidates = nc.getNames();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName astName = iASTNameArray[n2];
                    try {
                        IBinding b = astName.resolveBinding();
                        if (b != null && !(b instanceof IProblemBinding) && bindings.add(b)) {
                            ignoreIndexBindings.add(this.fIndex.adaptBinding(b));
                        }
                    }
                    catch (RuntimeException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                    ++n2;
                }
                IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
                IIndexBinding[] n5 = idxBindings = this.fIndex.findBindings(name, false, filter, this.fMonitor);
                int n3 = idxBindings.length;
                boolean n4 = false;
                while (var12_12 < n3) {
                    IIndexBinding idxBinding = n5[var12_12];
                    if (!ignoreIndexBindings.contains(idxBinding)) {
                        bindings.add(idxBinding);
                    }
                    ++var12_12;
                }
                IIndexMacro[] iIndexMacroArray = macros = this.fIndex.findMacros(name, filter, this.fMonitor);
                int n6 = macros.length;
                n3 = 0;
                while (n3 < n6) {
                    IIndexMacro iIndexMacro = iIndexMacroArray[n3];
                    ICElementHandle elem = IndexUI.getCElementForMacro(project, this.fIndex, iIndexMacro);
                    if (elem != null) {
                        elems.add((ICElement)elem);
                    }
                    ++n3;
                }
                for (IBinding iBinding : bindings) {
                    IName[] names = this.findNames(this.fIndex, ast, 0, iBinding);
                    this.convertToCElements(project, this.fIndex, names, elems);
                }
                return this.navigateCElements(elems);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return false;
    }

    private void openInclude(IASTPreprocessorIncludeStatement incStmt) {
        String name = null;
        if (incStmt.isResolved()) {
            name = incStmt.getPath();
        }
        if (name != null) {
            Path path = new Path(name);
            this.runInUIThread(new Runnable((IPath)path){
                private final /* synthetic */ IPath val$path;
                {
                    this.val$path = iPath;
                }

                public void run() {
                    try {
                        OpenDeclarationsAction.this.open(this.val$path, 0, 0);
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            });
        } else {
            this.reportIncludeLookupFailure(new String(incStmt.getName().toCharArray()));
        }
    }

    private boolean navigateOneLocation(IName[] declNames) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            IASTFileLocation fileloc = declName.getFileLocation();
            if (fileloc != null) {
                Path path = new Path(fileloc.getFileName());
                int offset = fileloc.getNodeOffset();
                int length = fileloc.getNodeLength();
                this.runInUIThread(new Runnable((IPath)path, offset, length){
                    private final /* synthetic */ IPath val$path;
                    private final /* synthetic */ int val$offset;
                    private final /* synthetic */ int val$length;
                    {
                        this.val$path = iPath;
                        this.val$offset = n;
                        this.val$length = n2;
                    }

                    public void run() {
                        try {
                            OpenDeclarationsAction.this.open(this.val$path, this.val$offset, this.val$length);
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                        }
                    }
                });
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean navigateViaCElements(ICProject project, IIndex index, IName[] declNames) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>();
        this.convertToCElements(project, index, declNames, elements);
        return this.navigateCElements(elements);
    }

    private void convertToCElements(ICProject project, IIndex index, IName[] declNames, List<ICElement> elements) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            try {
                ICElementHandle elem = this.getCElementForName(project, index, declName);
                if (elem instanceof ISourceReference) {
                    elements.add((ICElement)elem);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
            ++n2;
        }
    }

    private boolean navigateCElements(final List<ICElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        this.runInUIThread(new Runnable(){

            public void run() {
                ISourceReference target = null;
                if (elements.size() == 1) {
                    target = (ISourceReference)elements.get(0);
                } else {
                    if (sIsJUnitTest) {
                        throw new RuntimeException("ambiguous input");
                    }
                    ICElement[] elemArray = elements.toArray(new ICElement[elements.size()]);
                    target = (ISourceReference)OpenActionUtil.selectCElement(elemArray, OpenDeclarationsAction.this.getSite().getShell(), CEditorMessages.getString("OpenDeclarationsAction.dialog.title"), CEditorMessages.getString("OpenDeclarationsAction.selectMessage"), -2112870367, 0);
                }
                if (target != null) {
                    ITranslationUnit tu = target.getTranslationUnit();
                    try {
                        ISourceRange sourceRange = target.getSourceRange();
                        if (tu != null && sourceRange != null) {
                            OpenDeclarationsAction.this.open(tu.getLocation(), sourceRange.getIdStartPos(), sourceRange.getIdLength());
                        }
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
        });
        return true;
    }

    private ICElementHandle getCElementForName(ICProject project, IIndex index, IName declName) throws CoreException {
        if (declName instanceof IIndexName) {
            return IndexUI.getCElementForName(project, index, (IIndexName)declName);
        }
        if (declName instanceof IASTName) {
            ITranslationUnit tu;
            IASTName astName = (IASTName)declName;
            IBinding binding = astName.resolveBinding();
            if (binding != null && (tu = IndexUI.getTranslationUnit(project, (IName)astName)) != null) {
                IASTFileLocation loc = astName.getFileLocation();
                Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
                return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)astName.isDefinition(), (IRegion)region, (long)0L);
            }
            return null;
        }
        return null;
    }

    private IName[] findNames(IIndex index, IASTTranslationUnit ast, int isKind, IBinding binding) throws CoreException {
        IName[] declNames = isKind == 2 ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, isKind, binding);
        if (declNames.length == 0) {
            declNames = isKind == 2 ? this.findDefinitions(index, ast, isKind, binding) : this.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, int isKind, IBinding binding) throws CoreException {
        ArrayList declNames = new ArrayList();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            if (!(name.resolveBinding() instanceof ICPPUsingDeclaration)) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] declNames = ast.getDeclarationsInAST(binding);
        int i = 0;
        while (i < declNames.length) {
            Object name = declNames[i];
            if (name.isDefinition()) {
                declNames[i] = null;
            }
            ++i;
        }
        if ((declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames)).length == 0) {
            declNames = index.findNames(binding, 9);
        }
        return declNames;
    }

    public void run() {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            new WrapperJob().schedule();
        }
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void runSync() throws CoreException {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            this.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void computeSelectedWord() {
        this.fTextSelection = this.getSelectedStringFromEditor();
        this.fSelectedText = null;
        if (this.fTextSelection != null) {
            if (this.fTextSelection.getLength() > 0) {
                this.fSelectedText = this.fTextSelection.getText();
            } else {
                IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                IRegion reg = CWordFinder.findWord(document, this.fTextSelection.getOffset());
                if (reg != null && reg.getLength() > 0) {
                    try {
                        this.fSelectedText = document.get(reg.getOffset(), reg.getLength());
                    }
                    catch (BadLocationException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                }
            }
        }
    }

    private static final class ASTNameCollector
    extends ASTVisitor {
        private char[] fName;
        private ArrayList<IASTName> fFound = new ArrayList(4);

        public ASTNameCollector(char[] name) {
            Assert.isNotNull((Object)name);
            this.fName = name;
            this.shouldVisitNames = true;
        }

        public ASTNameCollector(String name) {
            this(name.toCharArray());
        }

        public int visit(IASTName name) {
            if (name != null && !(name instanceof ICPPASTQualifiedName) && !(name instanceof ICPPASTTemplateId) && CharArrayUtils.equals((char[])this.fName, (char[])name.toCharArray())) {
                this.fFound.add(name);
            }
            return 3;
        }

        public IASTName[] getNames() {
            return this.fFound.toArray(new IASTName[this.fFound.size()]);
        }
    }

    private class WrapperJob
    extends Job {
        WrapperJob() {
            super(CEditorMessages.getString("OpenDeclarations.dialog.title"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                return OpenDeclarationsAction.this.performNavigation(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

