/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCompletionProposalComputer
extends ParsingBasedProposalComputer {
    @Override
    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext cContext, IASTCompletionNode completionNode, String prefix) throws CoreException {
        boolean handleHelp = false;
        if (completionNode != null) {
            IASTName[] names = completionNode.getNames();
            int i = 0;
            while (i < names.length) {
                IASTName name = names[i];
                if (name.getTranslationUnit() != null && !(name.getParent() instanceof IASTFieldReference)) {
                    handleHelp = true;
                    break;
                }
                ++i;
            }
        }
        if (!handleHelp) {
            return Collections.emptyList();
        }
        final ITranslationUnit tu = cContext.getTranslationUnit();
        ICHelpInvocationContext helpContext = new ICHelpInvocationContext(){

            public IProject getProject() {
                return tu.getCProject().getProject();
            }

            public ITranslationUnit getTranslationUnit() {
                return tu;
            }
        };
        IFunctionSummary[] summaries = CHelpProviderManager.getDefault().getMatchingFunctions(helpContext, prefix);
        if (summaries == null) {
            return Collections.emptyList();
        }
        int repOffset = cContext.getInvocationOffset() - prefix.length();
        int repLength = prefix.length();
        Image image = CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getFunctionImageDescriptor());
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IFunctionSummary[] iFunctionSummaryArray = summaries;
        int n = summaries.length;
        int n2 = 0;
        while (n2 < n) {
            IFunctionSummary summary = iFunctionSummaryArray[n2];
            String fname = String.valueOf(summary.getName()) + "()";
            String fdesc = summary.getDescription();
            IFunctionSummary.IFunctionPrototypeSummary fproto = summary.getPrototype();
            String fargs = fproto.getArguments();
            int relevance = this.computeBaseRelevance(prefix, summary.getName()) + 200;
            CCompletionProposal proposal = new CCompletionProposal(fname, repOffset, repLength, image, fproto.getPrototypeString(true), relevance, cContext.getViewer());
            if (fdesc != null) {
                proposal.setAdditionalProposalInfo(fdesc);
            }
            if (!cContext.isContextInformationStyle()) {
                proposal.setCursorPosition(fname.length() - 1);
            }
            if (fargs != null && fargs.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(image, fname, fargs);
                info.setContextInformationPosition(cContext.getContextInformationOffset());
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
            ++n2;
        }
        return proposals;
    }
}

