/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.doctools;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwner;
import org.eclipse.cdt.internal.ui.text.doctools.Messages;
import org.eclipse.cdt.internal.ui.text.doctools.NullDocCommentOwner;
import org.eclipse.cdt.internal.ui.text.doctools.ProjectMap;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwnershipListener;
import org.eclipse.cdt.ui.text.doctools.IDocCommentViewerConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocCommentOwnerManager {
    private static final String ELEMENT_OWNER = "owner";
    private static final String ATTRKEY_OWNER_ID = "id";
    private static final String ATTRKEY_OWNER_NAME = "name";
    private static final String ATTRKEY_OWNER_SINGLELINE = "singleline";
    private static final String ATTRKEY_OWNER_MULTILINE = "multiline";
    private static final String QUALIFIER = "org.eclipse.cdt.core";
    private static final String WORKSPACE_DOC_TOOL_NODE = "doctool";
    private static final String PREFKEY_WORKSPACE_DEFAULT = "workspace.default";
    private static DocCommentOwnerManager singleton;
    private Map<String, IDocCommentOwner> fOwners;
    private IDocCommentOwner fWorkspaceOwner;
    private Map<IProject, ProjectMap> prj2map = new HashMap<IProject, ProjectMap>();
    private static List<IDocCommentOwnershipListener> fListeners;

    public static DocCommentOwnerManager getInstance() {
        return singleton == null ? (singleton = new DocCommentOwnerManager()) : singleton;
    }

    private DocCommentOwnerManager() {
        this.fOwners = DocCommentOwnerManager.getCommentOwnerExtensions();
        fListeners = new ArrayList<IDocCommentOwnershipListener>();
        Preferences prefs = new InstanceScope().getNode(QUALIFIER).node(WORKSPACE_DOC_TOOL_NODE);
        String id = prefs.get(PREFKEY_WORKSPACE_DEFAULT, NullDocCommentOwner.INSTANCE.getID());
        this.fWorkspaceOwner = this.getOwner(id);
        if (this.fWorkspaceOwner == null) {
            this.fWorkspaceOwner = NullDocCommentOwner.INSTANCE;
        }
    }

    public boolean projectDefinesOwnership(IProject project) {
        return !this.getProjectMap((IResource)project).isEmpty();
    }

    public void setWorkspaceCommentOwner(IDocCommentOwner newOwner) {
        if (newOwner == null) {
            throw new IllegalArgumentException();
        }
        if (!this.fWorkspaceOwner.getID().equals(newOwner.getID())) {
            IDocCommentOwner oldOwner = this.fWorkspaceOwner;
            this.fWorkspaceOwner = newOwner;
            Preferences prefs = new InstanceScope().getNode(QUALIFIER).node(WORKSPACE_DOC_TOOL_NODE);
            prefs.put(PREFKEY_WORKSPACE_DEFAULT, newOwner.getID());
            this.fireWorkspaceOwnershipChanged(oldOwner, this.fWorkspaceOwner);
        }
    }

    public IDocCommentOwner getWorkspaceCommentOwner() {
        return this.fWorkspaceOwner;
    }

    public IDocCommentOwner getCommentOwner(IResource resource) {
        if (resource == null) {
            return NullDocCommentOwner.INSTANCE;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)resource)) {
            return this.getWorkspaceCommentOwner();
        }
        ProjectMap pm = this.getProjectMap(resource);
        String ownerID = pm.getOwnerID(resource);
        IDocCommentOwner result = this.getOwner(ownerID);
        return result == null ? this.fWorkspaceOwner : result;
    }

    public IDocCommentOwner getOwner(String id) {
        if (NullDocCommentOwner.INSTANCE.getID().equals(id)) {
            return NullDocCommentOwner.INSTANCE;
        }
        return this.fOwners.get(id);
    }

    public void setCommentOwner(IResource resource, IDocCommentOwner newOwner, boolean removeSubMappings) {
        Assert.isNotNull((Object)resource);
        if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)resource)) {
            this.setWorkspaceCommentOwner(newOwner);
            return;
        }
        ProjectMap pm = this.getProjectMap(resource);
        IDocCommentOwner oldOwner = this.getCommentOwner(resource);
        pm.setCommentOwner(resource, newOwner);
        IDocCommentOwner newLogicalOwner = this.getCommentOwner(resource);
        if (!newLogicalOwner.getID().equals(oldOwner.getID())) {
            this.fireOwnershipChanged(resource, removeSubMappings, oldOwner, newLogicalOwner);
        }
    }

    public IDocCommentOwner[] getRegisteredOwners() {
        return this.fOwners.values().toArray(new IDocCommentOwner[this.fOwners.values().size()]);
    }

    public void addListener(IDocCommentOwnershipListener listener) {
        if (!fListeners.contains(listener)) {
            fListeners.add(listener);
        }
    }

    public void removeListener(IDocCommentOwnershipListener listener) {
        fListeners.remove(listener);
    }

    private ProjectMap getProjectMap(IResource resource) {
        Assert.isNotNull((Object)resource);
        IProject project = resource.getProject();
        if (!this.prj2map.containsKey(project)) {
            this.prj2map.put(project, new ProjectMap(project));
        }
        return this.prj2map.get(project);
    }

    private static Map<String, IDocCommentOwner> getCommentOwnerExtensions() {
        IExtension[] extensions;
        HashMap<String, IDocCommentOwner> result = new HashMap<String, IDocCommentOwner>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexProviders = registry.getExtensionPoint("org.eclipse.cdt.ui.DocCommentOwner");
        IExtension[] iExtensionArray = extensions = indexProviders.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                IConfigurationElement[] ce;
                IConfigurationElement[] iConfigurationElementArray = ce = extension.getConfigurationElements();
                int n3 = ce.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_OWNER)) {
                        String name;
                        IDocCommentViewerConfiguration multi = (IDocCommentViewerConfiguration)element.createExecutableExtension(ATTRKEY_OWNER_MULTILINE);
                        IDocCommentViewerConfiguration single = (IDocCommentViewerConfiguration)element.createExecutableExtension(ATTRKEY_OWNER_SINGLELINE);
                        String id = element.getAttribute(ATTRKEY_OWNER_ID);
                        if (result.put(id, new DocCommentOwner(id, name = element.getAttribute(ATTRKEY_OWNER_NAME), multi, single)) != null) {
                            String msg = MessageFormat.format(Messages.DocCommentOwnerManager_DuplicateMapping0, id);
                            CCorePlugin.log((IStatus)new Status(2, "org.eclipse.cdt.ui", msg));
                        }
                    }
                    ++n4;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log((Throwable)ce);
            }
            ++n2;
        }
        return result;
    }

    private void fireOwnershipChanged(IResource resource, boolean submappingsRemoved, IDocCommentOwner oldOwner, IDocCommentOwner newOwner) {
        for (IDocCommentOwnershipListener docCommentOwnershipListener : fListeners) {
            docCommentOwnershipListener.ownershipChanged(resource, submappingsRemoved, oldOwner, newOwner);
        }
    }

    private void fireWorkspaceOwnershipChanged(IDocCommentOwner oldOwner, IDocCommentOwner newOwner) {
        for (IDocCommentOwnershipListener element : fListeners) {
            element.workspaceOwnershipChanged(oldOwner, newOwner);
        }
    }
}

