/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.spelling.AddWordProposal;
import org.eclipse.cdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.eclipse.cdt.internal.ui.text.spelling.DisableSpellCheckingProposal;
import org.eclipse.cdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.cdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.cdt.ui.text.IProblemLocation;
import org.eclipse.cdt.ui.text.IQuickFixProcessor;
import org.eclipse.core.runtime.CoreException;

public class WordQuickFixProcessor
implements IQuickFixProcessor {
    public ICCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        int threshold = SpellingPreferences.spellingProposalThreshold();
        int size = 0;
        List<RankedWordProposal> proposals = null;
        String[] arguments = null;
        IProblemLocation location = null;
        RankedWordProposal proposal = null;
        ICCompletionProposal[] result = null;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            int index = 0;
            while (index < locations.length) {
                location = locations[index];
                if (location.getProblemId() == Integer.MIN_VALUE && (arguments = location.getProblemArguments()) != null && arguments.length > 4) {
                    sentence = Boolean.valueOf(arguments[3]);
                    match = Boolean.valueOf(arguments[4]);
                    boolean bl = fixed = arguments[0].charAt(0) == '<';
                    if (sentence && match && !fixed) {
                        result = new ICCompletionProposal[]{new ChangeCaseProposal(arguments, location.getOffset(), location.getLength(), context, engine.getLocale())};
                        break;
                    }
                    proposals = new ArrayList<RankedWordProposal>(checker.getProposals(arguments[0], sentence));
                    size = proposals.size();
                    if (threshold > 0 && size > threshold) {
                        Collections.sort(proposals);
                        proposals = proposals.subList(size - threshold - 1, size - 1);
                        size = proposals.size();
                    }
                    boolean extendable = !fixed ? checker.acceptsWords() || AddWordProposal.canAskToConfigure() : false;
                    result = new ICCompletionProposal[size + (extendable ? 3 : 2)];
                    index = 0;
                    while (index < size) {
                        proposal = proposals.get(index);
                        result[index] = new WordCorrectionProposal(proposal.getText(), arguments, location.getOffset(), location.getLength(), context, proposal.getRank());
                        ++index;
                    }
                    if (extendable) {
                        result[index++] = new AddWordProposal(arguments[0], context);
                    }
                    result[index++] = new WordIgnoreProposal(arguments[0], context);
                    result[index++] = new DisableSpellCheckingProposal(context);
                    break;
                }
                ++index;
            }
        }
        return result;
    }

    public final boolean hasCorrections(ITranslationUnit unit, int id) {
        return id == Integer.MIN_VALUE;
    }
}

