/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSelector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.viewsupport.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;

public class IndexUI {
    private static final ICElementHandle[] EMPTY_ELEMENTS = new ICElementHandle[0];

    public static IIndexBinding elementToBinding(IIndex index, ICElement element) throws CoreException {
        return IndexUI.elementToBinding(index, element, -1);
    }

    public static IIndexBinding elementToBinding(IIndex index, ICElement element, int linkageID) throws CoreException {
        if (element instanceof ISourceReference) {
            ISourceReference sf = (ISourceReference)element;
            ISourceRange range = sf.getSourceRange();
            if (range.getIdLength() != 0) {
                IIndexName name = IndexUI.elementToName(index, element, linkageID);
                if (name != null) {
                    return index.findBinding((IName)name);
                }
            } else {
                String name = element.getElementName();
                name = name.substring(name.lastIndexOf(58) + 1);
                IIndexBinding[] bindings = index.findBindings(name.toCharArray(), IndexFilter.ALL, (IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < bindings.length) {
                    IIndexBinding binding = bindings[i];
                    if (IndexUI.checkBinding(binding, element)) {
                        return binding;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private static boolean checkBinding(IIndexBinding binding, ICElement element) {
        try {
            switch (element.getElementType()) {
                case 63: {
                    return binding instanceof IEnumeration;
                }
                case 61: {
                    return binding instanceof ICPPNamespace;
                }
                case 66: 
                case 67: {
                    return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 1;
                }
                case 64: 
                case 65: {
                    return binding instanceof ICPPClassType && ((ICompositeType)binding).getKey() == 3;
                }
                case 68: 
                case 69: {
                    return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 2;
                }
                case 80: {
                    return binding instanceof ITypedef;
                }
                case 70: 
                case 71: {
                    return binding instanceof ICPPMethod;
                }
                case 72: {
                    return binding instanceof IField;
                }
                case 73: 
                case 74: {
                    return binding instanceof ICPPFunction && !(binding instanceof ICPPMethod);
                }
                case 76: 
                case 77: {
                    return binding instanceof IVariable;
                }
                case 81: {
                    return binding instanceof IEnumerator;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: {
                    return binding instanceof ICPPClassTemplate;
                }
                case 88: 
                case 89: {
                    return binding instanceof ICPPFunctionTemplate && !(binding instanceof ICPPMethod);
                }
                case 90: 
                case 91: {
                    return binding instanceof ICPPFunctionTemplate && binding instanceof ICPPMethod;
                }
                case 92: {
                    return binding instanceof ICPPTemplateParameter;
                }
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    public static IIndexName elementToName(IIndex index, ICElement element) throws CoreException {
        return IndexUI.elementToName(index, element, -1);
    }

    public static IIndexName elementToName(IIndex index, ICElement element, int linkageID) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            int i = 0;
            while (i < files.length) {
                IIndexFile file = files[i];
                if (linkageID == -1 || file.getLinkageID() == linkageID) {
                    String elementName = element.getElementName();
                    int idx = elementName.lastIndexOf(":") + 1;
                    ISourceRange pos = sf.getSourceRange();
                    IRegion region = IndexUI.getConvertedRegion(tu, file, pos.getIdStartPos() + idx, pos.getIdLength() - idx);
                    IIndexName[] names = file.findNames(region.getOffset(), region.getLength());
                    int j = 0;
                    while (j < names.length) {
                        IIndexName name = names[j];
                        if (!name.isReference() && elementName.endsWith(new String(name.toCharArray()))) {
                            return name;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isIndexed(IIndex index, ICElement element) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            return files.length > 0;
        }
        return false;
    }

    private static IRegion getConvertedRegion(ITranslationUnit tu, IIndexFile file, int pos, int length) throws CoreException {
        Region region = new Region(pos, length);
        IPositionConverter converter = CCorePlugin.getPositionTrackerManager().findPositionConverter(tu, file.getTimestamp());
        if (converter != null) {
            region = converter.actualToHistoric((IRegion)region);
        }
        return region;
    }

    public static IIndexInclude elementToInclude(IIndex index, IInclude include) throws CoreException {
        IIndexFileLocation location;
        ITranslationUnit tu;
        if (include != null && (tu = include.getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            int j = 0;
            while (j < files.length) {
                IIndexFile file = files[j];
                String elementName = include.getElementName();
                elementName = elementName.substring(elementName.lastIndexOf(47) + 1);
                ISourceRange pos = include.getSourceRange();
                IRegion region = IndexUI.getConvertedRegion(tu, file, pos.getIdStartPos(), pos.getIdLength());
                IIndexInclude[] includes = index.findIncludes(file);
                int bestDiff = Integer.MAX_VALUE;
                IIndexInclude best = null;
                int i = 0;
                while (i < includes.length) {
                    IIndexInclude candidate = includes[i];
                    int diff = Math.abs(candidate.getNameOffset() - region.getOffset());
                    if (diff > bestDiff) break;
                    if (candidate.getName().endsWith(elementName)) {
                        bestDiff = diff;
                        best = candidate;
                    }
                    ++i;
                }
                if (best != null) {
                    return best;
                }
                ++j;
            }
        }
        return null;
    }

    public static ICElementHandle[] findRepresentative(IIndex index, IBinding binding) throws CoreException {
        ICElementHandle elem;
        ICElementHandle[] defs = IndexUI.findAllDefinitions(index, binding);
        if (defs.length == 0 && (elem = IndexUI.findAnyDeclaration(index, null, binding)) != null) {
            defs = new ICElementHandle[]{elem};
        }
        return defs;
    }

    public static ICElementHandle[] findAllDefinitions(IIndex index, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] defs = index.findNames(binding, 10);
            ArrayList<ICElementHandle> result = new ArrayList<ICElementHandle>();
            int i = 0;
            while (i < defs.length) {
                IIndexName in = defs[i];
                ICElementHandle definition = IndexUI.getCElementForName(null, index, in);
                if (definition != null) {
                    result.add(definition);
                }
                ++i;
            }
            return result.toArray(new ICElementHandle[result.size()]);
        }
        return EMPTY_ELEMENTS;
    }

    public static ICElementHandle getCElementForName(ICProject preferProject, IIndex index, IASTName declName) throws CoreException {
        ITranslationUnit tu;
        assert (!declName.isReference());
        IBinding binding = declName.resolveBinding();
        if (binding != null && (tu = IndexUI.getTranslationUnit(preferProject, (IName)declName)) != null) {
            IFile file = (IFile)tu.getResource();
            long timestamp = file != null ? file.getLocalTimeStamp() : 0L;
            IASTFileLocation loc = declName.getFileLocation();
            Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
            IPositionConverter converter = CCorePlugin.getPositionTrackerManager().findPositionConverter(tu, timestamp);
            if (converter != null) {
                region = converter.actualToHistoric((IRegion)region);
            }
            return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)declName.isDefinition(), (IRegion)region, (long)timestamp);
        }
        return null;
    }

    public static ITranslationUnit getTranslationUnit(ICProject cproject, IName name) {
        return IndexUI.getTranslationUnit(cproject, name.getFileLocation());
    }

    private static ITranslationUnit getTranslationUnit(ICProject cproject, IASTFileLocation fileLocation) {
        if (fileLocation != null) {
            IPath path = Path.fromOSString((String)fileLocation.getFileName());
            try {
                return CoreModelUtil.findTranslationUnitForLocation((IPath)path, (ICProject)cproject);
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
        return null;
    }

    public static ICElementHandle getCElementForName(ICProject preferProject, IIndex index, IIndexName declName) throws CoreException {
        assert (!declName.isReference());
        ITranslationUnit tu = IndexUI.getTranslationUnit(preferProject, (IName)declName);
        if (tu != null) {
            return IndexUI.getCElementForName(tu, index, declName);
        }
        return null;
    }

    public static ICElementHandle getCElementForName(ITranslationUnit tu, IIndex index, IIndexName declName) throws CoreException {
        Region region = new Region(declName.getNodeOffset(), declName.getNodeLength());
        long timestamp = declName.getFile().getTimestamp();
        return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)index.findBinding((IName)declName), (boolean)declName.isDefinition(), (IRegion)region, (long)timestamp);
    }

    public static ICElementHandle getCElementForMacro(ICProject preferProject, IIndex index, IIndexMacro macro) throws CoreException {
        IIndexName name;
        ITranslationUnit tu = IndexUI.getTranslationUnit(preferProject, macro.getFileLocation());
        if (tu != null && (name = macro.getDefinition()) != null) {
            Region region = new Region(name.getNodeOffset(), name.getNodeLength());
            long timestamp = macro.getFile().getTimestamp();
            return CElementHandleFactory.create((ITranslationUnit)tu, (IIndexMacro)macro, (IRegion)region, (long)timestamp);
        }
        return null;
    }

    public static ICElementHandle findAnyDeclaration(IIndex index, ICProject preferProject, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, 1);
            int i = 0;
            while (i < names.length) {
                ICElementHandle elem = IndexUI.getCElementForName(preferProject, index, names[i]);
                if (elem != null) {
                    return elem;
                }
                ++i;
            }
        }
        return null;
    }

    public static IASTName getSelectedName(IEditorInput editorInput, ITextSelection selection) throws CoreException {
        return IndexUI.getSelectedName(editorInput, selection.getOffset(), selection.getLength());
    }

    public static IASTName getSelectedName(IEditorInput editorInput, IRegion selection) throws CoreException {
        return IndexUI.getSelectedName(editorInput, selection.getOffset(), selection.getLength());
    }

    private static IASTName getSelectedName(IEditorInput editorInput, final int offset, final int length) {
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (workingCopy == null) {
            return null;
        }
        final IASTName[] result = new IASTName[1];
        ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_ACTIVE_ONLY, null, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                if (ast != null) {
                    IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                    IASTName name = nodeSelector.findEnclosingName(offset, length);
                    if (name != null && name.getParent() instanceof IASTPreprocessorMacroExpansion) {
                        IASTFileLocation floc = name.getParent().getFileLocation();
                        IASTNode node = ((ASTNodeSelector)nodeSelector).findEnclosingNodeInExpansion(floc.getNodeOffset(), floc.getNodeLength());
                        if (node instanceof IASTName) {
                            name = (IASTName)node;
                        } else if (node instanceof IASTFunctionCallExpression) {
                            IASTExpression expr = ((IASTFunctionCallExpression)node).getFunctionNameExpression();
                            if (expr instanceof IASTIdExpression) {
                                name = ((IASTIdExpression)expr).getName();
                            }
                        } else {
                            if (node instanceof IASTSimpleDeclaration) {
                                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)node).getDeclarators();
                                if (dtors != null && dtors.length > 0) {
                                    node = dtors[0];
                                }
                            } else if (node instanceof IASTFunctionDefinition) {
                                node = ((IASTFunctionDefinition)node).getDeclarator();
                            }
                            if (node instanceof IASTDeclarator) {
                                IASTDeclarator dtor = CPPVisitor.findTypeRelevantDeclarator((IASTDeclarator)((IASTDeclarator)node));
                                name = dtor.getName();
                            }
                        }
                    }
                    result[0] = name;
                }
                return Status.OK_STATUS;
            }
        });
        return result[0];
    }

    public static String getFileNotIndexedMessage(ICElement input) {
        Properties props;
        ITranslationUnit tu = null;
        if (input instanceof ISourceReference) {
            ISourceReference ref = (ISourceReference)input;
            tu = ref.getTranslationUnit();
        }
        if (tu == null) {
            return NLS.bind((String)Messages.IndexUI_infoNotInSource, (Object)input.getElementName());
        }
        String msg = NLS.bind((String)Messages.IndexUI_infoNotInIndex, (Object)tu.getElementName());
        IResource res = tu.getResource();
        if (!(res == null || (props = IndexerPreferences.getProperties((IProject)res.getProject())) != null && "true".equals(props.get("indexAllFiles")))) {
            msg = String.valueOf(msg) + " " + Messages.IndexUI_infoSelectIndexAllFiles;
        }
        return msg;
    }

    public static ICElement attemptConvertionToHandle(IIndex index, ICElement input) throws CoreException {
        ICElementHandle handle;
        if (input instanceof ICElementHandle) {
            return input;
        }
        IIndexName name = IndexUI.elementToName(index, input);
        if (name != null && (handle = IndexUI.getCElementForName(input.getCProject(), index, name)) != null) {
            return handle;
        }
        return input;
    }
}

