/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabFolderOptionBlock {
    protected boolean initializingTabs = true;
    private Composite composite;
    private boolean bShowMessageArea;
    private String fErrorMessage;
    private boolean bIsValid = true;
    private Label messageLabel;
    private ArrayList<ICOptionPage> pages = new ArrayList();
    protected ICOptionContainer fParent;
    private ICOptionPage fCurrentPage;
    private TabFolder fFolder;

    public TabFolderOptionBlock(boolean showMessageArea) {
        this.bShowMessageArea = showMessageArea;
    }

    public TabFolderOptionBlock(ICOptionContainer parent, boolean showMessageArea) {
        this.bShowMessageArea = showMessageArea;
        this.setOptionContainer(parent);
    }

    public void setOptionContainer(ICOptionContainer parent) {
        this.fParent = parent;
    }

    public TabFolderOptionBlock(ICOptionContainer parent) {
        this(parent, true);
    }

    protected void addOptionPage(ICOptionPage page) {
        if (!this.pages.contains(page)) {
            this.pages.add(page);
        }
    }

    protected List<ICOptionPage> getOptionPages() {
        return this.pages;
    }

    public Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        if (this.bShowMessageArea) {
            this.messageLabel = new Label(this.composite, 16384);
            this.messageLabel.setFont(this.composite.getFont());
            this.messageLabel.setLayoutData((Object)new GridData(768));
            Label separator = new Label(this.composite, 256);
            separator.setLayoutData((Object)new GridData(768));
        }
        this.createFolder(this.composite);
        this.addTabs();
        this.setCurrentPage(this.pages.get(0));
        this.initializingTabs = false;
        String desc = this.pages.get(0).getDescription();
        if (this.messageLabel != null && desc != null) {
            this.messageLabel.setText(desc);
        }
        return this.composite;
    }

    protected ICOptionPage getStartPage() {
        return this.pages.get(0);
    }

    public int getPageIndex() {
        return this.pages.indexOf(this.getCurrentPage());
    }

    protected void createFolder(Composite parent) {
        this.fFolder = new TabFolder(parent, 0);
        this.fFolder.setLayoutData((Object)new GridData(1808));
        this.fFolder.setLayout((Layout)new TabFolderLayout());
        this.fFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TabFolderOptionBlock.this.initializingTabs) {
                    TabFolderOptionBlock.this.setCurrentPage((ICOptionPage)((TabItem)e.item).getData());
                    TabFolderOptionBlock.this.fParent.updateContainer();
                }
            }
        });
    }

    protected void addTab(ICOptionPage tab) {
        TabItem item = new TabItem(this.fFolder, 0);
        item.setText(tab.getTitle());
        Image img = tab.getImage();
        if (img != null) {
            item.setImage(img);
        }
        item.setData((Object)tab);
        tab.setContainer(this.fParent);
        tab.createControl((Composite)item.getParent());
        item.setControl(tab.getControl());
        this.addOptionPage(tab);
    }

    protected abstract void addTabs();

    public boolean performApply(IProgressMonitor monitor) {
        if (this.initializingTabs) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.pages.size());
        try {
            for (ICOptionPage tab : this.pages) {
                try {
                    tab.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    CUIPlugin.errorDialog(this.composite.getShell(), CUIMessages.getString("TabFolderOptionBlock.error"), CUIMessages.getString("TabFolderOptionBlock.error.settingOptions"), e, true);
                    monitor.done();
                    return false;
                }
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (this.initializingTabs) {
            return;
        }
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(visible);
        }
        this.update();
    }

    public void update() {
        if (this.initializingTabs) {
            return;
        }
        boolean ok = true;
        for (ICOptionPage tab : this.pages) {
            ok = tab.isValid();
            if (ok) continue;
            String errorMessage = tab.getErrorMessage();
            if (!tab.getControl().isVisible()) {
                this.setErrorMessage(CUIMessages.getFormattedString("TabFolderOptionBlock.error.message", tab.getTitle()));
                break;
            }
            this.setErrorMessage(errorMessage);
            break;
        }
        if (ok) {
            ICOptionPage tab;
            this.setErrorMessage(null);
            tab = this.getCurrentPage();
            if (this.messageLabel != null) {
                this.messageLabel.setText(tab.getDescription() != null ? tab.getDescription() : "");
            }
        }
        this.setValid(ok);
    }

    private void setValid(boolean ok) {
        this.bIsValid = ok;
    }

    private void setErrorMessage(String message) {
        this.fErrorMessage = message;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean isValid() {
        return this.bIsValid;
    }

    public void performDefaults() {
        if (this.initializingTabs) {
            return;
        }
        this.getCurrentPage().performDefaults();
    }

    public ICOptionPage getCurrentPage() {
        return this.fCurrentPage;
    }

    public void setCurrentPage(ICOptionPage page) {
        ICOptionPage oldPage = this.fCurrentPage;
        this.fCurrentPage = page;
        this.fCurrentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
    }
}

