/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.KVStringPair;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SCDOptionsEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CCommandDSC {
    private static final String SINGLE_SPACE = " ";
    private static final String CMD_DESCRIPTION_ELEM = "commandDescription";
    private static final String CMD_SI_ELEM = "commandScannerInfo";
    private static final String OPTION_ELEM = "option";
    private static final String SI_ITEM_ELEM = "siItem";
    private static final String KEY_ATTR = "key";
    private static final String VALUE_ATTR = "value";
    private static final String QUOTE_INCLUDE_ATTR = "quote";
    private static final String KIND_ATTR = "kind";
    private int commandId;
    private List compilerCommand = new ArrayList();
    private boolean discovered = false;
    private boolean cppFileType;
    private IProject project;
    private List symbols;
    private List includes;
    private List quoteIncludes;

    public CCommandDSC(boolean cppFileType) {
        this(cppFileType, null);
    }

    public CCommandDSC(boolean cppFileType, IProject project) {
        this.cppFileType = cppFileType;
        this.symbols = new ArrayList();
        this.includes = new ArrayList();
        this.quoteIncludes = new ArrayList();
        this.project = project;
    }

    public boolean appliesToCPPFileType() {
        return this.cppFileType;
    }

    public void addSCOption(KVStringPair option) {
        if (this.project != null && (option.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString()) || option.getKey().equals(SCDOptionsEnum.INCLUDE.toString()) || option.getKey().equals(SCDOptionsEnum.ISYSTEM.toString()) || option.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString()) || option.getKey().equals(SCDOptionsEnum.IQUOTE.toString()))) {
            String value = option.getValue();
            value = CygpathTranslator.translateIncludePaths(this.project, Collections.singletonList(value)).get(0);
            value = CCommandDSC.makeRelative(this.project, (IPath)new Path(value)).toOSString();
            option = new KVStringPair(option.getKey(), value);
        }
        this.compilerCommand.add(option);
    }

    public Integer getCommandIdAsInteger() {
        return new Integer(this.getCommandId());
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public String toString() {
        String commandAsString = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            String value = optionPair.getValue();
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + value + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public int getId() {
        return this.commandId;
    }

    public String getSCDRunnableCommand(boolean quoteIncludePaths, boolean quoteDefines) {
        String commandAsString = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (optionPair.getKey().equals(SCDOptionsEnum.COMMAND.toString())) {
                commandAsString = String.valueOf(commandAsString) + optionPair.getValue() + SINGLE_SPACE;
                continue;
            }
            if (optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString()) || optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            String value = optionPair.getValue();
            if (optionPair.getKey().equals(SCDOptionsEnum.INCLUDE.toString()) || optionPair.getKey().equals(SCDOptionsEnum.ISYSTEM.toString()) || optionPair.getKey().equals(SCDOptionsEnum.IQUOTE.toString())) {
                value = CCommandDSC.makeAbsolute(this.project, value);
                if (quoteIncludePaths) {
                    value = "\"" + value + "\"";
                }
            } else if (quoteDefines && optionPair.getKey().equals(SCDOptionsEnum.DEFINE.toString())) {
                if (value.indexOf(39) == -1) {
                    value = "'" + value + "'";
                } else {
                    value = value.replaceAll("\"", "\\\\\"");
                    value = "\"" + value + "\"";
                }
            }
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + value + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public String getCompilerName() {
        String compiler = new String();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.COMMAND.toString())) continue;
            compiler = optionPair.getValue();
            break;
        }
        return compiler.trim();
    }

    public List getImacrosFile() {
        ArrayList<String> imacrosFiles = new ArrayList<String>();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString())) continue;
            imacrosFiles.add(CCommandDSC.makeAbsolute(this.project, optionPair.getValue()));
        }
        return imacrosFiles;
    }

    public List getIncludeFile() {
        ArrayList<String> includeFiles = new ArrayList<String>();
        for (KVStringPair optionPair : this.compilerCommand) {
            if (!optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            includeFiles.add(CCommandDSC.makeAbsolute(this.project, optionPair.getValue()));
        }
        return includeFiles;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0.getClass().equals(this.getClass())) {
            CCommandDSC other = (CCommandDSC)arg0;
            return this.compilerCommand.equals(other.compilerCommand) && this.cppFileType == other.cppFileType;
        }
        return false;
    }

    public int hashCode() {
        return this.compilerCommand.hashCode();
    }

    public List getIncludes() {
        return CCommandDSC.makeAbsolute(this.project, this.includes);
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public List getQuoteIncludes() {
        return CCommandDSC.makeAbsolute(this.project, this.quoteIncludes);
    }

    public void setQuoteIncludes(List includes) {
        this.quoteIncludes = includes;
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List symbols) {
        this.symbols = symbols;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    public void serialize(Element cmdElem) {
        Element siItem;
        Document doc = cmdElem.getOwnerDocument();
        Element cmdDescElem = doc.createElement(CMD_DESCRIPTION_ELEM);
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            Element optionElem = doc.createElement(OPTION_ELEM);
            KVStringPair option = (KVStringPair)i.next();
            optionElem.setAttribute(KEY_ATTR, option.getKey());
            optionElem.setAttribute(VALUE_ATTR, option.getValue());
            cmdDescElem.appendChild(optionElem);
        }
        cmdElem.appendChild(cmdDescElem);
        Element siElem = doc.createElement(CMD_SI_ELEM);
        Iterator j = this.quoteIncludes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siItem.setAttribute(QUOTE_INCLUDE_ATTR, "true");
            siElem.appendChild(siItem);
        }
        j = this.includes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siElem.appendChild(siItem);
        }
        j = this.symbols.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "SYMBOL_DEFINITION");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siElem.appendChild(siItem);
        }
        cmdElem.appendChild(siElem);
    }

    public void deserialize(Element cmdElem) {
        NodeList siList;
        NodeList descList = cmdElem.getElementsByTagName(CMD_DESCRIPTION_ELEM);
        if (descList.getLength() > 0) {
            Element descElem = (Element)descList.item(0);
            NodeList optionList = descElem.getElementsByTagName(OPTION_ELEM);
            int i = 0;
            while (i < optionList.getLength()) {
                Element optionElem = (Element)optionList.item(i);
                String key = optionElem.getAttribute(KEY_ATTR);
                String value = optionElem.getAttribute(VALUE_ATTR);
                KVStringPair option = new KVStringPair(key, value);
                this.addSCOption(option);
                ++i;
            }
        }
        if ((siList = cmdElem.getElementsByTagName(CMD_SI_ELEM)).getLength() > 0) {
            Element siElem = (Element)siList.item(0);
            NodeList siItemList = siElem.getElementsByTagName(SI_ITEM_ELEM);
            int i = 0;
            while (i < siItemList.getLength()) {
                Element siItemElem = (Element)siItemList.item(i);
                String kind = siItemElem.getAttribute(KIND_ATTR);
                String value = siItemElem.getAttribute(VALUE_ATTR);
                String quote = siItemElem.getAttribute(QUOTE_INCLUDE_ATTR);
                if (kind.equals("INCLUDE_PATH")) {
                    if (quote.equals("true")) {
                        this.quoteIncludes.add(value);
                    } else {
                        this.includes.add(value);
                    }
                } else if (kind.equals("SYMBOL_DEFINITION")) {
                    this.symbols.add(value);
                }
                ++i;
            }
            this.setDiscovered(true);
        }
    }

    public void resolveOptions(IProject project) {
        if (!this.isDiscovered()) {
            ArrayList<String> symbols = new ArrayList<String>();
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> quoteincludes = new ArrayList<String>();
            for (KVStringPair optionPair : this.compilerCommand) {
                String key = optionPair.getKey();
                String value = optionPair.getValue();
                if (key.equals(SCDOptionsEnum.INCLUDE.toString()) || key.equals(SCDOptionsEnum.ISYSTEM.toString())) {
                    includes.add(value);
                    continue;
                }
                if (key.equals(SCDOptionsEnum.IQUOTE.toString())) {
                    quoteincludes.add(value);
                    continue;
                }
                if (!key.equals(SCDOptionsEnum.DEFINE.toString())) continue;
                symbols.add(value);
            }
            this.setIncludes(includes);
            this.setQuoteIncludes(quoteincludes);
            this.setSymbols(symbols);
        }
        this.setDiscovered(true);
    }

    public static IPath makeRelative(IProject project, IPath path) {
        IResource resource = CCommandDSC.findResource(project, path);
        if (resource != null && resource.getProject() == project) {
            path = resource.getProjectRelativePath();
        }
        return path;
    }

    private static IResource findResource(IProject project, IPath path) {
        IWorkspaceRoot root;
        IResource resource = project.findMember(path, false);
        if (resource == null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path, false)) == null) {
            IFile[] resources = root.findFilesForLocation(path);
            if (project != null) {
                int i = 0;
                while (i < resources.length) {
                    IProject myProject = resources[i].getProject();
                    if (myProject != null && myProject.equals((Object)project)) {
                        resource = resources[i];
                        break;
                    }
                    ++i;
                }
            }
            if (resource == null && resources.length > 0) {
                resource = resources[0];
            }
        }
        return resource;
    }

    public static List makeRelative(IProject project, List paths) {
        ArrayList<String> list = new ArrayList<String>(paths.size());
        for (String path : paths) {
            path = CCommandDSC.makeRelative(project, (IPath)new Path(path)).toOSString();
            list.add(path);
        }
        return list;
    }

    public static final String makeAbsolute(IProject project, String path) {
        IResource res;
        Path ppath = new Path(path);
        if (project != null && !ppath.isAbsolute() && (res = project.findMember((IPath)ppath)) != null && (ppath = res.getLocation()) != null) {
            path = ppath.toOSString();
        }
        return path;
    }

    public static List makeAbsolute(IProject project, List paths) {
        ArrayList<String> list = new ArrayList<String>(paths.size());
        for (String path : paths) {
            path = CCommandDSC.makeAbsolute(project, path);
            list.add(path);
        }
        return list;
    }
}

