/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.core.runtime.CoreException;

public class Conversions {
    public static Cost checkImplicitConversionSequence(boolean allowUDC, IASTExpression sourceExp, IType source, IType target, boolean isImpliedObject) throws DOMException {
        Cost cost;
        allowUDC &= !isImpliedObject;
        target = SemanticUtil.getUltimateTypeViaTypedefs(target);
        source = SemanticUtil.getUltimateTypeViaTypedefs(source);
        if (target instanceof ICPPReferenceType) {
            IType T2;
            IType cv1T1 = SemanticUtil.getUltimateTypeViaTypedefs(((ICPPReferenceType)target).getType());
            cost = new Cost(source, cv1T1);
            cost.targetHadReference = true;
            boolean lvalue = sourceExp == null || !CPPVisitor.isRValue(sourceExp);
            IType iType = T2 = source instanceof IQualifierType ? SemanticUtil.getUltimateTypeViaTypedefs(((IQualifierType)source).getType()) : source;
            if (lvalue && Conversions.isReferenceCompatible(cv1T1, source)) {
                if (cost.source.isSameType(cost.target) || isImpliedObject && cost.source instanceof ICPPClassType && cost.target instanceof ICPPClassType) {
                    cost.rank = 0;
                    return cost;
                }
                Conversions.qualificationConversion(cost);
                Conversions.derivedToBaseConversion(cost);
            } else if (T2 instanceof ICPPClassType && allowUDC) {
                IType newSource;
                boolean isNewSourceLValue;
                ICPPMethod[] fcns = SemanticUtil.getConversionOperators((ICPPClassType)T2);
                Cost operatorCost = null;
                IFunction conv = null;
                boolean ambiguousConversionOperator = false;
                if (fcns.length > 0 && !(fcns[0] instanceof IProblemBinding)) {
                    ICPPMethod[] iCPPMethodArray = fcns;
                    int n = fcns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPMethod op = iCPPMethodArray[n2];
                        Cost cost2 = Conversions.checkStandardConversionSequence(op.getType().getReturnType(), target, false);
                        if (cost2.rank != -1) {
                            if (operatorCost == null) {
                                operatorCost = cost2;
                                conv = op;
                            } else {
                                int cmp = operatorCost.compare(cost2);
                                if (cmp >= 0) {
                                    ambiguousConversionOperator = cmp == 0;
                                    operatorCost = cost2;
                                    conv = op;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (conv != null && !ambiguousConversionOperator && (isNewSourceLValue = (newSource = conv.getType().getReturnType()) instanceof ICPPReferenceType) && Conversions.isReferenceCompatible(cv1T1, newSource)) {
                    cost = new Cost(cv1T1, newSource);
                    Conversions.qualificationConversion(cost);
                    Conversions.derivedToBaseConversion(cost);
                }
            }
            if (cost.rank == -1) {
                boolean cv1isConst = false;
                if (cv1T1 instanceof IQualifierType) {
                    cv1isConst = ((IQualifierType)cv1T1).isConst() && !((IQualifierType)cv1T1).isVolatile();
                } else if (cv1T1 instanceof IPointerType) {
                    boolean bl = cv1isConst = ((IPointerType)cv1T1).isConst() && !((IPointerType)cv1T1).isVolatile();
                }
                if (cv1isConst) {
                    if (!lvalue && source instanceof ICPPClassType) {
                        cost = new Cost(source, target);
                        cost.rank = 0;
                    } else {
                        Integer cmp;
                        boolean illformed = false;
                        if (Conversions.isReferenceRelated(cv1T1, source) && ((cmp = Conversions.compareQualifications(cv1T1, source)) == null || cmp < 0)) {
                            illformed = true;
                        }
                        if (!illformed) {
                            Cost temp;
                            cost = Conversions.checkStandardConversionSequence(source, cv1T1, isImpliedObject);
                            if (allowUDC && (cost.rank == -1 || cost.rank == 6) && (temp = Conversions.checkUserDefinedConversionSequence(source, cv1T1)) != null) {
                                cost = temp;
                            }
                        }
                    }
                }
            }
        } else {
            Cost temp;
            cost = Conversions.checkStandardConversionSequence(source, target, isImpliedObject);
            if (allowUDC && (cost.rank == -1 || cost.rank == 6) && (temp = Conversions.checkUserDefinedConversionSequence(source, target)) != null) {
                cost = temp;
            }
        }
        return cost;
    }

    private static final Integer compareQualifications(IType cv1, IType cv2) throws DOMException {
        int cmpVolatile;
        int cmpConst;
        boolean cv1Const = false;
        boolean cv2Const = false;
        boolean cv1Volatile = false;
        boolean cv2Volatile = false;
        if (cv1 instanceof IQualifierType) {
            IQualifierType qt1 = (IQualifierType)cv1;
            cv1Const = qt1.isConst();
            cv1Volatile = qt1.isVolatile();
        } else if (cv1 instanceof IPointerType) {
            IPointerType pt1 = (IPointerType)cv1;
            cv1Const = pt1.isConst();
            cv1Volatile = pt1.isVolatile();
        }
        if (cv2 instanceof IQualifierType) {
            IQualifierType qt2 = (IQualifierType)cv2;
            cv2Const = qt2.isConst();
            cv2Volatile = qt2.isVolatile();
        } else if (cv2 instanceof IPointerType) {
            IPointerType pt2 = (IPointerType)cv2;
            cv1Const = pt2.isConst();
            cv1Volatile = pt2.isVolatile();
        }
        int n = cv1Const ? (cv2Const ? 0 : 1) : (cmpConst = !cv2Const ? 0 : -1);
        int n2 = cv1Volatile ? (cv2Volatile ? 0 : 1) : (cmpVolatile = !cv2Volatile ? 0 : -1);
        if (cmpConst == cmpVolatile) {
            return cmpConst;
        }
        if (cmpConst != 0 && cmpVolatile == 0) {
            return cmpConst;
        }
        if (cmpConst == 0 && cmpVolatile != 0) {
            return cmpVolatile;
        }
        return null;
    }

    private static final boolean isReferenceRelated(IType cv1t1, IType cv2t2) throws DOMException {
        IType t1 = SemanticUtil.getUltimateTypeUptoPointers(cv1t1);
        IType t2 = SemanticUtil.getUltimateTypeUptoPointers(cv2t2);
        if (t1 instanceof IPointerType && t2 instanceof IPointerType) {
            IType ptt1 = ((IPointerType)t1).getType();
            IType ptt2 = ((IPointerType)t2).getType();
            return ptt1 != null && ptt2 != null ? ptt1.isSameType(ptt2) : ptt1 == ptt2;
        }
        t1 = t1 instanceof IQualifierType ? ((IQualifierType)t1).getType() : t1;
        IType iType = t2 = t2 instanceof IQualifierType ? ((IQualifierType)t2).getType() : t2;
        if (t1 instanceof ICPPClassType && t2 instanceof ICPPClassType) {
            return Conversions.calculateInheritanceDepth(10, t2, t1) >= 0;
        }
        return t1 != null && t2 != null ? t1.isSameType(t2) : t1 == t2;
    }

    private static final boolean isReferenceCompatible(IType cv1t1, IType cv2t2) throws DOMException {
        if (Conversions.isReferenceRelated(cv1t1, cv2t2)) {
            Integer cmp = Conversions.compareQualifications(cv1t1, cv2t2);
            return cmp != null && cmp >= 0;
        }
        return false;
    }

    protected static final Cost checkStandardConversionSequence(IType source, IType target, boolean isImplicitThis) throws DOMException {
        Cost cost = Conversions.lvalue_to_rvalue(source, target);
        if (cost.source == null || cost.target == null) {
            return cost;
        }
        if (cost.source.isSameType(cost.target) || isImplicitThis && cost.source instanceof ICPPClassType && cost.target instanceof ICPPClassType) {
            cost.rank = 0;
            return cost;
        }
        Conversions.qualificationConversion(cost);
        if (cost.qualification == -1) {
            return cost;
        }
        IType s = SemanticUtil.getUltimateType(cost.source, true);
        IType t = SemanticUtil.getUltimateType(cost.target, true);
        if (s == null || t == null) {
            cost.rank = -1;
            return cost;
        }
        if (s.isSameType(t) || isImplicitThis && s instanceof ICPPClassType && t instanceof ICPPClassType) {
            return cost;
        }
        Conversions.promotion(cost);
        if (cost.promotion > 0 || cost.rank > -1) {
            return cost;
        }
        Conversions.conversion(cost);
        if (cost.rank > -1) {
            return cost;
        }
        Conversions.derivedToBaseConversion(cost);
        if (cost.rank == -1) {
            Conversions.relaxTemplateParameters(cost);
        }
        return cost;
    }

    private static final Cost checkUserDefinedConversionSequence(IType source, IType target) throws DOMException {
        ICPPMethod[] ops;
        IFunction[] constructors;
        Cost constructorCost = null;
        Cost operatorCost = null;
        IType s = SemanticUtil.getUltimateType(source, true);
        IType t = SemanticUtil.getUltimateType(target, true);
        if (t instanceof ICPPClassType && (constructors = ((ICPPClassType)t).getConstructors()).length > 0 && !(constructors[0] instanceof IProblemBinding)) {
            ICPPConstructor constructor;
            LookupData data = new LookupData();
            data.forUserDefinedConversion = true;
            data.functionParameters = new IType[]{source};
            IBinding binding = CPPSemantics.resolveFunction(data, constructors);
            if (binding instanceof ICPPConstructor && !(constructor = (ICPPConstructor)binding).isExplicit()) {
                constructorCost = Conversions.checkStandardConversionSequence(t, target, false);
                if (constructorCost.rank == -1) {
                    constructorCost = null;
                }
            }
        }
        boolean ambiguousConversionOperator = false;
        if (s instanceof ICPPClassType && (ops = SemanticUtil.getConversionOperators((ICPPClassType)s)).length > 0 && !(ops[0] instanceof IProblemBinding)) {
            ICPPMethod[] iCPPMethodArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod op = iCPPMethodArray[n2];
                Cost cost = Conversions.checkStandardConversionSequence(op.getType().getReturnType(), target, false);
                if (cost.rank != -1) {
                    if (operatorCost == null) {
                        operatorCost = cost;
                    } else {
                        int cmp = operatorCost.compare(cost);
                        if (cmp >= 0) {
                            ambiguousConversionOperator = cmp == 0;
                            operatorCost = cost;
                        }
                    }
                }
                ++n2;
            }
        }
        if (constructorCost != null) {
            if (operatorCost == null || ambiguousConversionOperator) {
                constructorCost.userDefined = 2;
                constructorCost.rank = 4;
            } else {
                constructorCost.userDefined = 1;
                constructorCost.rank = 4;
            }
            return constructorCost;
        }
        if (operatorCost != null) {
            operatorCost.rank = 4;
            operatorCost.userDefined = ambiguousConversionOperator ? 1 : 2;
            return operatorCost;
        }
        return null;
    }

    private static final int calculateInheritanceDepth(int maxdepth, IType type, IType ancestorToFind) throws DOMException {
        if (type == ancestorToFind || type.isSameType(ancestorToFind)) {
            return 0;
        }
        if (maxdepth > 0 && type instanceof ICPPClassType && ancestorToFind instanceof ICPPClassType) {
            ICPPClassType clazz = (ICPPClassType)type;
            if (clazz instanceof ICPPDeferredClassInstance) {
                clazz = (ICPPClassType)((ICPPDeferredClassInstance)clazz).getSpecializedBinding();
            }
            ICPPBase[] iCPPBaseArray = clazz.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof IType) {
                    int n3;
                    IType tbase = (IType)((Object)base);
                    if (tbase.isSameType(ancestorToFind) || ancestorToFind instanceof ICPPSpecialization && ((IType)((Object)((ICPPSpecialization)((Object)ancestorToFind)).getSpecializedBinding())).isSameType(tbase)) {
                        return 1;
                    }
                    if ((tbase = SemanticUtil.getUltimateTypeViaTypedefs(tbase)) instanceof ICPPClassType && (n3 = Conversions.calculateInheritanceDepth(maxdepth - 1, tbase, ancestorToFind)) > 0) {
                        return n3 + 1;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    private static final Cost lvalue_to_rvalue(IType source, IType target) throws DOMException {
        Cost cost = new Cost(source, target);
        if (!Conversions.isCompleteType(source)) {
            cost.rank = -1;
            return cost;
        }
        if (source instanceof ICPPReferenceType) {
            source = ((ICPPReferenceType)source).getType();
            while (source instanceof ITypedef) {
                source = ((ITypedef)source).getType();
            }
        }
        if (target instanceof ICPPReferenceType) {
            target = ((ICPPReferenceType)target).getType();
            cost.targetHadReference = true;
        }
        if (target instanceof IPointerType && ((IPointerType)target).getType() instanceof IFunctionType && source instanceof IFunctionType) {
            source = new CPPPointerType(source);
        } else if (target instanceof IPointerType && source instanceof IArrayType) {
            source = new CPPPointerType(((IArrayType)source).getType());
        }
        if (source instanceof IQualifierType) {
            IType t = ((IQualifierType)source).getType();
            while (t instanceof ITypedef) {
                t = ((ITypedef)t).getType();
            }
            if (!(t instanceof ICPPClassType)) {
                source = t;
            }
        } else if (source instanceof IPointerType && (((IPointerType)source).isConst() || ((IPointerType)source).isVolatile())) {
            IType t = ((IPointerType)source).getType();
            while (t instanceof ITypedef) {
                t = ((ITypedef)t).getType();
            }
            if (!(t instanceof ICPPClassType)) {
                source = new CPPPointerType(t);
            }
        }
        cost.source = source;
        cost.target = target;
        return cost;
    }

    /*
     * Unable to fully structure code
     */
    private static final void qualificationConversion(Cost cost) throws DOMException {
        block27: {
            block28: {
                block26: {
                    canConvert = true;
                    requiredConversion = 0;
                    s = cost.source;
                    t = cost.target;
                    constInEveryCV2k = true;
                    firstPointer = true;
                    while (true) {
                        s = SemanticUtil.getUltimateTypeViaTypedefs(s);
                        t = SemanticUtil.getUltimateTypeViaTypedefs(t);
                        sourceIsPointer = s instanceof IPointerType;
                        targetIsPointer = t instanceof IPointerType;
                        if (!targetIsPointer) {
                            if (!sourceIsPointer) break;
                            if (t instanceof ICPPBasicType && ((ICPPBasicType)t).getType() == 6) {
                                canConvert = true;
                                requiredConversion = 2;
                                break;
                            }
                            canConvert = false;
                            break;
                        }
                        if (!sourceIsPointer) {
                            canConvert = false;
                            break;
                        }
                        if (s instanceof ICPPPointerToMemberType ^ t instanceof ICPPPointerToMemberType) {
                            canConvert = false;
                            break;
                        }
                        op1 = (IPointerType)s;
                        op2 = (IPointerType)t;
                        if (op1.isConst() && !op2.isConst() || op1.isVolatile() && !op2.isVolatile()) {
                            canConvert = false;
                            requiredConversion = -1;
                            break;
                        }
                        if (!(constInEveryCV2k || op1.isConst() == op2.isConst() && op1.isVolatile() == op2.isVolatile())) {
                            canConvert = false;
                            requiredConversion = -1;
                            break;
                        }
                        constInEveryCV2k &= firstPointer != false || op2.isConst() != false;
                        s = op1.getType();
                        t = op2.getType();
                        firstPointer = false;
                    }
                    if (cost.targetHadReference && s instanceof ICPPReferenceType) {
                        s = ((ICPPReferenceType)s).getType();
                    }
                    if (!(s instanceof IQualifierType ^ t instanceof IQualifierType)) break block26;
                    if (t instanceof IQualifierType) {
                        if (!constInEveryCV2k) {
                            canConvert = false;
                            requiredConversion = -1;
                        } else {
                            canConvert = true;
                            requiredConversion = 2;
                        }
                    } else if (t instanceof IBasicType && ((IBasicType)t).getType() == 2 && s instanceof IQualifierType) {
                        qt = ((IQualifierType)s).getType();
                        if (qt instanceof IBasicType) {
                            val = ((IBasicType)qt).getValue();
                            canConvert = val != null && val instanceof IASTLiteralExpression != false && ((IASTLiteralExpression)val).getKind() == 3;
                        } else {
                            canConvert = false;
                            requiredConversion = -1;
                        }
                    } else {
                        canConvert = false;
                        requiredConversion = -1;
                    }
                    break block27;
                }
                if (!(s instanceof IQualifierType) || !(t instanceof IQualifierType)) break block28;
                qs = (IQualifierType)s;
                qt = (IQualifierType)t;
                if (qs.isConst() == qt.isConst() && qs.isVolatile() == qt.isVolatile()) {
                    requiredConversion = 0;
                } else if (qs.isConst() != false && qt.isConst() == false || qs.isVolatile() != false && qt.isVolatile() == false || !constInEveryCV2k) {
                    requiredConversion = -1;
                    canConvert = false;
                } else {
                    requiredConversion = 2;
                }
                break block27;
            }
            if (!constInEveryCV2k || canConvert) break block27;
            canConvert = true;
            requiredConversion = 2;
            i = 1;
            type = s;
            ** GOTO lbl98
            {
                block29: {
                    if (type instanceof IQualifierType) {
                        canConvert = false;
                    } else if (type instanceof IPointerType) {
                        v0 = canConvert = ((IPointerType)type).isConst() == false && ((IPointerType)type).isVolatile() == false;
                    }
                    if (canConvert) break block29;
                    requiredConversion = -1;
                    ** GOTO lbl96
                }
                type = ((ITypeContainer)type).getType();
                do {
                    if (type instanceof ITypeContainer) continue block1;
lbl96:
                    // 2 sources

                    type = t;
                    ++i;
lbl98:
                    // 2 sources

                } while (canConvert && i == true);
            }
        }
        cost.qualification = requiredConversion;
        if (canConvert) {
            cost.rank = 0;
        }
    }

    private static final void promotion(Cost cost) throws DOMException {
        IType src = cost.source;
        IType trg = cost.target;
        if (src.isSameType(trg)) {
            return;
        }
        if (src instanceof IBasicType && trg instanceof IBasicType) {
            int sType = ((IBasicType)src).getType();
            int tType = ((IBasicType)trg).getType();
            if (tType == 3 && (sType == 3 || sType == 2 || sType == 6 || sType == 7 || sType == 0) || tType == 5 && sType == 4) {
                cost.promotion = 1;
            }
        } else if (src instanceof IEnumeration && trg instanceof IBasicType && (((IBasicType)trg).getType() == 3 || ((IBasicType)trg).getType() == 0)) {
            cost.promotion = 1;
        }
        cost.rank = cost.promotion > 0 ? 1 : -1;
    }

    private static final void conversion(Cost cost) throws DOMException {
        IType src = cost.source;
        IType trg = cost.target;
        cost.conversion = 0;
        cost.detail = 0;
        IType[] sHolder = new IType[1];
        IType[] tHolder = new IType[1];
        IType s = SemanticUtil.getUltimateType(src, sHolder, true);
        IType t = SemanticUtil.getUltimateType(trg, tHolder, true);
        IType sPrev = sHolder[0];
        IType tPrev = tHolder[0];
        if (src instanceof IBasicType && trg instanceof IPointerType) {
            IASTExpression exp = ((IBasicType)src).getValue();
            if (exp instanceof IASTLiteralExpression && ((IASTLiteralExpression)exp).getKind() == 0) {
                try {
                    String val = exp.toString().toLowerCase().replace('u', '0');
                    val.replace('l', '0');
                    if (Integer.decode(val) == 0) {
                        cost.rank = 2;
                        cost.conversion = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (sPrev instanceof IPointerType) {
            if (tPrev instanceof IPointerType && t instanceof IBasicType && ((IBasicType)t).getType() == 1) {
                cost.rank = 2;
                cost.conversion = 1;
                cost.detail = 2;
                return;
            }
            if (s instanceof ICPPClassType && tPrev instanceof IPointerType && t instanceof ICPPClassType) {
                int depth = Conversions.calculateInheritanceDepth(10, s, t);
                cost.rank = depth > -1 ? 2 : -1;
                cost.conversion = depth > -1 ? depth : 0;
                cost.detail = 1;
                return;
            }
            if (!(trg instanceof IBasicType) || ((IBasicType)trg).getType() != 6) {
                return;
            }
        }
        if (t instanceof IBasicType && s instanceof IBasicType || s instanceof IEnumeration) {
            cost.rank = 2;
            cost.conversion = 1;
        } else if (trg instanceof IBasicType && ((IBasicType)trg).getType() == 6 && s instanceof IPointerType) {
            cost.rank = 2;
            cost.conversion = 1;
        } else if (s instanceof ICPPPointerToMemberType && t instanceof ICPPPointerToMemberType) {
            ICPPPointerToMemberType spm = (ICPPPointerToMemberType)s;
            ICPPPointerToMemberType tpm = (ICPPPointerToMemberType)t;
            IType st = spm.getType();
            IType tt = tpm.getType();
            if (st != null && tt != null && st.isSameType(tt)) {
                int depth = Conversions.calculateInheritanceDepth(10, tpm.getMemberOfClass(), spm.getMemberOfClass());
                cost.rank = depth > -1 ? 2 : -1;
                cost.conversion = depth > -1 ? depth : 0;
                cost.detail = 1;
            }
        }
    }

    private static final void derivedToBaseConversion(Cost cost) throws DOMException {
        int depth;
        IType s = SemanticUtil.getUltimateType(cost.source, true);
        IType t = SemanticUtil.getUltimateType(cost.target, true);
        if (cost.targetHadReference && s instanceof ICPPClassType && t instanceof ICPPClassType && (depth = Conversions.calculateInheritanceDepth(10, s, t)) > -1) {
            cost.rank = 3;
            cost.conversion = depth;
        }
    }

    private static final boolean isCompleteType(IType type) {
        if ((type = SemanticUtil.getUltimateType(type, false)) instanceof ICPPClassType) {
            if (type instanceof ICPPInternalBinding) {
                return ((ICPPInternalBinding)((Object)type)).getDefinition() != null;
            }
            if (type instanceof IIndexFragmentBinding) {
                try {
                    return ((IIndexFragmentBinding)((Object)type)).hasDefinition();
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            }
        }
        return true;
    }

    private static final void relaxTemplateParameters(Cost cost) {
        IType s = SemanticUtil.getUltimateType(cost.source, false);
        IType t = SemanticUtil.getUltimateType(cost.target, false);
        if (s instanceof ICPPTemplateTypeParameter && t instanceof ICPPTemplateTypeParameter || s instanceof ICPPTemplateTemplateParameter && t instanceof ICPPTemplateTemplateParameter) {
            cost.rank = 6;
        }
    }
}

