/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner.IIndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeFileContent;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexBasedCodeReaderFactory
implements IIndexBasedCodeReaderFactory {
    private static final String GAP = "__gap__";
    private final IIndex fIndex;
    private int fLinkage;
    private Set<IIndexFileLocation> fIncludedFiles = new HashSet<IIndexFileLocation>();
    private final ICodeReaderFactory fFallBackFactory;
    private final ASTFilePathResolver fPathResolver;
    private final AbstractIndexerTask fRelatedIndexerTask;
    private boolean fSupportFillGapFromContextToHeader = false;

    public IndexBasedCodeReaderFactory(IIndex index, ASTFilePathResolver pathResolver, int linkage, ICodeReaderFactory fallbackFactory) {
        this(index, pathResolver, linkage, fallbackFactory, null);
    }

    public IndexBasedCodeReaderFactory(IIndex index, ASTFilePathResolver pathResolver, int linkage, ICodeReaderFactory fallbackFactory, AbstractIndexerTask relatedIndexerTask) {
        this.fIndex = index;
        this.fFallBackFactory = fallbackFactory;
        this.fPathResolver = pathResolver;
        this.fRelatedIndexerTask = relatedIndexerTask;
        this.fLinkage = linkage;
    }

    public void setSupportFillGapFromContextToHeader(boolean val) {
        this.fSupportFillGapFromContextToHeader = val;
    }

    public void setLinkage(int linkageID) {
        this.fLinkage = linkageID;
    }

    public void cleanupAfterTranslationUnit() {
        this.fIncludedFiles.clear();
    }

    @Override
    public int getUniqueIdentifier() {
        return 0;
    }

    @Override
    public ICodeReaderCache getCodeReaderCache() {
        return null;
    }

    @Override
    public CodeReader createCodeReaderForTranslationUnit(String path) {
        if (this.fFallBackFactory != null) {
            return this.fFallBackFactory.createCodeReaderForTranslationUnit(path);
        }
        return ParserUtil.createReader(path, null);
    }

    @Override
    public CodeReader createCodeReaderForInclusion(String path) {
        if (this.fFallBackFactory != null) {
            return this.fFallBackFactory.createCodeReaderForInclusion(path);
        }
        return ParserUtil.createReader(path, null);
    }

    @Override
    public boolean getInclusionExists(String path) {
        return this.fPathResolver.doesIncludeFileExist(path);
    }

    @Override
    public void reportTranslationUnitFile(String path) {
        IIndexFileLocation ifl = this.fPathResolver.resolveASTPath(path);
        this.fIncludedFiles.add(ifl);
    }

    @Override
    public boolean hasFileBeenIncludedInCurrentTranslationUnit(String path) {
        IIndexFileLocation ifl = this.fPathResolver.resolveASTPath(path);
        return this.fIncludedFiles.contains(ifl);
    }

    @Override
    public IncludeFileContent getContentForInclusion(String path) {
        CodeReader codeReader;
        IIndexFileLocation ifl = this.fPathResolver.resolveIncludeFile(path);
        if (ifl == null) {
            return null;
        }
        path = this.fPathResolver.getASTPath(ifl);
        if (!this.fIncludedFiles.add(ifl)) {
            return new IncludeFileContent(path, IncludeFileContent.InclusionKind.SKIP_FILE);
        }
        try {
            IIndexFile file = this.fIndex.getFile(this.fLinkage, ifl);
            if (file != null) {
                try {
                    LinkedHashMap<IIndexFileLocation, AbstractIndexerTask.FileContent> fileContentMap = new LinkedHashMap<IIndexFileLocation, AbstractIndexerTask.FileContent>();
                    ArrayList<IIndexFile> files = new ArrayList<IIndexFile>();
                    this.collectFileContent(file, fileContentMap, files, false);
                    ArrayList<IIndexMacro> allMacros = new ArrayList<IIndexMacro>();
                    ArrayList<ICPPUsingDirective> allDirectives = new ArrayList<ICPPUsingDirective>();
                    for (Map.Entry<IIndexFileLocation, AbstractIndexerTask.FileContent> entry : fileContentMap.entrySet()) {
                        AbstractIndexerTask.FileContent content = entry.getValue();
                        allMacros.addAll((Collection<IIndexMacro>)Arrays.asList(content.fMacros));
                        allDirectives.addAll((Collection<ICPPUsingDirective>)Arrays.asList(content.fDirectives));
                        this.fIncludedFiles.add(entry.getKey());
                    }
                    return new IncludeFileContent(path, allMacros, allDirectives, files);
                }
                catch (NeedToParseException needToParseException) {}
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        if ((codeReader = this.createCodeReaderForInclusion(path)) != null) {
            return new IncludeFileContent(codeReader);
        }
        return null;
    }

    private void collectFileContent(IIndexFile file, Map<IIndexFileLocation, AbstractIndexerTask.FileContent> macroMap, List<IIndexFile> files, boolean checkIncluded) throws CoreException, NeedToParseException {
        IIndexInclude[] includeDirectives;
        AbstractIndexerTask.FileContent content;
        IIndexFileLocation ifl = file.getLocation();
        if (macroMap.containsKey(ifl) || checkIncluded && this.fIncludedFiles.contains(ifl)) {
            return;
        }
        if (this.fRelatedIndexerTask != null) {
            content = this.fRelatedIndexerTask.getFileContent(this.fLinkage, ifl);
            if (content == null) {
                throw new NeedToParseException();
            }
        } else {
            content = new AbstractIndexerTask.FileContent();
            content.fMacros = file.getMacros();
            content.fDirectives = file.getUsingDirectives();
        }
        macroMap.put(ifl, content);
        files.add(file);
        IIndexInclude[] iIndexIncludeArray = includeDirectives = file.getIncludes();
        int n = includeDirectives.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexInclude indexInclude = iIndexIncludeArray[n2];
            IIndexFile includedFile = this.fIndex.resolveInclude(indexInclude);
            if (includedFile != null) {
                this.collectFileContent(includedFile, macroMap, files, true);
            }
            ++n2;
        }
    }

    @Override
    public IncludeFileContent getContentForContextToHeaderGap(String path) {
        ArrayList<ICPPUsingDirective> directives;
        ArrayList<IIndexMacro> macros;
        HashSet<IIndexFile> filesIncluded;
        block10: {
            IIndexFile contextFile;
            IIndexFileLocation ifl;
            block9: {
                IIndexFile targetFile;
                block8: {
                    if (!this.fSupportFillGapFromContextToHeader) {
                        return null;
                    }
                    ifl = this.fPathResolver.resolveASTPath(path);
                    if (ifl == null) {
                        return null;
                    }
                    targetFile = this.fIndex.getFile(this.fLinkage, ifl);
                    if (targetFile != null) break block8;
                    return null;
                }
                contextFile = this.findContext(targetFile);
                if (contextFile != targetFile && contextFile != null) break block9;
                return null;
            }
            filesIncluded = new HashSet<IIndexFile>();
            macros = new ArrayList<IIndexMacro>();
            directives = new ArrayList<ICPPUsingDirective>();
            if (this.collectFileContentForGap(contextFile, ifl, filesIncluded, macros, directives)) break block10;
            return null;
        }
        try {
            for (IIndexFile file : filesIncluded) {
                this.fIncludedFiles.add(file.getLocation());
            }
            Collections.reverse(macros);
            return new IncludeFileContent(GAP, macros, directives, new ArrayList<IIndexFile>(filesIncluded));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private IIndexFile findContext(IIndexFile file) throws CoreException {
        HashSet<IIndexFile> ifiles = new HashSet<IIndexFile>();
        ifiles.add(file);
        IIndexInclude include = file.getParsedInContext();
        while (include != null) {
            IIndexFile context = include.getIncludedBy();
            if (!ifiles.add(context)) {
                return file;
            }
            file = context;
        }
        return file;
    }

    private boolean collectFileContentForGap(IIndexFile from, IIndexFileLocation to, Set<IIndexFile> filesIncluded, List<IIndexMacro> macros, List<ICPPUsingDirective> directives) throws CoreException {
        int startd;
        int startm;
        IIndexFileLocation ifl = from.getLocation();
        if (ifl.equals(to)) {
            return true;
        }
        if (this.fIncludedFiles.contains(ifl) || !filesIncluded.add(from)) {
            return false;
        }
        IIndexInclude[] includeDirectives = from.getIncludes();
        IIndexInclude success = null;
        IIndexInclude[] iIndexIncludeArray = includeDirectives;
        int n = includeDirectives.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexInclude indexInclude = iIndexIncludeArray[n2];
            IIndexFile includedFile = this.fIndex.resolveInclude(indexInclude);
            if (includedFile != null && this.collectFileContentForGap(includedFile, to, filesIncluded, macros, directives)) {
                success = indexInclude;
                break;
            }
            ++n2;
        }
        IIndexMacro[] mymacros = from.getMacros();
        ICPPUsingDirective[] mydirectives = from.getUsingDirectives();
        if (success == null) {
            startm = mymacros.length - 1;
            startd = mydirectives.length - 1;
        } else {
            startd = -1;
            startm = -1;
            int offset = success.getNameOffset();
            IIndexMacro[] iIndexMacroArray = from.getMacros();
            int n3 = iIndexMacroArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexMacro macro = iIndexMacroArray[n4];
                if (macro.getFileLocation().getNodeOffset() < offset) {
                    ++startm;
                }
                ++n4;
            }
        }
        int i = startm;
        while (i >= 0) {
            macros.add(mymacros[i]);
            --i;
        }
        i = startd;
        while (i >= 0) {
            directives.add(mydirectives[i]);
            --i;
        }
        return success != null;
    }

    private static final class NeedToParseException
    extends Exception {
        private NeedToParseException() {
        }
    }
}

