/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.BitSet;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.core.runtime.CoreException;

public class IndexFileSet
implements IIndexFileSet {
    private HashMap<IIndexFragment, IIndexFragmentFileSet> fSubSets = new HashMap();

    public void add(IIndexFile indexFile) {
        IIndexFragmentFile fragFile = (IIndexFragmentFile)indexFile;
        IIndexFragment frag = fragFile.getIndexFragment();
        IIndexFragmentFileSet subSet = this.fSubSets.get(frag);
        if (subSet == null) {
            subSet = frag.createFileSet();
            this.fSubSets.put(frag, subSet);
        }
        subSet.add(fragFile);
    }

    public IBinding[] filterFileLocalBindings(IBinding[] bindings) {
        if (bindings == null || bindings.length == 0) {
            return bindings;
        }
        BitSet ok = new BitSet(bindings.length);
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (binding != null) {
                IIndexFragmentBinding fb = binding instanceof IIndexFragmentBinding ? (IIndexFragmentBinding)binding : (IIndexFragmentBinding)binding.getAdapter(IIndexFragmentBinding.class);
                try {
                    if (fb != null && fb.isFileLocal()) {
                        IIndexFragmentFileSet subSet = this.fSubSets.get(fb.getFragment());
                        if (subSet != null && subSet.containsFileOfLocalBinding(fb)) {
                            ok.set(i);
                        }
                    } else {
                        ok.set(i);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
        if (ok.cardinality() == bindings.length) {
            return bindings;
        }
        IBinding[] result = new IBinding[ok.cardinality()];
        int j = ok.nextSetBit(0);
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = bindings[j];
            j = ok.nextSetBit(j + 1);
            ++i2;
        }
        return result;
    }
}

