/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplate;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassSpecialization
extends PDOMCPPSpecialization
implements ICPPClassType,
ICPPClassSpecializationScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int FIRSTBASE = 44;
    private static final int MEMBERLIST = 48;
    protected static final int RECORD_SIZE = 52;

    public PDOMCPPClassSpecialization(PDOM pdom, PDOMNode parent, ICPPClassType classType, PDOMBinding specialized) throws CoreException {
        super(pdom, parent, (ICPPSpecialization)((Object)classType), specialized);
        if (specialized instanceof PDOMCPPClassTemplate) {
            ((PDOMCPPClassTemplate)specialized).addMember(this);
        } else if (specialized instanceof PDOMCPPClassTemplateSpecialization) {
            ((PDOMCPPClassTemplateSpecialization)specialized).addMember(this);
        }
    }

    public PDOMCPPClassSpecialization(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 52;
    }

    public int getNodeType() {
        return 37;
    }

    public ICPPClassType getOriginalClassType() {
        return (ICPPClassType)this.getSpecializedBinding();
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 44);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        int rec = base != null ? base.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 44, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        int nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    public IField findField(String name) throws DOMException {
        this.fail();
        return null;
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPBase[] getBases() throws DOMException {
        if (!(this instanceof ICPPTemplateDefinition) && this.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            try {
                ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
                PDOMCPPBase base = this.getFirstBase();
                while (base != null) {
                    list.add(base);
                    base = base.getNextBase();
                }
                Collections.reverse(list);
                ICPPBase[] bases = list.toArray(new ICPPBase[list.size()]);
                return bases;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else {
            ICPPBase[] pdomBases = ((ICPPClassType)this.getSpecializedBinding()).getBases();
            if (pdomBases != null) {
                Object[] result = null;
                ICPPBase[] iCPPBaseArray = pdomBases;
                int n = pdomBases.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase origBase = iCPPBaseArray[n2];
                    ICPPBase specBase = (ICPPBase)((ICPPInternalBase)((Object)origBase)).clone();
                    IBinding origClass = origBase.getBaseClass();
                    if (origClass instanceof IType) {
                        IType specClass = CPPTemplates.instantiateType((IType)((Object)origClass), this.getArgumentMap(), this);
                        if ((specClass = SemanticUtil.getUltimateType(specClass, true)) instanceof IBinding) {
                            ((ICPPInternalBase)((Object)specBase)).setBaseClass((IBinding)((Object)specClass));
                        }
                        result = (ICPPBase[])ArrayUtil.append(ICPPBase.class, result, specBase);
                    }
                    ++n2;
                }
                return (ICPPBase[])ArrayUtil.trim(ICPPBase.class, result);
            }
        }
        return new ICPPBase[0];
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        try {
            PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
            this.accept(visitor);
            return visitor.getConstructors();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            this.accept(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            this.accept(visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPField[0];
        }
    }

    public IField[] getFields() throws DOMException {
        this.fail();
        return null;
    }

    public IBinding[] getFriends() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return CPPClassType.getMethods(this);
    }

    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    public int getKey() throws DOMException {
        return ((ICPPClassType)this.getSpecializedBinding()).getKey();
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPSpecialization) {
            ICPPClassType otherCT;
            ICPPClassType myCT = (ICPPClassType)this.getSpecializedBinding();
            if (!myCT.isSameType(otherCT = (ICPPClassType)((ICPPSpecialization)((Object)type)).getSpecializedBinding())) {
                return false;
            }
            ObjectMap m1 = this.getArgumentMap();
            ObjectMap m2 = ((ICPPSpecialization)((Object)type)).getArgumentMap();
            if (m1 == null || m2 == null || m1.size() != m2.size()) {
                return false;
            }
            int i = 0;
            while (i < m1.size()) {
                IType t1 = (IType)m1.getAt(i);
                IType t2 = (IType)m2.getAt(i);
                if (t1 == null || !t1.isSameType(t2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public ICPPClassType getClassType() {
        return this;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        if (!(this instanceof ICPPTemplateDefinition) && this.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            try {
                if (this.getDBName().equals(name.toCharArray())) {
                    if (CPPClassScope.isConstructorReference(name)) {
                        return CPPSemantics.resolveAmbiguities(name, this.getConstructors());
                    }
                    return this;
                }
                BindingCollector visitor = new BindingCollector(this.getLinkageImpl(), name.toCharArray());
                this.accept(visitor);
                return CPPSemantics.resolveAmbiguities(name, visitor.getBindings());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else {
            try {
                if (this.getDBName().equals(name.toCharArray()) && !CPPClassScope.isConstructorReference(name)) {
                    return this;
                }
                IBinding[] specialized = ((ICPPClassType)this.getSpecializedBinding()).getCompositeScope().getBindings(name, resolve, false);
                SpecializationFinder visitor = new SpecializationFinder(specialized);
                this.accept(visitor);
                return CPPSemantics.resolveAmbiguities(name, visitor.getSpecializations());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    public IBinding getInstance(IBinding original) {
        SpecializationFinder visitor = new SpecializationFinder(new IBinding[]{original});
        try {
            this.accept(visitor);
            return visitor.getSpecializations()[0];
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return original;
        }
    }

    public ICPPMethod[] getImplicitMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true, false);
            this.accept(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    public IIndexBinding getScopeBinding() {
        return this;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    public void addMember(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
        list.addMember(member);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
        list.accept(visitor);
    }

    public String toString() {
        String result = super.toString();
        ObjectMap map = this.getArgumentMap();
        int i = 0;
        while (i < map.size()) {
            result = String.valueOf(result) + " <" + map.keyAt(i) + "=>" + this.getArgumentMap().getAt(i) + ">";
            ++i;
        }
        return result;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        Object[] result = null;
        if (!(this instanceof ICPPTemplateDefinition) && this.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            try {
                if (!prefixLookup && this.getDBName().compare(name.toCharArray(), true) == 0 || prefixLookup && this.getDBName().comparePrefix(name.toCharArray(), false) == 0) {
                    result = (IBinding[])ArrayUtil.append(IBinding.class, result, this);
                }
                BindingCollector visitor = new BindingCollector(this.getLinkageImpl(), name.toCharArray(), null, prefixLookup, !prefixLookup);
                this.accept(visitor);
                result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, visitor.getBindings());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else {
            try {
                if (!prefixLookup && this.getDBName().compare(name.toCharArray(), true) == 0 || prefixLookup && this.getDBName().comparePrefix(name.toCharArray(), false) == 0) {
                    result = (IBinding[])ArrayUtil.append(IBinding.class, result, this);
                }
                IBinding[] specialized = ((ICPPClassType)this.getSpecializedBinding()).getCompositeScope().getBindings(name, resolve, prefixLookup);
                SpecializationFinder visitor = new SpecializationFinder(specialized);
                this.accept(visitor);
                result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, visitor.getSpecializations());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    private class SpecializationFinder
    implements IPDOMVisitor {
        private ObjectMap specMap;

        public SpecializationFinder(IBinding[] specialized) {
            this.specMap = new ObjectMap(specialized.length);
            IBinding[] iBindingArray = specialized;
            int n = specialized.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding element = iBindingArray[n2];
                this.specMap.put(element, null);
                ++n2;
            }
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            ICPPSpecialization specialization;
            IBinding specialized;
            if (node instanceof ICPPSpecialization && this.specMap.containsKey(specialized = ((ICPPSpecialization)((Object)node)).getSpecializedBinding()) && (specialization = (ICPPSpecialization)this.specMap.get(node)) == null) {
                this.specMap.remove(specialized);
                this.specMap.put(specialized, node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPSpecialization[] getSpecializations() {
            ICPPSpecialization[] result = new ICPPSpecialization[this.specMap.size()];
            int i = 0;
            while (i < this.specMap.size()) {
                ICPPSpecialization specialization = (ICPPSpecialization)this.specMap.getAt(i);
                result[i] = specialization != null ? specialization : CPPTemplates.createSpecialization(PDOMCPPClassSpecialization.this, (IBinding)this.specMap.keyAt(i), PDOMCPPClassSpecialization.this.getArgumentMap());
                ++i;
            }
            return result;
        }
    }
}

