/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPInstance;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionInstance
extends PDOMCPPInstance
implements ICPPFunction {
    private static final int NUM_PARAMS = 48;
    private static final int FIRST_PARAM = 52;
    private static final int FUNCTION_TYPE = 56;
    protected static final int RECORD_SIZE = 60;

    public PDOMCPPFunctionInstance(PDOM pdom, PDOMNode parent, ICPPFunction function, PDOMBinding instantiated) throws CoreException {
        super(pdom, parent, (ICPPTemplateInstance)((Object)function), instantiated);
        Database db = pdom.getDB();
        try {
            PDOMNode typeNode;
            IFunctionType ft = function.getType();
            if (ft != null && (typeNode = this.getLinkageImpl().addType(this, ft)) != null) {
                db.putInt(this.record + 56, typeNode.getRecord());
            }
            ft = this.getType();
            IParameter[] params = function.getParameters();
            IType[] paramTypes = ft.getParameterTypes();
            db.putInt(this.record + 48, params.length);
            ICPPFunction sFunc = (ICPPFunction)((ICPPSpecialization)((Object)function)).getSpecializedBinding();
            IParameter[] sParams = sFunc.getParameters();
            IType[] sParamTypes = sFunc.getType().getParameterTypes();
            int i = 0;
            while (i < params.length) {
                int typeRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0;
                PDOMCPPParameter sParam = new PDOMCPPParameter(pdom, (PDOMNode)this, sParams[i], sParamTypes[i]);
                this.setFirstParameter(new PDOMCPPParameterSpecialization(pdom, (PDOMNode)this, (ICPPParameter)params[i], sParam, typeRecord));
                ++i;
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPFunctionInstance(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 60;
    }

    public int getNodeType() {
        return 26;
    }

    public PDOMCPPParameterSpecialization getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 52);
        return rec != 0 ? new PDOMCPPParameterSpecialization(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameterSpecialization param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 52, rec);
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 48);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameterSpecialization param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public IFunctionType getType() throws DOMException {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 56);
            return offset == 0 ? null : new PDOMCPPFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isInline() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isInline();
    }

    public boolean isMutable() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isMutable();
    }

    public boolean isAuto() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isAuto();
    }

    public boolean isExtern() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isExtern();
    }

    public boolean isExternC() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isExternC();
    }

    public boolean isRegister() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isRegister();
    }

    public boolean isStatic() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isStatic();
    }

    public boolean takesVarArgs() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).takesVarArgs();
    }

    public IScope getFunctionScope() throws DOMException {
        this.fail();
        return null;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }
}

